/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.geo;

import cn.gongler.util.sgeo.geo.IGeoPoint;
import cn.gongler.util.sgeo.geo.Scope;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ScopeGroup
implements Iterable<Scope> {
    private static final long serialVersionUID = 1L;
    public static final long BUSSTOP_GROUPID = 1L;
    public static final long LINESCOPE_GROUPID = 2L;
    public static final long CHANG_GROUPID = 3L;
    public static final long OVERSPEED_GROUPID = 4L;
    public static final long CITYSCOPE_GROUPID = 5L;
    public static final long OIL_LEAVELINE_GROUPID = 6L;
    public static final Comparator<Scope> AREA_CMP = Comparator.comparingDouble(Scope::polygonArea).thenComparingLong(Scope::id);
    public static final ScopeGroup CHANGZHANS_SCOPEGROUP = new ScopeGroup(3L, "\u573a\u7ad9", AREA_CMP);
    public static final ScopeGroup BUSSTOPS_SCOPEGROUP = new ScopeGroup(1L, "\u7ad9\u70b9", null);
    public static final ScopeGroup LINESCOPE_SCOPEGROUP = new ScopeGroup(2L, "\u7ebf\u8def\u56f4\u680f", null);
    public static final ScopeGroup OVERSPEED_SCOPEGROUP = new ScopeGroup(4L, "\u9650\u901f\u533a\u57df", AREA_CMP);
    public static final ScopeGroup CITYSCOPE_SCOPEGROUP = new ScopeGroup(5L, "\u57ce\u533a\u533a\u57df", null);
    private final long id;
    private final String name;
    private static final Comparator<Scope> DEFAULT_CMP = Comparator.comparingLong(Scope::id);
    private final SortedSet<Scope> scopes;
    static final Map<Long, Scope> SCOPE_QUICK_MAP = new ConcurrentHashMap<Long, Scope>();

    ScopeGroup(long id, String name, Comparator<Scope> cmp) {
        this.id = id;
        this.name = name;
        this.scopes = new ConcurrentSkipListSet<Scope>(cmp != null ? cmp : DEFAULT_CMP);
    }

    public long id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Scope firstInside(IGeoPoint gps) {
        for (Scope scope : this.scopes()) {
            if (!scope.inside(gps)) continue;
            return scope;
        }
        return null;
    }

    public Scope firstInside(IGeoPoint gps, Predicate<Scope> filter) {
        for (Scope scope : this.scopes()) {
            if (!filter.test(scope) || !scope.inside(gps)) continue;
            return scope;
        }
        return null;
    }

    public Collection<Scope> allInside(IGeoPoint gps) {
        return this.scopes().stream().filter(scope -> scope.inside(gps)).collect(Collectors.toList());
    }

    public Collection<Scope> scopes() {
        return Collections.unmodifiableCollection(this.scopes);
    }

    static Scope QuickScope(long scopeId) {
        return SCOPE_QUICK_MAP.get(scopeId);
    }

    void removeScope(long scopeId) {
        this.scopes.stream().filter(scope -> scope.id() == scopeId).collect(Collectors.toList()).forEach(this.scopes::remove);
        SCOPE_QUICK_MAP.remove(scopeId);
    }

    void addScope(Scope scope) {
        this.scopes.add(scope);
        SCOPE_QUICK_MAP.put(scope.id(), scope);
    }

    void flushScope(Scope scope) {
        this.removeScope(scope.id());
        this.addScope(scope);
    }

    void addAllScope(Collection<Scope> scopes) {
        this.scopes.stream().mapToLong(Scope::id).forEach(SCOPE_QUICK_MAP::remove);
        this.scopes.clear();
        this.scopes.addAll(scopes);
        SCOPE_QUICK_MAP.putAll(scopes.stream().collect(Collectors.toMap(Scope::id, Function.identity())));
    }

    public Scope scope(long scopeId) {
        return this.scopes.stream().filter(s -> s.id() == scopeId).findAny().orElse(null);
    }

    @Override
    public Iterator<Scope> iterator() {
        return this.scopes().iterator();
    }

    public String toString() {
        return "{scopeGroup" + this.id() + "," + this.name + " scopes:" + this.scopes.size() + "}";
    }
}

