/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.geo;

import cn.gongler.util.sgeo.geo.IGeoPoint;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class EquidistancePolylineBuilder {
    private static final long serialVersionUID = 11369096263413918L;
    private final int meter;
    LinkedList<IGeoPoint> points = new LinkedList();

    public static EquidistancePolylineBuilder of(int meter) {
        return new EquidistancePolylineBuilder(meter);
    }

    private EquidistancePolylineBuilder(int meter) {
        this.meter = meter;
    }

    private static IGeoPoint CreateNext(IGeoPoint previous, IGeoPoint targetPoint, int meters) {
        double distanceMeters = previous.metersTo(targetPoint);
        if (distanceMeters < (double)meters) {
            return null;
        }
        double persent = (double)meters / distanceMeters;
        return IGeoPoint.of(previous.gpsLng() + (targetPoint.gpsLng() - previous.gpsLng()) * persent, previous.gpsLat() + (targetPoint.gpsLat() - previous.gpsLat()) * persent);
    }

    private List<IGeoPoint> createMiddlePoints(IGeoPoint point1, IGeoPoint point2) {
        IGeoPoint next;
        ArrayList<IGeoPoint> middlePoints = new ArrayList<IGeoPoint>();
        IGeoPoint previous = point1;
        while ((next = EquidistancePolylineBuilder.CreateNext(previous, point2, this.meter)) != null) {
            middlePoints.add(next);
            previous = next;
        }
        return middlePoints;
    }

    public EquidistancePolylineBuilder add(IGeoPoint point) {
        if (!this.points.isEmpty()) {
            IGeoPoint previous = this.points.getLast();
            List<IGeoPoint> middlePoints = this.createMiddlePoints(previous, point);
            this.points.addAll(middlePoints);
        }
        this.points.add(point);
        return this;
    }

    public EquidistancePolylineBuilder addAll(List<IGeoPoint> points) {
        for (IGeoPoint point : points) {
            this.add(point);
        }
        return this;
    }

    public List<IGeoPoint> build() {
        return this.points;
    }
}

