/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.resend;

import cn.gongler.util.GonglerUtil;
import java.io.Closeable;
import java.time.LocalDateTime;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResenderEngineer
implements Closeable {
    private static final long serialVersionUID = -7775477028134507369L;
    private final long TICK_TIME = 100L;
    private final AtomicLong resendSeconds = new AtomicLong(20L);
    private volatile boolean cancel = false;
    private final BlockingQueue<TaskWrapper> sendingQueue = new LinkedBlockingQueue<TaskWrapper>();
    private final Thread worker = GonglerUtil.StartDaemonThread("Resend.worker", () -> {
        int frame = 0;
        while (!this.cancel) {
            LocalDateTime jobPlanTime;
            TaskWrapper taskWrapper;
            ++frame;
            LocalDateTime currentTime = LocalDateTime.now();
            while ((taskWrapper = (TaskWrapper)this.sendingQueue.peek()) != null && ((jobPlanTime = taskWrapper.getTimeoutTime()).isBefore(currentTime) || jobPlanTime.isBefore(LocalDateTime.now()))) {
                this.sendingQueue.poll();
                if (taskWrapper.isCancel()) continue;
                if (taskWrapper.expiredTime().isAfter(currentTime)) {
                    try {
                        taskWrapper.notifyResendEvent(currentTime);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LocalDateTime nextPlanTime = currentTime.plusSeconds(this.resendSeconds());
                    taskWrapper.initTimeoutTime(nextPlanTime);
                    this.sendingQueue.offer(taskWrapper);
                    continue;
                }
                try {
                    taskWrapper.expired(currentTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (frame % 4095 == 0) {
                // empty if block
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ResenderEngineer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    });

    ResenderEngineer() {
    }

    public ResenderEngineer resendSeconds(long resendSeconds) {
        this.resendSeconds.set(resendSeconds);
        return this;
    }

    private long resendSeconds() {
        return this.resendSeconds.get();
    }

    public ISendTaskRef addSendTask(IntConsumer send, LocalDateTime expiredTime, IntConsumer expiredEventListener) {
        TaskWrapper task = new TaskWrapper(send, expiredTime, expiredEventListener);
        this.sendingQueue.offer(task);
        return task;
    }

    public void removeSendTask(ISendTaskRef taskRef) {
        if (taskRef instanceof TaskWrapper) {
            TaskWrapper wrapper = (TaskWrapper)taskRef;
            wrapper.cancel();
        }
    }

    public int getQueueSize() {
        return this.sendingQueue.size();
    }

    @Override
    public void close() {
        this.cancel = true;
        this.worker.interrupt();
    }

    private class TaskWrapper
    implements ISendTaskRef {
        private static final long serialVersionUID = 1L;
        private final LocalDateTime createTime = LocalDateTime.now();
        private final IntConsumer task;
        private final LocalDateTime expiredTime;
        private final IntConsumer expiredEventListener;
        private int sendTimes = 0;
        private LocalDateTime timeoutTime;
        private volatile boolean cancel = false;

        TaskWrapper(IntConsumer task, LocalDateTime expiredTime, IntConsumer expiredEventListener) {
            this.task = task;
            this.expiredTime = expiredTime;
            this.expiredEventListener = expiredEventListener;
            this.timeoutTime = LocalDateTime.now().plusSeconds(ResenderEngineer.this.resendSeconds());
        }

        public void notifyResendEvent(LocalDateTime currentTime) {
            ++this.sendTimes;
            GonglerUtil.ExecuteWithCatchAny(() -> this.task.accept(1 + this.sendTimes));
        }

        public LocalDateTime expiredTime() {
            return this.expiredTime;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public LocalDateTime getTimeoutTime() {
            return this.timeoutTime;
        }

        public void initTimeoutTime(LocalDateTime timeoutTime) {
            this.timeoutTime = timeoutTime;
        }

        private void expired(LocalDateTime currentTime) {
            this.expiredEventListener.accept(1 + this.sendTimes);
        }

        public boolean isCancel() {
            return this.cancel;
        }

        public void cancel() {
            this.cancel = true;
        }
    }

    public static interface ISendTaskRef {
    }
}

