/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.Bytesable;
import cn.gongler.util.protocol.itemtype.DatetimeBcdItemType;
import cn.gongler.util.protocol.itemtype.ItemType;
import cn.gongler.util.protocol.itemtype.IteratorBuilder;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Map;

public class Item
implements Bytesable {
    private static final long serialVersionUID = 1L;
    private final ItemType refType;
    private Object value;

    public Item(ItemType itemType, Object value) {
        this.refType = itemType;
        this.value = value;
    }

    public ItemType itemType() {
        return this.refType;
    }

    public Object getValue() {
        return this.value;
    }

    public Item setValue(Object value) {
        if (value == null) {
            value = this.refType.create().getValue();
        } else if (value instanceof Item) {
            throw new IllegalArgumentException("Item.Value MUST be not Item.");
        }
        this.refType.safeSetItemValue(this, value);
        return this;
    }

    public void unsafeSetValue(Object value) {
        this.value = value;
    }

    public long longValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return 0L;
    }

    public double doubleValue() {
        return this.longValue();
    }

    public int intValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return 0;
    }

    public String stringValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return "";
    }

    public LocalDateTime datetimeValue() {
        if (this.value instanceof LocalDateTime) {
            return (LocalDateTime)this.value;
        }
        return DatetimeBcdItemType.INIT_VAL;
    }

    public final Item getSubitem(int key) {
        return this.refType.getSubitemImpl(this, key);
    }

    public final Item setSubitem(int key, Object newValue) {
        this.refType.setSubitemImpl(this, key, newValue);
        return this;
    }

    public final Item addSubitem(Item subitem) {
        return this.addSubitem(subitem.getValue());
    }

    public final Item addSubitem(Object subitemValue) {
        this.refType.addSubitemImpl(this, subitemValue);
        return this;
    }

    public byte[] bytesValue() {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return new byte[0];
    }

    @Override
    public void toBytes(BytesBuilder out) {
        this.refType.toBytes(this.value, out);
    }

    public void toFlatObject(IteratorBuilder<Object> build) {
        this.refType.toFlatObject(this, build);
    }

    public final String formatFlatObjects() {
        return this.itemType().formatFlatObjects(this);
    }

    public String toString() {
        return this.refType.toString(this.getValue());
    }

    public int statementParam(CallableStatement statement, int pos) throws SQLException {
        return this.refType.statementParamImpl(this, statement, pos);
    }

    public Timestamp toTimestamp() {
        return Timestamp.valueOf((LocalDateTime)this.getValue());
    }

    public double toDouble() {
        return this.refType.toDoubleImpl(this);
    }

    public Map<Long, Item> mapValue() {
        return (Map)this.getValue();
    }
}

