/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.BytesItemType;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Scanner;

public class DatetimeBcdItemType
extends ItemType<BytesItemType> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTime INIT_VAL = LocalDateTime.of(2000, 1, 1, 1, 1, 1);
    final DatetimeBcdType datetimieBcdType;
    private static final DateTimeFormatter YYYYMMDD_HHMMSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static DatetimeBcdItemType YYMMDDHHMMSS(String name) {
        return new DatetimeBcdItemType(name, DatetimeBcdType.YYMMDDHHMMSS);
    }

    public static DatetimeBcdItemType YYMMDD(String name) {
        return new DatetimeBcdItemType(name, DatetimeBcdType.YYMMDD);
    }

    public DatetimeBcdItemType(String name) {
        this(name, DatetimeBcdType.YYMMDDHHMMSS);
    }

    public DatetimeBcdItemType(String name, DatetimeBcdType datetimieBcdType) {
        super(name);
        this.datetimieBcdType = datetimieBcdType;
    }

    @Override
    protected Class insideValueClass() {
        return LocalDateTime.class;
    }

    @Override
    public Item create() {
        LocalDateTime datetime = LocalDateTime.now();
        return this._newItem(datetime);
    }

    @Override
    public Item load(Scanner in) {
        LocalDateTime datetime = GonglerUtil.LocalDateTime2000_01_01;
        try {
            String value = in.next();
            datetime = LocalDateTime.parse(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._newItem(datetime);
    }

    @Override
    public Item load(BytesLoader in) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (this.datetimieBcdType.hasDate) {
            year = 2000 + in.loadBcdInt(1);
            month = in.loadBcdInt(1);
            day = in.loadBcdInt(1);
        }
        if (this.datetimieBcdType.hasTime) {
            hour = in.loadBcdInt(1);
            minute = in.loadBcdInt(1);
            second = in.loadBcdInt(1);
        }
        LocalDateTime datetime = LocalDateTime.of(year, month, day, hour, minute, second);
        return this._newItem(datetime);
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setTimestamp(pos++, item.toTimestamp());
        return 1;
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        LocalDateTime datetime = (LocalDateTime)itemValue;
        if (this.datetimieBcdType.hasDate) {
            out.addBcd(1, (long)(datetime.getYear() % 100));
            out.addBcd(1, (long)datetime.getMonthValue());
            out.addBcd(1, (long)datetime.getDayOfMonth());
        }
        if (this.datetimieBcdType.hasTime) {
            out.addBcd(1, (long)datetime.getHour());
            out.addBcd(1, (long)datetime.getMinute());
            out.addBcd(1, (long)datetime.getSecond());
        }
    }

    @Override
    public String toString(Object itemValue) {
        if (itemValue instanceof LocalDateTime) {
            LocalDateTime datetime = (LocalDateTime)itemValue;
            return YYYYMMDD_HHMMSS.format(datetime);
        }
        throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef" + itemValue);
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum DatetimeBcdType {
        YYMMDDHHMMSS(6, true, true),
        YYMMDD(3, true, false),
        HHMMSS(3, false, true);

        int len;
        private final boolean hasDate;
        private final boolean hasTime;

        private DatetimeBcdType(int len, boolean date, boolean time) {
            this.len = len;
            this.hasDate = date;
            this.hasTime = time;
        }

        public int len() {
            return this.len;
        }
    }
}

