/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Scanner;

public class BcdItemTypeAsString
extends ItemType<BcdItemTypeAsString> {
    private static final long serialVersionUID = 1L;
    private final int bytes;
    private final String INIT_VAL;

    public BcdItemTypeAsString(int bytes, String name) {
        super(name);
        this.bytes = bytes;
        char[] chars = new char[bytes * 2];
        Arrays.fill(chars, '0');
        this.INIT_VAL = new String(chars);
    }

    @Override
    public Item create() {
        return this._newItem(this.INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {
        String value = in.next();
        return this._newItem(value);
    }

    @Override
    public Item load(BytesLoader in) {
        byte[] buf;
        if (this.bytes == 0) {
            buf = in.loadRemainBytes();
        } else {
            int len = this.bytes < 0 ? in.loadUnsignedByte() : this.bytes;
            buf = new byte[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = (byte)in.loadUnsignedByte();
            }
        }
        return this._newItem(BcdItemTypeAsString.Bytes2Hex(buf));
    }

    private String align(String bcdStr) {
        char[] chars = new char[this.bytes * 2];
        Arrays.fill(chars, '0');
        char[] org = bcdStr.toCharArray();
        if (chars.length < org.length) {
            throw new IllegalArgumentException("bcd string is too long:" + bcdStr);
        }
        if (chars.length == org.length) {
            return bcdStr;
        }
        int newFrom = chars.length - org.length;
        Arrays.fill(chars, 0, newFrom, '0');
        System.arraycopy(org, 0, chars, newFrom, org.length);
        return new String(chars);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        String bcdStr = (String)itemValue;
        bcdStr = this.align(bcdStr);
        byte[] byteBlock = BcdItemTypeAsString.Hex2Bytes(bcdStr);
        if (this.bytes < 0) {
            build.addByte(byteBlock.length);
        } else if (this.bytes > 0) {
            if (byteBlock.length != this.bytes) {
                byteBlock = Arrays.copyOf(byteBlock, this.bytes);
            }
        } else if (this.bytes == 0) {
            // empty if block
        }
        build.addBytes(byteBlock);
    }

    @Override
    protected Class insideValueClass() {
        return String.class;
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setString(pos++, this.toString(item.getValue()));
        return 1;
    }

    static byte[] Hex2Bytes(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        for (int i = 0; i < chars.length; i += 2) {
            int hi = Character.digit(chars[i], 16);
            int lo = Character.digit(chars[i + 1], 16);
            bytes[i / 2] = (byte)(hi << 4 | lo);
        }
        return bytes;
    }

    static String Bytes2Hex(byte[] bytes) {
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder build = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            build.append(digits[aByte >>> 4 & 0xF]);
            build.append(digits[aByte & 0xF]);
        }
        return build.toString();
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

