/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import java.util.Scanner;

public class BcdItemTypeAsLong
extends ItemType<BcdItemTypeAsLong> {
    private static final long serialVersionUID = 1L;
    protected final int bytes;
    private final Long INIT_VAL = 0L;

    public BcdItemTypeAsLong(int bytes, String name) {
        super(name);
        this.bytes = bytes;
    }

    @Override
    public Item create() {
        return this._newItem(this.INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {
        long value = this.INIT_VAL;
        try {
            value = in.nextLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._newItem(value);
    }

    @Override
    public Item load(BytesLoader in) {
        long value = in.loadBcd(this.bytes);
        return this._newItem(value);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        long val = (Long)itemValue;
        out.addBcd(this.bytes, val);
    }

    @Override
    public String toString(Object itemValue) {
        if (itemValue instanceof Long) {
            return Long.toHexString((Long)itemValue);
        }
        if (itemValue instanceof Number) {
            return this.toString(((Number)itemValue).longValue());
        }
        throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef" + itemValue);
    }

    @Override
    protected Class insideValueClass() {
        return Long.class;
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

