/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.math;

import java.math.BigInteger;

class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    private static final long serialVersionUID = -1L;
    public static final long MIN_VALUE = Long.MIN_VALUE;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final Class<UnsignedLong> TYPE = UnsignedLong.class;
    private final long value;
    public static final int SIZE = 64;
    public static final int BYTES = 8;

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static String toHexString(long i) {
        return Long.toUnsignedString(i, 16);
    }

    public static String toOctalString(long i) {
        return Long.toOctalString(i);
    }

    public static String toBinaryString(long i) {
        return Long.toBinaryString(i);
    }

    public static String toString(long i) {
        return Long.toUnsignedString(i);
    }

    public static long parse(String s, int radix) throws NumberFormatException {
        return Long.parseUnsignedLong(s, radix);
    }

    public static long parse(String s) throws NumberFormatException {
        return UnsignedLong.parse(s, 10);
    }

    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return Long.parseUnsignedLong(s);
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return UnsignedLong.parse(s, radix);
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return UnsignedLong.parse(s, 10);
    }

    public static Long valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Long decode(String nm) throws NumberFormatException {
        Long result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Long.valueOf(nm.substring(index), radix);
            result = negative ? Long.valueOf(-result.longValue()) : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Long.valueOf(constant, radix);
        }
        return result;
    }

    public UnsignedLong(long value) {
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return UnsignedLong.toString(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedLong) {
            return this.value == ((UnsignedLong)obj).value;
        }
        return false;
    }

    public static Long getLong(String nm, Long val) {
        String v = null;
        try {
            v = System.getProperty(nm);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (v != null) {
            try {
                return Long.decode(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    @Override
    public int compareTo(UnsignedLong anotherLong) {
        return Long.compareUnsigned(this.value, anotherLong.value);
    }

    public static int compare(long x, long y) {
        return Long.compareUnsigned(x, y);
    }

    public static int compareUnsigned(long x, long y) {
        return UnsignedLong.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor < 0L) {
            return UnsignedLong.compareUnsigned(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend > 0L) {
            return dividend / divisor;
        }
        return UnsignedLong.toUnsignedBigInteger(dividend).divide(UnsignedLong.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (dividend > 0L && divisor > 0L) {
            return dividend % divisor;
        }
        if (UnsignedLong.compareUnsigned(dividend, divisor) < 0) {
            return dividend;
        }
        return UnsignedLong.toUnsignedBigInteger(dividend).remainder(UnsignedLong.toUnsignedBigInteger(divisor)).longValue();
    }

    public static long highestOneBit(long i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        i |= i >> 32;
        return i - (i >>> 1);
    }

    public static long lowestOneBit(long i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)(i >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)i;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static int numberOfTrailingZeros(long i) {
        int x;
        if (i == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)i;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(i >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    public static int bitCount(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    public static long rotateLeft(long i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static long reverse(long i) {
        i = (i & 0x5555555555555555L) << 1 | i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) << 2 | i >>> 2 & 0x3333333333333333L;
        i = (i & 0xF0F0F0F0F0F0F0FL) << 4 | i >>> 4 & 0xF0F0F0F0F0F0F0FL;
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        i = i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
        return i;
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        return i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    private static class LongCache {
        static final Long[] cache = new Long[256];

        private LongCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                LongCache.cache[i] = new Long(i - 128);
            }
        }
    }
}

