/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;

public class DelegateOutputStream
extends FilterOutputStream {
    final IntUnaryOperator mapper;

    public static DelegateOutputStream filter(OutputStream out, IntUnaryOperator mapper) {
        return new DelegateOutputStream(out, mapper);
    }

    public static DelegateOutputStream consumer(OutputStream out, IntConsumer consumer) {
        return new DelegateOutputStream(out, a -> {
            consumer.accept(a);
            return a;
        });
    }

    public static DelegateOutputStream consoleHex(OutputStream out) {
        return DelegateOutputStream.consumer(out, a -> {
            if (a >= 0) {
                System.out.printf("%2X", a & 0xFF);
            }
        });
    }

    public static DelegateOutputStream console(OutputStream out) {
        return DelegateOutputStream.consumer(out, a -> {
            if (a >= 0) {
                System.out.printf("%c", Character.valueOf((char)a));
            }
        });
    }

    public static DelegateOutputStream consumer(IntConsumer consumer) {
        return new DelegateOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }, a -> {
            consumer.accept(a);
            return a;
        });
    }

    DelegateOutputStream(OutputStream out, IntUnaryOperator mapper) {
        super(out);
        this.mapper = mapper;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(this.mapper.applyAsInt(b));
    }
}

