/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.function;

import java.util.Objects;
import java.util.function.Function;

public interface NullableFunction<T, R>
extends Function<T, R> {
    public static <T1, R1> NullableFunction<T1, R1> of(NullableFunction<T1, R1> map) {
        NullableFunction headMapper = a -> a;
        return headMapper.then(map);
    }

    default public <V> NullableFunction<T, V> then(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> {
            if (t == null) {
                return null;
            }
            Object r = this.apply(t);
            if (r == null) {
                return null;
            }
            return after.apply((R)r);
        };
    }

    default public <V> NullableFunction<V, R> before(Function<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> {
            if (v == null) {
                return null;
            }
            Object t = before.apply((Object)v);
            if (t == null) {
                return null;
            }
            return this.apply(t);
        };
    }

    default public R apply(T t, R defaultVal) {
        if (t == null) {
            return defaultVal;
        }
        Object ret = this.apply(t);
        if (ret == null) {
            return defaultVal;
        }
        return ret;
    }

    @Override
    @Deprecated
    default public <V> NullableFunction<T, V> andThen(Function<? super R, ? extends V> after) {
        return this.then(after);
    }

    @Override
    @Deprecated
    default public <V> NullableFunction<V, R> compose(Function<? super V, ? extends T> before) {
        return this.before(before);
    }
}

