/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.db;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.function.ExceptionFunction;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DbUtil {
    private static final long serialVersionUID = 8761451535995732352L;

    private DbUtil() {
    }

    public static void Rollback(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int ExecuteUpdate(Connection conn, String sql, Object ... args) {
        try (PreparedStatement smt = conn.prepareStatement(sql);){
            int n = DbUtil.PreparedStatementWithArgs(smt, args).executeUpdate();
            return n;
        }
        catch (Exception e) {
            DbUtil.Rollback(conn);
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public static int ExecuteUpdate(Connection conn, PreparedStatement smt, Object ... args) {
        try {
            return DbUtil.PreparedStatementWithArgs(smt, args).executeUpdate();
        }
        catch (Exception e) {
            DbUtil.Rollback(conn);
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean Execute(Connection conn, String sql, Object ... args) {
        try (PreparedStatement smt = conn.prepareStatement(sql);){
            boolean bl = DbUtil.PreparedStatementWithArgs(smt, args).execute();
            return bl;
        }
        catch (Exception e) {
            DbUtil.Rollback(conn);
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ExecuteSimpleCall(Connection conn, String sql, Object ... args) {
        int whyCnt = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++whyCnt;
        }
        int argCnt = args.length;
        if (whyCnt != argCnt) {
            System.out.println("\n!!!!!!!?Cnt=" + whyCnt + "<>argCnt" + argCnt + ", " + sql + Arrays.toString(args) + "\n\n");
        }
        try (CallableStatement smt = conn.prepareCall(sql);){
            boolean bl = DbUtil.PreparedStatementWithArgs(smt, args).execute();
            return bl;
        }
        catch (Exception e) {
            DbUtil.Rollback(conn);
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public static void ExecuteQuery(Connection conn, String query, RowHandler hander) {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            DbUtil.ExecuteQuery(conn, rs, hander);
        }
        catch (SQLException e) {
            throw GonglerUtil.toRuntimeException(new SQLException(e.toString() + " when " + query, e));
        }
    }

    private static void ExecuteQuery(Connection conn, ResultSet rs, RowHandler hander) {
        if (conn == null || rs == null) {
            return;
        }
        try {
            int index = 0;
            while (rs.next()) {
                hander.rowHandle(rs, index++);
            }
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public static void ExecuteQuery(Connection conn, String query, RowHandler hander, Object ... args) {
        try (PreparedStatement smt = conn.prepareStatement(query);){
            DbUtil.PreparedStatementWithArgs(smt, args);
            ResultSet rs = smt.executeQuery();
            int index = 0;
            while (rs.next()) {
                hander.rowHandle(rs, index++);
            }
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(new SQLException(e.toString() + " when " + query, e));
        }
    }

    public static <S extends PreparedStatement> S PreparedStatementWithArgs(S smt, Object ... args) throws SQLException {
        int argIndex = 1;
        for (Object arg : args) {
            if (arg instanceof Integer) {
                smt.setInt(argIndex, (Integer)arg);
            } else if (arg instanceof Long) {
                smt.setLong(argIndex, (Long)arg);
            } else if (arg instanceof String) {
                smt.setString(argIndex, (String)arg);
            } else if (arg instanceof Timestamp) {
                smt.setTimestamp(argIndex, (Timestamp)arg);
            } else if (arg instanceof Double) {
                smt.setDouble(argIndex, (Double)arg);
            } else if (arg instanceof Float) {
                smt.setFloat(argIndex, ((Float)arg).floatValue());
            } else if (arg instanceof RowId) {
                smt.setRowId(argIndex, (RowId)arg);
            } else if (arg instanceof Short) {
                smt.setShort(argIndex, (Short)arg);
            } else if (arg instanceof Blob) {
                smt.setBlob(argIndex, (Blob)arg);
            } else if (arg == null) {
                smt.setObject(argIndex, null);
            } else {
                throw new IllegalArgumentException("index=" + argIndex + ", arg=" + arg);
            }
            ++argIndex;
        }
        return smt;
    }

    public static <T> Stream<T> Stream(ResultSet rs, ExceptionFunction<ResultSet, T> t) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(GonglerUtil.IterableAdapter(rs).iterator(), 0), false).map(t::applyWithThrowAny).filter(Objects::nonNull);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R> R Stream(Connection conn, ExceptionFunction<ResultSet, T> t, ExceptionFunction<Stream<T>, R> mapper, String query, Object ... args) {
        try (PreparedStatement smt = conn.prepareStatement(query);){
            R r = mapper.applyWithThrowAny(DbUtil.Stream(DbUtil.PreparedStatementWithArgs(smt, args).executeQuery(), t));
            return r;
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Stream<T> Stream(Connection conn, ExceptionFunction<ResultSet, T> t, String query, Object ... args) {
        try (PreparedStatement smt = conn.prepareStatement(query);){
            Stream stream = DbUtil.Stream(DbUtil.PreparedStatementWithArgs(smt, args).executeQuery(), t).collect(Collectors.toList()).stream();
            return stream;
        }
        catch (SQLException e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public static interface RowHandler {
        default public void begin() {
        }

        public void rowHandle(ResultSet var1, int var2) throws Exception;

        default public void finished(int count) {
        }
    }
}

