/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.concurrent;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class LinkedTable<E>
extends AbstractCollection<E>
implements Iterable<E> {
    private static final long serialVersionUID = 1500038516065571125L;
    private final LinkedNode HeadNode;

    public LinkedTable(Class<E> aClass) {
        this.HeadNode = new LinkedNode(aClass);
    }

    public LinkedNode headNode() {
        return this.HeadNode;
    }

    public LinkedNode lastNormalNode() {
        LinkedNode firstNormalNode = this.headNode().next;
        return firstNormalNode == null ? null : firstNormalNode.loopFindNextNormalNode(node -> ((LinkedNode)node).next == null);
    }

    public LinkedNode addNode(E e) {
        Objects.requireNonNull(e);
        return this.HeadNode.append(e);
    }

    @Override
    public boolean add(E e) {
        this.addNode(e);
        return true;
    }

    public LinkedNode findNode(Predicate<E> condition) {
        LinkedNode cur = this.HeadNode;
        while ((cur = cur.next) != null) {
            if (!condition.test(cur.get())) continue;
            return cur;
        }
        return null;
    }

    public LinkedNode getNode(E e) {
        return this.findNode(val -> Objects.equals(e, val));
    }

    @Override
    public int size() {
        LinkedNode cur = this.HeadNode;
        int cnt = 0;
        while ((cur = cur.next) != null) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean isEmpty() {
        return this.headNode().next == null;
    }

    @Override
    public String toString() {
        return this.toDetailString();
    }

    public String toDetailString() {
        StringBuilder buf = new StringBuilder();
        buf.append("LinkedTable.size:").append(this.size());
        String itemsToString = this.stream().map(String::valueOf).collect(Collectors.joining(", ", "{", "}"));
        buf.append(itemsToString);
        return buf.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            LinkedNode cur;
            LinkedNode nextModifiedWhenCheckNext;
            {
                this.cur = LinkedTable.this.HeadNode;
            }

            @Override
            public boolean hasNext() {
                this.nextModifiedWhenCheckNext = this.cur.next;
                return this.nextModifiedWhenCheckNext != null;
            }

            @Override
            public E next() {
                this.cur = this.nextModifiedWhenCheckNext;
                return this.cur.get();
            }
        };
    }

    public class LinkedNode {
        private final E val;
        private LinkedNode next = null;

        public LinkedNode(E e) {
            this.val = e;
        }

        public LinkedNode(Class<E> aClass) {
            this.val = null;
        }

        public LinkedNode append(E e) {
            LinkedNode oldNext;
            LinkedNode newNext = new LinkedNode(e);
            newNext.next = oldNext = this.next;
            this.next = newNext;
            return newNext;
        }

        public LinkedNode next() {
            return this.next;
        }

        public LinkedNode loopNext() {
            LinkedNode next2 = this.next;
            if (next2 == null) {
                next2 = LinkedTable.this.headNode().next;
            }
            return next2;
        }

        public E get() {
            return this.val;
        }

        public boolean isTail() {
            return this.next() == null;
        }

        public String toString() {
            return this.val + (this.next == null ? "_nextIsNull" : "") + "_tail:" + this.isTail();
        }

        public Iterable<LinkedNode> nextTurnAfterCurrentNode() {
            return () -> new Iterator<LinkedNode>(){
                int selfCount;
                LinkedNode cur;
                LinkedNode nextModifiedWhenCheckNext;
                {
                    this.cur = LinkedNode.this;
                    this.selfCount = 0;
                }

                private LinkedNode _next() {
                    if (LinkedNode.this == LinkedTable.this.headNode()) {
                        return this.cur.next;
                    }
                    if (this.cur == LinkedNode.this && this.selfCount == 1) {
                        return null;
                    }
                    return this.cur.loopNext();
                }

                @Override
                public boolean hasNext() {
                    this.nextModifiedWhenCheckNext = this._next();
                    return this.nextModifiedWhenCheckNext != null;
                }

                @Override
                public LinkedNode next() {
                    LinkedNode next = this.nextModifiedWhenCheckNext;
                    if (next == LinkedNode.this) {
                        ++this.selfCount;
                    }
                    this.cur = next;
                    return next;
                }
            };
        }

        public LinkedNode loopFindNextNormalNode(Predicate<LinkedNode> test) {
            for (LinkedNode node : this.nextTurnAfterCurrentNode()) {
                if (!test.test(node)) continue;
                return node;
            }
            return null;
        }
    }
}

