/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.concurrent;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.ITask;
import cn.gongler.util.Recently;
import cn.gongler.util.concurrent.CloseRegister;
import cn.gongler.util.concurrent.LinkedTable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;

public class ConcurrentBusExecutor
implements BiConsumer<Long, ITask> {
    private static final long serialVersionUID = -6245783377880067812L;
    protected final Thread[] threads;
    private final Map<Long, BusContext> busMap = new ConcurrentHashMap<Long, BusContext>();
    private final LinkedTable<BusContext> busLinkedTable = new LinkedTable<BusContext>(BusContext.class);
    private final Recently<TaskWrapper> taskHis = new Recently(30);
    private final Recently<TaskWrapper> tooLongTimeTaskHis = new Recently(15);
    private static boolean debug = false;

    public ConcurrentBusExecutor(int nThread) {
        this.threads = new Thread[nThread];
        for (int i = 0; i < nThread; ++i) {
            this.threads[i] = GonglerUtil.StartDaemonThread("ConcurrentBusExecutor.worker" + i, () -> {
                LinkedTable.LinkedNode previousNode = this.busLinkedTable.headNode();
                int frame = 0;
                block11: while (true) {
                    ++frame;
                    LinkedTable.LinkedNode nextWaitingNode = this.nextWaitingBus(previousNode);
                    if (nextWaitingNode == null) {
                        Thread.sleep(100L);
                        continue;
                    }
                    previousNode = nextWaitingNode;
                    BusContext bus = (BusContext)nextWaitingNode.get();
                    Runnable[] runnableArray = new Runnable[1];
                    runnableArray[0] = bus::leaveQueue;
                    CloseRegister end = CloseRegister.of(runnableArray);
                    Throwable throwable = null;
                    try {
                        while (true) {
                            TaskWrapper task;
                            if ((task = bus.pollTask()) == null) continue block11;
                            try {
                                task.execute();
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (end == null) continue;
                        if (throwable != null) {
                            try {
                                end.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        end.close();
                        continue;
                    }
                    break;
                }
            });
        }
        ConcurrentBusExecutor.log("\n init finished.");
    }

    @Override
    public void accept(Long busKey, ITask task) {
        TaskWrapper taskWrap = new TaskWrapper(busKey, task);
        ConcurrentBusExecutor.log("push()" + busKey + ", " + task);
        this.taskHis.push(taskWrap);
        boolean ret = this.Bus(busKey).push(taskWrap);
    }

    private LinkedTable.LinkedNode nextWaitingBus(LinkedTable.LinkedNode previousNode) throws InterruptedException {
        return previousNode.loopFindNextNormalNode(node -> ((BusContext)node.get()).isReadReadly());
    }

    public long size() {
        long count = 0L;
        for (BusContext bus : this.busLinkedTable) {
            count += (long)bus.queue.size();
        }
        return count;
    }

    public long total() {
        long count = 0L;
        for (BusContext bus : this.busLinkedTable) {
            count += bus.pushCount;
        }
        return count;
    }

    public Map<Long, Integer> toMap() {
        TreeMap<Long, Integer> map = new TreeMap<Long, Integer>();
        for (BusContext bus : this.busLinkedTable) {
            if (bus.queue.isEmpty()) continue;
            map.put(bus.busId(), bus.queue.size());
        }
        return map;
    }

    public Map<Long, Collection<TaskWrapper>> toTaskMap() {
        TreeMap<Long, Collection<TaskWrapper>> map = new TreeMap<Long, Collection<TaskWrapper>>();
        for (BusContext bus : this.busLinkedTable) {
            Collection<TaskWrapper> tasks = bus.tasks();
            if (bus.queue.isEmpty()) continue;
            map.put(bus.busId(), Collections.unmodifiableCollection(tasks));
        }
        return map;
    }

    public Collection<TaskWrapper> getTasks(Long busId) {
        LinkedTable.LinkedNode node = this.busLinkedTable.findNode(bus -> bus.busId().equals(busId));
        BusContext bus2 = (BusContext)node.get();
        return Collections.unmodifiableCollection(bus2.queue);
    }

    private BusContext Bus(Long busKey) {
        BusContext bus = this.busMap.computeIfAbsent(busKey, id -> {
            BusContext b = new BusContext((Long)id);
            this.busLinkedTable.add(b);
            return b;
        });
        return bus;
    }

    private static void log(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public Recently<TaskWrapper> tooLongTimeTaskHis() {
        return this.tooLongTimeTaskHis;
    }

    public Recently<TaskWrapper> taskHis() {
        return this.taskHis;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.size() + "/" + this.total() + ",threads:" + this.threads.length;
    }

    private static class BusContext {
        private final Long busId;
        private final BlockingQueue<TaskWrapper> queue = new LinkedBlockingQueue<TaskWrapper>();
        TaskWrapper previousPollTask = null;
        long pushCount = 0L;
        long offerCount = 0L;
        private boolean using = false;
        private Thread usingThread = null;

        public BusContext(Long busKey) {
            this.busId = busKey;
        }

        public Long busId() {
            return this.busId;
        }

        private boolean push(TaskWrapper task) {
            ++this.pushCount;
            return this.queue.offer(task);
        }

        TaskWrapper pollTask() {
            TaskWrapper ret = (TaskWrapper)this.queue.poll();
            if (ret != null) {
                ++this.offerCount;
                this.previousPollTask = ret;
            }
            return ret;
        }

        public Collection<TaskWrapper> tasks() {
            ArrayList<TaskWrapper> ret = new ArrayList<TaskWrapper>();
            TaskWrapper prev = this.previousPollTask;
            if (prev != null) {
                ret.add(prev);
            }
            ret.addAll(this.queue);
            return ret;
        }

        synchronized boolean isReadReadly() {
            if (!this.queue.isEmpty() && !this.using) {
                this.using = true;
                this.usingThread = Thread.currentThread();
                return true;
            }
            return false;
        }

        synchronized void leaveQueue() {
            this.using = false;
            this.usingThread = null;
            ConcurrentBusExecutor.log("releaveQueue()//" + this);
        }

        public String toString() {
            return this.busId() + "_" + this.using + "_" + this.usingThread + "_queue:" + this.queue.size();
        }
    }

    public static enum TaskState {
        TASK_WAITING,
        TASK_RUNNING,
        TASK_FINISHED;

    }

    public class TaskWrapper {
        private final Long busId;
        private final ITask task;
        private final LocalDateTime createdTime;
        private LocalDateTime beginToHandleTime = null;
        private LocalDateTime finishedTime = null;
        private long millis = -1L;

        TaskWrapper(Long busId, ITask task) {
            this.busId = busId;
            this.task = task;
            this.createdTime = LocalDateTime.now();
        }

        void execute() throws Exception {
            this.beginToHandle();
            try {
                this.task.run();
            }
            finally {
                this.finished();
            }
        }

        void beginToHandle() {
            this.beginToHandleTime = LocalDateTime.now();
        }

        void finished() {
            this.finishedTime = LocalDateTime.now();
            this.millis = Duration.between(this.beginToHandleTime, this.finishedTime).toMillis();
            if (this.millis > 2000L) {
                ConcurrentBusExecutor.this.tooLongTimeTaskHis.push(this);
            }
        }

        public Long busId() {
            return this.busId;
        }

        public ITask task() {
            return this.task;
        }

        public long millns() {
            return this.millis;
        }

        public LocalDateTime createdTime() {
            return this.createdTime;
        }

        public LocalDateTime beginToHandleTime() {
            return this.beginToHandleTime;
        }

        public LocalDateTime finishedTime() {
            return this.finishedTime;
        }

        public TaskState taskState() {
            LocalDateTime beginToHandleTime = this.beginToHandleTime;
            LocalDateTime finishedTime = this.finishedTime;
            TaskState stat = beginToHandleTime == null ? TaskState.TASK_WAITING : (finishedTime == null ? TaskState.TASK_RUNNING : TaskState.TASK_FINISHED);
            return stat;
        }

        public String toString() {
            LocalDateTime beginToHandleTime = this.beginToHandleTime;
            LocalDateTime finishedTime = this.finishedTime;
            TaskState stat = this.taskState();
            StringBuilder buf = new StringBuilder(128).append("task_").append(this.createdTime.toLocalTime()).append("_").append((Object)stat).append("(");
            switch (stat) {
                case TASK_WAITING: {
                    buf.append("waiting:").append(Duration.between(this.createdTime, LocalDateTime.now()));
                    break;
                }
                case TASK_RUNNING: {
                    buf.append("waited:").append(Duration.between(this.createdTime, beginToHandleTime)).append(", executing:").append(Duration.between(beginToHandleTime, LocalDateTime.now()));
                    break;
                }
                case TASK_FINISHED: {
                    buf.append("waited:").append(Duration.between(this.createdTime, beginToHandleTime)).append(", executed:").append(Duration.between(beginToHandleTime, finishedTime));
                }
            }
            return buf.append(")_").append(this.task()).toString();
        }
    }
}

