/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.collection;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MapFluent<K, V> {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> map;

    public MapFluent(Map<K, V> map) {
        this.map = map;
    }

    public static <K, V> MapFluent of(Map<K, V> map) {
        return new MapFluent<K, V>(map);
    }

    public static <K, V> MapFluent<K, V> of() {
        return new MapFluent(new HashMap());
    }

    public static <K, V> MapFluent<K, V> concurrentHashMap() {
        return new MapFluent(new ConcurrentHashMap());
    }

    public MapFluent<K, V> put(K key, V value) {
        this.map.put(key, value);
        return this;
    }

    public MapFluent<K, V> add(K key, V value) {
        return this.put(key, value);
    }

    public Map<K, V> result() {
        return this.map;
    }

    public Stream<Map.Entry<K, V>> stream() {
        return this.map.entrySet().stream();
    }

    public Stream<Map.Entry<K, V>> stream(Predicate<? super V> valPredicate, Predicate<? super K> keyPredicate) {
        return this.map.entrySet().stream().filter(a -> keyPredicate.test((Object)a.getKey())).filter(a -> valPredicate.test((Object)a.getValue()));
    }

    public Stream<Map.Entry<K, V>> stream(Predicate<? super V> valPredicate) {
        return this.map.entrySet().stream().filter(a -> valPredicate.test((Object)a.getValue()));
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    public String toString() {
        return this.map.toString();
    }
}

