/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.HexUtil;
import cn.gongler.util.bytes.ToBytes;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class Str
implements ToBytes {
    private static final long serialVersionUID = 1L;
    private final int byteCnt;
    private final CharSequence msg;
    private final Charset charset;
    private byte ch = 0;

    public static Str of(int byteCnt, CharSequence msg) {
        return Str.utf8(byteCnt, msg);
    }

    public static Str of(int byteCnt, CharSequence msg, Charset charset) {
        return new Str(byteCnt, msg, charset);
    }

    public static Str gbk(int byteCnt, CharSequence msg) {
        return Str.of(byteCnt, msg, Charset.forName("GBK"));
    }

    public static Str utf8(int byteCnt, CharSequence msg) {
        return Str.of(byteCnt, msg, StandardCharsets.UTF_8);
    }

    private Str(int byteCnt, CharSequence msg, Charset charset) {
        this.byteCnt = byteCnt;
        this.msg = msg;
        this.charset = charset;
    }

    public Str filledChar(char ch) {
        this.ch = (byte)ch;
        return this;
    }

    @Override
    public byte[] toBytes() {
        byte[] body = this.msg.toString().getBytes(this.charset);
        if (this.byteCnt > 0) {
            byte[] ret = Arrays.copyOf(body, this.byteCnt);
            if (body.length < this.byteCnt && this.ch != 0) {
                Arrays.fill(ret, body.length, this.byteCnt, this.ch);
            }
            return ret;
        }
        if (this.byteCnt < 0) {
            GonglerUtil.requireLessThenOrEqual(Math.abs(this.byteCnt), 2);
            return BytesBuilder.of().addNum(-this.byteCnt, (long)body.length).addBytes(body).toBytes();
        }
        if (this.byteCnt == 0) {
            return BytesBuilder.of().addBytes(body).toBytes();
        }
        throw new IllegalArgumentException("" + this.byteCnt);
    }

    public String toString() {
        return HexUtil.BytesToHex(this.toBytes());
    }
}

