/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.HexUtil;
import cn.gongler.util.bytes.SimpleByteArrayRange;
import cn.gongler.util.bytes.function.IntByteConsumer;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public interface IBytesRange {
    public byte[] buf();

    public int from();

    public int size();

    default public int getByte(int index) {
        GonglerUtil.require(index >= 0 && index < this.size() || index < 0 && index >= -this.size());
        return this.buf()[this.from() + (index >= 0 ? index : this.size() + index)];
    }

    default public IBytesRange getSubRange(int pos, int size) {
        int absoluteIndex = this.from() + pos >= 0 ? pos : this.size() + pos;
        GonglerUtil.require(absoluteIndex >= 0 && absoluteIndex < this.from() + this.size() && pos + size <= this.size());
        return IBytesRange.of(this::buf, this.from() + pos, size);
    }

    default public String toHex() {
        return HexUtil.BytesToHex(this.buf(), this.from(), this.size());
    }

    default public String toHexMessage() {
        return "(size:" + this.size() + ")" + HexUtil.BytesToHex(this.buf(), this.from(), this.size(), " ");
    }

    default public byte[] toBytes() {
        return Arrays.copyOfRange(this.buf(), this.from(), this.from() + this.size());
    }

    default public byte[] toBytes(int pos, int size) {
        int absoluteIndex = this.from() + (pos >= 0 ? pos : this.size() + pos);
        GonglerUtil.require(absoluteIndex >= 0 && absoluteIndex < this.from() + this.size() && pos + size <= this.size());
        return Arrays.copyOfRange(this.buf(), absoluteIndex, absoluteIndex + size);
    }

    default public IBytesRange println() {
        System.out.println(HexUtil.BytesToMessage(this.toBytes()));
        return this;
    }

    default public void forEach(IntByteConsumer consumer) {
        for (int i = 0; i < this.size(); ++i) {
            consumer.accept(i, this.getByte(i));
        }
    }

    default public void forEach(IntConsumer consumer) {
        for (int i = 0; i < this.size(); ++i) {
            consumer.accept(this.getByte(i));
        }
    }

    default public IntStream toIntStream() {
        return IntStream.range(0, this.size()).map(this::getByte);
    }

    public static IBytesRange of(Supplier<byte[]> bufGetter, int from, int size) {
        return SimpleByteArrayRange.of(bufGetter, from, size);
    }

    public static IBytesRange of(Supplier<byte[]> bufGetter) {
        return SimpleByteArrayRange.of(bufGetter, 0, bufGetter.get().length);
    }

    public static IBytesRange of(byte[] buf, int from, int size) {
        return SimpleByteArrayRange.of(() -> buf, from, size);
    }

    public static IBytesRange of(byte[] buf) {
        return SimpleByteArrayRange.of(() -> buf, 0, buf.length);
    }

    public static IBytesRange of(Byte[] buf, int from, int size) {
        byte[] ret = new byte[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = buf[from + i];
        }
        return IBytesRange.of(ret);
    }

    public static IBytesRange of(Byte[] buf) {
        return IBytesRange.of(buf, 0, buf.length);
    }

    public static IBytesRange of(CharSequence hex) {
        return IBytesRange.of(HexUtil.HexToBytes(hex));
    }
}

