/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.Bits;
import cn.gongler.util.bytes.Bytes;
import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.HexUtil;
import cn.gongler.util.bytes.IBytesRange;
import cn.gongler.util.bytes.SimpleByteArrayRange;
import cn.gongler.util.bytes.ToBytes;
import cn.gongler.util.text.StringLinker;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class BytesLoader {
    private static final long serialVersionUID = -7939956045118259253L;
    private boolean defaultIsBigEndian = true;
    private final byte[] buf;
    private int pos = 0;
    private byte bitBuf = 0;
    private int bitCnt = 0;
    private static final Map<Class, Function<BytesLoader, ?>> map = new HashMap();

    public static BytesLoader of(byte[] buf) {
        return BytesLoader.BigEndian(buf);
    }

    public static BytesLoader LittleEndian(byte[] buf) {
        return new BytesLoader(buf).littleEndian();
    }

    public static BytesLoader BigEndian(byte[] buf) {
        return new BytesLoader(buf).bigEndian();
    }

    public static BytesLoader of(CharSequence hex) {
        return BytesLoader.of(HexUtil.HexToBytes(hex));
    }

    public static BytesLoader of(byte[] buf, int from, int size) {
        return BytesLoader.of(Arrays.copyOfRange(buf, from, from + size));
    }

    public static BytesLoader of(IntStream stream) {
        return BytesLoader.of(BytesBuilder.of().addByteStream(stream).toBytes());
    }

    public static BytesLoader of(List<Byte> list) {
        return BytesLoader.of(list.stream());
    }

    public static BytesLoader of(Stream<Byte> stream) {
        return BytesLoader.of(BytesBuilder.of().addByteStream(stream).toBytes());
    }

    public static BytesLoader of(Byte[] buf) {
        return BytesLoader.of(buf, 0, buf.length);
    }

    public static BytesLoader of(Byte[] buf, int from, int size) {
        return BytesLoader.of(BytesBuilder.of().addBytes(buf, from, size).toBytes());
    }

    public static BytesLoader of(IBytesRange bytesRange) {
        return BytesLoader.of(bytesRange.buf(), bytesRange.from(), bytesRange.size());
    }

    public static BytesLoader of(ToBytes toBytes) {
        byte[] bytes = toBytes.toBytes();
        return BytesLoader.of(bytes, 0, bytes.length);
    }

    public static BytesLoader of(InputStream in) {
        return BytesLoader.of(BytesBuilder.of().addByteStream(in).toBytes());
    }

    public static BytesLoader ofFile(Path binFile) {
        return BytesLoader.of(BytesBuilder.of().addFile(binFile).toBytes());
    }

    public static BytesLoader ofHexFile(Path hexFile) {
        return BytesLoader.of(BytesBuilder.of().addHexFile(hexFile).toBytes());
    }

    protected BytesLoader(byte[] buf) {
        this.buf = buf;
    }

    private BytesLoader littleEndian() {
        this.defaultIsBigEndian = false;
        return this;
    }

    private BytesLoader bigEndian() {
        this.defaultIsBigEndian = true;
        return this;
    }

    public ByteOrder defaultByteOrder() {
        return this.defaultIsBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public BytesLoader defaultByteOrder(ByteOrder defaultByteOrder) {
        this.defaultIsBigEndian = ByteOrder.BIG_ENDIAN.equals(defaultByteOrder);
        return this;
    }

    public int loadUnsignedByte() {
        return this.loadByte() & 0xFF;
    }

    public Long loadLong(int bytes) {
        return this.loadLong(bytes, null);
    }

    public Long loadLong(int bytes, Long defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        return this.defaultIsBigEndian ? this.loadLongBigEndian(bytes) : this.loadLongLittleEndian(bytes);
    }

    public double loadDouble(int bytes, int scale) {
        return (double)this.loadLong(bytes).longValue() / Math.pow(10.0, scale);
    }

    public int loadInt(int bytes) {
        return this.loadLong(bytes, 0L).intValue();
    }

    public int loadInt(int bytes, int defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        return this.loadLong(bytes, 0L).intValue();
    }

    public int loadSignedInt(int bytes) {
        return this.loadSignedInt(bytes, 0);
    }

    public int loadSignedInt(int bytes, int defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        int ret = this.loadInt(bytes);
        if ((ret >>> bytes * 8 - 1 & 1) != 0 && bytes < 4) {
            ret -= 1 << bytes * 8;
        }
        return ret;
    }

    public Integer loadInteger(int bytes) {
        return this.loadInteger(bytes, null);
    }

    public Integer loadInteger(int bytes, Integer defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        return this.loadLong(bytes, 0L).intValue();
    }

    public BigInteger loadBigInteger(int bytes, BigInteger defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        byte[] buf = this.loadBytes(bytes);
        return new BigInteger(buf);
    }

    public BigInteger loadBigInteger(int bytes) {
        return this.loadBigInteger(bytes, null);
    }

    public int loadBcdInt(int bytes) {
        return this.loadBcdInt(bytes, 0);
    }

    public int loadBcdInt(int bytes, int defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        return this.loadBcdInteger(bytes, 0);
    }

    public Integer loadBcdInteger(int bytes) {
        return this.loadBcdInteger(bytes, null);
    }

    public Integer loadBcdInteger(int bytes, Integer defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        return this.loadBcd(bytes, 0L).intValue();
    }

    public Long loadBcd(int bytes) {
        return this.loadBcd(bytes, null);
    }

    public Long loadBcd(int bytes, Long defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        long ret = 0L;
        for (int i = 0; i < bytes; ++i) {
            int b = this.loadUnsignedByte();
            int high = b >> 4 & 0xF;
            int low = b & 0xF;
            if (high > 9 || low > 9) {
                throw new NumberFormatException("BCD: 0x" + Integer.toHexString(b));
            }
            ret = ret * 100L + (long)(high * 10 + low);
        }
        return ret;
    }

    public Long loadLongBigEndian(int bytes) {
        return this.loadLongBigEndian(bytes, null);
    }

    public Long loadLongBigEndian(int bytes, Long defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        long ret = 0L;
        for (int i = 0; i < bytes; ++i) {
            ret <<= 8;
            ret |= (long)this.loadUnsignedByte();
        }
        return ret;
    }

    public Long loadLongLittleEndian(int bytes) {
        return this.loadLongLittleEndian(bytes, null);
    }

    public Long loadLongLittleEndian(int bytes, Long defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        long ret = 0L;
        for (int i = 0; i < bytes; ++i) {
            long currentByte = this.loadUnsignedByte();
            ret |= (currentByte <<= (int)((long)i * 8L));
        }
        return ret;
    }

    public Integer loadIntBigEndian(int bytes) {
        return this.loadIntBigEndian(bytes, null);
    }

    public Integer loadIntBigEndian(int bytes, Integer defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        return this.loadLongBigEndian(bytes).intValue();
    }

    public Integer loadIntLittleEndian(int bytes) {
        return this.loadIntLittleEndian(bytes, null);
    }

    public Integer loadIntLittleEndian(int bytes, Integer defaultVal) {
        if (this.remainBytesCount() < bytes) {
            return defaultVal;
        }
        return this.loadLongLittleEndian(bytes).intValue();
    }

    public byte loadByte() {
        GonglerUtil.requireEquals(0, this.bitCnt);
        int now = this.pos;
        byte ret = now >= this.buf.length ? (byte)0 : this.buf[now];
        ++this.pos;
        return ret;
    }

    public BytesLoader skip(int len) {
        for (int i = 0; i < len; ++i) {
            this.loadByte();
        }
        return this;
    }

    public byte[] loadBytes(int bodyLen) {
        byte[] ret = new byte[bodyLen];
        for (int i = 0; i < bodyLen; ++i) {
            ret[i] = this.loadByte();
        }
        return ret;
    }

    public IBytesRange loadBytesRange(int bodyLen) {
        if (this.remainBytesCount() > bodyLen) {
            return IBytesRange.of(this.buf, this.pos, bodyLen);
        }
        return IBytesRange.of(Arrays.copyOfRange(this.buf, this.pos, this.pos + bodyLen));
    }

    public byte[] loadRemainBytes() {
        if (this.pos < this.buf.length) {
            int oldPos = this.pos;
            this.pos += this.buf.length - this.pos;
            return Arrays.copyOfRange(this.buf, this.pos, this.buf.length);
        }
        return Bytes.EMPTY_BYTES;
    }

    public BytesLoader loadBytesLoader(int bytes) {
        int blockBytes = bytes < 0 ? this.loadInt(Math.abs(bytes)) : (bytes == 0 ? this.remainBytesCount() : bytes);
        byte[] valueBytes = this.loadBytes(blockBytes);
        return new BytesLoader(valueBytes);
    }

    public int remainBytesCount() {
        return Math.max(0, this.buf.length - this.pos);
    }

    public int loadBit() {
        if (this.bitCnt == 0) {
            this.bitBuf = this.loadByte();
            this.bitCnt = 8;
        }
        int ret = this.bitBuf >>> this.bitCnt - 1 & 1;
        --this.bitCnt;
        return ret;
    }

    public int loadBitsAsInt(int bitCnt) {
        GonglerUtil.requireLessThenOrEqual(bitCnt, 32);
        int ret = 0;
        for (int i = 0; i < bitCnt; ++i) {
            ret <<= 1;
            ret |= this.loadBit();
        }
        return ret;
    }

    public long loadBitsAsLong(int bitCnt) {
        GonglerUtil.requireLessThenOrEqual(bitCnt, 64);
        long ret = 0L;
        for (int i = 0; i < bitCnt; ++i) {
            ret <<= 1;
            ret |= (long)this.loadBit();
        }
        return ret;
    }

    public Bits loadBits(int bitCnt) {
        GonglerUtil.requireLessThenOrEqual(bitCnt, 64);
        long ret = 0L;
        for (int i = 0; i < bitCnt; ++i) {
            ret <<= 1;
            ret |= (long)this.loadBit();
        }
        return Bits.of(ret);
    }

    public <T> T load(Loadable<T> loadable) {
        return loadable.load(this);
    }

    public <T> T load(int bytes, LoadableBySize<T> loadable) {
        return loadable.load(bytes, this);
    }

    public static <T> void register(Class<T> aClass, Function<BytesLoader, ? super T> factory) {
        map.put(aClass, factory);
    }

    public <T> T load(Class<T> aClass) {
        return (T)map.get(aClass).apply(this);
    }

    public int loadRemainBits() {
        return this.loadBitsAsInt(this.bitCnt);
    }

    public IBytesRange toBytesRange() {
        return SimpleByteArrayRange.of(() -> this.buf, 0, this.pos);
    }

    public String toString() {
        StringLinker build = StringLinker.of(" ");
        build.merge(StringLinker.of().add((Object)this.pos).add((Object)Character.valueOf('/')).add((Object)this.buf.length).add((Object)Character.valueOf(':')));
        for (int i = 0; i < this.buf.length; ++i) {
            if (i == this.pos) {
                build.add((Object)">");
            }
            build.add((Object)HexUtil.ByteToHex(this.buf[i]));
        }
        return build.toString();
    }

    @FunctionalInterface
    public static interface LoadableBySize<T> {
        public T load(int var1, BytesLoader var2);
    }

    @FunctionalInterface
    public static interface Loadable<T> {
        public T load(BytesLoader var1);
    }
}

