/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.ITask;
import cn.gongler.util.bytes.Bits;
import cn.gongler.util.bytes.BitsBuilder;
import cn.gongler.util.bytes.Bytes;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.bytes.Bytesable;
import cn.gongler.util.bytes.HexUtil;
import cn.gongler.util.bytes.IBytesRange;
import cn.gongler.util.bytes.SimpleByteArrayRange;
import cn.gongler.util.bytes.Str;
import cn.gongler.util.bytes.ToBytes;
import cn.gongler.util.io.DelegateOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class BytesBuilder
implements ToBytes {
    private static final long serialVersionUID = 8467353696428321139L;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected final int initCapacity;
    protected byte[] buf;
    protected int pos = 0;
    private final BitsBuilder bitBuilder = new BitsBuilder(this::addByte);
    protected int mark = 0;
    private Map<Integer, StringJoiner> traceMap = new LinkedHashMap<Integer, StringJoiner>();
    private Charset charset = StandardCharsets.UTF_8;
    public int nullValType = 1;
    private int limited = Integer.MAX_VALUE;
    private static final BigInteger INT100 = new BigInteger("100");
    private static final BigInteger INT_FF = new BigInteger("255");
    private static final BigInteger BIG_INTEGER_0 = new BigInteger("0");
    private char stringFilledChar = '\u0000';
    private boolean stringTailNul = false;
    private HexBuilder hexBuilderView = new HexBuilder();

    public static BytesBuilder of() {
        return BytesBuilder.BigEndian();
    }

    protected static HexBuilder supportAppendHex() {
        return BytesBuilder.of().asHexBuilder();
    }

    public static BytesBuilder LittleEndian() {
        return new BytesBuilder().byteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    private static BytesBuilder BigEndian() {
        return new BytesBuilder().byteOrder(ByteOrder.BIG_ENDIAN);
    }

    public static BytesBuilder StringFilledSpace() {
        return new BytesBuilder().stringFilledSpace();
    }

    private BytesBuilder _note(Object obj) {
        StringJoiner join = this.traceMap.computeIfAbsent(this.pos, a -> new StringJoiner(","));
        join.add(Objects.toString(obj));
        return this;
    }

    protected BytesBuilder() {
        this(512);
    }

    protected BytesBuilder(int initCapacity) {
        this.initCapacity = initCapacity;
        this.buf = new byte[initCapacity];
    }

    private BytesBuilder byteOrder(boolean isBigEndian) {
        this.byteOrder = isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return this;
    }

    public BytesBuilder byteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public boolean isBigEndian() {
        return ByteOrder.BIG_ENDIAN.equals(this.byteOrder);
    }

    public BytesBuilder charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public BytesBuilder utf8() {
        this.charset = StandardCharsets.UTF_8;
        return this;
    }

    public BytesBuilder gbk() {
        this.charset = Charset.forName("GB18030");
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public BytesBuilder exceptionIfNullVal() {
        this.nullValType = 0;
        return this;
    }

    public BytesBuilder placeHolderIfNullVal() {
        this.nullValType = 1;
        return this;
    }

    public BytesBuilder nullValType(int nullValType) {
        this.nullValType = nullValType;
        return this;
    }

    private BytesBuilder stringTailNul(boolean enable) {
        this.stringTailNul = enable;
        return this;
    }

    public BytesBuilder stringTailNul() {
        this.stringTailNul = true;
        return this;
    }

    protected byte[] buf() {
        return this.buf;
    }

    protected void prepareNextWriteBytes(int newBytes) {
        GonglerUtil.require(this.pos + newBytes <= this.limited);
        if (this.pos + newBytes > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, 64 + Math.max(this.buf.length * 2, this.pos + newBytes));
        }
    }

    public BytesBuilder skip(int byteCnt) {
        this.requireBitsFinished();
        this.prepareNextWriteBytes(byteCnt);
        this.movePos(byteCnt);
        return this;
    }

    protected void movePos(int byteCnt) {
        this.pos += byteCnt;
    }

    public BytesBuilder mark() {
        this.mark = this.pos;
        return this;
    }

    public BytesBuilder moveToMark() {
        this.pos = this.mark;
        return this;
    }

    protected int pos() {
        return this.pos;
    }

    protected BytesBuilder pos(int newPos) {
        int bufSize = this.buf().length;
        if (newPos > bufSize) {
            this.prepareNextWriteBytes(newPos - bufSize);
        }
        this.pos = newPos;
        return this;
    }

    public int size() {
        return this.pos;
    }

    public BytesBuilder toSize(int newSize) {
        return this.pos(newSize);
    }

    public BytesBuilder setBack(int backIndex, int byteVal) {
        if (backIndex <= 0) {
            throw new IllegalArgumentException("\u4e3a\u4e86\u9632\u6b62\u5fd8\u8bb0\u79fb\u52a8\u6e38\u6807\uff0c\u5f3a\u5236\u53ea\u80fd\u4fee\u6539\u4e4b\u524d\u6570\u636e");
        }
        this.buf()[this.pos - backIndex] = (byte)byteVal;
        return this;
    }

    public BytesBuilder limited(int limited) {
        this.limited = limited;
        return this;
    }

    public int limited() {
        return this.limited;
    }

    private <T> T handleNullVal(T val, T defaultVal) {
        if (val == null) {
            if (this.nullValType == 0) {
                throw new NullPointerException();
            }
            if (this.nullValType == 1) {
                return defaultVal;
            }
        }
        return val;
    }

    public BytesBuilder duplicate() {
        final Supplier<byte[]> bufSupplier = this::buf;
        BytesBuilder view = new BytesBuilder(){

            @Override
            public byte[] buf() {
                this.buf = (byte[])bufSupplier.get();
                return this.buf;
            }
        };
        view.buf = this.buf();
        view.pos = view.mark = this.pos;
        view.byteOrder = this.byteOrder;
        view.limited = this.limited;
        return view;
    }

    public BytesBuilder duplicate(int newPos) {
        BytesBuilder ret = this.duplicate();
        return this.duplicate().pos(newPos);
    }

    public BytesBuilder slice(int byteCnt) {
        BytesBuilder view = this.duplicate();
        view.limited = byteCnt;
        this.skip(byteCnt);
        return view;
    }

    protected BytesBuilder fillValueAtPos(int byteValue) {
        this.buf()[this.pos] = (byte)byteValue;
        return this;
    }

    public BytesBuilder setByte(int globalIndex, int byteVal) {
        this.buf()[globalIndex] = (byte)byteVal;
        return this;
    }

    public BytesBuilder setBytes(int globalIndex, byte[] block) {
        for (int i = 0; i < block.length; ++i) {
            this.buf()[globalIndex + i] = block[i];
        }
        return this;
    }

    public BytesBuilder setBytes(int globalIndex, ToBytes item) {
        byte[] block = item.toBytes();
        for (int i = 0; i < block.length; ++i) {
            this.buf()[globalIndex + i] = block[i];
        }
        return this;
    }

    public BytesBuilder setNum(int globalIndex, int byteCnt, long val) {
        this.duplicate().pos(globalIndex).addNum(byteCnt, val);
        return this;
    }

    public BytesBuilder setString(int globalIndex, int byteCnt, CharSequence msg, Charset charset) {
        this.duplicate().pos(globalIndex).addString(byteCnt, msg, charset);
        return this;
    }

    protected BytesBuilder _addByte(int byteVal) {
        this.fillValueAtPos(byteVal);
        this.movePos(1);
        return this;
    }

    protected BytesBuilder _addBytes(byte[] buf, int from, int size) {
        this.requireBitsFinished();
        if (size > 0) {
            this.prepareNextWriteBytes(size);
            System.arraycopy(buf, from, this.buf(), this.pos, Math.min(buf.length - from, size));
            this.movePos(size);
        }
        return this;
    }

    public BytesBuilder addByte(int byteVal) {
        this.requireBitsFinished();
        this.prepareNextWriteBytes(1);
        return this._addByte(byteVal);
    }

    public BytesBuilder addByte(Byte byteVal) {
        byteVal = this.handleNullVal(byteVal, (byte)0);
        return this.addByte(byteVal.intValue());
    }

    public BytesBuilder addByteRepeat(int byteVal, int repeatTimes) {
        for (int i = 0; i < repeatTimes; ++i) {
            this.addByte(byteVal);
        }
        return this;
    }

    public BytesBuilder addBcd(int byteCnt, Long val) {
        val = this.handleNullVal(val, 0L);
        return this.addBcd(byteCnt, (long)val);
    }

    public BytesBuilder addBcd(int byteCnt, Integer val) {
        val = this.handleNullVal(val, 0);
        return this.addBcd(byteCnt, val.longValue());
    }

    public BytesBuilder addBcd(int byteCnt, long val) {
        this.skip(byteCnt);
        for (int i = 0; i < byteCnt; ++i) {
            int byteVal = (int)(val % 100L);
            int high = byteVal / 10;
            int low = byteVal % 10;
            this.setBack(1 + i, high << 4 | low);
            val /= 100L;
        }
        return this;
    }

    public BytesBuilder addBcd(int byteCnt, BigInteger value) {
        this.skip(byteCnt);
        value = this.handleNullVal(value, BIG_INTEGER_0);
        for (int i = 0; i < byteCnt; ++i) {
            int byteVal = value.mod(INT100).intValue();
            int high = byteVal / 10;
            int low = byteVal % 10;
            this.setBack(1 + i, high << 4 | low);
            value = value.divide(INT100);
        }
        return this;
    }

    public BytesBuilder addBcd(int byteCnt, String bcd) {
        bcd = this.handleNullVal(bcd, "0");
        return this.addBcd(byteCnt, new BigInteger(bcd));
    }

    public BytesBuilder addShort(Short value) {
        value = this.handleNullVal(value, (short)0);
        return this.addNum(2, value);
    }

    public BytesBuilder addInt(Integer value) {
        value = this.handleNullVal(value, 0);
        return this.addNum(4, value);
    }

    public BytesBuilder addLong(Long value) {
        value = this.handleNullVal(value, 0L);
        return this.addNum(8, value);
    }

    public BytesBuilder addDouble(int byteCnt, Double value, int scale) {
        value = this.handleNullVal(value, 0.0);
        long longVal = new BigDecimal(value).movePointRight(scale).setScale(0, RoundingMode.HALF_UP).longValue();
        return this.addNum(byteCnt, longVal);
    }

    public BytesBuilder addNum(int byteCnt, long value) {
        return this.isBigEndian() ? this.addNumBigEndian(byteCnt, value) : this.addNumLittleEndian(byteCnt, value);
    }

    public BytesBuilder addNum(int byteCnt, Long value) {
        value = this.handleNullVal(value, 0L);
        return this.addNum(byteCnt, (long)value);
    }

    public BytesBuilder addNum(int byteCnt, Integer value) {
        value = this.handleNullVal(value, 0);
        return this.addNum(byteCnt, value.longValue());
    }

    public BytesBuilder addNum(int byteCnt, Integer value, Integer defaultVal) {
        return this.addNum(byteCnt, GonglerUtil.WithDefault(value, defaultVal).longValue());
    }

    public BytesBuilder addNum(int byteCnt, Short value) {
        value = this.handleNullVal(value, (short)0);
        return this.addNum(byteCnt, value.longValue());
    }

    public BytesBuilder addNum(int byteCnt, Number value) {
        value = this.handleNullVal(value, 0);
        return this.addNum(byteCnt, value.longValue());
    }

    public BytesBuilder addNum1(long value) {
        return this.addNum(1, value);
    }

    public BytesBuilder addNum2(long value) {
        return this.addNum(2, value);
    }

    public BytesBuilder addNum3(long value) {
        return this.addNum(3, value);
    }

    public BytesBuilder addNum4(long value) {
        return this.addNum(4, value);
    }

    public BytesBuilder addNum8(long value) {
        return this.addNum(8, value);
    }

    public BytesBuilder addNumLittleEndian(int byteCnt, long value) {
        this._note("LE" + byteCnt + ":" + value);
        for (int i = 0; i < byteCnt; ++i) {
            this.addByte((int)(value >> 8 * i) & 0xFF);
        }
        return this;
    }

    public BytesBuilder addNumBigEndian(int byteCnt, long value) {
        this._note("BE" + byteCnt + ":" + value);
        for (int i = byteCnt - 1; i >= 0; --i) {
            this.addByte((int)(value >> 8 * i) & 0xFF);
        }
        return this;
    }

    public BytesBuilder addNum(int byteCnt, long value, ByteOrder byteOrder) {
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            this.addNumBigEndian(byteCnt, value);
        } else {
            this.addNumLittleEndian(byteCnt, value);
        }
        return this;
    }

    public BytesBuilder addNum(int byteCnt, String decode) {
        long val = GonglerUtil.DecodeLong(decode);
        return this.addNum(byteCnt, val);
    }

    public BytesBuilder addNum(int byteCnt, BigInteger value) {
        value = this.handleNullVal(value, BIG_INTEGER_0);
        return this.isBigEndian() ? this.addNumBigEndian(byteCnt, value) : this.addNumLittleEndian(byteCnt, value);
    }

    public BytesBuilder addNumLittleEndian(int byteCnt, BigInteger value) {
        this._note("LE" + byteCnt + ":" + value);
        value = this.handleNullVal(value, BIG_INTEGER_0);
        for (int i = 0; i < byteCnt; ++i) {
            this.addByte(value.shiftRight(8 * i).mod(INT_FF).intValue());
        }
        return this;
    }

    public BytesBuilder addNumBigEndian(int byteCnt, BigInteger value) {
        this._note("BE" + byteCnt + ":" + value);
        value = this.handleNullVal(value, BIG_INTEGER_0);
        for (int i = byteCnt - 1; i >= 0; --i) {
            this.addByte(value.shiftRight(8 * i).mod(INT_FF).intValue());
        }
        return this;
    }

    public BytesBuilder addNum(int byteCnt, BigInteger value, ByteOrder byteOrder) {
        if (ByteOrder.BIG_ENDIAN.equals(byteOrder)) {
            this.addNumBigEndian(byteCnt, value);
        } else {
            this.addNumLittleEndian(byteCnt, value);
        }
        return this;
    }

    public BytesBuilder addHex(int byteCnt, CharSequence hexNum) {
        if ((hexNum = (CharSequence)this.handleNullVal(hexNum, "0")).length() > byteCnt * 2) {
            hexNum = hexNum.subSequence(hexNum.length() - byteCnt * 2, hexNum.length());
        } else if (hexNum.length() < byteCnt * 2) {
            hexNum = GonglerUtil.Repeat(byteCnt * 2 - hexNum.length(), "0") + hexNum;
        }
        return this.addBytes(hexNum);
    }

    public BytesBuilder addHex(CharSequence hex) {
        hex = this.handleNullVal(hex, "");
        return this.addBytes(hex);
    }

    public BytesBuilder append(CharSequence hex) {
        return this.addHex(hex);
    }

    public BytesBuilder addHex(Iterable<String> hexList) {
        this.requireBitsFinished();
        hexList.forEach(this::addBytes);
        return this;
    }

    public BytesBuilder addHex(int byteCntPerItem, Iterable<String> hexList) {
        this.requireBitsFinished();
        hexList.forEach(a -> this.addBytes(byteCntPerItem, (CharSequence)a));
        return this;
    }

    public BytesBuilder addHex(Stream<String> stream) {
        this.requireBitsFinished();
        stream.forEach(this::addBytes);
        return this;
    }

    public BytesBuilder addHex(String ... hexArray) {
        this.requireBitsFinished();
        Arrays.stream(hexArray).forEach(this::addBytes);
        return this;
    }

    public <T> BytesBuilder addHex(Iterable<T> list, Function<T, String> mapper) {
        list.forEach(a -> this.addBytes((CharSequence)mapper.apply(a)));
        return this;
    }

    protected BytesBuilder stringFilledChar(char ch) {
        this.stringFilledChar = ch;
        return this;
    }

    public BytesBuilder stringFilledSpace() {
        return this.stringFilledChar(' ');
    }

    public BytesBuilder stringFilledNul() {
        return this.stringFilledChar('\u0000');
    }

    protected BytesBuilder execute(ITask task) {
        task.executeWithThrowAny();
        return this;
    }

    public BytesBuilder addString(int byteCnt, CharSequence msg, Charset charset) {
        this._note(charset.toString() + "_L" + byteCnt + ":" + msg);
        String msg2 = ((CharSequence)this.handleNullVal(msg, "")).toString();
        if (this.stringTailNul) {
            msg2 = msg2 + '\u0000';
        }
        return this.addBytes(Str.of(byteCnt, msg2, charset).filledChar(this.stringFilledChar).toBytes());
    }

    public BytesBuilder addString(int byteCnt, char prefix, CharSequence msg) {
        GonglerUtil.require(byteCnt > 0, "byteCnt\u5fc5\u987b\u5927\u4e8e0:" + byteCnt);
        this._note(this.charset.toString() + "_L" + byteCnt + ",prefix:" + prefix + "," + msg);
        String msg2 = ((CharSequence)this.handleNullVal(msg, "")).toString();
        byte[] body = msg2.getBytes();
        byte[] prefixArray = new byte[byteCnt];
        int i = prefixArray.length - 1;
        int j = body.length - 1;
        while (i >= 0) {
            prefixArray[i] = j >= 0 ? body[j] : (byte)prefix;
            --i;
            --j;
        }
        return this.addBytes(prefixArray);
    }

    public BytesBuilder addString(int byteCnt, CharSequence msg) {
        return this.addString(byteCnt, msg, this.charset());
    }

    public BytesBuilder addUtf8(int byteCnt, CharSequence msg) {
        this.addString(byteCnt, msg, StandardCharsets.UTF_8);
        return this;
    }

    public BytesBuilder addGbk(int byteCnt, CharSequence msg) {
        this.addString(byteCnt, msg, Charset.forName("GB18030"));
        return this;
    }

    public BytesBuilder addString(CharSequence msg) {
        return this.addString(0, msg, this.charset());
    }

    public BytesBuilder addUtf8(CharSequence msg) {
        this.addString(0, msg, StandardCharsets.UTF_8);
        return this;
    }

    public BytesBuilder addGbk(CharSequence msg) {
        this.addString(0, msg, Charset.forName("GB18030"));
        return this;
    }

    public BytesBuilder addByteStream(InputStream in) {
        try (BufferedInputStream bin = new BufferedInputStream(in);){
            int cnt;
            byte[] inBuf = new byte[1024];
            while ((cnt = ((InputStream)bin).read(inBuf)) >= 0) {
                this.addBytes(inBuf, 0, cnt);
            }
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(e);
        }
        return this;
    }

    public BytesBuilder addByteStream(IntStream stream) {
        stream.forEach(this::addByte);
        return this;
    }

    public BytesBuilder addByteStream(Stream<Byte> stream) {
        stream.mapToInt(Byte::intValue).forEach(this::addByte);
        return this;
    }

    public BytesBuilder addHexStream(Stream<CharSequence> stream) {
        stream.forEach(this::addBytes);
        return this;
    }

    protected BytesBuilder addHex(Reader hexReader) {
        try (BufferedReader bin = new BufferedReader(hexReader);){
            String line;
            while ((line = bin.readLine()) != null) {
                String hex = line.split("#")[0].replaceAll("\\s", "");
                if (HexUtil.isStrictHex(hex)) {
                    this.addBytes(hex);
                    continue;
                }
                throw new IllegalArgumentException(hex);
            }
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(e);
        }
        return this;
    }

    public BytesBuilder addHexFile(Path hexFile) {
        return this.addHexFile(hexFile, StandardCharsets.UTF_8);
    }

    private BytesBuilder addHexFile(Path hexFile, Charset charset) {
        try {
            return this.addHex(new InputStreamReader((InputStream)new FileInputStream(hexFile.toFile()), charset));
        }
        catch (FileNotFoundException e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public BytesBuilder addFile(Path binFile) {
        try {
            return this.addByteStream(Files.newInputStream(binFile, new OpenOption[0]));
        }
        catch (IOException e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public BytesBuilder addBytes(byte[] buf, int from, int size) {
        GonglerUtil.requireLessThenOrEqual(from + size, buf.length);
        return this._addBytes(buf, from, size);
    }

    public BytesBuilder addBytes(byte[] bytes) {
        bytes = this.handleNullVal(bytes, Bytes.EMPTY_BYTES);
        return this._addBytes(bytes, 0, bytes.length);
    }

    public BytesBuilder addBytes(int byteCnt, byte[] bytes) {
        bytes = this.handleNullVal(bytes, GonglerUtil.emptyByteArray());
        return this._addBytes(bytes, 0, byteCnt);
    }

    public BytesBuilder addBytes(CharSequence hex) {
        return this.addBytes(HexUtil.HexToBytes(hex));
    }

    public BytesBuilder addBytes(int byteCnt, CharSequence hex) {
        return this.addBytes(byteCnt, HexUtil.HexToBytes(hex));
    }

    public BytesBuilder addBytes(BytesBuilder another) {
        another.requireBitsFinished();
        return this.addBytes(another.buf(), 0, another.pos);
    }

    public BytesBuilder addBytes(IBytesRange bytesRange) {
        return this.addBytes(bytesRange.buf(), bytesRange.from(), bytesRange.size());
    }

    public BytesBuilder addBytes(Byte[] bytes) {
        bytes = (Byte[])this.handleNullVal(bytes, GonglerUtil.emptyArray());
        return this.addBytes(bytes, 0, bytes.length);
    }

    public BytesBuilder addBytes(Byte[] bytes, int from, int size) {
        for (int i = 0; i < size; ++i) {
            this.addByte(bytes[from + i]);
        }
        return this;
    }

    public BytesBuilder addBytes(Bytesable item) {
        this.requireBitsFinished();
        this._note(String.valueOf(item));
        item.toBytes(this);
        return this;
    }

    public BytesBuilder addBytes(Iterable<Bytesable> items) {
        this.requireBitsFinished();
        items.forEach(a -> a.toBytes(this));
        return this;
    }

    public BytesBuilder addBytes(ToBytes item) {
        this.requireBitsFinished();
        this._note(String.valueOf(item));
        return this.addBytes(item.toBytes());
    }

    public BytesBuilder addBytes(List<ToBytes> items) {
        items.forEach(a -> this.addBytes(a.toBytes()));
        return this;
    }

    public <T> BytesBuilder addBytes(T obj, Function<T, byte[]> mapper) {
        this.addBytes(mapper.apply(obj));
        return this;
    }

    public <T> BytesBuilder addBytes(Iterable<T> list, Function<T, byte[]> mapper) {
        list.forEach(a -> this.addBytes((byte[])mapper.apply(a)));
        return this;
    }

    public BytesBuilder addBytes(Stream<byte[]> stream) {
        stream.forEach(this::addBytes);
        return this;
    }

    public BytesBuilder addBit(boolean bitVal) {
        this.bitBuilder.addBit(bitVal);
        return this;
    }

    public BytesBuilder addBitRepeat(boolean bitVal, int repeatTimes) {
        this.bitBuilder.addBitRepeat(bitVal, repeatTimes);
        return this;
    }

    public BytesBuilder addBit(int bitVal) {
        this.bitBuilder.addBit(bitVal);
        return this;
    }

    public BytesBuilder addBit(Integer bitVal) {
        this.bitBuilder.addBit(GonglerUtil.WithDefault(bitVal, 0));
        return this;
    }

    public BytesBuilder addBit(Integer bitVal, Integer defaultVal) {
        this.bitBuilder.addBit(GonglerUtil.WithDefault(bitVal, defaultVal));
        return this;
    }

    public BytesBuilder addBitRepeat(int bitVal, int repeatTimes) {
        this.bitBuilder.addBitRepeat(bitVal, repeatTimes);
        return this;
    }

    public BytesBuilder addBits(int bitCnt, long val) {
        this.bitBuilder.addBits(bitCnt, val);
        return this;
    }

    public BytesBuilder addBits(int bitCnt, Integer val) {
        this.bitBuilder.addBits(bitCnt, GonglerUtil.WithDefault(val, 0).longValue());
        return this;
    }

    public BytesBuilder addBits(int bitCnt, Integer val, Integer defaultVal) {
        this.bitBuilder.addBits(bitCnt, GonglerUtil.WithDefault(val, defaultVal).longValue());
        return this;
    }

    public BytesBuilder addBits(List<Boolean> bits) {
        this.bitBuilder.addBits(bits);
        return this;
    }

    public BytesBuilder addBits(CharSequence bitsStr) {
        this.bitBuilder.addBits(bitsStr);
        return this;
    }

    public BytesBuilder addBits(int byteCnt, Iterable<Integer> bitIndexs) {
        Bits bits = Bits.of().byteSize(byteCnt);
        for (Integer index : bitIndexs) {
            GonglerUtil.requireLessThen(index, byteCnt * 8);
            bits.bit((int)index, true);
        }
        this.addNum(byteCnt, bits);
        return this;
    }

    protected BytesBuilder requireBitsFinished() {
        this.bitBuilder.requireFinished();
        return this;
    }

    public BytesBuilder addTest(int times, IntUnaryOperator byteMaker) {
        for (int i = 0; i < times; ++i) {
            this.addByte(byteMaker.applyAsInt(i));
        }
        return this;
    }

    public BytesBuilder addStatistics(int byteCnt, ToIntFunction<IntStream> statistics) {
        return this.addNum(byteCnt, (long)statistics.applyAsInt(IntStream.range(0, this.pos).map(a -> this.buf()[a] & 0xFF)));
    }

    public BytesBuilder addBytesRefPrevious(Function<IBytesRange, byte[]> mapper) {
        this.requireBitsFinished();
        byte[] bytes = mapper.apply(IBytesRange.of(this::buf, 0, this.pos));
        this.addBytes(bytes);
        return this;
    }

    public OutputStream getOutputStream() {
        return DelegateOutputStream.consumer(this::addByte);
    }

    public int distanceFromMark() {
        return this.pos - this.mark;
    }

    public BytesBuilder peek(Consumer<CharSequence> consumer) {
        return this.peek(8, consumer);
    }

    public BytesBuilder peek(int byteCnt, Consumer<CharSequence> consumer) {
        if (byteCnt == 0) {
            byteCnt = this.size();
        }
        String msg = HexUtil.BytesToMessage(this.buf, Math.max(0, this.pos - byteCnt), this.pos);
        consumer.accept(msg);
        return this;
    }

    public BytesBuilder println() {
        System.out.println(this.toHexMessage());
        return this;
    }

    public BytesBuilder note(CharSequence note) {
        this._note(note);
        return this;
    }

    public HexBuilder asHexBuilder() {
        return this.hexBuilderView;
    }

    @Override
    public byte[] toBytes() {
        this.requireBitsFinished();
        return Arrays.copyOf(this.buf(), this.pos);
    }

    @Override
    public String toHex() {
        this.requireBitsFinished();
        return HexUtil.BytesToHex(this.buf(), 0, this.pos);
    }

    public IBytesRange toBytesRange() {
        this.requireBitsFinished();
        return SimpleByteArrayRange.of(this::buf, 0, this.pos);
    }

    public BytesLoader toBytesLoader() {
        return BytesLoader.of(this.buf(), 0, this.pos);
    }

    public int reduce(int identity, IntBinaryOperator op) {
        this.requireBitsFinished();
        int result = identity;
        for (int i = 0; i < this.pos; ++i) {
            result = op.applyAsInt(result, this.buf()[i] & 0xFF);
        }
        return result;
    }

    public IntStream toIntStream() {
        return IntStream.range(0, this.pos).map(a -> this.buf()[a] & 0xFF);
    }

    public BytesBuilder saveToFile(Path file) {
        this.requireBitsFinished();
        try {
            Files.write(file, this.toBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw GonglerUtil.toRuntimeException(e);
        }
        return this;
    }

    public BytesBuilder saveToFile(String filename) {
        return this.saveToFile(Paths.get(filename, new String[0]));
    }

    public BytesBuilder saveToHexFile(Path file) {
        this.requireBitsFinished();
        try {
            Files.write(file, Collections.singletonList(this.toHex()), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw GonglerUtil.toRuntimeException(e);
        }
        return this;
    }

    public BytesBuilder saveToHexFile(String filename) {
        return this.saveToHexFile(Paths.get(filename, new String[0]));
    }

    @Override
    public String toHexMessage() {
        int size = this.size();
        StringBuilder build = new StringBuilder().append("(bytes:").append(size).append(")");
        for (int i = 0; i < size; ++i) {
            StringJoiner msg = this.traceMap.get(i);
            if (msg != null) {
                build.append("(").append(msg).append(")");
            }
            build.append(HexUtil.ByteToHex(this.buf()[i])).append(" ");
        }
        if (this.bitBuilder.remainBitCnt() > 0) {
            build.append("+bits").append(this.bitBuilder);
        }
        return build.toString();
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(HexUtil.BytesToHex(this.toBytes()));
        if (this.bitBuilder.remainBitCnt() > 0) {
            build.append("+bits").append(this.bitBuilder);
        }
        return build.toString();
    }

    public static class Builder {
        private static final long serialVersionUID = 1L;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        private Charset charset = StandardCharsets.UTF_8;
        public int nullValType = 0;
        private char stringFilledChar = '\u0000';
        private boolean stringTailNul = false;

        public static Builder of() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder littleEndian() {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            return this;
        }

        public Builder bigEndian() {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            return this;
        }

        public Builder byteOrder(ByteOrder defaultByteOrder) {
            this.byteOrder = defaultByteOrder;
            return this;
        }

        public ByteOrder byteOrder() {
            return this.byteOrder;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder utf8() {
            this.charset = StandardCharsets.UTF_8;
            return this;
        }

        public Builder gbk() {
            this.charset = Charset.forName("GB18030");
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        public Builder exceptionIfNullVal() {
            this.nullValType = 0;
            return this;
        }

        public Builder placeHolderIfNullVal() {
            this.nullValType = 1;
            return this;
        }

        public Builder nullValType(int nullValType) {
            this.nullValType = nullValType;
            return this;
        }

        public int nullValType() {
            return this.nullValType;
        }

        public Builder stringFilledChar(char ch) {
            this.stringFilledChar = ch;
            return this;
        }

        public Builder stringTailNul() {
            this.stringTailNul = true;
            return this;
        }

        public BytesBuilder build() {
            return BytesBuilder.of().byteOrder(this.byteOrder).charset(this.charset).nullValType(this.nullValType).stringFilledChar(this.stringFilledChar).stringTailNul(this.stringTailNul);
        }
    }

    public class HexBuilder
    implements CharSequence {
        public HexBuilder append(CharSequence hex) {
            return this.addHex(hex);
        }

        public HexBuilder addHex(CharSequence hex) {
            BytesBuilder.this.addHex(hex);
            return this;
        }

        public HexBuilder addHex(int byteCnt, CharSequence val) {
            BytesBuilder.this.addHex(byteCnt, val);
            return this;
        }

        public HexBuilder addBcd(int byteCnt, Long val) {
            BytesBuilder.this.addBcd(byteCnt, val);
            return this;
        }

        public HexBuilder addBcd(int byteCnt, Integer val) {
            BytesBuilder.this.addBcd(byteCnt, val);
            return this;
        }

        public HexBuilder addNum(int byteCnt, Long val) {
            BytesBuilder.this.addNum(byteCnt, val);
            return this;
        }

        public HexBuilder addNum(int byteCnt, Integer val) {
            BytesBuilder.this.addNum(byteCnt, val);
            return this;
        }

        public HexBuilder skip(int byteCnt) {
            BytesBuilder.this.skip(byteCnt);
            return this;
        }

        public HexBuilder addString(int byteCnt, String val) {
            BytesBuilder.this.addString(byteCnt, val);
            return this;
        }

        public HexBuilder addString(String val) {
            BytesBuilder.this.addString(val);
            return this;
        }

        public HexBuilder addBits(CharSequence binStr) {
            BytesBuilder.this.addBits(binStr);
            return this;
        }

        public HexBuilder addBytes(byte[] val) {
            BytesBuilder.this.addBytes(val);
            return this;
        }

        public HexBuilder addBytes(ToBytes val) {
            BytesBuilder.this.addBytes(val);
            return this;
        }

        public HexBuilder addBytes(int byteCnt, byte[] val) {
            BytesBuilder.this.addBytes(byteCnt, val);
            return this;
        }

        public HexBuilder addBytes(int byteCnt, CharSequence hex) {
            BytesBuilder.this.addBytes(byteCnt, hex);
            return this;
        }

        public BytesBuilder asBytesBuilder() {
            return BytesBuilder.this;
        }

        public byte[] toBytes() {
            return BytesBuilder.this.toBytes();
        }

        public String toHex() {
            return BytesBuilder.this.toHex();
        }

        @Override
        public int length() {
            return BytesBuilder.this.size() * 2;
        }

        @Override
        public char charAt(int index) {
            byte ch = BytesBuilder.this.buf()[index / 2];
            return HexUtil.hexCharInByte(ch, index % 2);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            StringBuilder buf = new StringBuilder(end - start);
            for (int i = start; i < end; ++i) {
                buf.append(this.charAt(i));
            }
            return buf.toString();
        }

        @Override
        public String toString() {
            return BytesBuilder.this.toHex();
        }
    }
}

