/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.tuple.Tuple;
import cn.gongler.util.tuple.Tuple2;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class Recently<E>
extends AbstractMap<LocalDateTime, E> {
    private static final long serialVersionUID = -3195148595268151000L;
    public static final Tuple2<AtomicInteger, AtomicLong> INSTANCE_CNT = Tuple.of(new AtomicInteger(), new AtomicLong());
    private static final Recently EMPTY = new Recently(1);
    private final Map.Entry<Long, E>[] buf;
    private final AtomicLong writePos = new AtomicLong(0L);
    private final int capacity;
    private final int capacityAlign;
    private final int mask;
    private final BiFunction<Long, E, Map.Entry<Long, E>> map;

    public static <T> Recently<T> empty() {
        return EMPTY;
    }

    public Recently() {
        this(16);
    }

    public Recently(int capacity) {
        this(capacity, null);
    }

    public Recently(int capacity, BiFunction<Long, E, Map.Entry<Long, E>> map) {
        this.capacity = capacity;
        this.capacityAlign = Recently.AlignCapacity(capacity);
        this.mask = this.capacityAlign - 1;
        this.buf = new Map.Entry[this.capacityAlign];
        INSTANCE_CNT.e1().incrementAndGet();
        INSTANCE_CNT.e2().addAndGet(capacity);
        this.map = map == null ? RecentlyEntry::new : map;
    }

    public E push(E e) {
        Objects.requireNonNull(e);
        this.buf[this.index((long)this.writePos.getAndIncrement())] = this.map.apply(System.currentTimeMillis(), e);
        return e;
    }

    private int index(long serial) {
        return (int)serial & this.mask;
    }

    private Map.Entry<Long, E> get(long pos) {
        return this.buf[this.index(pos)];
    }

    public void forEach(long limit, BiConsumer<LocalDateTime, E> action) {
        GonglerUtil.MapForEachLimit(this, limit, action);
    }

    public long pushTimes() {
        return this.writePos.longValue();
    }

    public Map.Entry<LocalDateTime, E>[] toArray() {
        return this.entrySet().toArray(new Map.Entry[0]);
    }

    @Override
    public String toString() {
        return this.toString(10L);
    }

    public String toString(long limit) {
        return this.values().stream().limit(limit).map(String::valueOf).collect(Collectors.joining(", "));
    }

    private static int AlignCapacity(int anyCapacity) {
        if (anyCapacity <= 1) {
            return 1;
        }
        return 1 << Recently.HighBitIndex(anyCapacity - 1) + 1;
    }

    private static int HighBitIndex(int val) {
        for (int i = 0; i < 32; ++i) {
            int moveBitCnt = 31 - i;
            if ((val >>> moveBitCnt & 1) != 1) continue;
            return moveBitCnt;
        }
        return 1;
    }

    @Override
    public Set<Map.Entry<LocalDateTime, E>> entrySet() {
        return new AbstractSet<Map.Entry<LocalDateTime, E>>(){

            @Override
            public Iterator<Map.Entry<LocalDateTime, E>> iterator() {
                return new Iterator<Map.Entry<LocalDateTime, E>>(){
                    final long firstReadPos;
                    final Map.Entry<Long, E> firstReadItem;
                    long iteratorNextSerial;
                    {
                        this.firstReadPos = Recently.this.writePos.get() - 1L;
                        this.firstReadItem = Recently.this.get(this.firstReadPos);
                        this.iteratorNextSerial = this.firstReadPos;
                    }

                    @Override
                    public boolean hasNext() {
                        long next = this.iteratorNextSerial;
                        Map.Entry nextItem = Recently.this.get(next);
                        return next > this.firstReadPos - (long)Recently.this.capacity && nextItem != null && (Long)nextItem.getKey() <= this.firstReadItem.getKey();
                    }

                    @Override
                    public Map.Entry<LocalDateTime, E> next() {
                        Map.Entry entry = Recently.this.get(this.iteratorNextSerial--);
                        return new AbstractMap.SimpleImmutableEntry(GonglerUtil.toLocalDateTime((Long)entry.getKey()), entry.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return Recently.this.buf.length;
            }
        };
    }

    private static class RecentlyEntry<LocalDateTime, E>
    extends AbstractMap.SimpleImmutableEntry<LocalDateTime, E> {
        public RecentlyEntry(LocalDateTime key, E value) {
            super(key, value);
        }
    }
}

