/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util;

import cn.gongler.util.ChineseLinenameComparator;
import cn.gongler.util.ITask;
import cn.gongler.util.RuntimeExceptionFromException;
import cn.gongler.util.function.ExceptionIntConsumer;
import cn.gongler.util.function.ExceptionIntFunction;
import cn.gongler.util.function.ExceptionSupplier;
import cn.gongler.util.text.StringLinker;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GonglerUtil {
    private static final long serialVersionUID = 11369096262707202L;
    private static final ExecutorService timeoutThreadPool = Executors.newCachedThreadPool();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final long KILO = 1024L;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;
    private static final long TERA = 0x10000000000L;
    public static LocalDateTime LocalDateTime2000_01_01 = LocalDateTime.of(2000, 1, 1, 0, 0);
    public static Timestamp TIMESTAMP_NULL = new Timestamp(0L);
    private static final DateTimeFormatter YYYYMMDD_HHMMSSXXX = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter YYYYMMDD_HHMMSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter YYYYMMDD_HHMM = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private static final DateTimeFormatter YYYYMMDD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter HHMMSS = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter HHMM = DateTimeFormatter.ofPattern("HH:mm");

    protected GonglerUtil() {
    }

    public static byte Byte(long val) {
        return (byte)val;
    }

    public static int Int(long val) {
        return (int)val;
    }

    public static int Int(short val) {
        return val & 0xFFFF;
    }

    public static int Int(byte val) {
        return val & 0xFF;
    }

    public static int Int(double val) {
        return (int)val;
    }

    public static double Round(double val, int digits) {
        double tmp = Math.pow(10.0, digits);
        return (double)Math.round(val * tmp) / tmp;
    }

    public static int min(int ... vals) {
        int min = Integer.MAX_VALUE;
        for (int val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static int max(int ... vals) {
        int max = Integer.MIN_VALUE;
        for (int val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static long min(long ... vals) {
        long min = Long.MAX_VALUE;
        for (long val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static long max(long ... vals) {
        long max = Long.MIN_VALUE;
        for (long val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static double min(double ... vals) {
        double min = Double.MAX_VALUE;
        for (double val : vals) {
            min = Math.min(min, val);
        }
        return min;
    }

    public static double max(double ... vals) {
        double max = -9.223372036854776E18;
        for (double val : vals) {
            max = Math.max(max, val);
        }
        return max;
    }

    public static double Avg(double ... vals) {
        double sum = 0.0;
        int count = 0;
        for (double val : vals) {
            sum += val;
            ++count;
        }
        return sum / (double)count;
    }

    public static <T> T MiddleValue(Collection<T> vals, Comparator<T> c) {
        TreeSet<T> set = new TreeSet<T>(c);
        set.addAll(vals);
        int i = 0;
        int middleIndex = set.size() / 2;
        for (T o : set) {
            if (i == middleIndex) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public static long MiddleValue(long ... vals) {
        Arrays.sort(vals);
        return vals[vals.length / 2];
    }

    public static int MiddleValue(int ... vals) {
        Arrays.sort(vals);
        return vals[vals.length / 2];
    }

    public static <T> T WithDefault(T val, T defaultVal) {
        return val == null ? defaultVal : val;
    }

    public static <T> T WithDefault(T val, Supplier<T> defaultVal) {
        return val == null ? defaultVal.get() : val;
    }

    public static <T, R> R WithDefault(T val, R defaultVal, Function<T, R> mapper) {
        return val == null ? defaultVal : mapper.apply(val);
    }

    public static <T> String WithDefault(T val, String defaultVal) {
        return GonglerUtil.WithDefault(val, defaultVal, String::valueOf);
    }

    public static Integer WithDefault(Integer val) {
        return GonglerUtil.WithDefault(val, 0);
    }

    public static Long WithDefault(Long val) {
        return GonglerUtil.WithDefault(val, 0L);
    }

    public static Short WithDefault(Short val) {
        return GonglerUtil.WithDefault(val, (short)0);
    }

    public static Byte WithDefault(Byte val) {
        return GonglerUtil.WithDefault(val, (byte)0);
    }

    public static Double WithDefault(Double val) {
        return GonglerUtil.WithDefault(val, 0.0);
    }

    public static Float WithDefault(Float val) {
        return GonglerUtil.WithDefault(val, Float.valueOf(0.0f));
    }

    public static Boolean WithDefault(Boolean val) {
        return GonglerUtil.WithDefault(val, Boolean.FALSE);
    }

    public static String WithDefault(String val) {
        return GonglerUtil.WithDefault(val, "");
    }

    public static <T> List<T> WithDefault(List<T> val) {
        return val != null ? val : Collections.emptyList();
    }

    public static <T> Set<T> WithDefault(Set<T> val) {
        return val != null ? val : Collections.emptySet();
    }

    public static <T> SortedSet<T> WithDefault(SortedSet<T> val) {
        return val != null ? val : Collections.emptySortedSet();
    }

    public static <T> NavigableSet<T> WithDefault(NavigableSet<T> val) {
        return val != null ? val : Collections.emptyNavigableSet();
    }

    public static <K, V> Map<K, V> WithDefault(Map<K, V> val) {
        return val != null ? val : Collections.emptyMap();
    }

    public static <K, V> SortedMap<K, V> WithDefault(SortedMap<K, V> val) {
        return val != null ? val : Collections.emptySortedMap();
    }

    public static <K, V> NavigableMap<K, V> WithDefault(NavigableMap<K, V> val) {
        return val != null ? val : Collections.emptyNavigableMap();
    }

    public static <T> T WithConsumer(T val, Consumer<T> op) {
        op.accept(val);
        return val;
    }

    public static <T> T WithNotNullConsumer(T val, Consumer<T> op) {
        if (val != null) {
            op.accept(val);
        }
        return val;
    }

    public static <T> void ifPresent(T param, Consumer<T> consumer) {
        if (param != null) {
            consumer.accept(param);
        }
    }

    public static Thread StartDaemonThread(String threadName, ITask task) {
        Thread thread = new Thread(GonglerUtil.RunnableWithCatchAny(task), threadName);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static void ExecuteWithCatchAny(ITask task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void ExecuteWithThrowAny(ITask task) {
        try {
            task.run();
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public static Runnable RunnableWithCatchAny(ITask task) {
        return () -> GonglerUtil.ExecuteWithCatchAny(task);
    }

    public static Runnable RunnableWithThrowAny(ITask task) {
        return () -> GonglerUtil.ExecuteWithThrowAny(task);
    }

    public static <T> T CallWithThrowAny(Callable<T> task) {
        try {
            return task.call();
        }
        catch (Exception e) {
            throw GonglerUtil.toRuntimeException(e);
        }
    }

    public static <T> T CallWithCatchAny(Callable<T> task, T defaultVal) {
        try {
            return task.call();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return defaultVal;
        }
    }

    public static void WithTimeout(Runnable task, Duration timeout) {
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(timeout.toMillis());
            thread.interrupt();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static void WithTimeout2Beta(ITask task, Duration timeout) {
        try {
            timeoutThreadPool.invokeAny(Collections.singleton(() -> {
                task.run();
                return task;
            }), timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new CompletionException("TimeoutException of " + timeout + " when execute task:" + task, ex);
        }
    }

    public static void WithTimeout2Beta(ITask task, Duration timeout, Duration expiredTime) {
        LocalDateTime to = LocalDateTime.now().plus(expiredTime);
        while (LocalDateTime.now().isBefore(to)) {
            try {
                timeoutThreadPool.invokeAny(Collections.singleton(() -> {
                    task.run();
                    return null;
                }), timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                throw new CompletionException("TimeoutException of " + timeout + " when execute task:" + task, ex);
            }
        }
    }

    public static RuntimeException toRuntimeException(Exception e) {
        return RuntimeExceptionFromException.of(e);
    }

    public static Exception toOriginalException(RuntimeException e) {
        return RuntimeExceptionFromException.toOriginal(e);
    }

    public static void Repeat(int times, ITask task) {
        for (int i = 1; i <= times; ++i) {
            task.executeWithThrowAny();
        }
    }

    public static void Repeat(int times, ExceptionIntConsumer task) {
        for (int i = 1; i <= times; ++i) {
            try {
                task.accept(i);
                continue;
            }
            catch (Exception e) {
                throw GonglerUtil.toRuntimeException(e);
            }
        }
    }

    public static String Repeat(int times, CharSequence msg) {
        return StringLinker.of().addRepeat(msg, times).toString();
    }

    public static <R> R RetryTimes(int times, ExceptionIntFunction<R> task) {
        for (int i = 1; i <= times; ++i) {
            try {
                return task.apply(i);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
        }
        return null;
    }

    public static <T> T[] newArray(Class<T> aClass, int size, ExceptionIntFunction<T> func) {
        Object[] array = (Object[])Array.newInstance(aClass, size);
        GonglerUtil.Repeat(size, (int i) -> {
            array[i] = func.apply(i);
        });
        return array;
    }

    public static byte[] newByteArray(int size, IntUnaryOperator func) {
        byte[] array = new byte[size];
        GonglerUtil.Repeat(size, (int i) -> {
            array[i] = (byte)func.applyAsInt(i);
        });
        return array;
    }

    public static int[] newIntArray(int size, IntUnaryOperator func) {
        int[] array = new int[size];
        GonglerUtil.Repeat(size, (int i) -> {
            array[i] = func.applyAsInt(i);
        });
        return array;
    }

    public static long[] newLongArray(int size, LongUnaryOperator func) {
        long[] array = new long[size];
        GonglerUtil.Repeat(size, (int i) -> {
            array[i] = func.applyAsLong(i);
        });
        return array;
    }

    public static <T> T[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static int[] emptyIntArray() {
        return EMPTY_INT_ARRAY;
    }

    public static long[] emptyLongArray() {
        return EMPTY_LONG_ARRAY;
    }

    public static byte[] emptyByteArray() {
        return EMPTY_BYTE_ARRAY;
    }

    public static <T> Iterable<T> IterableAdapter(final ExceptionSupplier<T> sup) {
        return () -> new Iterator<T>(){
            Object cur;

            @Override
            public boolean hasNext() {
                this.cur = GonglerUtil.CallWithThrowAny(sup::get);
                return this.cur != null;
            }

            @Override
            public T next() {
                return this.cur;
            }
        };
    }

    public static <T> Iterator<T> IteratorAdapter(final ExceptionSupplier<T> sup) {
        return new Iterator<T>(){
            T cur;

            @Override
            public boolean hasNext() {
                this.cur = GonglerUtil.CallWithThrowAny(sup::get);
                return this.cur != null;
            }

            @Override
            public T next() {
                return this.cur;
            }
        };
    }

    public static <T> Iterable<T> IterableAdapter(final T[] sup) {
        return () -> new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < sup.length;
            }

            @Override
            public T next() {
                return sup[this.i++];
            }
        };
    }

    public static <T> Iterator<T> IteratorAdapter(final T[] sup) {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < sup.length;
            }

            @Override
            public T next() {
                return sup[this.i++];
            }
        };
    }

    public static <E> Iterable<E> IterableAdapter(final Enumeration<E> source) {
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return source.hasMoreElements();
            }

            @Override
            public E next() {
                return source.nextElement();
            }
        };
    }

    public static <E> Iterator<E> IteratorAdapter(final Enumeration<E> source) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return source.hasMoreElements();
            }

            @Override
            public E next() {
                return source.nextElement();
            }
        };
    }

    public static Iterable<ResultSet> IterableAdapter(final ResultSet rs) {
        return () -> new Iterator<ResultSet>(){

            @Override
            public boolean hasNext() {
                return GonglerUtil.CallWithThrowAny(rs::next);
            }

            @Override
            public ResultSet next() {
                return rs;
            }
        };
    }

    public static Iterator<ResultSet> IteratorAdapter(final ResultSet rs) {
        return new Iterator<ResultSet>(){

            @Override
            public boolean hasNext() {
                return GonglerUtil.CallWithThrowAny(rs::next);
            }

            @Override
            public ResultSet next() {
                return rs;
            }
        };
    }

    public static <T, R> Iterable<R> IterableFilter(Iterable<T> list, Class<R> aClass) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T e : list) {
            if (!aClass.isInstance(e)) continue;
            ret.add(e);
        }
        return ret;
    }

    public static <E> Iterator<E> LimitIterator(final long limit, final Iterator<E> original) {
        return new Iterator<E>(){
            long i = 0L;

            @Override
            public boolean hasNext() {
                return original.hasNext() && this.i < limit;
            }

            @Override
            public E next() {
                ++this.i;
                return original.next();
            }
        };
    }

    public static <E> Collection<E> LimitIterator(Collection<E> original, long limit) {
        return new ArrayList();
    }

    @Deprecated
    public static <E> Iterable<E> LimitIterable(long limit, Iterable<E> original) {
        return () -> GonglerUtil.LimitIterator(limit, original.iterator());
    }

    public static <E> Collection<E> Limit(Iterable<E> original, long limit) {
        ArrayList<E> ret = new ArrayList<E>();
        int i = 0;
        for (E e : original) {
            ret.add(e);
            if ((long)(++i) < limit) continue;
            break;
        }
        return ret;
    }

    public static <K, V> Map<K, V> LimitMap(final Map<K, V> original, final long limit) {
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return new HashSet(GonglerUtil.Limit(original.entrySet(), limit));
            }
        };
    }

    public static <E> Iterable<E> ForEachFrom(ExceptionSupplier<E> sup) {
        return GonglerUtil.IterableAdapter(sup);
    }

    public static int DecodeInt(String nm) throws NumberFormatException {
        return (int)GonglerUtil.DecodeLong(nm);
    }

    public static long DecodeLong(String nm) throws NumberFormatException {
        String danweiStr = GonglerUtil.SuffixOf(nm, 1);
        long danwei = 1L;
        switch (danweiStr) {
            case "k": 
            case "K": {
                danwei = 1024L;
                break;
            }
            case "m": 
            case "M": {
                danwei = 0x100000L;
                break;
            }
            case "g": 
            case "G": {
                danwei = 0x40000000L;
            }
        }
        if (danwei > 1L) {
            return GonglerUtil._decodeLong(GonglerUtil.ExcludeEndOf(nm, 1)) * danwei;
        }
        return GonglerUtil._decodeLong(nm);
    }

    private static long _decodeLong(String nm) throws NumberFormatException {
        long result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0o", index) || nm.startsWith("0O", index)) {
            index += 2;
            radix = 8;
        } else if (nm.startsWith("0b", index) || nm.startsWith("0B", index)) {
            index += 2;
            radix = 2;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Long.valueOf(nm.substring(index), radix);
            result = negative ? -result : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Long.valueOf(constant, radix);
        }
        return result;
    }

    public static List<Integer> DecodeIntegers(String str) {
        return GonglerUtil.IsEmptyString(str) ? Collections.emptyList() : Arrays.stream(str.split(",")).map(GonglerUtil::DecodeInt).collect(Collectors.toList());
    }

    public static List<Long> DecodeLongs(String str) {
        return GonglerUtil.IsEmptyString(str) ? Collections.emptyList() : Arrays.stream(str.split(",")).map(GonglerUtil::DecodeLong).collect(Collectors.toList());
    }

    public static Boolean parseBoolean(String boolStr, Boolean defaultBool) {
        Boolean ret;
        if (boolStr == null) {
            return defaultBool;
        }
        switch (boolStr.toUpperCase()) {
            case "YES": 
            case "Y": 
            case "TRUE": 
            case "T": 
            case "ON": {
                ret = true;
                break;
            }
            case "NO": 
            case "N": 
            case "FALSE": 
            case "F": 
            case "OFF": {
                ret = false;
                break;
            }
            default: {
                ret = defaultBool;
            }
        }
        return ret;
    }

    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return Long.parseUnsignedLong(s);
    }

    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        return Long.parseUnsignedLong(s, radix);
    }

    public static int parseUnsignedInt(String s) throws NumberFormatException {
        return Integer.parseUnsignedInt(s);
    }

    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {
        return Integer.parseUnsignedInt(s, radix);
    }

    public static short parseUnsignedShort(String s) throws NumberFormatException {
        return GonglerUtil.parseUnsignedShort(s, 10);
    }

    public static short parseUnsignedShort(String s, int radix) throws NumberFormatException {
        int val = Integer.parseUnsignedInt(s, radix);
        if (val < 0 || val > 65535) {
            throw new NumberFormatException();
        }
        return (short)val;
    }

    public static short parseUnsignedByte(String s) throws NumberFormatException {
        return GonglerUtil.parseUnsignedByte(s, 10);
    }

    public static short parseUnsignedByte(String s, int radix) throws NumberFormatException {
        int val = Integer.parseUnsignedInt(s, radix);
        if (val < 0 || val > 255) {
            throw new NumberFormatException();
        }
        return (byte)val;
    }

    public static boolean IsEmptyString(String str) {
        return !GonglerUtil.IsNotEmptyString(str);
    }

    public static boolean IsNotEmptyString(String str) {
        return str != null && str.length() > 0;
    }

    public static String SuffixOf(String str, int charCount) {
        return str.substring(str.length() - charCount);
    }

    public static String PrefixOf(String str, int charCount) {
        return str.substring(0, charCount);
    }

    public static String ExcludeEndOf(String str, int charCount) {
        return str.substring(0, str.length() - charCount);
    }

    public static String ToString(Object ... items) {
        StringBuilder buf = new StringBuilder();
        for (Object item : items) {
            buf.append(item);
        }
        return buf.toString();
    }

    public static String PrintStackTraceToString(Throwable e) {
        CharArrayWriter bout = new CharArrayWriter(512);
        try (PrintWriter print = new PrintWriter((Writer)bout, true);){
            e.printStackTrace(print);
        }
        return bout.toString();
    }

    public static String GpsDoubleToString(double gps) {
        return String.format("%.6f", gps);
    }

    public static String SubstringAfter(String msg, String delimiter) {
        if (msg == null) {
            return null;
        }
        int index = msg.indexOf(delimiter);
        if (index >= 0) {
            return msg.substring(index + delimiter.length());
        }
        return null;
    }

    public static String SubstringBefore(String msg, String delimiter) {
        if (msg == null) {
            return null;
        }
        int index = msg.indexOf(delimiter);
        if (index >= 0) {
            return msg.substring(0, index);
        }
        return null;
    }

    public static String lastSubstring(String msg, int charCntMax) {
        if (msg == null) {
            return null;
        }
        int from = Math.max(msg.length() - charCntMax, 0);
        return msg.substring(from, msg.length());
    }

    public static long Kilo(long val) {
        return 1024L * val;
    }

    public static long Mega(long val) {
        return 0x100000L * val;
    }

    public static long Giga(long val) {
        return 0x40000000L * val;
    }

    public static long Tera(long val) {
        return 0x10000000000L * val;
    }

    public static long toEpochMilli(LocalDateTime ldt) {
        return ldt.toInstant(ZoneOffset.ofTotalSeconds(TimeZone.getDefault().getRawOffset() / 1000)).toEpochMilli();
    }

    public static long toEpochMilli(OffsetDateTime odt) {
        return odt.toInstant().toEpochMilli();
    }

    public static OffsetDateTime toOffsetDateTime(long millis) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long millis) {
        return new Timestamp(millis).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Date oldTime) {
        return LocalDateTime.ofInstant(oldTime.toInstant(), ZoneId.systemDefault());
    }

    public static Timestamp toTimestamp(LocalDateTime ldt) {
        return new Timestamp(GonglerUtil.toEpochMilli(ldt));
    }

    public static Date toUtilDate(LocalDateTime ldt) {
        return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String HHMM(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return HHMM.format(time);
    }

    public static String HHMM(long time) {
        return new SimpleDateFormat("HH:mm").format(time);
    }

    public static String HHMMSS(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return HHMMSS.format(time);
    }

    public static String HHMMSS(long time) {
        return new SimpleDateFormat("HH:mm:ss").format(time);
    }

    public static String YYYYMMDD(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return YYYYMMDD.format(time);
    }

    public static String YYYYMMDD(long time) {
        return new SimpleDateFormat("yyyy-MM-dd").format(time);
    }

    public static String YYYYMMDD_HHMM(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return YYYYMMDD_HHMM.format(time);
    }

    public static String YYYYMMDD_HHMM(long time) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(time);
    }

    public static String YYYYMMDD_HHMMSS(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return YYYYMMDD_HHMMSS.format(time);
    }

    public static String YYYYMMDD_HHMMSS(long time) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(time);
    }

    public static String YYYYMMDD_HHMMSSXXX(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return YYYYMMDD_HHMMSSXXX.format(time);
    }

    public static String YYYYMMDD_HHMMSSXXX(long time) {
        return new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS").format(time);
    }

    public static Charset GBK() {
        return Charset.forName("GBK");
    }

    public static Charset GB18030() {
        return Charset.forName("GB18030");
    }

    public static int msgLedWidth(String msg) {
        return msg.getBytes(GonglerUtil.GBK()).length;
    }

    public static <T> Comparator<T> LineComparator(Function<T, String> func) {
        return ChineseLinenameComparator.of(func);
    }

    public static Comparator<String> LineComparator() {
        return GonglerUtil.LineComparator(Function.identity());
    }

    public static Duration Duration(Runnable task) {
        LocalDateTime from = LocalDateTime.now();
        task.run();
        LocalDateTime to = LocalDateTime.now();
        return Duration.between(from, to);
    }

    public static String toUnsignedString(long val) {
        return Long.toUnsignedString(val);
    }

    public static String toUnsignedString(long val, int radix) {
        return Long.toUnsignedString(val, radix);
    }

    public static <A> int CompareAny(A a1, A a2) {
        if (Objects.equals(a1, a2)) {
            return 0;
        }
        if (a1 instanceof Number && a2 instanceof Number && a1.getClass() != a2.getClass()) {
            return Double.compare(((Number)a1).doubleValue(), ((Number)a2).doubleValue());
        }
        if (a1 instanceof Comparable && a2 instanceof Comparable && a1.getClass() == a2.getClass()) {
            Comparator c = Comparator.naturalOrder();
            return Objects.compare(a1, a2, c);
        }
        if (a1 == null && a2 != null) {
            return -1;
        }
        if (a1 != null && a2 == null) {
            return 1;
        }
        if (a1 != null && a2 != null) {
            if (a1 instanceof CharSequence || a2 instanceof CharSequence) {
                return String.valueOf(a1).compareTo(String.valueOf(a2));
            }
            return Integer.compare(a1.hashCode(), a2.hashCode());
        }
        throw new UnsupportedOperationException("\u4e0d\u5e94\u8be5\u8fd8\u6709\u8fdb\u5165\u5230\u8fd9\u91cc\u7684\u60c5\u51b5\u3002\u5982\u679c\u4f60\u770b\u5230\u6211\u8bf4\u660e\u6709\u9057\u6f0f\u7684\u60c5\u51b5\u3002");
    }

    public static <A> Comparator<A> AnyComparator() {
        return GonglerUtil::CompareAny;
    }

    public static InputStream FilterInputStream(InputStream in, final IntUnaryOperator func) {
        return new FilterInputStream(in){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ch = this.read();
                if (ch == -1) {
                    throw new EOFException();
                }
                b[0] = (byte)func.applyAsInt(ch);
                return 1;
            }
        };
    }

    public static OutputStream FilterOutputStream(OutputStream out, final IntUnaryOperator func) {
        return new FilterOutputStream(out){

            @Override
            public void write(int b) throws IOException {
                super.write(func.applyAsInt(b));
            }
        };
    }

    public static int IntForceRange(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int UnsignedIntForceRange(int val, int min, int max) {
        return (int)GonglerUtil.LongForceRange((long)val & 0xFFFFFFFFL, (long)min & 0xFFFFFFFFL, (long)max & 0xFFFFFFFFL);
    }

    public static long LongForceRange(long val, long min, long max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static LocalDateTime ForceToLocalDateTime(int year, int month, int day, int hour, int minute, int second) {
        year = GonglerUtil.IntForceRange(year, 0, 9999);
        month = GonglerUtil.IntForceRange(month, 1, 12);
        day = GonglerUtil.IntForceRange(day, 1, GonglerUtil.daysOfMonth(year, month));
        hour = GonglerUtil.IntForceRange(hour, 0, 23);
        minute = GonglerUtil.IntForceRange(minute, 0, 59);
        second = GonglerUtil.IntForceRange(second, 0, 59);
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public static LocalDate ForceToLocalDate(int year, int month, int day) {
        year = GonglerUtil.IntForceRange(year, 0, 9999);
        month = GonglerUtil.IntForceRange(month, 1, 12);
        day = GonglerUtil.IntForceRange(day, 1, GonglerUtil.daysOfMonth(year, month));
        return LocalDate.of(year, month, day);
    }

    public static int daysOfMonth(int year, int month) {
        LocalDateTime from = LocalDateTime.of(year, month, 1, 0, 0, 0);
        LocalDateTime to = from.plusMonths(1L);
        return (int)Duration.between(from, to).toDays();
    }

    public static boolean require(boolean val) {
        return GonglerUtil.require(val, "requireTrue");
    }

    public static boolean require(boolean val, String msg) {
        if (!val) {
            throw new IllegalArgumentException(msg);
        }
        return val;
    }

    private static String assertMessage(Object expected, Object actual) {
        return "expected: " + expected + ", but actual: " + actual;
    }

    private static String assertMessage(Object expected, Object actual, String msg) {
        return "expected: " + expected + ", but actual: " + actual + ", " + msg;
    }

    public static <T> void requireEquals(T expected, T actual) {
        if (!Objects.equals(expected, actual)) {
            throw new IllegalArgumentException(GonglerUtil.assertMessage(expected, actual));
        }
    }

    public static <T> void requireEquals(T expected, T actual, String msg) {
        if (!Objects.equals(expected, actual)) {
            throw new IllegalArgumentException(GonglerUtil.assertMessage(expected, actual, msg));
        }
    }

    public static void requireEquals(int expected, int actual) {
        if (expected != actual) {
            throw new IllegalArgumentException(GonglerUtil.assertMessage(expected, actual));
        }
    }

    public static void requireEquals(long expected, long actual) {
        if (expected != actual) {
            throw new IllegalArgumentException(GonglerUtil.assertMessage(expected, actual));
        }
    }

    public static void requireLessThenOrEqual(int val, int limit) {
        if (val > limit) {
            throw new IllegalArgumentException(val + "\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u9650\u5b9a\u503c" + limit);
        }
    }

    public static void requireLessThenOrEqual(long val, long limit) {
        if (val > limit) {
            throw new IllegalArgumentException(val + "\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u9650\u5b9a\u503c" + limit);
        }
    }

    public static void requireLessThen(int val, int limit) {
        if (val >= limit) {
            throw new IllegalArgumentException(val + "\u5e94\u5c0f\u4e8e\u9650\u5b9a\u503c" + limit);
        }
    }

    public static void requireLessThen(long val, long limit) {
        if (val >= limit) {
            throw new IllegalArgumentException(val + "\u5e94\u5c0f\u4e8e\u9650\u5b9a\u503c" + limit);
        }
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static int requireIntRange(int val, int min, int max) {
        if (val < min || val > max) {
            throw new IllegalArgumentException("" + val + " not in [" + min + ", " + max + "]");
        }
        return val;
    }

    public static long requireLongRange(long val, long min, long max) {
        if (val < min || val > max) {
            throw new IllegalArgumentException("" + val + " not in [" + min + ", " + max + "]");
        }
        return val;
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(expectedSize * 4 / 3 + 1);
    }

    public static <K extends Comparable, V> ConcurrentSkipListMap<K, V> newConcurrentSkipListMap() {
        return new ConcurrentSkipListMap();
    }

    public static <K extends Comparable> TreeSet<K> newTreeSet() {
        return new TreeSet();
    }

    public static <T> List<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    public static <T> List<T> newList(int size, ExceptionIntFunction<T> func) {
        ArrayList list = new ArrayList();
        GonglerUtil.Repeat(size, (int i) -> list.add(func.toFunction().apply(i)));
        return list;
    }

    public static <K extends Comparable> ConcurrentSkipListSet<K> newConcurrentSkipListSet() {
        return new ConcurrentSkipListSet();
    }

    public static <K, V> void MapForEach(Map<K, V> map, UnaryOperator<Stream<Map.Entry<K, V>>> mapper, BiConsumer<K, V> action) {
        ((Stream)mapper.apply(map.entrySet().stream())).forEach(e -> action.accept(e.getKey(), e.getValue()));
    }

    public static <K, V> void MapForEachLimit(Map<K, V> map, long limit, BiConsumer<K, V> action) {
        GonglerUtil.MapForEach(map, stream -> stream.limit(limit), action);
    }

    public static <K extends Comparable, V> void MapForEachOrdered(Map<K, V> map, BiConsumer<? super K, ? super V> action) {
        if (map instanceof SortedMap) {
            map.forEach(action);
        } else {
            new TreeMap<K, V>(map).forEach(action);
        }
    }

    public static <K, V> void MapForEachOrdered(Map<K, V> map, Comparator<? super K> comparator, BiConsumer<? super K, ? super V> action) {
        TreeMap<Object, Object> ret = new TreeMap<Object, Object>(comparator);
        ret.putAll(map);
        ret.forEach(action);
    }

    public static <T> Collection<T> Sort(Iterable<T> collect, Comparator<? super T> c) {
        if (collect instanceof Set) {
            TreeSet<T> ret = new TreeSet<T>(c);
            for (T e : collect) {
                ret.add(e);
            }
            return ret;
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (T e : collect) {
            ret.add(e);
        }
        Collections.sort(ret, c);
        return ret;
    }

    public static <T extends Comparable> Collection<T> Sort(Iterable<T> collect) {
        if (collect instanceof Set) {
            TreeSet<Comparable> ret = new TreeSet<Comparable>();
            for (Comparable e : collect) {
                ret.add(e);
            }
            return ret;
        }
        ArrayList<Comparable> ret = new ArrayList<Comparable>();
        for (Comparable e : collect) {
            ret.add(e);
        }
        Collections.sort(ret);
        return ret;
    }

    public static <T> Collection<T> Sort(Iterable<T> arg, Function<? super T, ? extends Comparable> keyExtractor) {
        return GonglerUtil.Sort(arg, Comparator.comparing(keyExtractor));
    }

    public static <T, K> SortedMap<K, T> Sort(Map<K, T> arg, Comparator<? super K> c) {
        TreeMap<K, T> ret = new TreeMap<K, T>(c);
        ret.putAll(arg);
        return ret;
    }

    public static <T, K> SortedMap<K, T> Sort(Map<K, T> arg, Function<? super K, ? extends Comparable> keyExtractor) {
        return GonglerUtil.Sort(arg, Comparator.comparing(keyExtractor));
    }

    public static <E> List<E> minusIndexableList() {
        return new SimpleArrayList();
    }

    public static <E> List<E> minusIndexableList(List<E> list) {
        SimpleArrayList<E> ins = new SimpleArrayList<E>();
        ins.addAll(list);
        return ins;
    }

    public static <T> T LastItem(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> T LastItem(T[] list) {
        if (list.length == 0) {
            return null;
        }
        return list[list.length - 1];
    }

    public static <E> List<E> Reverse(List<E> srcList) {
        ArrayList<E> dest = new ArrayList<E>(srcList);
        Collections.reverse(dest);
        return dest;
    }

    public static byte[] Reverse(byte[] src) {
        int len = src.length;
        byte[] dst = Arrays.copyOf(src, len);
        for (int i = len / 2; i >= 0; --i) {
            byte tmp = dst[i];
            dst[i] = dst[len - 1 - i];
            dst[len - 1 - i] = tmp;
        }
        return dst;
    }

    public static <T> T[] Reverse(T[] src) {
        int len = src.length;
        T[] dst = Arrays.copyOf(src, len);
        for (int i = len / 2; i >= 0; --i) {
            T tmp = dst[i];
            dst[i] = dst[len - 1 - i];
            dst[len - 1 - i] = tmp;
        }
        return dst;
    }

    public static void Close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static AutoCloseable AutoCloseable(ITask closeTask) {
        return closeTask::run;
    }

    public static void Rollback(Connection conn) {
        if (conn != null) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void Commit(Connection conn) throws SQLException {
        if (conn != null && !conn.getAutoCommit()) {
            conn.commit();
        }
    }

    public static TimerTask TimerTask(final ITask task) {
        return new TimerTask(){

            @Override
            public void run() {
                GonglerUtil.ExecuteWithCatchAny(task);
            }
        };
    }

    public static <T> Comparator<T> HashComparator() {
        return Comparator.comparingInt(Object::hashCode);
    }

    public static boolean IsLinux() {
        return "Linux".equalsIgnoreCase(System.getProperty("os.name"));
    }

    public void ImportPropertiesToSystemIfNoExisted(Properties prop) {
        for (String key : prop.stringPropertyNames()) {
            if (System.getProperty(key) == null) {
                System.setProperty(key, prop.getProperty(key));
                continue;
            }
            new IllegalArgumentException("Can not replace system propertiy " + key + "=" + System.getProperty(key) + " -> " + prop.getProperty(key)).printStackTrace();
        }
    }

    static class SimpleArrayList<E>
    extends ArrayList<E> {
        SimpleArrayList() {
        }

        @Override
        public E get(int index) {
            index = index >= 0 ? index : this.size() + index;
            return super.get(index);
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }
}

