/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface EqualsComparator<T> {
    public static <E, F> EqualsComparator<F> compare(Function<F, E> mapper) {
        Objects.requireNonNull(mapper);
        return (a, b) -> Objects.equals(mapper.apply(a), mapper.apply(b));
    }

    default public <E> EqualsComparator<T> thenCompare(Function<T, E> mapper) {
        Objects.requireNonNull(mapper);
        return (a, b) -> this.apply(a, b) && Objects.equals(mapper.apply(a), mapper.apply(b));
    }

    public boolean apply(T var1, T var2);

    public static void main(String[] args) {
        LocalDateTime a = LocalDateTime.now();
        LocalDateTime b = a.minusMinutes(1L);
        EqualsComparator<LocalDateTime> equalsComparator = EqualsComparator.compare(LocalDateTime::toLocalDate).thenCompare(LocalDateTime::toLocalTime);
        System.out.println(equalsComparator.apply(a, a));
        System.out.println(equalsComparator.apply(a, b));
    }
}

