/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.UUID;
import java.util.regex.Pattern;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoUtil {
    static final Pool<Kryo> kryoPool = new Pool<Kryo>(true, false, 1024){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.setReferences(false);
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            kryo.addDefaultSerializer(Throwable.class, (Serializer)new JavaSerializer());
            kryo.addDefaultSerializer(UUID.class, (Serializer)new DefaultSerializers.UUIDSerializer());
            kryo.addDefaultSerializer(URI.class, (Serializer)new DefaultSerializers.URISerializer());
            kryo.addDefaultSerializer(Pattern.class, (Serializer)new DefaultSerializers.PatternSerializer());
            return kryo;
        }
    };
    static final Pool<Output> outputPool = new Pool<Output>(true, false, 512){

        protected Output create() {
            return new Output(8192, -1);
        }
    };
    static final Pool<Input> inputPool = new Pool<Input>(true, false, 512){

        protected Input create() {
            return new Input(8192);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] serialize(T obj) {
        Kryo kryo = (Kryo)kryoPool.obtain();
        Output output = (Output)outputPool.obtain();
        try {
            byte[] byArray;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                output.setOutputStream((OutputStream)stream);
                kryo.writeClassAndObject(output, obj);
                output.flush();
                byArray = stream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
            }
            stream.close();
            return byArray;
        }
        finally {
            output.reset();
            kryoPool.free((Object)kryo);
            outputPool.free((Object)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] data) {
        Kryo kryo = (Kryo)kryoPool.obtain();
        Input input = (Input)inputPool.obtain();
        try {
            input.setBuffer(data);
            Object object = kryo.readClassAndObject(input);
            return object;
        }
        catch (Exception e) {
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            input.reset();
            kryoPool.free((Object)kryo);
            inputPool.free((Object)input);
        }
    }
}

