/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import cn.godmao.utils.RandomUtil;
import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class CollectUtil
extends CollUtil {
    private static final Map<Object, AtomicLong> counterGroup = new HashMap<Object, AtomicLong>();

    private CollectUtil() {
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> collection, Function<V, K> function) {
        if (collection == null) {
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (V next : collection) {
            K apply = function.apply(next);
            map.put(apply, next);
        }
        return map;
    }

    public static <K1, K2, V> Map<K1, K2> toMap(Iterable<V> collection, Function<V, K1> f1, Function<V, K2> f2) {
        if (collection == null) {
            return null;
        }
        HashMap<K1, K2> map = new HashMap<K1, K2>();
        for (V next : collection) {
            K1 k1 = f1.apply(next);
            K2 k2 = f2.apply(next);
            map.put(k1, k2);
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(V[] collection, Function<V, K> function) {
        if (collection == null) {
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (V next : collection) {
            K apply = function.apply(next);
            map.put(apply, next);
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toGroup(Iterable<V> collection, Function<V, K> function) {
        if (collection == null) {
            return null;
        }
        HashMap<K, List> map = new HashMap<K, List>();
        for (V next : collection) {
            K apply = function.apply(next);
            List list = map.getOrDefault(apply, new ArrayList());
            list.add(next);
            map.put(apply, list);
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toGroup(V[] collection, Function<V, K> function) {
        if (collection == null) {
            return null;
        }
        HashMap<K, List> map = new HashMap<K, List>();
        for (V next : collection) {
            K apply = function.apply(next);
            List list = map.getOrDefault(apply, new ArrayList());
            list.add(next);
            map.put(apply, list);
        }
        return map;
    }

    public static <T, V> T getOne(Iterable<? extends T> collection, Function<T, V> function, V value) {
        for (T t : collection) {
            V apply = function.apply(t);
            if (!apply.equals(value)) continue;
            return t;
        }
        return null;
    }

    public static <T, V> T getOne(T[] collection, Function<T, V> function, V value) {
        for (T t : collection) {
            V apply = function.apply(t);
            if (!apply.equals(value)) continue;
            return t;
        }
        return null;
    }

    public static <T, V> List<T> getArr(List<T> collection, Function<T, V> function, V ... values) {
        if (values.length == 0) {
            return collection;
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        block0: for (T t : collection) {
            V apply = function.apply(t);
            for (V value : values) {
                if (apply instanceof Collection) {
                    if (!((Collection)apply).contains(value)) continue;
                    result.add(t);
                    continue block0;
                }
                if (!apply.equals(value)) continue;
                result.add(t);
                continue block0;
            }
        }
        return result;
    }

    public static <T, V> List<T> getArr(List<T> collection, Function<T, V> function, Iterable<V> values) {
        if (null == values) {
            return collection;
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        block0: for (T t : collection) {
            V apply = function.apply(t);
            for (V value : values) {
                if (apply instanceof Collection) {
                    if (!((Collection)apply).contains(value)) continue;
                    result.add(t);
                    continue block0;
                }
                if (!apply.equals(value)) continue;
                result.add(t);
                continue block0;
            }
        }
        return result;
    }

    public static <T, V> List<V> getArr(Iterable<? extends T> collection, Function<T, V> function) {
        ArrayList<V> result = new ArrayList<V>();
        for (T t : collection) {
            V apply = function.apply(t);
            result.add(apply);
        }
        return result;
    }

    public static <T, V> Set<V> getSet(Iterable<? extends T> collection, Function<T, V> function) {
        HashSet<V> result = new HashSet<V>();
        for (T t : collection) {
            V apply = function.apply(t);
            result.add(apply);
        }
        return result;
    }

    public static <T, V> Set<V> getSet(T[] collection, Function<T, V> function) {
        HashSet<V> result = new HashSet<V>();
        for (T t : collection) {
            V apply = function.apply(t);
            result.add(apply);
        }
        return result;
    }

    public static <T, V> Set<T> getSet(Iterable<? extends T> collection, Function<T, V> function, V ... values) {
        if (values.length == 0) {
            return new HashSet();
        }
        HashSet<T> result = new HashSet<T>();
        block0: for (T t : collection) {
            V apply = function.apply(t);
            for (V value : values) {
                if (apply instanceof Collection) {
                    if (!((Collection)apply).contains(value)) continue;
                    result.add(t);
                    continue block0;
                }
                if (!apply.equals(value)) continue;
                result.add(t);
                continue block0;
            }
        }
        return result;
    }

    public static <T, V> Set<T> getSet(T[] collection, Function<T, V> function, V ... values) {
        if (values.length == 0) {
            return CollectUtil.setOf(collection);
        }
        HashSet<T> result = new HashSet<T>();
        block0: for (T t : collection) {
            V apply = function.apply(t);
            for (V value : values) {
                if (apply instanceof Collection) {
                    if (!((Collection)apply).contains(value)) continue;
                    result.add(t);
                    continue block0;
                }
                if (!apply.equals(value)) continue;
                result.add(t);
                continue block0;
            }
        }
        return result;
    }

    public static <T, V> Set<T> getSet(Iterable<? extends T> collection, Function<T, V> function, Iterable<V> values) {
        if (null == values) {
            return new HashSet();
        }
        HashSet<T> result = new HashSet<T>();
        block0: for (T t : collection) {
            V apply = function.apply(t);
            for (V value : values) {
                if (apply instanceof Collection) {
                    if (!((Collection)apply).contains(value)) continue;
                    result.add(t);
                    continue block0;
                }
                if (!apply.equals(value)) continue;
                result.add(t);
                continue block0;
            }
        }
        return result;
    }

    public static <T, V> Set<T> getSet(T[] collection, Function<T, V> function, Iterable<V> values) {
        if (null == values) {
            return CollectUtil.setOf(collection);
        }
        HashSet<T> result = new HashSet<T>();
        block0: for (T t : collection) {
            V apply = function.apply(t);
            for (V value : values) {
                if (apply instanceof Collection) {
                    if (!((Collection)apply).contains(value)) continue;
                    result.add(t);
                    continue block0;
                }
                if (!apply.equals(value)) continue;
                result.add(t);
                continue block0;
            }
        }
        return result;
    }

    public static <T, V> void remove(Iterable<? extends T> collection, Function<T, V> function, V ... values) {
        for (V value : values) {
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                T next = iterator.next();
                V apply = function.apply(next);
                if (!apply.equals(value)) continue;
                iterator.remove();
            }
        }
    }

    public static <T, V> void remove(Collection<? extends T> collection, Function<T, V> function, Iterable<V> values) {
        for (V value : values) {
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                T next = iterator.next();
                V apply = function.apply(next);
                if (!apply.equals(value)) continue;
                iterator.remove();
            }
        }
    }

    public static <K, V> Collection<V> getValues(Map<K, V> map, Iterable<? extends K> keys) {
        ArrayList<V> vs = new ArrayList<V>();
        for (K key : keys) {
            V v = map.get(key);
            if (v == null) continue;
            vs.add(v);
        }
        return vs;
    }

    public static <S> Set<S> setOf(S ... es) {
        HashSet<S> result = new HashSet<S>();
        for (S e : es) {
            if (null == e) continue;
            result.add(e);
        }
        return result;
    }

    public static <S> Set<S> setOf(Set<S> result, S ... es) {
        for (S e : es) {
            if (null == e) continue;
            result.add(e);
        }
        return result;
    }

    public static <S> List<S> listOf(S ... es) {
        ArrayList<S> result = new ArrayList<S>();
        for (S e : es) {
            if (null == e) continue;
            result.add(e);
        }
        return result;
    }

    public static <S> List<S> listOf(List<S> result, S ... es) {
        for (S e : es) {
            if (null == e) continue;
            result.add(e);
        }
        return result;
    }

    public static <T, V extends Comparable<? super V>> T max(Collection<? extends T> collection, Function<T, V> function) {
        if (collection == null) {
            return Collections.max(collection);
        }
        Iterator<T> i = collection.iterator();
        T r = i.next();
        Comparable candidate = (Comparable)function.apply(r);
        while (i.hasNext()) {
            T next = i.next();
            Comparable comp = (Comparable)function.apply(next);
            if (comp.compareTo(candidate) <= 0) continue;
            candidate = comp;
            r = next;
        }
        return r;
    }

    public static <T, V extends Comparable<? super V>> T min(Collection<? extends T> collection, Function<T, V> function) {
        if (collection == null) {
            return Collections.min(collection);
        }
        Iterator<T> i = collection.iterator();
        T r = i.next();
        Comparable candidate = (Comparable)function.apply(r);
        while (i.hasNext()) {
            T next = i.next();
            Comparable comp = (Comparable)function.apply(next);
            if (comp.compareTo(candidate) >= 0) continue;
            candidate = comp;
            r = next;
        }
        return r;
    }

    public static <C extends Collection<E>, E> C fill(C array, E obj) {
        return CollectUtil.fill(array, obj, null);
    }

    public static <C extends Collection<E>, E> C fill(C array, E obj, Integer size) {
        int arraySize = null == size ? array.size() : size.intValue();
        array.clear();
        for (int i = 0; i < arraySize; ++i) {
            array.add(obj);
        }
        return array;
    }

    public static <T, V> List<T> distinct(Iterable<? extends T> collection, Function<T, V> function) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<V> hash = new HashSet<V>();
        for (T t : collection) {
            V apply = function.apply(t);
            if (hash.contains(apply)) continue;
            hash.add(apply);
            result.add(t);
        }
        return result;
    }

    public static <C> boolean contains(C[] array, C c) {
        for (C c1 : array) {
            if (!c1.equals(c)) continue;
            return true;
        }
        return false;
    }

    private static AtomicLong getCounter(Object key) {
        AtomicLong atomicLong = counterGroup.get(key);
        if (null == atomicLong) {
            atomicLong = new AtomicLong(-1L);
            counterGroup.put(key, atomicLong);
        }
        return atomicLong;
    }

    public static <T> T next(Collection<T> array, AtomicLong counter) {
        if (null == array || array.isEmpty()) {
            return null;
        }
        int findIndex = Math.abs((int)(counter.incrementAndGet() % (long)array.size()));
        if (array instanceof List) {
            return (T)((List)array).get(findIndex);
        }
        int index = 0;
        for (T t : array) {
            if (index++ != findIndex) continue;
            return t;
        }
        return null;
    }

    public static <T> T next(Object key, Collection<T> array) {
        return CollectUtil.next(array, CollectUtil.getCounter(key));
    }

    public static <T> T next(Collection<T> array) {
        return CollectUtil.next(array.hashCode(), array);
    }

    public static <T> T random(Collection<T> array) {
        if (null == array || array.isEmpty()) {
            return null;
        }
        int findIndex = RandomUtil.randomInt((int)array.size());
        if (array instanceof List) {
            return (T)((List)array).get(findIndex);
        }
        int index = 0;
        for (T t : array) {
            if (index++ != findIndex) continue;
            return t;
        }
        return null;
    }
}

