package cn.godmao.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;


/**
 * 压缩工具类
 */
public class CompressUtil extends cn.hutool.extra.compress.CompressUtil {

    /**
     * 压缩数据
     */
    public static byte[] compress(byte[] data) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        GZIPOutputStream gzip = new GZIPOutputStream(out, data.length);
        gzip.write(data);
        gzip.close();//必须先关闭它
        return out.toByteArray();

    }

    /**
     * 解压数据
     */
    public static byte[] uncompress(byte[] data) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        GZIPInputStream gin = new GZIPInputStream(in, data.length);
        byte[] buffer = new byte[1024];
        int n;
        while ((n = gin.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();

    }
}
