/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import cn.godmao.utils.CollectUtil;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ObjectUtil
extends cn.hutool.core.util.ObjectUtil {
    private static final Double DOUBLE_DEFAULT = 0.0;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);
    private Set<Class<?>> baseTypeSet = CollectUtil.setOf(Byte.class, Short.class, Integer.class, Long.class, Character.class, Double.class, Float.class, String.class);

    public static boolean isNull(Object ... objs) {
        for (Object obj : objs) {
            if (!ObjectUtil.isEmpty(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotNull(Object ... obj) {
        return !ObjectUtil.isNull(obj);
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectUtil.isEmpty(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    public static <T> T defaultValue(Class<T> type) {
        boolean empty = ObjectUtil.isEmpty(type);
        if (empty) {
            throw new NullPointerException();
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (type == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (type == Float.TYPE) {
                return (T)FLOAT_DEFAULT;
            }
            if (type == Double.TYPE) {
                return (T)DOUBLE_DEFAULT;
            }
        }
        return null;
    }

    public static <T> T checkNotNull(T arg, String text) {
        if (arg == null) {
            throw new NullPointerException(text);
        }
        return arg;
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression) {
        ObjectUtil.isTrue(expression, "[Assertion failed] - this expression must be true");
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object) {
        ObjectUtil.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static boolean hasLength(String str) {
        return ObjectUtil.hasLength((CharSequence)str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static void hasLength(String text, String message) {
        if (!ObjectUtil.hasLength(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean hasText(String str) {
        return ObjectUtil.hasText((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!ObjectUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static void hasText(String text, String message) {
        if (!ObjectUtil.hasText(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring, String message) {
        if (ObjectUtil.hasLength(textToSearch) && ObjectUtil.hasLength(substring) && textToSearch.indexOf(substring) != -1) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring) {
        ObjectUtil.doesNotContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [" + substring + "]");
    }

    public static void notEmpty(Object[] array, String message) {
        if (ObjectUtil.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array) {
        ObjectUtil.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(byte[] array, String msg) {
        if (ObjectUtil.isEmpty(array)) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void noNullElements(Object[] array) {
        ObjectUtil.noNullElements(array, "[Assertion failed] - this array must not contain any null elements");
    }

    public static void notEmpty(Collection collection, String message) {
        if (ObjectUtil.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection collection) {
        ObjectUtil.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Map map, String message) {
        if (ObjectUtil.isEmpty(map)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Map map) {
        ObjectUtil.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static void isInstanceOf(Class clazz, Object obj) {
        ObjectUtil.isInstanceOf(clazz, obj, "");
    }

    public static void isInstanceOf(Class type, Object obj, String message) {
        ObjectUtil.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message + "Object of class [" + (obj != null ? obj.getClass().getName() : "null") + "] must be an instance of " + type);
        }
    }

    public static void isAssignable(Class superType, Class subType) {
        ObjectUtil.isAssignable(superType, subType, "");
    }

    public static void isAssignable(Class superType, Class subType, String message) {
        ObjectUtil.notNull(superType, "Type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(message + subType + " is not assignable to " + superType);
        }
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression) {
        ObjectUtil.state(expression, "[Assertion failed] - this state invariant must be true");
    }

    public boolean isBaseType(Object value) {
        Class<?> beanClass = value.getClass();
        return this.baseTypeSet.contains(beanClass);
    }

    public boolean isBaseType(Class<?> beanClass) {
        return this.baseTypeSet.contains(beanClass);
    }

    public static Boolean isNumeric(String str) {
        if (null == str) {
            return false;
        }
        return str.matches("\\d+");
    }
}

