package cn.godmao.utils.common;

import cn.hutool.core.util.StrUtil;
import cn.godmao.utils.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

public class SimpleHelper extends ObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(SimpleHelper.class);

    public static String format(CharSequence template, Object... params) {
        return StrUtil.format(template, params);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        return StrUtil.format(template, map);
    }

    public static int parseInteger(Integer value) {
        return parseInteger(value, 0);
    }

    public static int parseInteger(Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static long parseLong(Long value) {
        return parseLong(value, 0);
    }

    public static long parseLong(Long value, long defaultValue) {
        return Objects.isNull(value) ? defaultValue : value;
    }

    public static boolean parseBoolean(Boolean value) {
        return parseBoolean(value, false);
    }

    public static boolean parseBoolean(Boolean value, boolean defaultValue) {
        return Objects.isNull(value) ? defaultValue : value;
    }

    public static Integer parseInteger(Object value) {
        if (ObjectUtil.isEmpty(value)) {
            return 0;
        }
        if (value instanceof Long) {
            return ((Long) value).intValue();
        } else if (value instanceof Integer) {
            return (Integer) value;
        } else if (value instanceof Double) {
            return ((Double) value).intValue();
        } else if (value instanceof BigDecimal) {
            return ((BigDecimal) value).intValue();
        } else if (value instanceof String) {
            if ("".equals(value)) {
                return 0;
            }
            try {
                return Integer.parseInt(((String) value).trim());
            } catch (Exception ex) {
                return 0;
            }
        } else if (value instanceof Float) {
            return ((Float) value).intValue();
        } else if (value instanceof Boolean) {
            return ((Boolean) value) ? 1 : 0;
        } else {
            try {
                throw new Exception("has parseInt Error!!");
            } catch (Exception e) {
                log.error("parseInteger_error", e);
            }
            return 0;
        }
    }

    /**
     * 将对象转换为long型
     */
    public static Long parseLong(Object value) {
        if (ObjectUtil.isEmpty(value)) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long) value;
        } else if (value instanceof Integer) {
            return ((Integer) value).longValue();
        } else if (value instanceof Double) {
            return ((Double) value).longValue();
        } else if (value instanceof Float) {
            return ((Float) value).longValue();
        } else if (value instanceof BigDecimal) {
            return ((BigDecimal) value).longValue();
        } else if (value instanceof String) {
            return Long.parseLong((String) value);
        } else {
            return 0L;
        }
    }

    /**
     * 将对象转换为double型
     */
    public static Double parseDouble(Object value) {
        if (value == null) {
            return 0.0;
        } else if (value instanceof Long) {
            return ((Long) value).doubleValue();
        } else if (value instanceof Integer) {
            return ((Integer) value).doubleValue();
        } else if (value instanceof Double) {
            return (Double) value;
        } else if (value instanceof String) {
            return Double.parseDouble((String) value);
        } else if (value instanceof Float) {
            return ((Float) value).doubleValue();
        } else if (value instanceof BigDecimal) {
            return ((BigDecimal) value).doubleValue();
        } else {
            log.error("parseDouble error, type is invalid, value is " + value);
            return 0.0d;
        }
    }


    /**
     * 将对象转换为boolean型
     */
    public static Boolean parseBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Integer) {
            return (Integer) value != 0;
        }
        if (value instanceof Long) {
            return (Long) value != 0L;
        } else if (value instanceof Boolean) {
            return (Boolean) value;
        } else if (value instanceof String) {
            return Boolean.parseBoolean((String) value);
        } else {
            log.error("parseBoolean error, type is invalid, value is "
                              + value);
            return false;
        }
    }

}
