package cn.godmao.utils.clazz;

import com.esotericsoftware.reflectasm.ConstructorAccess;

public abstract class ClassAccess extends MethodAccess {
    final ConstructorAccess<?> constructorAccess;

    protected ClassAccess() {
        this.constructorAccess = ConstructorAccess.get(this.getClass());
    }

    @SuppressWarnings("unchecked")
    public <T> T newInstance() {
        return (T) this.constructorAccess.newInstance();
    }

    public ConstructorAccess<?> getConstructorAccess() {
        return constructorAccess;
    }
}
