package cn.godmao.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class MathUtil extends cn.hutool.core.math.MathUtil {
    protected static final BigDecimal DECIMAL_ZERO = new BigDecimal(BigInteger.ZERO);
    private static final Map<Class<? extends Number>, BigDecimal> ints = new HashMap<>();

    static {
        ints.put(Byte.class, BigDecimal.valueOf(Byte.MAX_VALUE));
        ints.put(Short.class, BigDecimal.valueOf(Short.MAX_VALUE));
        ints.put(Integer.class, BigDecimal.valueOf(Integer.MAX_VALUE));
        ints.put(Long.class, BigDecimal.valueOf(Long.MAX_VALUE));
        ints.put(BigInteger.class, BigDecimal.valueOf(-1));
    }

    public static final Random RANDOM = new Random();

    public static int randomInt(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static int randomInt(int max) {
        return RANDOM.nextInt(max + 1);
    }

    public static long randomLong(long min, long max) {
        return nextLong(max - min + 1L) + min;
    }

    public static long nextLong(long bound) {
        return boundedNextLong(RANDOM, bound);
    }

    private static long boundedNextLong(Random random, long bound) {
        final long m = bound - 1;
        long r = random.nextLong();
        if ((bound & m) == 0L) {
            r &= m;
        } else {
            for (long u = r >>> 1;
                 u + m - (r = u % bound) < 0L;
                 u = random.nextLong() >>> 1)
                ;
        }
        return r;
    }

    public static BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal) n;
        }
        if (n instanceof BigInteger) {
            return new BigDecimal((BigInteger) n);
        }
        return BigDecimal.valueOf(n.doubleValue());
    }


    public static boolean isZero(Number n) {
        if (isInteger(n)) {
            if (n instanceof BigInteger) {
                return ((BigInteger) n).compareTo(BigInteger.ZERO) == 0;
            }
            return n.doubleValue() == 0;
        }
        if (n instanceof Float) {
            return n.floatValue() == 0f;
        }
        if (n instanceof Double) {
            return n.doubleValue() == 0d;
        }
        return toBigDecimal(n).compareTo(DECIMAL_ZERO) == 0;
    }

    public static boolean isInteger(Number n) {
        return ints.containsKey(n.getClass());
    }
}