package cn.godmao.utils;

import com.esotericsoftware.reflectasm.ConstructorAccess;

import java.lang.reflect.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtil extends cn.hutool.core.util.ClassUtil {
    private static final Map<Class<?>, ConstructorAccess<?>> classAccessMap = new ConcurrentHashMap<>();

    public static <T> ConstructorAccess<T> getConstructorAccess(Class<T> clazz) {
        ConstructorAccess<T> classRefInfo = (ConstructorAccess<T>) classAccessMap.get(clazz);
        if (null == classRefInfo) {
            classRefInfo = ConstructorAccess.get(clazz);
            classAccessMap.putIfAbsent(clazz, classRefInfo);
        }
        return classRefInfo;
    }

    public static <T> T instance(Class<T> cClass) {
        return getConstructorAccess(cClass).newInstance();
    }

    public static <T> T instance(Class<T> cClass, Object... initargs) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?>[] parameterTypes = new Class[initargs.length];
        for (int i = 0; i < initargs.length; i++) {
            parameterTypes[i] = initargs[i].getClass();
        }
        return instance(cClass, parameterTypes, initargs);
    }

    public static <T> T instance(Class<T> cClass, Class<?>[] parameterTypes, Object... initargs) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return cClass.getDeclaredConstructor(parameterTypes).newInstance(initargs);
    }

    public static Class<?> find0(
            final Object object, Class<?> parametrizedSuperclass, String typeParamName) {

        final Class<?> thisClass = object.getClass();
        Class<?> currentClass = thisClass;
        for (; ; ) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = -1;
                TypeVariable<?>[] typeParams = currentClass.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParams.length; i++) {
                    if (typeParamName.equals(typeParams[i].getName())) {
                        typeParamIndex = i;
                        break;
                    }
                }

                if (typeParamIndex < 0) {
                    throw new IllegalStateException(
                            "unknown type parameter '" + typeParamName + "': " + parametrizedSuperclass);
                }

                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }

                Type[] actualTypeParams = ((ParameterizedType) genericSuperType).getActualTypeArguments();

                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    actualTypeParam = ((ParameterizedType) actualTypeParam).getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    return (Class<?>) actualTypeParam;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType) actualTypeParam).getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType) componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class<?>) componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    // Resolved type parameter points to another type parameter.
                    TypeVariable<?> v = (TypeVariable<?>) actualTypeParam;
                    if (!(v.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }

                    currentClass = thisClass;
                    parametrizedSuperclass = (Class<?>) v.getGenericDeclaration();
                    typeParamName = v.getName();
                    if (parametrizedSuperclass.isAssignableFrom(thisClass)) {
                        continue;
                    }
                    return Object.class;
                }

                return fail(thisClass, typeParamName);
            }
            currentClass = currentClass.getSuperclass();
            if (currentClass == null) {
                return fail(thisClass, typeParamName);
            }
        }
    }

    private static Class<?> fail(Class<?> type, String typeParamName) {
        throw new IllegalStateException(
                "cannot determine the type of the type parameter '" + typeParamName + "': " + type);
    }


    /**
     * @param exclusionModifiers 排除的指定权限的方法
     */
    public static List<Method> getMethods(Method[] methods, int... exclusionModifiers) {
        List<Method> methodList = new ArrayList<>();
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            boolean exist = false;
            for (int exclusionModifier : exclusionModifiers) {
                if (exclusionModifier == modifiers) {
                    exist = true;
                    break;
                }
            }
            if (!exist) {
                methodList.add(method);
            }
        }
        return methodList;
    }
}
