package cn.godmao.utils.clazz;

import cn.godmao.utils.ColumnUtil;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodAccess {
    final static Map<Class<?>, com.esotericsoftware.reflectasm.MethodAccess> METHOD_ACCESS_CACHE = new ConcurrentHashMap<>();
    final com.esotericsoftware.reflectasm.MethodAccess methodAccess;
    final Object bean;

    public MethodAccess(Object bean) {
        this.bean = bean;
        this.methodAccess = getMethodAccess(this.bean.getClass());
    }

    protected MethodAccess() {
        this.bean = this;
        this.methodAccess = getMethodAccess(this.bean.getClass());
    }

    public Object invoke(Object bean, int methodIndex, Object... args) {
        return this.methodAccess.invoke(bean, methodIndex, args);
    }

    public Object invoke(int methodIndex, Object... args) {
        return invoke(bean, methodIndex, args);
    }

    public Object invoke(String methodName, Class<?>[] paramTypes, Object... args) {
        return invoke(this.methodAccess.getIndex(methodName, paramTypes), args);
    }

    public Object invoke(String methodName, Object... args) {
        Class<?>[] paramTypes = new Class<?>[args.length];
        for (int i = 0; i < args.length; i++) {
            paramTypes[i] = args[i].getClass();
        }
        return invoke(methodName, paramTypes, args);
    }

    public Object invoke0(String methodName, Object... args) {
        return invoke(this.methodAccess.getIndex(methodName, args == null ? 0 : args.length), args);
    }

    private Object invoke_(Serializable serializable, Class<?>[] paramTypes, Object... args) {
        return invoke(ColumnUtil.getSerializedLambda(serializable).getImplMethodName(), paramTypes, args);
    }

    private Object invoke_(Serializable serializable, Object... args) {
        return invoke(ColumnUtil.getSerializedLambda(serializable).getImplMethodName(), args);
    }

    private Object invoke0_(Serializable serializable, Object... args) {
        return invoke0(ColumnUtil.getSerializedLambda(serializable).getImplMethodName(), args);
    }

    //
    public <R> Object invoke0(F1<R> function, Object... args) {
        return invoke0_(function, args);
    }

    public <R> Object invoke(F1<R> function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public <R> Object invoke(F1<R> function, Object... args) {
        return invoke_(function, args);
    }

    public <P1> Object invoke0(F2<P1> function, Object... args) {
        return invoke0_(function, args);
    }

    public <P1> Object invoke(F2<P1> function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public <P1> Object invoke(F2<P1> function, Object... args) {
        return invoke_(function, args);
    }

    public Object invoke0(F3 function, Object... args) {
        return invoke0_(function, args);
    }

    public Object invoke(F3 function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public Object invoke(F3 function, Object... args) {
        return invoke_(function, args);
    }

    public <R, P1> Object invoke0(F4<R, P1> function, Object... args) {
        return invoke0_(function, args);
    }

    public <R, P1> Object invoke(F4<R, P1> function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public <R, P1> Object invoke(F4<R, P1> function, Object... args) {
        return invoke_(function, args);
    }

    public <R, P1, P2> Object invoke0(F5<R, P1, P2> function, Object... args) {
        return invoke0_(function, args);
    }

    public <R, P1, P2> Object invoke(F5<R, P1, P2> function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public <R, P1, P2> Object invoke(F5<R, P1, P2> function, Object... args) {
        return invoke_(function, args);
    }

    public <R, P1, P2, P3> Object invoke0(F6<R, P1, P2, P3> function, Object... args) {
        return invoke0_(function, args);
    }

    public <R, P1, P2, P3> Object invoke(F6<R, P1, P2, P3> function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public <R, P1, P2, P3> Object invoke(F6<R, P1, P2, P3> function, Object... args) {
        return invoke_(function, args);
    }

    public <P1, P2> Object invoke0(F7<P1, P2> function, Object... args) {
        return invoke0_(function, args);
    }

    public <P1, P2> Object invoke(F7<P1, P2> function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public <P1, P2> Object invoke(F7<P1, P2> function, Object... args) {
        return invoke_(function, args);
    }

    public <P1, P2, P3> Object invoke0(F8<P1, P2, P3> function, Object... args) {
        return invoke0_(function, args);
    }

    public <P1, P2, P3> Object invoke(F8<P1, P2, P3> function, Class<?>[] paramTypes, Object... args) {
        return invoke_(function, paramTypes, args);
    }

    public <P1, P2, P3> Object invoke(F8<P1, P2, P3> function, Object... args) {
        return invoke_(function, args);
    }


    public com.esotericsoftware.reflectasm.MethodAccess getMethodAccess() {
        return methodAccess;
    }

    public static com.esotericsoftware.reflectasm.MethodAccess getMethodAccess(Class<?> clazz) {
        com.esotericsoftware.reflectasm.MethodAccess methodAccess = METHOD_ACCESS_CACHE.get(clazz);
        if (null == methodAccess) {
            methodAccess = com.esotericsoftware.reflectasm.MethodAccess.get(clazz);
            METHOD_ACCESS_CACHE.put(clazz, methodAccess);
        }
        return methodAccess;
    }

    public interface F extends Serializable {

    }

    @FunctionalInterface
    public interface F1<R> extends F {
        R get();
    }

    @FunctionalInterface
    public interface F2<P1> extends F {
        void get(P1 obj);
    }

    @FunctionalInterface
    public interface F3 extends F {
        void get();
    }

    @FunctionalInterface
    public interface F4<R, P1> extends F {
        R get(P1 obj);
    }

    @FunctionalInterface
    public interface F5<R, P1, P2> extends F {
        R get(P1 p1, P2 p2);
    }

    @FunctionalInterface
    public interface F6<R, P1, P2, P3> extends F {
        R get(P1 p1, P2 p2, P3 p3);
    }


    @FunctionalInterface
    public interface F7<P1, P2> extends F {
        void get(P1 p1, P2 p2);
    }

    @FunctionalInterface
    public interface F8<P1, P2, P3> extends F {
        void get(P1 p1, P2 p2, P3 p3);
    }
}
