/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class ExecutorUtil {
    public static ExecutorService newSingleThreadExecutor(String namePrefix) {
        ThreadFactory threadFactory = ExecutorUtil.createThreadFactory(namePrefix);
        return ExecutorUtil.newSingleThreadExecutor(threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    public static ExecutorService newCacheThreadPool(String namePrefix) {
        ThreadFactory threadFactory = ExecutorUtil.createThreadFactory(namePrefix);
        return ExecutorUtil.newCacheThreadPool(threadFactory);
    }

    public static ExecutorService newCacheThreadPool(ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return Executors.newFixedThreadPool(corePoolSize, threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int corePoolSize, String namePrefix) {
        ThreadFactory threadFactory = ExecutorUtil.createThreadFactory(namePrefix);
        return ExecutorUtil.newFixedThreadPool(corePoolSize, threadFactory);
    }

    public static ScheduledExecutorService newSingleScheduled(ThreadFactory threadFactory) {
        return ExecutorUtil.newScheduled(1, threadFactory);
    }

    public static ScheduledExecutorService newSingleScheduled(String namePrefix) {
        ThreadFactory threadFactory = ExecutorUtil.createThreadFactory(namePrefix);
        return ExecutorUtil.newScheduled(1, threadFactory);
    }

    public static ScheduledExecutorService newScheduled(int corePoolSize, String namePrefix) {
        ThreadFactory threadFactory = ExecutorUtil.createThreadFactory(namePrefix);
        return ExecutorUtil.newScheduled(corePoolSize, threadFactory);
    }

    public static ScheduledExecutorService newScheduled(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    public static ThreadFactory createThreadFactory(String namePrefix) {
        return ExecutorUtil.createThreadFactory(namePrefix, true);
    }

    public static ThreadFactory createThreadFactory(String namePrefix, boolean daemon) {
        return ThreadFactoryBuilder.create().setNamePrefix(namePrefix).setDaemon(daemon).build();
    }
}

