package cn.godmao.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import org.objenesis.strategy.StdInstantiatorStrategy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class KryoUtil {

    static final int CAPACITY        = 8;
    static final int BUFFER_SIZE     = 256;
    static final int MAX_BUFFER_SIZE = 512;

    static final Pool<Kryo> kryoPool = new Pool<Kryo>(true, false, CAPACITY) {
        protected Kryo create() {
            final Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.setReferences(true);
            kryo.setInstantiatorStrategy(new DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
            return kryo;
        }
    };

    static final Pool<Output> outputPool = new Pool<Output>(true, false, CAPACITY) {
        protected Output create() {
            return new Output(BUFFER_SIZE, MAX_BUFFER_SIZE);
        }
    };

    static final Pool<Input> inputPool = new Pool<Input>(true, false, CAPACITY) {
        protected Input create() {
            return new Input(BUFFER_SIZE);
        }
    };


    public static <T> byte[] serialize(T obj) {
        Kryo kryo = kryoPool.obtain();
        Output output = outputPool.obtain();
        try (final ByteArrayOutputStream stream = new ByteArrayOutputStream()) {
            output.setOutputStream(stream);
            kryo.writeClassAndObject(output, obj);
            output.flush();
            return stream.toByteArray();
        } catch (IOException e) {
//            e.printStackTrace();
            return null;
        } finally {
            output.reset();
            kryoPool.free(kryo);
            outputPool.free(output);
        }
    }

    public static Object deserialize(byte[] data) {
        Kryo kryo = kryoPool.obtain();
        Input input = inputPool.obtain();
        try {
            input.setBuffer(data);
            return kryo.readClassAndObject(input);
        } catch (Exception e) {
//            e.printStackTrace();
            return null;
        } finally {
            input.reset();
            kryoPool.free(kryo);
            inputPool.free(input);
        }
    }

//    // ==============================================================
//    static final         int               BUFFER_SIZE     = 256;
//    static final         int               MAX_BUFFER_SIZE = 512;
//
//    static private final ThreadLocal<Kryo> kryoPool        = ThreadLocal.withInitial(() -> {
//        final Kryo kryo = new Kryo();
//        kryo.setRegistrationRequired(false);
//        kryo.setReferences(true);
//        kryo.setInstantiatorStrategy(new DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
//        return kryo;
//    });
//
//    static final ThreadLocal<Output> outputPool = ThreadLocal.withInitial(()-> new Output(BUFFER_SIZE, MAX_BUFFER_SIZE));
//    static final ThreadLocal<Input> inputPool = ThreadLocal.withInitial(()-> new Input(BUFFER_SIZE));
//
//
//    public static <T> byte[] serialize(T obj) {
//        Kryo kryo = kryoPool.get();
//        Output output = outputPool.get();
//        try (final ByteArrayOutputStream stream = new ByteArrayOutputStream()) {
//            output.setOutputStream(stream);
//            kryo.writeClassAndObject(output, obj);
//            output.flush();
//            return stream.toByteArray();
//        } catch (IOException e) {
//            throw new RuntimeException(e);
//        } finally {
//            output.reset();
//        }
//    }
//
//    public static Object deserialize(byte[] data) {
//        Kryo kryo = kryoPool.get();
//        Input input = inputPool.get();
//        try {
//            input.setBuffer(data);
//            return kryo.readClassAndObject(input);
//        } finally {
//            input.reset();
//        }
//    }

}
