/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils.common;

import cn.godmao.utils.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

public class SimpleHelper
extends ObjectUtil {
    public static String format(CharSequence template, Object ... params) {
        return StrUtil.format((CharSequence)template, (Object[])params);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        return StrUtil.format((CharSequence)template, map);
    }

    public static int parseInteger(Integer value) {
        return SimpleHelper.parseInteger(value, 0);
    }

    public static int parseInteger(Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static long parseLong(Long value) {
        return SimpleHelper.parseLong(value, 0L);
    }

    public static long parseLong(Long value, long defaultValue) {
        return Objects.isNull(value) ? defaultValue : value;
    }

    public static boolean parseBoolean(Boolean value) {
        return SimpleHelper.parseBoolean(value, false);
    }

    public static boolean parseBoolean(Boolean value, boolean defaultValue) {
        return Objects.isNull(value) ? defaultValue : value;
    }

    public static Integer parseInteger(Object value) {
        if (ObjectUtil.isEmpty(value)) {
            return 0;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof String) {
            if ("".equals(value)) {
                return 0;
            }
            try {
                return Integer.parseInt(((String)value).trim());
            }
            catch (Exception ex) {
                return 0;
            }
        }
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        try {
            throw new Exception("has parseInt Error!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Long parseLong(Object value) {
        if (ObjectUtil.isEmpty(value)) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return 0L;
    }

    public static Double parseDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        return 0.0;
    }

    public static Boolean parseBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof Long) {
            return (Long)value != 0L;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }
}

