/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoUtil {
    static final int CAPACITY = 8;
    static final int BUFFER_SIZE = 256;
    static final int MAX_BUFFER_SIZE = 512;
    static final Pool<Kryo> kryoPool = new Pool<Kryo>(true, false, 8){

        protected Kryo create() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.setReferences(true);
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            return kryo;
        }
    };
    static final Pool<Output> outputPool = new Pool<Output>(true, false, 8){

        protected Output create() {
            return new Output(256, 512);
        }
    };
    static final Pool<Input> inputPool = new Pool<Input>(true, false, 8){

        protected Input create() {
            return new Input(256);
        }
    };

    public static <T> byte[] serialize(T obj) {
        Kryo kryo = (Kryo)kryoPool.obtain();
        Output output = (Output)outputPool.obtain();
        try {
            byte[] byArray;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                output.setOutputStream((OutputStream)stream);
                kryo.writeClassAndObject(output, obj);
                output.flush();
                byArray = stream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
            return byArray;
        }
        finally {
            output.reset();
            kryoPool.free((Object)kryo);
            outputPool.free((Object)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] data) {
        Kryo kryo = (Kryo)kryoPool.obtain();
        Input input = (Input)inputPool.obtain();
        try {
            input.setBuffer(data);
            Object object = kryo.readClassAndObject(input);
            return object;
        }
        finally {
            input.reset();
            kryoPool.free((Object)kryo);
            inputPool.free((Object)input);
        }
    }
}

