/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import cn.godmao.utils.ObjectUtil;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends cn.hutool.core.date.DateUtil {
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private static final ZoneOffset DEFAULT_ZONE_OFFSET = DEFAULT_ZONE_ID.getRules().getOffset(Instant.now());
    private static final Map<String, DateTimeFormatter> DATE_TIME_FORMATTER_MAP = new HashMap<String, DateTimeFormatter>();
    public static final String DATE_PATTERN1 = "yyyy-MM-dd";
    public static final String DATE_PATTERN2 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_PATTERN3 = "yyyy/MM/dd HH:mm";
    public static final String DATE_PATTERN4 = "yyyyMMdd";
    public static final String DATE_PATTERN5 = "yyyy/MM/dd";
    public static final String DATE_PATTERN6 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_PATTERN7 = "yyyy-MM-dd HH:mm";
    public static final String DATE_PATTERN8 = "yyyy/MM/dd/HH/mm/ss";
    public static final String DATE_PATTERN9 = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String DATE_PATTERN10 = "yyyy_MM_dd";
    public static final String DATE_PATTERN11 = "yyyy-MM";

    private static DateTimeFormatter getFormatter(String pattern) {
        return DATE_TIME_FORMATTER_MAP.getOrDefault(pattern, DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(Date date, String pattern) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        ObjectUtil.hasText(pattern, "PATTERN: [" + pattern + "] \u53c2\u6570\u975e\u6cd5");
        return DateUtil.formatLocalDateTime(DateUtil.toLocalDateTime(date), pattern);
    }

    public static String formartLocalDate(LocalDate localDate, String pattern) {
        ObjectUtil.notNull(localDate, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        ObjectUtil.hasText(pattern, "PATTERN: [" + pattern + "] \u53c2\u6570\u975e\u6cd5");
        return DateUtil.formatLocalDateTime(DateUtil.toLocalDateTime(localDate), pattern);
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, String pattern) {
        ObjectUtil.notNull(localDateTime, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        ObjectUtil.hasText(pattern, "PATTERN: [" + pattern + "] \u53c2\u6570\u975e\u6cd5");
        return localDateTime.format(DateUtil.getFormatter(pattern));
    }

    public static Date toDate(String str, String pattern) {
        ObjectUtil.hasText(str, "STR: [" + str + "] \u53c2\u6570\u975e\u6cd5");
        ObjectUtil.hasText(pattern, "PATTERN: [" + pattern + "] \u53c2\u6570\u975e\u6cd5");
        return DateUtil.toDate(LocalDateTime.parse(str, DateUtil.getFormatter(pattern)));
    }

    public static Date toDate(LocalDate localDate) {
        ObjectUtil.notNull(localDate, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return Date.from(localDate.atStartOfDay(DEFAULT_ZONE_ID).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        ObjectUtil.notNull(localDateTime, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return Date.from(localDateTime.atZone(DEFAULT_ZONE_ID).toInstant());
    }

    public static LocalDate toLocalDate(String str) {
        ObjectUtil.hasText(str, "STR: [" + str + "] \u53c2\u6570\u975e\u6cd5");
        return DateUtil.toLocalDate(str, DATE_PATTERN1);
    }

    public static LocalDate toLocalDate(String str, String pattern) {
        ObjectUtil.hasText(str, "STR: [" + str + "] \u53c2\u6570\u975e\u6cd5");
        ObjectUtil.hasText(pattern, "PATTERN: [" + pattern + "] \u53c2\u6570\u975e\u6cd5");
        return LocalDate.parse(str, DateUtil.getFormatter(pattern));
    }

    public static LocalDate toLocalDate(Date date) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toZonedDateTime(date).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(String str) {
        ObjectUtil.hasText(str, "STR: [" + str + "] \u53c2\u6570\u975e\u6cd5");
        return DateUtil.toLocalDateTime(str, DATE_PATTERN2);
    }

    public static LocalDateTime toLocalDateTime(String str, String pattern) {
        ObjectUtil.hasText(str, "STR: [" + str + "] \u53c2\u6570\u975e\u6cd5");
        ObjectUtil.hasText(pattern, "PATTERN: [" + pattern + "] \u53c2\u6570\u975e\u6cd5");
        return LocalDateTime.parse(str, DateUtil.getFormatter(pattern));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toZonedDateTime(date).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate) {
        ObjectUtil.notNull(localDate, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return localDate.atStartOfDay();
    }

    public static Date addDateSeconds(Date date, int seconds) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusSeconds(seconds));
    }

    public static Date addDateMinutes(Date date, int minutes) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusMinutes(minutes));
    }

    public static Date addDateHours(Date date, int hours) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusHours(hours));
    }

    public static Date addDateDays(Date date, int days) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusDays(days));
    }

    public static Date addDateWeeks(Date date, int weeks) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusWeeks(weeks));
    }

    public static Date addDateMonths(Date date, int months) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusMonths(months));
    }

    public static Date addDateYears(Date date, int years) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.toDate(DateUtil.toLocalDateTime(date).plusYears(years));
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        ObjectUtil.notNull(date, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return date.toInstant().atZone(DEFAULT_ZONE_ID);
    }

    public static LocalDateTime fromSeconds(long seconds) {
        return LocalDateTime.ofEpochSecond(seconds, 0, DEFAULT_ZONE_OFFSET);
    }

    public static LocalDateTime fromMillSeconds(long millSeconds) {
        Instant instant = Instant.ofEpochMilli(millSeconds);
        return LocalDateTime.ofInstant(instant, DEFAULT_ZONE_ID);
    }

    public static long getSeconds(LocalDateTime localDateTime) {
        ObjectUtil.notNull(localDateTime, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return DateUtil.getMillSeconds(localDateTime) / 1000L;
    }

    public static long getMillSeconds(LocalDateTime localDateTime) {
        ObjectUtil.notNull(localDateTime, "\u4f20\u5165\u7684\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a [null]");
        return localDateTime.toInstant(DEFAULT_ZONE_OFFSET).toEpochMilli();
    }

    public static String[] getPatterns() {
        try {
            if (ObjectUtil.isNotEmpty(DATE_TIME_FORMATTER_MAP)) {
                return (String[])DATE_TIME_FORMATTER_MAP.keySet().stream().toArray(String[]::new);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate(Object str) {
        try {
            if (str instanceof Long) {
                return new Date((Long)str);
            }
            if (str instanceof Integer) {
                return new Date(Long.parseLong(str.toString()));
            }
            if (str instanceof String) {
                ObjectUtil.hasText((String)str, "PATTERN: [" + str + "] \u53c2\u6570\u975e\u6cd5");
                String[] patterns = DateUtil.getPatterns();
                if (ObjectUtil.isEmpty(patterns)) {
                    return null;
                }
                return DateUtils.parseDate((String)((String)str), (String[])patterns);
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date lastMonday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        calendar.set(7, 2);
        return DateUtils.truncate((Date)calendar.getTime(), (int)5);
    }

    public static Date monday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        return DateUtils.truncate((Date)calendar.getTime(), (int)5);
    }

    public static Date weekStart(Integer plusWeeks) {
        LocalDate monday = LocalDate.now().with(DayOfWeek.MONDAY);
        monday = monday.plusWeeks(plusWeeks.intValue());
        long endtime = monday.atStartOfDay().toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        Date date = new Date();
        date.setTime(endtime);
        return date;
    }

    public static Date weekEnd(Integer plusWeeks) {
        LocalDate sunday = LocalDate.now().with(DayOfWeek.SUNDAY);
        sunday = sunday.plusWeeks(plusWeeks.intValue());
        long endtime = LocalDateTime.of(sunday.getYear(), sunday.getMonth(), sunday.getDayOfMonth(), 23, 59, 59, 999999999).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        Date date = new Date();
        date.setTime(endtime);
        return date;
    }

    public static Date lastYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        calendar.set(6, 1);
        return DateUtils.truncate((Date)calendar.getTime(), (int)5);
    }

    public static Date year() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, 1);
        return DateUtils.truncate((Date)calendar.getTime(), (int)5);
    }

    public static Date designatedDate(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, day);
        return DateUtils.truncate((Date)calendar.getTime(), (int)5);
    }

    public static int dateDelta(Date date) {
        Calendar calendar = Calendar.getInstance();
        long delta = calendar.getTime().getTime() - date.getTime();
        return (int)delta;
    }

    public static List<String> completionDate(LocalDateTime startDate, LocalDateTime endDate) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_PATTERN1);
        ArrayList<String> dateList = new ArrayList<String>();
        int i = 0;
        while (!Duration.between(startDate.plusDays(i), endDate).isNegative()) {
            dateList.add(startDate.plusDays(i).format(dateTimeFormatter));
            ++i;
        }
        return dateList;
    }

    public static boolean isToday(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long today = calendar.getTimeInMillis();
        return time - today < 86400000L && time - today > 0L;
    }

    static {
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN1, DateTimeFormatter.ofPattern(DATE_PATTERN1));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN2, DateTimeFormatter.ofPattern(DATE_PATTERN2));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN3, DateTimeFormatter.ofPattern(DATE_PATTERN3));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN4, DateTimeFormatter.ofPattern(DATE_PATTERN4));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN5, DateTimeFormatter.ofPattern(DATE_PATTERN5));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN6, DateTimeFormatter.ofPattern(DATE_PATTERN6));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN7, DateTimeFormatter.ofPattern(DATE_PATTERN7));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN8, DateTimeFormatter.ofPattern(DATE_PATTERN8));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN9, DateTimeFormatter.ofPattern(DATE_PATTERN9));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN10, DateTimeFormatter.ofPattern(DATE_PATTERN10));
        DATE_TIME_FORMATTER_MAP.put(DATE_PATTERN11, DateTimeFormatter.ofPattern(DATE_PATTERN11));
    }
}

