/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ColumnUtil {
    static String defaultSplit = "";
    static Integer defaultToType = 0;
    static Map<CFunction<?, ?>, String> fieldNameCache = new ConcurrentHashMap();
    static Map<Class<?>, SerializedLambda> CLASS_LAMDBA_CACHE = new ConcurrentHashMap();

    public static <T> String getFieldName(CFunction<T, ?> fn) {
        String fieldName = fieldNameCache.get(fn);
        if (null == fieldName) {
            fieldName = ColumnUtil.getFieldName(fn, defaultSplit);
            fieldNameCache.putIfAbsent(fn, fieldName);
        }
        return fieldName;
    }

    private static <T> String getFieldName(CFunction<T, ?> fn, String split) {
        return ColumnUtil.getFieldName(fn, split, defaultToType);
    }

    private static <T> String getFieldName(CFunction<T, ?> fn, String split, Integer toType) {
        Field field;
        SerializedLambda serializedLambda = ColumnUtil.getSerializedLambda(fn);
        String fieldName = null;
        String implMethodName = serializedLambda.getImplMethodName();
        String implMethodNamePame = null;
        if (implMethodName.contains("get")) {
            implMethodNamePame = "get";
        } else if (implMethodName.contains("is")) {
            implMethodNamePame = "is";
        }
        fieldName = implMethodName.substring(implMethodNamePame.length());
        fieldName = fieldName.replaceFirst("" + fieldName.charAt(0), ("" + fieldName.charAt(0)).toLowerCase());
        try {
            field = Class.forName(serializedLambda.getImplClass().replace("/", ".")).getDeclaredField(fieldName);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        TableField tableField = field.getAnnotation(TableField.class);
        if (tableField != null && tableField.value().length() > 0) {
            return tableField.value();
        }
        switch (toType) {
            case 1: {
                return fieldName.replaceAll("[A-Z]", split + "$0").toUpperCase();
            }
            case 2: {
                return fieldName.replaceAll("[A-Z]", split + "$0").toLowerCase();
            }
        }
        return fieldName.replaceAll("[A-Z]", split + "$0");
    }

    public static <T> SerializedLambda getSerializedLambda(Serializable fn) {
        SerializedLambda serializedLambda = CLASS_LAMDBA_CACHE.get(fn.getClass());
        if (null == serializedLambda) {
            Method write = null;
            try {
                write = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            write.setAccessible(Boolean.TRUE);
            try {
                serializedLambda = (SerializedLambda)write.invoke((Object)fn, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            CLASS_LAMDBA_CACHE.putIfAbsent(fn.getClass(), serializedLambda);
        }
        return serializedLambda;
    }

    public static boolean hasField(Class c, String fieldName) {
        Field[] fields;
        for (Field f : fields = c.getDeclaredFields()) {
            if (!fieldName.equals(f.getName())) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface CFunction<T, R>
    extends Function<T, R>,
    Serializable {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TableField {
        public String value() default "";
    }
}

