/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.utils;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtil
extends cn.hutool.core.util.ClassUtil {
    private static final Map<Class<?>, ConstructorAccess<?>> classAccessMap = new ConcurrentHashMap();
    private static final Map<String, Class<?>> forNameClassMap = new ConcurrentHashMap();

    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> class_ = forNameClassMap.get(className);
        if (null == class_) {
            class_ = Class.forName(className);
            forNameClassMap.putIfAbsent(className, class_);
        }
        return class_;
    }

    public static <T> ConstructorAccess<T> getConstructorAccess(Class<T> clazz) {
        ConstructorAccess classRefInfo = classAccessMap.get(clazz);
        if (null == classRefInfo) {
            classRefInfo = ConstructorAccess.get(clazz);
            classAccessMap.putIfAbsent(clazz, classRefInfo);
        }
        return classRefInfo;
    }

    public static <T> T instance(Class<T> cClass) {
        return (T)ClassUtil.getConstructorAccess(cClass).newInstance();
    }

    public static <T> T instance(Class<T> cClass, Object ... initargs) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class[] parameterTypes = new Class[initargs.length];
        for (int i = 0; i < initargs.length; ++i) {
            parameterTypes[i] = initargs[i].getClass();
        }
        return ClassUtil.instance(cClass, parameterTypes, initargs);
    }

    public static <T> T instance(Class<T> cClass, Class<?>[] parameterTypes, Object ... initargs) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return cClass.getDeclaredConstructor(parameterTypes).newInstance(initargs);
    }

    public static Class<?> find0(Object object, Class<?> parametrizedSuperclass, String typeParamName) {
        Class<?> thisClass;
        Class<?> currentClass = thisClass = object.getClass();
        while (true) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = -1;
                TypeVariable<Class<?>>[] typeParams = currentClass.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParamName.equals(typeParams[i].getName())) continue;
                    typeParamIndex = i;
                    break;
                }
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + parametrizedSuperclass);
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    return (Class)actualTypeParam;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    TypeVariable v = (TypeVariable)actualTypeParam;
                    if (!(v.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    currentClass = thisClass;
                    parametrizedSuperclass = (Class)v.getGenericDeclaration();
                    typeParamName = v.getName();
                    if (parametrizedSuperclass.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                return ClassUtil.fail(thisClass, typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        return ClassUtil.fail(thisClass, typeParamName);
    }

    private static Class<?> fail(Class<?> type, String typeParamName) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + typeParamName + "': " + type);
    }

    public static List<Method> getMethods(Method[] methods, int ... exclusionModifiers) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            boolean exist = false;
            for (int exclusionModifier : exclusionModifiers) {
                if (exclusionModifier != modifiers) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            methodList.add(method);
        }
        return methodList;
    }
}

