/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.shell;

import cn.godmao.executor.DefaultExecutorService;
import cn.godmao.shell.annotation.Shell;
import cn.godmao.shell.annotation.ShellController;
import cn.godmao.utils.ClassUtil;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ObjectUtil;
import cn.godmao.utils.clazz.MethodAccess;
import cn.hutool.core.lang.ClassScanner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import org.fusesource.jansi.Ansi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class JavaShell {
    private String format_content_heard = Ansi.ansi().eraseScreen().render("@|MAGENTA \t%s      \t%s                    \t%s \n|@").toString();
    private String format_content = Ansi.ansi().eraseScreen().render("@|BLUE \t%s      \t%s                    \t%s \n|@").toString();
    private String format_frame = Ansi.ansi().eraseScreen().render("@|CYAN =====================================%s============================================ \n|@").toString();
    private Class<?> mainClass;
    private Scanner scanner;
    private Formatter formatter;
    private String currentPath;
    private DefaultExecutorService executorService;
    private Map<String, ShellAccess> depository = new HashMap<String, ShellAccess>();
    private Collection<Object> beans;
    @Autowired
    private ApplicationContext applicationContext;

    public JavaShell(Class<?> mainClass) {
        this.beans = new ArrayList<Object>();
        this.mainClass = mainClass;
        this.currentPath = null;
        ClassScanner classScanner = new ClassScanner(this.mainClass.getPackage().getName(), clazz -> Objects.nonNull(AnnotationUtils.findAnnotation((Class)clazz, ShellController.class)));
        for (Class clazz2 : classScanner.scan()) {
            ShellController controller = (ShellController)AnnotationUtils.findAnnotation((Class)clazz2, ShellController.class);
            if (null == controller) continue;
            this.beans.add(ClassUtil.getConstructorAccess((Class)clazz2).newInstance());
        }
    }

    public JavaShell(Object ... beanArr) {
        this.beans = new ArrayList<Object>();
        this.currentPath = null;
        this.beans.addAll(CollectUtil.listOf((Object[])beanArr));
    }

    public JavaShell() {
        if (null == this.applicationContext) {
            throw new RuntimeException("\u5f53\u524d\u975espring\u542f\u52a8! \u8bf7\u4f7f\u7528 new JavaShell(Class<?> mainClass)");
        }
        this.beans = this.applicationContext.getBeansWithAnnotation(ShellController.class).values();
        this.currentPath = null;
        this.start();
    }

    public synchronized void start() {
        String colorStr = "@|BLACK BLACK|@ @|RED RED|@ @|GREEN GREEN|@ @|YELLOW YELLOW|@ @|BLUE BLUE|@ @|MAGENTA MAGENTA|@ @|CYAN CYAN|@ @|WHITE WHITE|@ @|DEFAULT DEFAULT|@";
        System.out.println(Ansi.ansi().eraseScreen().render(colorStr));
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        this.formatter = new Formatter(System.out);
        this.scanner = new Scanner(System.in);
        this.executorService = new DefaultExecutorService();
        for (Object bean : this.beans) {
            ShellController controller = (ShellController)AnnotationUtils.findAnnotation(bean.getClass(), ShellController.class);
            if (null == controller) continue;
            this.depository.put(controller.value(), new ShellAccess(bean));
        }
        this.menu();
    }

    private void menu() {
        if (!this.depository.containsKey(this.currentPath)) {
            this.menu_main();
        } else {
            this.menu_sub();
        }
        this.doRun();
    }

    private void menu_main() {
        this.formatter.format(this.format_frame, null == this.currentPath ? "\u9996\u9875" : this.currentPath);
        this.formatter.format(this.format_content_heard, "title", "path", "method");
        for (String key : this.depository.keySet()) {
            ShellAccess shellAccess = this.depository.get(key);
            ShellController controller = shellAccess.getController();
            ArrayList<ShellInfo> shells = shellAccess.getShells();
            HashSet<String> methods = new HashSet<String>();
            for (ShellInfo shellInfo : shells) {
                Shell shell = shellInfo.getShell();
                if (ObjectUtil.isEmpty((Object)shell.title())) {
                    methods.addAll(shellInfo.getKeys());
                    continue;
                }
                methods.add(shell.title());
            }
            String title = ObjectUtil.isEmpty((Object)controller.title()) ? key : controller.title();
            String path = controller.value();
            this.formatter.format(this.format_content, title, path, methods);
        }
        this.formatter.format(this.format_frame, null == this.currentPath ? "\u9996\u9875" : this.currentPath);
    }

    private void menu_sub() {
        this.formatter.format(this.format_frame, this.currentPath);
        this.formatter.format(this.format_content_heard, "title", "path", "param");
        ShellAccess shellAccess = this.depository.get(this.currentPath);
        for (ShellInfo shellInfo : shellAccess.getShells()) {
            Shell shell = shellInfo.getShell();
            String methodName = shellInfo.getMethodName();
            String title = ObjectUtil.isNotEmpty((Object)shell.title()) ? shell.title() : methodName;
            Set<String> keys = shellInfo.getKeys();
            List parameterTypeNames = CollectUtil.getArr((Collection)CollectUtil.listOf((Object[])shellInfo.getParameterTypes()), Class::getSimpleName);
            this.formatter.format(this.format_content, title, keys, parameterTypeNames);
        }
        this.formatter.format(this.format_frame, this.currentPath);
    }

    private void doRun() {
        this.executorService.execute((Object)this.currentPath, () -> {
            System.err.print("\n: ");
            String nextLine = this.scanner.nextLine();
            String[] parms = nextLine.split(" ");
            String parm = parms[0];
            if ("cd".equals(parm)) {
                String path = parms.length > 1 ? parms[1] : null;
                this.currentPath = this.depository.containsKey(path) ? path : null;
                this.menu();
            } else if ("home".equals(parm)) {
                this.menu();
            } else if (null == this.currentPath && this.depository.containsKey(parm)) {
                this.currentPath = parm;
                this.menu();
            } else if (parm.length() > 0) {
                this.doShell(parm, Arrays.copyOfRange(parms, 1, parms.length));
            }
            this.doRun();
        });
    }

    private void doShell(String key, String ... obj) {
        ShellAccess shellAccess = this.depository.get(this.currentPath);
        if (null == shellAccess) {
            return;
        }
        ArrayList<ShellInfo> shells = shellAccess.getShells();
        for (ShellInfo shellInfo : shells) {
            if (!shellInfo.getKeys().contains(key)) continue;
            this.invoke(shellAccess, shellInfo, obj);
        }
    }

    private void invoke(ShellAccess shellAccess, ShellInfo shellInfo, String ... obj) {
        Object[] objects = new Object[obj.length];
        Class<?>[] parameterTypes = shellInfo.getParameterTypes();
        Object result = shellAccess.invoke(shellInfo.getIndex(), obj);
        if (!shellInfo.getMethod().getReturnType().equals(Void.TYPE)) {
            if (null == result) {
                result = "\u7a7a";
            }
            String pri = String.format("@| %s |@", result);
            System.out.println(Ansi.ansi().eraseScreen().render(pri));
        }
    }

    private static class ShellAccess
    extends MethodAccess {
        private final Object bean;
        private final ShellController controller;
        private final ArrayList<ShellInfo> shells;

        public ShellAccess(Object bean) {
            super(bean);
            this.bean = bean;
            this.shells = new ArrayList();
            this.controller = (ShellController)AnnotationUtils.findAnnotation(bean.getClass(), ShellController.class);
            List methods = ClassUtil.getMethods((Method[])ClassUtil.getDeclaredMethods(bean.getClass()), (int[])new int[]{2});
            for (Method method : methods) {
                Shell shell = (Shell)AnnotationUtils.findAnnotation((Method)method, Shell.class);
                if (null == shell) continue;
                String[] values = shell.value();
                String methodName = method.getName();
                Class[] parameterTypes = method.getParameterTypes();
                int index = this.getMethodAccess().getIndex(methodName, parameterTypes);
                ShellInfo shellInfo = new ShellInfo(shell, method, index);
                this.shells.add(shellInfo);
            }
        }

        public ShellController getController() {
            return this.controller;
        }

        public ArrayList<ShellInfo> getShells() {
            return this.shells;
        }

        public Object getBean() {
            return this.bean;
        }
    }

    private static class ShellInfo {
        private Shell shell;
        private Set<String> keys;
        private String methodName;
        private String[] params;
        private Class<?>[] parameterTypes;
        private Integer index;
        private Method method;

        public ShellInfo(Shell shell, Method method, Integer index) {
            this.method = method;
            this.shell = shell;
            this.methodName = method.getName();
            this.params = null;
            this.parameterTypes = method.getParameterTypes();
            this.index = index;
            this.keys = CollectUtil.setOf((Object[])shell.value());
        }

        public Shell getShell() {
            return this.shell;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String[] getParams() {
            return this.params;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

