/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.poker.guandan;

import cn.godmao.common.IFunction;
import cn.godmao.poker.IPokerType;
import cn.godmao.poker.IPokers;
import cn.godmao.poker.Poker;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.MathUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GuandanUtil {
    public static final int CARDTYPE_ILLEGALCARD = -1;
    public static final int CARDTYPE_NOCARD = 0;
    public static final int CARDTYPE_SINGLECARD = 1;
    public static final int CARDTYPE_DOUBLECARD = 2;
    public static final int CARDTYPE_DOUBLECARDLINETHREE = 3;
    public static final int CARDTYPE_THREECARD = 4;
    public static final int CARDTYPE_THREECARDTWO = 5;
    public static final int CARDTYPE_THREECARDLINE = 6;
    public static final int CARDTYPE_SINGLELINE = 7;
    public static final int CARDTYPE_SINGLELINESAMECOLOR = 8;
    public static final int CARDTYPE_BOMBCARD = 9;
    public static final int CARDTYPE_BOMBCARDKING = 10;
    public static List<List<Poker>> initShunziTonghua;
    public static LinkedHashMap<Set<Integer>, List<Poker>> initShunzi;
    public static LinkedHashMap<Set<Integer>, List<Poker>> initGangban;
    public static LinkedHashMap<Set<Integer>, List<Poker>> initLiandui;
    public static Map<Integer, List<List<Poker>>> initLaiZi_1;
    public static Map<Integer, List<List<Poker>>> initLaiZi_2;
    public static final List<Integer> arrlist;
    public static final int maxNum = 100;
    private static final ArrayList defaultList;
    private static final HashMap<?, ?> defaultMap;

    public static void main(String[] args) {
        List<Poker> pokers = new ArrayList<Poker>();
        pokers.add(Poker.\u5927\u738b);
        pokers.add(Poker.\u5c0f\u738b);
        pokers.add(Poker.\u6885\u82b1J);
        pokers.add(Poker.\u65b9\u5757A);
        pokers.add(Poker.\u65b9\u5757Q);
        pokers.add(Poker.\u6885\u82b18);
        pokers.add(Poker.\u6885\u82b18);
        pokers.add(Poker.\u65b9\u57578);
        pokers.add(Poker.\u9ed1\u68438);
        pokers.add(Poker.\u7ea2\u68437);
        pokers.add(Poker.\u9ed1\u68437);
        pokers.add(Poker.\u9ed1\u68436);
        pokers.add(Poker.\u65b9\u57575);
        pokers.add(Poker.\u6885\u82b15);
        pokers.add(Poker.\u65b9\u57574);
        pokers.add(Poker.\u65b9\u57573);
        pokers.add(Poker.\u65b9\u57572);
        pokers = GuandanUtil.newList(pokers);
        GuandanPokersWeight guandanPokersWeight = GuandanUtil.arrangePoker(pokers, 4);
        System.out.println(1);
    }

    public static List<Poker> newList(List<Poker> cards) {
        List<Poker> copy = GuandanUtil.copy(cards);
        for (int x = 0; x < copy.size(); ++x) {
            copy.get(x).setNumber(x);
        }
        return copy;
    }

    public static List<Poker> deal(List<Poker> myHandCards, List<Poker> pokerList, LinkedHashMap<Integer, Integer> typeNums, int laiziValue) {
        ArrayList<Poker> result = new ArrayList<Poker>();
        Set values = CollectUtil.getSet(myHandCards, Poker::getValue);
        ArrayList<Poker> chongfu_not = new ArrayList<Poker>();
        for (Poker poker : pokerList) {
            if (values.contains(poker.getValue())) continue;
            chongfu_not.add(poker);
        }
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(chongfu_not, laiziValue);
        List<Poker> cards = laiZiOrNot.get(2);
        List<Poker> king = laiZiOrNot.get(3);
        block13: for (Integer type : typeNums.keySet()) {
            Integer num = typeNums.get(type);
            if (num < 1) continue;
            block0 : switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(cards);
                    ArrayList<List<Poker>> duizis = new ArrayList<List<Poker>>(pokerMapByValue.values());
                    Collections.shuffle(duizis);
                    for (List list : duizis) {
                        if (list.size() < 2) continue;
                        if (num < 1) break block0;
                        Integer n = num;
                        num = num - 1;
                        ArrayList<Poker> newduizi = new ArrayList<Poker>(list.subList(0, 2));
                        GuandanUtil.deletePoker(cards, newduizi, (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        result.addAll(newduizi);
                    }
                    continue block13;
                }
                case 3: {
                    break;
                }
                case 4: {
                    Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(cards);
                    ArrayList<List<Poker>> sangetous = new ArrayList<List<Poker>>(pokerMapByValue.values());
                    Collections.shuffle(sangetous);
                    for (List sangetou : sangetous) {
                        if (sangetou.size() < 3) continue;
                        if (num < 1) break block0;
                        Integer n = num;
                        num = num - 1;
                        ArrayList newSangetou = new ArrayList(sangetou.subList(0, 3));
                        GuandanUtil.deletePoker(cards, newSangetou, (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        result.addAll(newSangetou);
                    }
                    continue block13;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    Map<Integer, List<Poker>> map = GuandanUtil.getPokerMapByColor(cards);
                    map.remove(Poker.Color.KING.getType());
                    ArrayList<List<Poker>> sameColors = new ArrayList<List<Poker>>(map.values());
                    Collections.shuffle(sameColors);
                    for (List list : sameColors) {
                        if (num < 1) break block0;
                        List<List<Poker>> list2 = GuandanUtil.optimalSingleLine(list, laiziValue);
                        if (list2.isEmpty()) continue;
                        Collections.shuffle(list2);
                        List<List<Poker>> sameColorShunzu_ = list2.subList(0, Math.min(list2.size(), num));
                        num = num - sameColorShunzu_.size();
                        List<Poker> pokers = GuandanUtil.mergeTogher(sameColorShunzu_);
                        GuandanUtil.deletePoker(cards, pokers, (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        result.addAll(pokers);
                    }
                    continue block13;
                }
                case 9: {
                    Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(cards);
                    ArrayList<List<Poker>> booms = new ArrayList<List<Poker>>(pokerMapByValue.values());
                    Collections.shuffle(booms);
                    for (List list : booms) {
                        if (list.size() < 4) continue;
                        if (num < 1) break block0;
                        Integer n = num;
                        num = num - 1;
                        GuandanUtil.deletePoker(cards, list, (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        result.addAll(list);
                    }
                    continue block13;
                }
                case 10: {
                    if (null == king || king.isEmpty() || num < 1) break;
                    result.addAll(king);
                    laiZiOrNot.remove(3);
                    GuandanUtil.deletePoker(cards, king, (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                    king = null;
                }
            }
        }
        return result;
    }

    public static List<List<Poker>> optimalSingleSameColor(List<Poker> cards, int laiziValue) {
        return GuandanUtil.optimalSingleLine(cards, laiziValue, true);
    }

    public static List<List<Poker>> optimalSingleLineSameColor(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = GuandanUtil.copy(cards);
        ArrayList<List<Poker>> result = new ArrayList<List<Poker>>();
        if (cards_copy.size() < 5) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards_copy, laiziValue);
        List laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        HashSet<Integer> hashcode = new HashSet<Integer>();
        ArrayList<List<Poker>> tonghuashun = new ArrayList<List<Poker>>();
        Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByColor(laiZiNot);
        for (Integer key_ : pokerMapByValue.keySet()) {
            List values = pokerMapByValue.get(key_);
            values = CollectUtil.distinct(values, Poker::getValue);
            values.sort(Comparator.comparingInt(Poker::getValue));
            for (int i = 0; i < values.size() && values.size() - i >= 5 - laiZi.size(); ++i) {
                List<Poker> new_shunzi1;
                int hash;
                Poker poker1 = (Poker)values.get(i);
                Poker poker2 = (Poker)values.get(i + 1);
                Poker poker3 = (Poker)values.get(i + 2);
                Poker poker4 = null;
                if (values.size() > i + 3) {
                    poker4 = (Poker)values.get(i + 3);
                }
                Poker poker5 = null;
                if (values.size() > i + 4) {
                    poker5 = (Poker)values.get(i + 4);
                }
                ArrayList<Poker> shunzi1 = new ArrayList<Poker>();
                shunzi1.add(GuandanUtil.copy(poker1));
                shunzi1.add(GuandanUtil.copy(poker2));
                shunzi1.add(GuandanUtil.copy(poker3));
                List<Poker> shunzi = GuandanUtil.getShunzi(shunzi1, Math.min(5 - shunzi1.size(), laiZi.size()));
                if (!shunzi.isEmpty() && !hashcode.contains(hash = Objects.hash(key_, GuandanUtil.hashCode_value(shunzi)))) {
                    new_shunzi1 = GuandanUtil.copy(shunzi1);
                    new_shunzi1.addAll(GuandanUtil.copy(laiZi.subList(0, 5 - shunzi1.size())));
                    tonghuashun.add(new_shunzi1);
                    hashcode.add(hash);
                }
                if (null != poker4) {
                    shunzi1.add(GuandanUtil.copy(poker4));
                }
                if (!(shunzi = GuandanUtil.getShunzi(shunzi1, Math.min(5 - shunzi1.size(), laiZi.size()))).isEmpty() && !hashcode.contains(hash = Objects.hash(key_, GuandanUtil.hashCode_value(shunzi)))) {
                    new_shunzi1 = GuandanUtil.copy(shunzi1);
                    new_shunzi1.addAll(GuandanUtil.copy(laiZi.subList(0, 5 - shunzi1.size())));
                    tonghuashun.add(new_shunzi1);
                    hashcode.add(hash);
                }
                if (null != poker5) {
                    shunzi1.add(GuandanUtil.copy(poker5));
                }
                if ((shunzi = GuandanUtil.getShunzi(shunzi1, Math.min(5 - shunzi1.size(), laiZi.size()))).isEmpty() || hashcode.contains(hash = Objects.hash(key_, GuandanUtil.hashCode_value(shunzi)))) continue;
                new_shunzi1 = GuandanUtil.copy(shunzi1);
                new_shunzi1.addAll(GuandanUtil.copy(laiZi.subList(0, 5 - shunzi1.size())));
                tonghuashun.add(new_shunzi1);
                hashcode.add(hash);
            }
        }
        return tonghuashun;
    }

    public static void init() {
    }

    private static List<List<Poker>> getBomKing(List<Poker> cards) {
        ArrayList<List<Poker>> result = new ArrayList<List<Poker>>();
        if (null == cards || cards.size() < 4) {
            return result;
        }
        ArrayList<Poker> da = null;
        ArrayList<Poker> xiao = null;
        for (Poker card : cards) {
            if (!card.getColor().equals(Poker.Color.KING.getType())) continue;
            if (card.getValue().equals(100)) {
                if (null == da) {
                    da = new ArrayList<Poker>();
                }
                da.add(card);
                continue;
            }
            if (!card.getValue().equals(99)) continue;
            if (null == xiao) {
                xiao = new ArrayList<Poker>();
            }
            xiao.add(card);
        }
        if (null != da && null != xiao && da.size() > 1 && xiao.size() > 1) {
            int min = Math.min(da.size(), xiao.size());
            min -= min % 2;
            for (int i = 0; i < min / 2; ++i) {
                ArrayList pokers = new ArrayList(4);
                pokers.addAll(new ArrayList(da.subList(i * 2, i * 2 + 2)));
                pokers.addAll(new ArrayList(xiao.subList(i * 2, i * 2 + 2)));
                result.add(pokers);
            }
        }
        return result;
    }

    public static List<List<Poker>> combination(List<Poker> pokers, int m) {
        ArrayList<List<Poker>> resultList = new ArrayList<List<Poker>>();
        if (pokers.size() <= m) {
            resultList.add(pokers);
            return resultList;
        }
        int n = pokers.size();
        boolean end = false;
        int[] tempNum = new int[n];
        for (int i = 0; i < n; ++i) {
            tempNum[i] = i < m ? 1 : 0;
        }
        ArrayList<Poker> result = new ArrayList<Poker>(m);
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (tempNum[i] != 1) continue;
            result.add(j, pokers.get(i));
            ++j;
        }
        resultList.add(result);
        int k = 0;
        while (!end) {
            int i;
            boolean findFirst = false;
            boolean swap = false;
            for (i = 0; i < n; ++i) {
                int l = 0;
                if (!findFirst && tempNum[i] == 1) {
                    k = i;
                    findFirst = true;
                }
                if (tempNum[i] == 1 && tempNum[i + 1] == 0) {
                    tempNum[i] = 0;
                    tempNum[i + 1] = 1;
                    swap = true;
                    for (l = 0; l < i - k; ++l) {
                        tempNum[l] = tempNum[k + l];
                    }
                    for (l = i - k; l < i; ++l) {
                        tempNum[l] = 0;
                    }
                    if (k == i && i + 1 == n - m) {
                        end = true;
                    }
                }
                if (swap) break;
            }
            result = new ArrayList(m);
            j = 0;
            for (i = 0; i < n; ++i) {
                if (tempNum[i] != 1) continue;
                result.add(j, pokers.get(i));
                ++j;
            }
            resultList.add(result);
        }
        return resultList;
    }

    public static boolean hasLaizi(List<Poker> cardss, int laiziValue) {
        if (null == cardss || cardss.isEmpty()) {
            return false;
        }
        for (Poker poker : cardss) {
            if (!poker.getValue().equals(laiziValue) || !poker.getColor().equals(Poker.Color.HONGTAO.getType())) continue;
            return true;
        }
        return false;
    }

    public static GuandanPokersWeight arrangePoker(List<Poker> cardss, int laiziValue) {
        return GuandanUtil.arrangePoker(cardss, laiziValue, arrlist, true);
    }

    public static GuandanPokersWeight arrangePoker(List<Poker> cardss, int laiziValue, boolean sortByWeight) {
        return GuandanUtil.arrangePoker(cardss, laiziValue, arrlist, sortByWeight);
    }

    public static GuandanPokersWeight arrangePoker(List<Poker> cardss, int laiziValue, List<Integer> arrlist, boolean sortByWeight) {
        List<Poker> cards = GuandanUtil.copy(cardss);
        GuandanPokersWeight result = new GuandanPokersWeight();
        result.setPokers(cardss);
        result.setWeightCount(0.0);
        result.setGuandanPokers(new ArrayList<GuandanPokers>());
        List<List<Poker>> bomKing = GuandanUtil.getBomKing(cards);
        if (!bomKing.isEmpty()) {
            for (List<Poker> list : bomKing) {
                GuandanPokers guandanPokers = new GuandanPokers();
                guandanPokers.setPokers(list);
                CardType cardType = new CardType(10, 1000);
                guandanPokers.setWeight(GuandanUtil.getPokerWeight(cardType, list));
                guandanPokers.setCardType(cardType);
                result.getGuandanPokers().add(guandanPokers);
                result.setWeightCount(result.getWeightCount() + guandanPokers.getWeight());
                GuandanUtil.deletePoker(cards, list, (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
            }
        }
        ArrayList<Integer> myArrlist = new ArrayList<Integer>();
        block21: for (Integer type : arrlist) {
            switch (type) {
                case 7: {
                    List<List<Poker>> shunziList = GuandanUtil.optimalSingleLine(cards, laiziValue);
                    if (shunziList.isEmpty()) continue block21;
                    myArrlist.add(type);
                    continue block21;
                }
                case 8: {
                    List<List<Poker>> shunziList_sameColor = GuandanUtil.optimalSingleSameColor(cards, laiziValue);
                    if (shunziList_sameColor.isEmpty()) continue block21;
                    myArrlist.add(type);
                    continue block21;
                }
                case 6: {
                    List<List<Poker>> list = GuandanUtil.optimalGangban(cards, laiziValue);
                    if (list.isEmpty()) continue block21;
                    myArrlist.add(type);
                    continue block21;
                }
                case 4: {
                    List<List<Poker>> list = GuandanUtil.mergeSame(cards, 3, true, true);
                    if (list.size() <= 0) continue block21;
                    myArrlist.add(type);
                    continue block21;
                }
                case 2: {
                    List<List<Poker>> list = GuandanUtil.mergeSame(cards, 2, true, true);
                    if (list.size() <= 0) continue block21;
                    myArrlist.add(type);
                    continue block21;
                }
                case 3: {
                    List<List<Poker>> duizilist2 = GuandanUtil.optimalBoubleLine(cards, laiziValue);
                    if (duizilist2.isEmpty()) continue block21;
                    myArrlist.add(type);
                    continue block21;
                }
                case 9: {
                    List<List<Poker>> zhadanlist = GuandanUtil.optimalBomb(cards, laiziValue);
                    if (zhadanlist.isEmpty()) continue block21;
                    myArrlist.add(type);
                    continue block21;
                }
            }
            System.err.println("\u672a\u77e5\u7c7b\u578b" + type);
        }
        if (GuandanUtil.hasLaizi(cards, laiziValue)) {
            myArrlist.remove((Object)4);
            myArrlist.remove((Object)2);
        }
        if (myArrlist.isEmpty()) {
            List<List<Poker>> list = GuandanUtil.mergeSame(cards, null, false, false);
            GuandanPokersWeight guandanPokersWeight = new GuandanPokersWeight();
            ArrayList<GuandanPokers> guandanPokers = new ArrayList<GuandanPokers>();
            double weightCount = 0.0;
            for (List<Poker> list2 : list) {
                CardType cardType = GuandanUtil.cardType(list2, laiziValue, null);
                double pokerWeight = GuandanUtil.getPokerWeight(cardType, list2);
                weightCount += pokerWeight;
                GuandanPokers guandanPokers1 = new GuandanPokers();
                guandanPokers1.setCardType(cardType);
                guandanPokers1.setPokers(list2);
                guandanPokers1.setWeight(pokerWeight);
                guandanPokers.add(guandanPokers1);
            }
            guandanPokersWeight.setWeightCount(weightCount);
            guandanPokersWeight.setGuandanPokers(guandanPokers);
            result.getGuandanPokers().addAll(guandanPokersWeight.getGuandanPokers());
            result.setWeightCount(result.getWeightCount() + guandanPokersWeight.getWeightCount());
            return result;
        }
        ArrayList<ArrayList<List<Poker>>> arrayList = new ArrayList<ArrayList<List<Poker>>>();
        HashMap<Integer, ArrayList<List<Poker>>> bbb = new HashMap<Integer, ArrayList<List<Poker>>>();
        List<String[]> permutation = GuandanUtil.permutationNoRepeat(myArrlist);
        for (String[] stringArray : permutation) {
            int hash;
            ArrayList<List<Poker>> arrayList2 = new ArrayList<List<Poker>>();
            List<Poker> list = GuandanUtil.copy(cards);
            block24: for (String types : stringArray) {
                int type = Integer.parseInt(types);
                switch (type) {
                    case 8: {
                        List<List<Poker>> shunziList_sameColor = GuandanUtil.optimalSingleSameColor(list, laiziValue);
                        if (shunziList_sameColor.size() <= 0) continue block24;
                        arrayList2.addAll(shunziList_sameColor);
                        GuandanUtil.deletePoker(list, GuandanUtil.mergeTogher(shunziList_sameColor), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        continue block24;
                    }
                    case 7: {
                        List<List<Poker>> shunziList = GuandanUtil.optimalSingleLine(list, laiziValue);
                        if (shunziList.size() <= 0) continue block24;
                        arrayList2.addAll(shunziList);
                        GuandanUtil.deletePoker(list, GuandanUtil.mergeTogher(shunziList), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        continue block24;
                    }
                    case 6: {
                        List<List<Poker>> gangbans = GuandanUtil.optimalGangban(list, laiziValue);
                        if (gangbans.size() <= 0) continue block24;
                        arrayList2.addAll(gangbans);
                        try {
                            GuandanUtil.deletePoker(list, GuandanUtil.mergeTogher(gangbans), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue block24;
                    }
                    case 4: {
                        List<List<Poker>> sangetouList = GuandanUtil.mergeSame(list, 3, true, false);
                        if (sangetouList.size() <= 0) continue block24;
                        arrayList2.addAll(sangetouList);
                        GuandanUtil.deletePoker(list, GuandanUtil.mergeTogher(sangetouList), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        continue block24;
                    }
                    case 2: {
                        List<List<Poker>> duiziList1 = GuandanUtil.mergeSame(list, 2, false, false);
                        if (duiziList1.size() <= 0) continue block24;
                        arrayList2.addAll(duiziList1);
                        GuandanUtil.deletePoker(list, GuandanUtil.mergeTogher(duiziList1), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        continue block24;
                    }
                    case 3: {
                        List<List<Poker>> lianduis = GuandanUtil.optimalBoubleLine(list, laiziValue);
                        if (lianduis.size() <= 0) continue block24;
                        arrayList2.addAll(lianduis);
                        GuandanUtil.deletePoker(list, GuandanUtil.mergeTogher(lianduis), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        continue block24;
                    }
                    case 9: {
                        List<List<Poker>> zhadanList = GuandanUtil.optimalBomb(list, laiziValue);
                        if (zhadanList.size() <= 0) continue block24;
                        arrayList2.addAll(zhadanList);
                        GuandanUtil.deletePoker(list, GuandanUtil.mergeTogher(zhadanList), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
                        continue block24;
                    }
                    default: {
                        System.err.println("\u672a\u77e5\u7c7b\u578b" + type);
                    }
                }
            }
            if (arrayList2.size() <= 0 || bbb.containsKey(hash = GuandanUtil.hashCode2(arrayList2))) continue;
            bbb.put(hash, arrayList2);
            arrayList.add(arrayList2);
        }
        for (List list : arrayList) {
            List<Poker> list3 = GuandanUtil.mergeTogher(list);
            List<Poker> list4 = GuandanUtil.copy(cards);
            GuandanUtil.deletePoker(list4, list3, (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
            List<List<Poker>> othersPokers = GuandanUtil.mergeSame(list4, null, false, false);
            list.addAll(othersPokers);
        }
        ArrayList<GuandanPokersWeight> guandanPokersWeights = new ArrayList<GuandanPokersWeight>();
        for (List list : arrayList) {
            GuandanPokersWeight guandanPokersWeight = new GuandanPokersWeight();
            ArrayList<GuandanPokers> guandanPokers = new ArrayList<GuandanPokers>();
            double weightCount = 0.0;
            for (List pokers : list) {
                CardType cardType = GuandanUtil.cardType(pokers, laiziValue, null);
                double pokerWeight = GuandanUtil.getPokerWeight(cardType, pokers);
                weightCount += pokerWeight;
                GuandanPokers guandanPokers1 = new GuandanPokers();
                guandanPokers1.setCardType(cardType);
                guandanPokers1.setPokers(pokers);
                guandanPokers1.setWeight(pokerWeight);
                guandanPokers.add(guandanPokers1);
            }
            guandanPokersWeight.setWeightCount(weightCount);
            guandanPokersWeight.setGuandanPokers(guandanPokers);
            guandanPokersWeights.add(guandanPokersWeight);
        }
        if (sortByWeight) {
            guandanPokersWeights.sort(Comparator.comparingDouble(GuandanPokersWeight::getWeightCount));
        } else {
            guandanPokersWeights.sort((a, b) -> Integer.compare(b.getGuandanPokers().size(), a.getGuandanPokers().size()));
        }
        GuandanPokersWeight guandanPokersWeight = (GuandanPokersWeight)guandanPokersWeights.get(guandanPokersWeights.size() - 1);
        result.getGuandanPokers().addAll(guandanPokersWeight.getGuandanPokers());
        result.setWeightCount(result.getWeightCount() + guandanPokersWeight.getWeightCount());
        return result;
    }

    public static List<List<Poker>> optimalBomb(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = GuandanUtil.copy(cards);
        for (int i = cards_copy.size() - 1; i >= 0; --i) {
            Poker poker = cards_copy.get(i);
            if (!poker.getColor().equals(Poker.Color.KING.getType())) continue;
            cards_copy.remove(i);
        }
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        if (cards_copy.size() < 4) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards_copy, laiziValue);
        List laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        List<List<Poker>> cardsList = GuandanUtil.laizicomb(laiZiNot, laiziValue, laiZi.size(), true);
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        ArrayList<Map<Integer, List<Poker>>> a = new ArrayList<Map<Integer, List<Poker>>>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 4) continue;
            Map<Integer, List<Poker>> dd = GuandanUtil.getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<Integer>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; --i) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() >= 4) continue;
                dd.remove(value);
            }
            dd.remove(100);
            dd.remove(99);
            GuandanUtil.adddd_value(a, dd, hashcodes);
        }
        result = GuandanUtil.optimalBomb(a);
        GuandanUtil.laizibuquan2(result, laiZi);
        if (!result.isEmpty() && laiZi.size() > 0) {
            GuandanUtil.deletePoker(cards_copy, GuandanUtil.mergeTogher(result), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
            List<List<Poker>> lists = GuandanUtil.optimalBomb(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    public static List<List<Poker>> optimalBomb(List<Map<Integer, List<Poker>>> a) {
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        HashMap<Integer, List> commmm = new HashMap<Integer, List>();
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (Map<Integer, List<Poker>> duiziMap : a) {
            int hashCode;
            ArrayList<List<Poker>> b = new ArrayList<List<Poker>>();
            for (List<Poker> pokers : duiziMap.values()) {
                if (pokers.size() < 4) continue;
                b.add(pokers);
            }
            if (b.isEmpty() || hashcodes.contains(hashCode = GuandanUtil.hashCode2_value(b))) continue;
            hashcodes.add(hashCode);
            List orDefault = commmm.getOrDefault(b.size(), new ArrayList());
            orDefault.add(b);
            commmm.put(b.size(), orDefault);
        }
        Optional max = commmm.keySet().stream().max(Integer::compareTo);
        if (max.isPresent()) {
            List lists = (List)commmm.get(max.get());
            int maxweight = -1;
            for (List list : lists) {
                int weight = 0;
                for (List pokers : list) {
                    weight += ((Poker)pokers.get(pokers.size() - 1)).getValue().intValue();
                }
                if (weight <= maxweight) continue;
                maxweight = weight;
                result = list;
            }
        }
        return result;
    }

    public static double getPokerWeight(CardType cardType, List<Poker> pokers) {
        double weightBase = 0.0;
        double weightExtra = 0.0;
        switch (cardType.getType()) {
            case 1: {
                weightBase = -1.5;
                if (pokers.get(0).getValue().equals(99)) {
                    weightExtra = 1.1;
                    break;
                }
                if (pokers.get(0).getValue().equals(100)) {
                    weightExtra = 1.25;
                    break;
                }
                if (pokers.get(0).getValue().equals(Poker.Color.HONGTAO.getType())) break;
                weightExtra = (double)cardType.getWeight().intValue() / 25.0;
                break;
            }
            case 2: {
                weightBase = -0.125;
                if (pokers.get(0).getValue().equals(99)) {
                    weightExtra = 1.1;
                    break;
                }
                if (pokers.get(0).getValue().equals(100)) {
                    weightExtra = 1.25;
                    break;
                }
                weightExtra = (double)cardType.getWeight().intValue() / 21.75;
                break;
            }
            case 3: {
                weightBase = 0.15 * (double)pokers.size() / 2.0;
                for (int a = 0; a < pokers.size() / 2; ++a) {
                    weightExtra += (double)(cardType.getWeight() - a) / 20.0;
                }
                break;
            }
            case 4: {
                weightBase = 0.575;
                weightExtra = (double)cardType.getWeight().intValue() / 20.0;
                break;
            }
            case 5: {
                weightBase = 0.675;
                weightExtra = (double)cardType.getWeight().intValue() / 20.0;
                break;
            }
            case 6: {
                weightBase = 0.625 * (double)pokers.size() / 3.0;
                for (int a = 0; a < pokers.size() / 3; ++a) {
                    weightExtra += (double)(cardType.getWeight() - a) / 20.0;
                }
                break;
            }
            case 7: {
                weightBase = 1.475;
                weightExtra = (double)cardType.getWeight().intValue() / 20.0;
                break;
            }
            case 8: {
                weightBase = 2.155;
                double daxiao1 = (double)cardType.getWeight().intValue() / 100.0;
                weightExtra = 1.38875 + daxiao1 / 20.0;
                break;
            }
            case 9: {
                weightBase = 2.155;
                double daxiao2 = (double)cardType.getWeight().intValue() / 100.0;
                weightExtra = (double)pokers.size() / 4.0 + daxiao2 / 20.0;
                break;
            }
            case 10: {
                weightBase = 2.155;
                weightExtra = (double)cardType.getWeight().intValue() / 1000.0 * 2.5;
                break;
            }
            default: {
                System.err.println("\u672a\u77e5\u724c\u578b" + cardType.getType());
            }
        }
        return weightBase + weightExtra;
    }

    private static List<List<Poker>> optimalGangban(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = GuandanUtil.copy(cards);
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        if (cards_copy.size() < 6) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards_copy, laiziValue);
        List laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        List<List<Poker>> cardsList = GuandanUtil.laizicomb(laiZiNot, laiziValue, laiZi.size());
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        ArrayList<Map<Integer, List<Poker>>> a = new ArrayList<Map<Integer, List<Poker>>>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 6) continue;
            Map<Integer, List<Poker>> dd = GuandanUtil.getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<Integer>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; --i) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() >= 3) continue;
                dd.remove(value);
            }
            dd.remove(100);
            dd.remove(99);
            if (dd.size() < 2) continue;
            GuandanUtil.adddd_value(a, dd, hashcodes);
            if (!dd.containsKey(1)) continue;
            LinkedHashMap<Integer, List<Poker>> b = new LinkedHashMap<Integer, List<Poker>>(dd);
            ((HashMap)b).replaceAll((integer, pokers) -> GuandanUtil.copy(pokers));
            b.put(14, (List)b.remove(1));
            GuandanUtil.adddd_value(a, b, hashcodes);
        }
        result = GuandanUtil.optimalGangban(a);
        GuandanUtil.laizibuquan2(result, laiZi);
        if (!result.isEmpty() && laiZi.size() > 0) {
            GuandanUtil.deletePoker(cards_copy, GuandanUtil.mergeTogher(result), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
            List<List<Poker>> lists = GuandanUtil.optimalGangban(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    private static List<List<Poker>> optimalSanDaiEr(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = GuandanUtil.copy(cards);
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        if (cards_copy.size() < 5) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards_copy, laiziValue);
        List laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        List<List<Poker>> cardsList = GuandanUtil.laizicomb(laiZiNot, laiziValue, laiZi.size());
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        ArrayList<Map<Integer, List<Poker>>> a = new ArrayList<Map<Integer, List<Poker>>>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 5) continue;
            Map<Integer, List<Poker>> dd = GuandanUtil.getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<Integer>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; --i) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() >= 3) continue;
                dd.remove(value);
            }
            dd.remove(100);
            dd.remove(99);
            if (dd.size() < 2) continue;
            GuandanUtil.adddd_value(a, dd, hashcodes);
            if (!dd.containsKey(1)) continue;
            LinkedHashMap<Integer, List<Poker>> b = new LinkedHashMap<Integer, List<Poker>>(dd);
            ((HashMap)b).replaceAll((integer, pokers) -> GuandanUtil.copy(pokers));
            b.put(14, (List)b.remove(1));
            GuandanUtil.adddd_value(a, b, hashcodes);
        }
        result = GuandanUtil.optimalGangban(a);
        GuandanUtil.laizibuquan2(result, laiZi);
        if (!result.isEmpty() && laiZi.size() > 0) {
            GuandanUtil.deletePoker(cards_copy, GuandanUtil.mergeTogher(result), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
            List<List<Poker>> lists = GuandanUtil.optimalGangban(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    private static List<List<Poker>> optimalGangban(List<Map<Integer, List<Poker>>> a) {
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        int sizeMax = 0;
        int oneMin = 100;
        int twoMin = 100;
        double weightMax = 0.0;
        for (Map<Integer, List<Poker>> listMap : a) {
            OptimalCards optimalGangban = GuandanUtil.optimalGangban(listMap);
            boolean add = false;
            int size = optimalGangban.getSize();
            double weight = optimalGangban.getWeight();
            int twoCount = optimalGangban.getTwoCount();
            int oneCount = optimalGangban.getOneCount();
            List<List<Poker>> b = optimalGangban.getPokersList();
            if (oneMin >= oneCount) {
                if (oneMin > oneCount) {
                    add = true;
                } else if (twoMin >= twoCount) {
                    if (twoMin > twoCount) {
                        add = true;
                    } else if (sizeMax <= size) {
                        if (sizeMax < size) {
                            add = true;
                        } else {
                            boolean bl = add = weightMax <= weight;
                        }
                    }
                }
            }
            if (!add) continue;
            oneMin = oneCount;
            twoMin = twoCount;
            sizeMax = size;
            weightMax = weight;
            result = b;
        }
        return result;
    }

    private static OptimalCards optimalGangban(Map<Integer, List<Poker>> listMap) {
        OptimalCards optimalCards = new OptimalCards();
        boolean firstAdd = false;
        ArrayList<Integer> values = new ArrayList<Integer>(listMap.keySet());
        for (int i = 0; i <= values.size() - 2; ++i) {
            List list2;
            boolean a1;
            int i1 = i;
            int i2 = i + 1;
            Integer value1 = (Integer)values.get(i1);
            Integer value2 = (Integer)values.get(i2);
            boolean bl = a1 = value1 + 1 == value2;
            if (!a1) continue;
            LinkedHashMap<Integer, List<Poker>> duiziMap = new LinkedHashMap<Integer, List<Poker>>(listMap);
            duiziMap.replaceAll((integer, poker) -> GuandanUtil.copy(poker));
            List list1 = (List)duiziMap.get(value1);
            if (list1.size() < 3 || (list2 = (List)duiziMap.get(value2)).size() < 3) continue;
            ArrayList sangetou1 = new ArrayList(list1.subList(0, 3));
            ArrayList sangetou2 = new ArrayList(list2.subList(0, 3));
            ArrayList add = new ArrayList(6);
            add.addAll(sangetou1);
            add.addAll(sangetou2);
            list1.removeAll(sangetou1);
            list2.removeAll(sangetou2);
            int oneCount = 0;
            int twoCount = 0;
            for (List pokers : duiziMap.values()) {
                if (pokers.size() == 1) {
                    ++oneCount;
                }
                if (pokers.size() != 2) continue;
                ++twoCount;
            }
            OptimalCards optimalGangban = GuandanUtil.optimalGangban(duiziMap);
            if (optimalGangban.getSize() < 1) {
                optimalGangban.setOneCount(optimalGangban.getOneCount() + oneCount);
                optimalGangban.setTwoCount(optimalGangban.getTwoCount() + twoCount);
            }
            optimalGangban.getPokersList().add(add);
            optimalGangban.setSize(optimalGangban.getPokersList().size());
            optimalGangban.setWeight(optimalGangban.getWeight() + (double)value2.intValue());
            boolean isAdd = false;
            if (optimalGangban.getSize() > 0 && optimalCards.getOneCount() >= optimalGangban.getOneCount()) {
                if (optimalCards.getOneCount() > optimalGangban.getOneCount()) {
                    isAdd = true;
                } else if (optimalCards.getTwoCount() >= optimalGangban.getTwoCount()) {
                    if (optimalCards.getTwoCount() > optimalGangban.getTwoCount()) {
                        isAdd = true;
                    } else if (optimalCards.getSize() <= optimalGangban.getSize()) {
                        if (optimalCards.getSize() < optimalGangban.getSize()) {
                            isAdd = true;
                        } else {
                            boolean bl2 = isAdd = optimalCards.getWeight() <= optimalGangban.getWeight();
                        }
                    }
                }
            }
            if (!isAdd && firstAdd) continue;
            firstAdd = true;
            optimalCards = optimalGangban;
        }
        return optimalCards;
    }

    private static void adddd_value(List<Map<Integer, List<Poker>>> a, Map<Integer, List<Poker>> dd, Set<Integer> hashcodes) {
        int hashCode = GuandanUtil.hashCode_value(dd);
        if (!hashcodes.contains(hashCode)) {
            hashcodes.add(hashCode);
            a.add(dd);
        }
    }

    private static OptimalCards optimalSingleLine(Map<Integer, List<Poker>> listMap) {
        OptimalCards optimalCards = new OptimalCards();
        boolean firstAdd = false;
        ArrayList<Integer> values = new ArrayList<Integer>(listMap.keySet());
        for (int i = 0; i <= values.size() - 5; ++i) {
            boolean a4;
            int i1 = i;
            int i2 = i + 1;
            int i3 = i + 2;
            int i4 = i + 3;
            int i5 = i + 4;
            Integer value1 = (Integer)values.get(i1);
            Integer value2 = (Integer)values.get(i2);
            Integer value3 = (Integer)values.get(i3);
            Integer value4 = (Integer)values.get(i4);
            Integer value5 = (Integer)values.get(i5);
            boolean a1 = value1 + 1 == value2;
            boolean a2 = value2 + 1 == value3;
            boolean a3 = value3 + 1 == value4;
            boolean bl = a4 = value4 + 1 == value5;
            if (a1 && a2 && a3 && a4) {
                List list5;
                List list4;
                List list3;
                List list2;
                LinkedHashMap<Integer, List<Poker>> duiziMap = new LinkedHashMap<Integer, List<Poker>>(listMap);
                duiziMap.replaceAll((integer, poker) -> GuandanUtil.copy(poker));
                List list1 = (List)duiziMap.get(value1);
                if (list1.isEmpty() || (list2 = (List)duiziMap.get(value2)).isEmpty() || (list3 = (List)duiziMap.get(value3)).isEmpty() || (list4 = (List)duiziMap.get(value4)).isEmpty() || (list5 = (List)duiziMap.get(value5)).isEmpty()) continue;
                ArrayList<Poker> add = new ArrayList<Poker>(5);
                add.add((Poker)list1.get(0));
                add.add((Poker)list2.get(0));
                add.add((Poker)list3.get(0));
                add.add((Poker)list4.get(0));
                add.add((Poker)list5.get(0));
                list1.remove(0);
                list2.remove(0);
                list3.remove(0);
                list4.remove(0);
                list5.remove(0);
                int oneCount = 0;
                int twoCount = 0;
                for (List pokers : duiziMap.values()) {
                    if (pokers.size() == 1) {
                        ++oneCount;
                    }
                    if (pokers.size() != 2) continue;
                    ++twoCount;
                }
                OptimalCards optimalSingleBest = GuandanUtil.optimalSingleLine(duiziMap);
                if (optimalSingleBest.getSize() < 1) {
                    optimalSingleBest.setOneCount(optimalSingleBest.getOneCount() + oneCount);
                    optimalSingleBest.setTwoCount(optimalSingleBest.getTwoCount() + twoCount);
                }
                optimalSingleBest.getPokersList().add(add);
                optimalSingleBest.setSize(optimalSingleBest.getPokersList().size());
                optimalSingleBest.setWeight(optimalSingleBest.getWeight() + (double)value5.intValue());
                boolean isAdd = false;
                if (optimalSingleBest.getSize() > 0 && optimalCards.getOneCount() >= optimalSingleBest.getOneCount()) {
                    if (optimalCards.getOneCount() > optimalSingleBest.getOneCount()) {
                        isAdd = true;
                    } else if (optimalCards.getTwoCount() >= optimalSingleBest.getTwoCount()) {
                        if (optimalCards.getTwoCount() > optimalSingleBest.getTwoCount()) {
                            isAdd = true;
                        } else if (optimalCards.getSize() <= optimalSingleBest.getSize()) {
                            if (optimalCards.getSize() < optimalSingleBest.getSize()) {
                                isAdd = true;
                            } else {
                                boolean bl2 = isAdd = optimalCards.getWeight() <= optimalSingleBest.getWeight();
                            }
                        }
                    }
                }
                if (!isAdd && firstAdd) continue;
                firstAdd = true;
                optimalCards = optimalSingleBest;
                continue;
            }
            if (!a4) continue;
            i = i4;
            if (a3) {
                i = i3;
                if (a2) {
                    i = i2;
                }
            }
            --i;
        }
        return optimalCards;
    }

    private static List<List<Poker>> optimalSingleLine(List<Map<Integer, List<Poker>>> a) {
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        int sizeMax = 0;
        int oneMin = 100;
        int twoMin = 100;
        double weightMax = 0.0;
        for (Map<Integer, List<Poker>> listMap : a) {
            OptimalCards optimalCards = GuandanUtil.optimalSingleLine(listMap);
            if (optimalCards.getSize() < 1) continue;
            boolean add = false;
            int size = optimalCards.getSize();
            double weight = optimalCards.getWeight();
            int twoCount = optimalCards.getTwoCount();
            int oneCount = optimalCards.getOneCount();
            List<List<Poker>> b = optimalCards.getPokersList();
            if (oneMin >= oneCount) {
                if (oneMin > oneCount) {
                    add = true;
                } else if (twoMin >= twoCount) {
                    if (twoMin > twoCount) {
                        add = true;
                    } else if (sizeMax <= size) {
                        if (sizeMax < size) {
                            add = true;
                        } else {
                            boolean bl = add = weightMax <= weight;
                        }
                    }
                }
            }
            if (!add) continue;
            oneMin = oneCount;
            twoMin = twoCount;
            sizeMax = size;
            weightMax = weight;
            result = b;
        }
        return result;
    }

    public static List<List<Poker>> optimalSingleLine(List<Poker> cards, int laiziValue) {
        return GuandanUtil.optimalSingleLine(cards, laiziValue, false);
    }

    public static List<List<Poker>> optimalSingleLine(List<Poker> cards, int laiziValue, boolean sameColor) {
        List<Poker> cards_copy = GuandanUtil.copy(cards);
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        if (cards_copy.size() < 5) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards_copy, laiziValue);
        List laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        List<List<Poker>> cardsList = GuandanUtil.laizicomb(laiZiNot, laiziValue, laiZi.size());
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        ArrayList<Map<Integer, List<Poker>>> a = new ArrayList<Map<Integer, List<Poker>>>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 5) continue;
            if (sameColor) {
                Map<Integer, Map<Integer, List<Poker>>> pokerColorAndValue = GuandanUtil.getPokerColorAndValue(pokers1);
                for (Map<Integer, List<Poker>> dd : pokerColorAndValue.values()) {
                    dd.remove(100);
                    dd.remove(99);
                    if (dd.size() < 5) continue;
                    GuandanUtil.adddd_value(a, dd, hashcodes);
                    if (!dd.containsKey(1)) continue;
                    LinkedHashMap<Integer, List<Poker>> b = new LinkedHashMap<Integer, List<Poker>>(dd);
                    ((HashMap)b).replaceAll((integer, poker) -> GuandanUtil.copy(poker));
                    b.put(14, (List)b.remove(1));
                    GuandanUtil.adddd_value(a, b, hashcodes);
                }
                continue;
            }
            Map<Integer, List<Poker>> dd = GuandanUtil.getPokerMapByValue(pokers1);
            dd.remove(100);
            dd.remove(99);
            if (dd.size() < 5) continue;
            GuandanUtil.adddd_value(a, dd, hashcodes);
            if (!dd.containsKey(1)) continue;
            LinkedHashMap<Integer, List<Poker>> b = new LinkedHashMap<Integer, List<Poker>>(dd);
            ((HashMap)b).replaceAll((integer, poker) -> GuandanUtil.copy(poker));
            b.put(14, (List)b.remove(1));
            GuandanUtil.adddd_value(a, b, hashcodes);
        }
        result = GuandanUtil.optimalSingleLine(a);
        GuandanUtil.optimalSameColor(result, cards, laiziValue);
        GuandanUtil.laizibuquan2(result, laiZi);
        if (!result.isEmpty() && laiZi.size() > 0) {
            GuandanUtil.deletePoker(cards_copy, GuandanUtil.mergeTogher(result), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
            List<List<Poker>> lists = GuandanUtil.optimalSingleLine(cards_copy, laiziValue, sameColor);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    private static List<List<Poker>> laizicomb(List<Poker> cards, int laiziValue, int laiziCount, boolean all) {
        ArrayList<List<Poker>> cardsList = new ArrayList<List<Poker>>();
        if (all) {
            if (laiziCount == 1) {
                List<List<Poker>> zuhe = GuandanUtil.copy2((Collection<? extends Collection<? extends Poker>>)initLaiZi_1.get(laiziValue));
                for (List<Poker> pokers : zuhe) {
                    List<Poker> copy_cards = GuandanUtil.copy(cards);
                    copy_cards.addAll(pokers);
                    cardsList.add(copy_cards);
                }
            } else if (laiziCount == 2) {
                List<List<Poker>> zuhe = GuandanUtil.copy2((Collection<? extends Collection<? extends Poker>>)initLaiZi_2.get(laiziValue));
                for (List<Poker> pokers : zuhe) {
                    List<Poker> copy_cards = GuandanUtil.copy(cards);
                    copy_cards.addAll(pokers);
                    cardsList.add(copy_cards);
                }
            } else {
                cardsList.add(cards);
            }
        } else if (laiziCount > 0) {
            List<List<Poker>> zuhe = GuandanUtil.copy2((Collection<? extends Collection<? extends Poker>>)initLaiZi_1.get(laiziValue));
            for (List<Poker> pokers : zuhe) {
                List<Poker> copy_cards = GuandanUtil.copy(cards);
                copy_cards.addAll(pokers);
                cardsList.add(copy_cards);
            }
        } else {
            cardsList.add(cards);
        }
        return cardsList;
    }

    private static List<List<Poker>> laizicomb(List<Poker> cards, int laiziValue, int laiziCount) {
        return GuandanUtil.laizicomb(cards, laiziValue, laiziCount, false);
    }

    private static Map<Integer, List<Poker>> getPokerMapByColor(List<Poker> cards) {
        HashMap<Integer, List<Poker>> dd = new HashMap<Integer, List<Poker>>();
        for (Poker poker : cards) {
            Integer color = poker.getColor();
            List orDefault = dd.getOrDefault(color, new ArrayList());
            orDefault.add(poker);
            dd.put(color, orDefault);
        }
        return dd;
    }

    public static Map<Integer, List<Poker>> getPokerMapByValue(List<Poker> cards) {
        HashMap<Integer, List<Poker>> dd = new HashMap<Integer, List<Poker>>();
        for (Poker poker : cards) {
            Integer value = poker.getValue();
            List orDefault = dd.getOrDefault(value, new ArrayList());
            orDefault.add(poker);
            dd.put(value, orDefault);
        }
        return dd;
    }

    public static Map<Integer, List<GuandanPokers>> getGuandanPokerMapByValue(List<GuandanPokers> guandanPokers) {
        HashMap<Integer, List<GuandanPokers>> aa = new HashMap<Integer, List<GuandanPokers>>();
        for (GuandanPokers guandanPoker : guandanPokers) {
            Collection pokers = guandanPoker.getPokers();
            Integer value = null;
            for (Poker poker : pokers) {
                value = poker.getValue();
                List orDefault = aa.getOrDefault(value, new ArrayList());
                orDefault.add(guandanPoker);
                aa.put(value, orDefault);
            }
        }
        return aa;
    }

    private static void optimalSameColor(List<List<Poker>> cardsList, List<Poker> cards, int laiziValue) {
        ArrayList<Poker> shunzi;
        List<Poker> cards_copy = GuandanUtil.copy(cards);
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards_copy, laiziValue);
        List laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        ArrayList<Integer> laiziValues = new ArrayList<Integer>();
        for (List<Poker> pokers : cardsList) {
            for (Poker poker : pokers) {
                if (null != poker.getNumber()) continue;
                laiziValues.add(poker.getValue());
            }
        }
        for (int i = 0; i < laiZi.size() - laiziValues.size(); ++i) {
            laiziValues.add(-1);
        }
        Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap = GuandanUtil.getColorAndValuesMap(laiZiNot);
        cardsList.sort((o1, o2) -> {
            MaxColorAndSize sizeByColorAndValuesMap1 = GuandanUtil.getMaxColorAndSizeByColorAndValuesMap(o1, colorAndValuesMap);
            MaxColorAndSize sizeByColorAndValuesMap2 = GuandanUtil.getMaxColorAndSizeByColorAndValuesMap(o2, colorAndValuesMap);
            return Integer.compare(sizeByColorAndValuesMap1.getSizeMax(), sizeByColorAndValuesMap2.getSizeMax());
        });
        ArrayList<Integer> setIndex = new ArrayList<Integer>();
        for (int i = cardsList.size() - 1; i >= 0; --i) {
            List<Poker> pokers = cardsList.get(i);
            Set values = CollectUtil.getSet(pokers, Poker::getValue);
            boolean has = false;
            shunzi = new ArrayList<Poker>();
            for (Integer color_ : colorAndValuesMap.keySet()) {
                Map<Integer, List<Poker>> value = colorAndValuesMap.get(color_);
                HashSet values_copy = new HashSet(values);
                values_copy.removeAll(value.keySet());
                if (!values_copy.isEmpty()) {
                    boolean ex = true;
                    if (values_copy.size() > laiziValues.size()) continue;
                    ArrayList laiziValues_copy = new ArrayList(laiziValues);
                    for (Integer value_ : values_copy) {
                        if (laiziValues_copy.contains(value_)) {
                            laiziValues_copy.remove(value_);
                            continue;
                        }
                        if (laiziValues_copy.contains(-1)) {
                            laiziValues_copy.remove((Object)-1);
                            continue;
                        }
                        ex = false;
                        break;
                    }
                    if (!ex) continue;
                    values_copy.clear();
                }
                for (Integer value_ : values) {
                    List<Poker> pokers1 = value.get(value_);
                    if (null == pokers1 || pokers1.isEmpty()) {
                        shunzi.add((Poker)laiZi.remove(0));
                        boolean remove = laiziValues.remove(value_);
                        if (remove) continue;
                        laiziValues.remove((Object)-1);
                        continue;
                    }
                    shunzi.add(GuandanUtil.copy(pokers1.remove(0)));
                    value.put(value_, pokers1);
                    if (!pokers1.isEmpty()) continue;
                    value.remove(value_);
                }
                if (value.isEmpty()) {
                    colorAndValuesMap.remove(color_);
                }
                has = true;
                break;
            }
            if (has) {
                cardsList.set(i, shunzi);
                continue;
            }
            setIndex.add(i);
        }
        for (Integer index : setIndex) {
            int needLaiziCount;
            List<Poker> pokers = cardsList.get(index);
            Set values = CollectUtil.getSet(pokers, Poker::getValue);
            shunzi = new ArrayList();
            for (Map<Integer, List<Poker>> value : colorAndValuesMap.values()) {
                HashSet<Integer> values_ = new HashSet<Integer>(value.keySet());
                for (Integer value_ : values) {
                    List<Poker> pokers1 = value.get(value_);
                    if (null == pokers1 || pokers1.isEmpty()) continue;
                    shunzi.add(GuandanUtil.copy(pokers1.remove(0)));
                    value.put(value_, pokers1);
                    if (!pokers1.isEmpty()) continue;
                    value.remove(value_);
                }
                values.removeAll(values_);
                if (!values.isEmpty()) continue;
                break;
            }
            if (shunzi.size() != pokers.size() && (needLaiziCount = pokers.size() - shunzi.size()) <= laiZi.size()) {
                ArrayList pokers3 = new ArrayList(laiZi.subList(0, needLaiziCount));
                shunzi.addAll(pokers3);
                laiZi.removeAll(pokers3);
            }
            cardsList.set(index, shunzi);
        }
    }

    private static List<Poker> getRamdonValue(Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap, Integer value, Integer size) {
        ArrayList<Poker> result = new ArrayList<Poker>();
        for (Map<Integer, List<Poker>> integerListMap : colorAndValuesMap.values()) {
            List<Poker> pokers = integerListMap.get(value);
            if (null == pokers || pokers.isEmpty()) continue;
            ArrayList<Poker> pokers1 = new ArrayList<Poker>(pokers.subList(0, Math.min(pokers.size(), size)));
            result.addAll(pokers1);
            size = size - pokers1.size();
        }
        return result;
    }

    private static void removeColorAndValuesMap(Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap, Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap2) {
        for (Integer color : colorAndValuesMap2.keySet()) {
            Map<Integer, List<Poker>> integerListMap = colorAndValuesMap.get(color);
            if (null == integerListMap) continue;
            Map<Integer, List<Poker>> integerListMap1 = colorAndValuesMap2.get(color);
            for (Integer value : integerListMap1.keySet()) {
                List<Poker> pokers = integerListMap.get(value);
                if (null == pokers || pokers.isEmpty()) continue;
                List<Poker> pokers1 = integerListMap1.get(value);
                pokers.removeAll(pokers1);
                if (!pokers.isEmpty()) continue;
                integerListMap.remove(value);
            }
            if (!integerListMap.isEmpty()) continue;
            colorAndValuesMap.remove(color);
        }
    }

    private static Map<Integer, Map<Integer, List<Poker>>> getColorAndValuesMap(List<Poker> cards) {
        HashMap<Integer, Map<Integer, List<Poker>>> colorAndValuesMap = new HashMap<Integer, Map<Integer, List<Poker>>>();
        for (Poker poker : cards) {
            Integer pokerColor = poker.getColor();
            Integer pokerValue = poker.getValue();
            Map pokerValueMap = colorAndValuesMap.getOrDefault(pokerColor, new HashMap());
            List pokersTemp1 = pokerValueMap.getOrDefault(pokerValue, new ArrayList());
            pokersTemp1.add(poker);
            pokerValueMap.put(pokerValue, pokersTemp1);
            colorAndValuesMap.put(pokerColor, pokerValueMap);
        }
        return colorAndValuesMap;
    }

    private static MaxColorAndSize getMaxColorAndSizeByColorAndValuesMap(List<Poker> cards, Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap) {
        MaxColorAndSize maxColorAndSize = new MaxColorAndSize();
        Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(cards);
        Set<Integer> valuesTemp = pokerMapByValue.keySet();
        int sizeMax = 0;
        int colorMax = -1;
        HashMap pokersMap = null;
        for (Integer color : colorAndValuesMap.keySet()) {
            int size = 0;
            HashMap pokersTemp = new HashMap();
            Map<Integer, List<Poker>> valueTempMap = colorAndValuesMap.get(color);
            for (Integer valueTemp : valuesTemp) {
                List a1 = valueTempMap.getOrDefault(valueTemp, new ArrayList());
                List<Poker> a2 = pokerMapByValue.get(valueTemp);
                if (a1.size() < a2.size()) continue;
                size += a2.size();
                pokersTemp.put(valueTemp, new ArrayList(a1.subList(0, a2.size())));
            }
            if (size <= sizeMax) continue;
            sizeMax = size;
            colorMax = color;
            pokersMap = pokersTemp;
        }
        maxColorAndSize.setColor(colorMax);
        maxColorAndSize.setSizeMax(sizeMax);
        maxColorAndSize.setPokersMap(pokersMap);
        return maxColorAndSize;
    }

    private static Map<Integer, Map<Integer, List<Poker>>> getPokerColorAndValue(List<Poker> cards) {
        HashMap<Integer, Map<Integer, List<Poker>>> pokerColorAndValue = new HashMap<Integer, Map<Integer, List<Poker>>>();
        for (Poker card : cards) {
            Integer color = card.getColor();
            Integer value = card.getValue();
            Map valueMap = pokerColorAndValue.getOrDefault(color, new HashMap());
            List pokers = valueMap.getOrDefault(value, new ArrayList());
            pokers.add(card);
            valueMap.put(value, pokers);
            pokerColorAndValue.put(color, valueMap);
        }
        return pokerColorAndValue;
    }

    private static void laizibuquan1(List<Poker> cards, List<Poker> laiZis) {
        if (laiZis.size() == 0) {
            return;
        }
        for (Poker card : cards) {
            if (null != card.getNumber()) continue;
            Poker laizi = laiZis.get(0);
            card.setNumber(laizi.getNumber());
            card.setValue(laizi.getValue());
            card.setColor(laizi.getColor());
            laiZis.remove(0);
        }
    }

    private static void laizibuquan2(List<List<Poker>> cardsList, List<Poker> laiZis) {
        if (laiZis.size() == 0) {
            return;
        }
        for (List<Poker> pokers : cardsList) {
            GuandanUtil.laizibuquan1(pokers, laiZis);
        }
    }

    private static OptimalCards optimalBoubleLine(Map<Integer, List<Poker>> listMap) {
        OptimalCards optimalCards = new OptimalCards();
        boolean firstAdd = false;
        ArrayList<Integer> values = new ArrayList<Integer>(listMap.keySet());
        for (int i = 0; i <= values.size() - 3; ++i) {
            boolean a2;
            int i1 = i;
            int i2 = i + 1;
            int i3 = i + 2;
            Integer value1 = (Integer)values.get(i1);
            Integer value2 = (Integer)values.get(i2);
            Integer value3 = (Integer)values.get(i3);
            boolean a1 = value1 + 1 == value2;
            boolean bl = a2 = value2 + 1 == value3;
            if (a1 && a2) {
                List list3;
                List list2;
                LinkedHashMap<Integer, List<Poker>> duiziMap = new LinkedHashMap<Integer, List<Poker>>(listMap);
                duiziMap.replaceAll((integer, poker) -> GuandanUtil.copy(poker));
                List list1 = (List)duiziMap.get(value1);
                if (list1.size() < 2 || (list2 = (List)duiziMap.get(value2)).size() < 2 || (list3 = (List)duiziMap.get(value3)).size() < 2) continue;
                ArrayList duizi1 = new ArrayList(list1.subList(0, 2));
                ArrayList duizi2 = new ArrayList(list2.subList(0, 2));
                ArrayList duizi3 = new ArrayList(list3.subList(0, 2));
                ArrayList add = new ArrayList(6);
                add.addAll(duizi1);
                add.addAll(duizi2);
                add.addAll(duizi3);
                list1.removeAll(duizi1);
                list2.removeAll(duizi2);
                list3.removeAll(duizi3);
                int oneCount = 0;
                int twoCount = 0;
                for (List pokers : duiziMap.values()) {
                    if (pokers.size() == 1) {
                        ++oneCount;
                    }
                    if (pokers.size() != 2) continue;
                    ++twoCount;
                }
                OptimalCards optimalBoubleLine = GuandanUtil.optimalBoubleLine(duiziMap);
                if (optimalBoubleLine.getSize() < 1) {
                    optimalBoubleLine.setOneCount(optimalBoubleLine.getOneCount() + oneCount);
                    optimalBoubleLine.setTwoCount(optimalBoubleLine.getTwoCount() + twoCount);
                }
                optimalBoubleLine.getPokersList().add(add);
                optimalBoubleLine.setSize(optimalBoubleLine.getPokersList().size());
                optimalBoubleLine.setWeight(optimalBoubleLine.getWeight() + (double)value3.intValue());
                boolean isAdd = false;
                if (optimalBoubleLine.getSize() > 0 && optimalCards.getOneCount() >= optimalBoubleLine.getOneCount()) {
                    if (optimalCards.getOneCount() > optimalBoubleLine.getOneCount()) {
                        isAdd = true;
                    } else if (optimalCards.getTwoCount() >= optimalBoubleLine.getTwoCount()) {
                        if (optimalCards.getTwoCount() > optimalBoubleLine.getTwoCount()) {
                            isAdd = true;
                        } else if (optimalCards.getSize() <= optimalBoubleLine.getSize()) {
                            if (optimalCards.getSize() < optimalBoubleLine.getSize()) {
                                isAdd = true;
                            } else {
                                boolean bl2 = isAdd = optimalCards.getWeight() <= optimalBoubleLine.getWeight();
                            }
                        }
                    }
                }
                if (!isAdd && firstAdd) continue;
                firstAdd = true;
                optimalCards = optimalBoubleLine;
                continue;
            }
            if (!a2) continue;
            i = i2;
            --i;
        }
        return optimalCards;
    }

    private static List<List<Poker>> optimalBoubleLine(List<Map<Integer, List<Poker>>> a) {
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        int sizeMax = 0;
        int oneMin = 100;
        int twoMin = 100;
        double weightMax = 0.0;
        for (Map<Integer, List<Poker>> listMap : a) {
            OptimalCards optimalBoubleLine = GuandanUtil.optimalBoubleLine(listMap);
            boolean add = false;
            int size = optimalBoubleLine.getSize();
            double weight = optimalBoubleLine.getWeight();
            int twoCount = optimalBoubleLine.getTwoCount();
            int oneCount = optimalBoubleLine.getOneCount();
            List<List<Poker>> b = optimalBoubleLine.getPokersList();
            if (oneMin >= oneCount) {
                if (oneMin > oneCount) {
                    add = true;
                } else if (twoMin >= twoCount) {
                    if (twoMin > twoCount) {
                        add = true;
                    } else if (sizeMax <= size) {
                        if (sizeMax < size) {
                            add = true;
                        } else {
                            boolean bl = add = weightMax <= weight;
                        }
                    }
                }
            }
            if (!add) continue;
            oneMin = oneCount;
            twoMin = twoCount;
            sizeMax = size;
            weightMax = weight;
            result = b;
        }
        return result;
    }

    private static List<List<Poker>> optimalBoubleLine(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = GuandanUtil.copy(cards);
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        if (cards_copy.size() < 6) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards_copy, laiziValue);
        List laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        List<List<Poker>> cardsList = GuandanUtil.laizicomb(laiZiNot, laiziValue, laiZi.size());
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        ArrayList<Map<Integer, List<Poker>>> a = new ArrayList<Map<Integer, List<Poker>>>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 6) continue;
            Map<Integer, List<Poker>> dd = GuandanUtil.getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<Integer>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; --i) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() >= 2) continue;
                dd.remove(value);
            }
            dd.remove(100);
            dd.remove(99);
            if (dd.size() < 3) continue;
            GuandanUtil.adddd_value(a, dd, hashcodes);
            if (!dd.containsKey(1)) continue;
            LinkedHashMap<Integer, List<Poker>> b = new LinkedHashMap<Integer, List<Poker>>(dd);
            ((HashMap)b).replaceAll((integer, pokers) -> GuandanUtil.copy(pokers));
            b.put(14, (List)b.remove(1));
            GuandanUtil.adddd_value(a, b, hashcodes);
        }
        result = GuandanUtil.optimalBoubleLine(a);
        GuandanUtil.laizibuquan2(result, laiZi);
        if (!result.isEmpty() && laiZi.size() > 0) {
            GuandanUtil.deletePoker(cards_copy, GuandanUtil.mergeTogher(result), (IFunction<? super Poker, Integer>)((IFunction & Serializable)Poker::getNumber));
            List<List<Poker>> lists = GuandanUtil.optimalBoubleLine(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    public static List<Poker> createPokers(int cardPair, boolean shuffle) {
        return GuandanUtil.createPokers(cardPair, shuffle, 0, true);
    }

    public static List<Poker> createPokers(int cardPair, boolean shuffle, Integer number, boolean addKing) {
        Integer n;
        ArrayList<Poker> allCard = new ArrayList<Poker>();
        if (null == number) {
            n = null;
        } else {
            Integer n2 = number;
            number = number + 1;
            n = n2;
        }
        number = n;
        for (int i = 1; i <= cardPair; ++i) {
            Integer n3;
            Integer n4;
            for (int type = 1; type <= 4; ++type) {
                for (int value = 1; value <= 13; ++value) {
                    Integer n5;
                    Poker poker = new Poker();
                    poker.setColor(type);
                    poker.setValue(value);
                    if (null == number) {
                        n5 = null;
                    } else {
                        Integer n6 = number;
                        number = number + 1;
                        n5 = n6;
                    }
                    poker.setNumber(n5);
                    allCard.add(poker);
                }
            }
            if (!addKing) continue;
            Poker da = new Poker();
            da.setColor(Poker.Color.KING.getType());
            da.setValue(100);
            if (null == number) {
                n4 = null;
            } else {
                Integer value = number;
                number = number + 1;
                n4 = value;
            }
            da.setNumber(n4);
            Poker xiao = new Poker();
            xiao.setColor(Poker.Color.KING.getType());
            xiao.setValue(99);
            if (null == number) {
                n3 = null;
            } else {
                Integer n7 = number;
                number = number + 1;
                n3 = n7;
            }
            xiao.setNumber(n3);
            allCard.add(da);
            allCard.add(xiao);
        }
        if (shuffle) {
            Collections.shuffle(allCard);
        }
        return allCard;
    }

    public static Map<Integer, List<Poker>> distribPokers(List<Poker> pokers, int peoplenum) {
        HashMap<Integer, List<Poker>> resultMap = new HashMap<Integer, List<Poker>>();
        double dnum = (double)pokers.size() / (double)peoplenum;
        double remainder = dnum % (double)((int)dnum);
        boolean zero = MathUtil.isZero((Number)remainder);
        if (!zero) {
            System.err.println("\u724c\u4e0d\u591f\u5206\u914d pokers : " + pokers.size() + " peoplenum : " + peoplenum);
            return null;
        }
        int num = (int)dnum;
        for (int i = 0; i < peoplenum; ++i) {
            ArrayList<Poker> temppokers = new ArrayList<Poker>(pokers.subList(i * num, (i + 1) * num));
            resultMap.put(i, temppokers);
        }
        return resultMap;
    }

    public static void deletePoker(List<Poker> cardsA, List<Poker> cardsB, IFunction<? super Poker, Integer> keyExtractor) {
        if (null == cardsB || cardsB.isEmpty()) {
            return;
        }
        if (null == cardsA || cardsA.isEmpty()) {
            return;
        }
        block0: for (Poker pokerB : cardsB) {
            for (Poker pokerA : cardsA) {
                if (!((Integer)keyExtractor.apply((Object)pokerB)).equals(keyExtractor.apply((Object)pokerA))) continue;
                cardsA.remove(pokerA);
                continue block0;
            }
        }
    }

    public static List<Poker> parsePokerByNumbers(List<Poker> pokers, Collection<Integer> pokersNumber) {
        if (null == pokersNumber || pokersNumber.isEmpty()) {
            return new ArrayList<Poker>();
        }
        ArrayList<Poker> resultCards = new ArrayList<Poker>();
        block0: for (Integer number : pokersNumber) {
            for (Poker poker : pokers) {
                if (!poker.getNumber().equals(number)) continue;
                resultCards.add(poker);
                continue block0;
            }
        }
        return resultCards;
    }

    public static boolean containPoker(List<Poker> cardsA, List<Poker> cardsB, IFunction<? super Poker, Integer> keyExtractor) {
        if (null == cardsB || cardsB.size() == 0) {
            return true;
        }
        for (Poker cardB : cardsB) {
            boolean contain = false;
            for (Poker cardA : cardsA) {
                if (!((Integer)keyExtractor.apply((Object)cardA)).equals(keyExtractor.apply((Object)cardB))) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            return contain;
        }
        return true;
    }

    public static boolean sameColor(List<Poker> cards) {
        if (null == cards || cards.size() < 2) {
            return false;
        }
        int color = cards.get(0).getColor();
        for (Poker card : cards) {
            if (card.getColor().equals(color)) continue;
            return false;
        }
        return true;
    }

    public static boolean sameColor(List<Poker> cards, int laiziValue) {
        if (null == cards || cards.size() < 2) {
            return false;
        }
        int color = cards.get(0).getColor();
        for (Poker card : cards) {
            if (card.getColor().equals(color) || card.getColor().equals(Poker.Color.HONGTAO.getType()) && card.getValue().equals(laiziValue)) continue;
            return false;
        }
        return true;
    }

    public static List<List<Poker>> mergeSame(List<Poker> cards, Integer sameSize, Boolean cardCross, Boolean sameSizeexceed) {
        ArrayList<List<Poker>> result = new ArrayList<List<Poker>>();
        if (null == cards || cards.isEmpty()) {
            return result;
        }
        HashMap<Integer, List> pokerMap = new HashMap<Integer, List>();
        for (Poker poker : cards) {
            Integer key = poker.getValue();
            List pokers = pokerMap.getOrDefault(key, new ArrayList());
            pokers.add(poker);
            pokerMap.put(key, pokers);
        }
        for (Integer pvkey : pokerMap.keySet()) {
            List pokers = (List)pokerMap.get(pvkey);
            if (null != sameSize) {
                if (null != sameSizeexceed && sameSizeexceed.booleanValue()) {
                    if (pokers.size() < sameSize) continue;
                    result.add(pokers);
                    continue;
                }
                if (null != cardCross && cardCross.booleanValue()) {
                    for (int i = 0; i <= pokers.size() - sameSize; i += sameSize.intValue()) {
                        ArrayList temppokers = new ArrayList(pokers.subList(i, i + sameSize));
                        result.add(temppokers);
                    }
                    continue;
                }
                if (pokers.size() != sameSize.intValue()) continue;
            }
            result.add(pokers);
        }
        return result;
    }

    public static List<Poker> mergeTogher(Collection<List<Poker>> cards) {
        ArrayList<Poker> result = new ArrayList<Poker>();
        if (null == cards || cards.isEmpty()) {
            return result;
        }
        for (List<Poker> pokers : cards) {
            result.addAll(pokers);
        }
        return result;
    }

    public static int getPokerDaXiao(Poker poker, int laiziValue) {
        return GuandanUtil.getPokerDaXiao(poker.getValue(), laiziValue);
    }

    public static List<Poker> getLianDui(List<Poker> cards, int laiziCount) {
        ArrayList<Poker> result = new ArrayList<Poker>();
        if (null == cards || cards.size() + laiziCount != 6) {
            return result;
        }
        Map pokerMapByValue = CollectUtil.toGroup(cards, Poker::getValue);
        for (List value : pokerMapByValue.values()) {
            if (value.size() <= 2) continue;
            return result;
        }
        Set cardsValue = pokerMapByValue.keySet();
        if (laiziCount == 0) {
            return initLiandui.getOrDefault(cardsValue, result);
        }
        for (Set<Integer> values : initLiandui.keySet()) {
            if (!values.containsAll(cardsValue)) continue;
            return initLiandui.getOrDefault(values, result);
        }
        return result;
    }

    public static List<Poker> getGangban(List<Poker> cards, int laiziCount) {
        ArrayList<Poker> result = new ArrayList<Poker>();
        if (null == cards || cards.size() + laiziCount != 6) {
            return result;
        }
        Map pokerMapByValue = CollectUtil.toGroup(cards, Poker::getValue);
        for (List value : pokerMapByValue.values()) {
            if (value.size() <= 3) continue;
            return result;
        }
        Set cardsValue = pokerMapByValue.keySet();
        if (laiziCount == 0) {
            return initGangban.getOrDefault(cardsValue, result);
        }
        for (Set<Integer> values : initGangban.keySet()) {
            if (!values.containsAll(cardsValue)) continue;
            return initGangban.getOrDefault(values, result);
        }
        return result;
    }

    public static int continueLength(List<Poker> cards) {
        if (null == cards || cards.size() < 2) {
            return 0;
        }
        ArrayList<Integer> values = new ArrayList<Integer>(CollectUtil.getSet(cards, Poker::getValue));
        if (values.contains(1)) {
            values.add(14);
        }
        int maxLength = 1;
        int length = 1;
        for (int i = 0; i < values.size() - 1; ++i) {
            Integer value1 = (Integer)values.get(i);
            Integer value2 = (Integer)values.get(i + 1);
            if (value1 + 1 == value2) {
                ++length;
                continue;
            }
            if (maxLength < length) {
                maxLength = length;
            }
            length = 1;
        }
        return Math.max(maxLength, length);
    }

    public static boolean hasShunziTonghua(List<Poker> cards) {
        if (null == cards || cards.size() < 5) {
            return false;
        }
        HashMap<Integer, List> pokerMap = new HashMap<Integer, List>();
        for (Poker card : cards) {
            List pokers = pokerMap.getOrDefault(card.getColor(), new ArrayList());
            pokers.add(card);
            pokerMap.put(card.getColor(), pokers);
        }
        for (List pokers : pokerMap.values()) {
            int lengthMax = GuandanUtil.continueLength(pokers);
            if (lengthMax < 5) continue;
            return true;
        }
        return false;
    }

    public static List<Poker> getShunzi(List<Poker> cards, int laiziCount) {
        ArrayList<Poker> result = new ArrayList<Poker>();
        if (null == cards || cards.size() + laiziCount != 5) {
            return result;
        }
        Set cardsValue = CollectUtil.getSet(cards, Poker::getValue);
        if (cardsValue.size() != cards.size()) {
            return result;
        }
        if (laiziCount == 0) {
            return GuandanUtil.copy((Collection<? extends Poker>)initShunzi.getOrDefault(cardsValue, result));
        }
        for (Set<Integer> shunziValues : initShunzi.keySet()) {
            if (!shunziValues.containsAll(cardsValue)) continue;
            return GuandanUtil.copy((Collection<? extends Poker>)initShunzi.getOrDefault(shunziValues, result));
        }
        return result;
    }

    public static int getPokerDaXiao(int pokervalue, int laiziValue) {
        if (pokervalue == laiziValue) {
            return 20;
        }
        if (pokervalue == 1) {
            return 14;
        }
        return pokervalue;
    }

    public static Map<Integer, List<Poker>> getLaiZiOrNot(List<Poker> cards, int laiziValue) {
        HashMap<Integer, List<Poker>> result = new HashMap<Integer, List<Poker>>(2);
        if (null == cards || cards.isEmpty()) {
            return result;
        }
        ArrayList<Poker> king = new ArrayList<Poker>();
        ArrayList<Poker> laiziNot = new ArrayList<Poker>();
        ArrayList<Poker> laizi = new ArrayList<Poker>();
        for (Poker card : cards) {
            if (card.getColor().equals(Poker.Color.KING.getType())) {
                king.add(card);
                continue;
            }
            if (!card.getColor().equals(Poker.Color.HONGTAO.getType()) || !card.getValue().equals(laiziValue)) {
                laiziNot.add(card);
                continue;
            }
            laizi.add(card);
        }
        result.put(1, laizi);
        result.put(2, laiziNot);
        result.put(3, king);
        ArrayList<Poker> pokers = new ArrayList<Poker>(laiziNot);
        pokers.addAll(king);
        result.put(4, pokers);
        return result;
    }

    public static Map<Integer, List<GuandanPokers>> getLaiZiOrNot1(List<GuandanPokers> cards, int laiziValue) {
        HashMap<Integer, List<GuandanPokers>> result = new HashMap<Integer, List<GuandanPokers>>(2);
        if (null == cards || cards.isEmpty()) {
            return result;
        }
        ArrayList<GuandanPokers> king = new ArrayList<GuandanPokers>();
        ArrayList<GuandanPokers> laiziNot = new ArrayList<GuandanPokers>();
        ArrayList<GuandanPokers> laizi = new ArrayList<GuandanPokers>();
        for (GuandanPokers card : cards) {
            Collection pokers = card.getPokers();
            for (Poker poker : pokers) {
                if (poker.getColor().equals(Poker.Color.KING.getType())) {
                    king.add(card);
                    continue;
                }
                if (!poker.getColor().equals(Poker.Color.HONGTAO.getType()) || !poker.getValue().equals(laiziValue)) {
                    laiziNot.add(card);
                    continue;
                }
                laizi.add(card);
            }
        }
        result.put(1, laizi);
        result.put(2, laiziNot);
        result.put(3, king);
        ArrayList<GuandanPokers> pokers = new ArrayList<GuandanPokers>(laiziNot);
        pokers.addAll(king);
        result.put(4, pokers);
        return result;
    }

    public static boolean comparePoker(CardType cardTypeA, CardType cardTypeB) {
        if (null == cardTypeA || null == cardTypeB) {
            return false;
        }
        Integer typeA = cardTypeA.getType();
        Integer weightA = cardTypeA.getWeight();
        Integer typeB = cardTypeB.getType();
        Integer weightB = cardTypeB.getWeight();
        if (typeA.equals(typeB) || typeA.equals(9) || typeA.equals(10) || typeA.equals(8)) {
            return weightA > weightB;
        }
        return false;
    }

    private static boolean yitiaolong(List<Poker> cards) {
        Integer value = null;
        for (Poker card : cards) {
            if (null == value || card.getValue().equals(value)) {
                value = card.getValue();
                continue;
            }
            return false;
        }
        return true;
    }

    public static List<GuandanPokers> copy3(List<GuandanPokers> guandanPokers) {
        ArrayList<GuandanPokers> result = new ArrayList<GuandanPokers>();
        for (GuandanPokers guandanPoker : guandanPokers) {
            GuandanPokers guandanPokers1 = new GuandanPokers();
            guandanPokers1.setPokers(GuandanUtil.copy(guandanPoker.getPokers()));
            guandanPokers1.setWeight(guandanPoker.getWeight());
            guandanPokers1.setCardType(new CardType(guandanPoker.getCardType().getType(), guandanPoker.getCardType().getWeight()));
            result.add(guandanPokers1);
        }
        return result;
    }

    public static List<List<Poker>> typeCard2(CardType cardType, List<GuandanPokers> guandanPokers, int laiziValue) {
        return GuandanUtil.typeCard2(cardType, guandanPokers, laiziValue, false);
    }

    /*
     * WARNING - void declaration
     */
    public static List<List<Poker>> typeCard2(CardType cardType, List<GuandanPokers> guandanPokers, int laiziValue, boolean qiang) {
        ArrayList<List<Poker>> result = new ArrayList<List<Poker>>();
        if (null == guandanPokers || guandanPokers.isEmpty()) {
            return result;
        }
        Integer type = cardType.getType();
        Integer weight = cardType.getWeight();
        List<GuandanPokers> guandanPokers_copy = GuandanUtil.copy3(guandanPokers);
        for (GuandanPokers guandanPokers2 : guandanPokers_copy) {
            CardType cardType_ = guandanPokers2.getCardType();
            Integer n = cardType_.getWeight();
            Integer type_ = cardType_.getType();
            if (!type_.equals(type) || n <= weight) continue;
            result.add((List<Poker>)guandanPokers2.getPokers());
        }
        switch (type) {
            case 1: {
                HashMap<Integer, List> typeGuandans = new HashMap<Integer, List>();
                for (GuandanPokers guandanPokers3 : guandanPokers) {
                    Integer type_guandanPoker = guandanPokers3.getCardType().getType();
                    List list = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList());
                    list.add(guandanPokers3);
                    typeGuandans.put(type_guandanPoker, list);
                }
                List guandanPokers_sanbudai = (List)typeGuandans.get(4);
                List guandanPokers_duizi = (List)typeGuandans.get(2);
                ArrayList guandanPokers_dheshi = new ArrayList();
                if (null != guandanPokers_sanbudai && !guandanPokers_sanbudai.isEmpty()) {
                    guandanPokers_dheshi.addAll(guandanPokers_sanbudai);
                }
                if (null != guandanPokers_duizi && !guandanPokers_duizi.isEmpty()) {
                    guandanPokers_dheshi.addAll(guandanPokers_duizi);
                }
                if (null == guandanPokers_duizi || guandanPokers_duizi.isEmpty()) break;
                guandanPokers_duizi.removeIf(guandanPokers1 -> guandanPokers1.getCardType().getWeight() <= weight);
                guandanPokers_duizi.removeIf(guandanPokers1 -> guandanPokers1.getCardType().getWeight() < 12);
                for (Serializable pokers : guandanPokers_duizi) {
                    ArrayList<Poker> arrayList = new ArrayList<Poker>();
                    arrayList.add((Poker)((GuandanPokers)pokers).getPokers().get(0));
                    result.add(arrayList);
                }
                break;
            }
            case 2: {
                HashMap<Integer, List> typeGuandans = new HashMap();
                for (GuandanPokers guandanPoker : guandanPokers) {
                    Integer n = guandanPoker.getCardType().getType();
                    List orDefault = typeGuandans.getOrDefault(n, new ArrayList());
                    orDefault.add(guandanPoker);
                    typeGuandans.put(n, orDefault);
                }
                List guandanPokers_sanbudai = (List)typeGuandans.get(4);
                List guandanPokers_gangban = (List)typeGuandans.get(6);
                List guandanPokers_sanliandui = (List)typeGuandans.get(3);
                ArrayList arrayList = new ArrayList();
                if (null != guandanPokers_sanbudai && !guandanPokers_sanbudai.isEmpty()) {
                    arrayList.addAll(guandanPokers_sanbudai);
                }
                if (null != guandanPokers_gangban && !guandanPokers_gangban.isEmpty()) {
                    arrayList.addAll(guandanPokers_gangban);
                }
                if (null != guandanPokers_sanliandui && !guandanPokers_sanliandui.isEmpty() && qiang) {
                    arrayList.addAll(guandanPokers_sanliandui);
                }
                if (qiang) {
                    Serializable pokers;
                    pokers = new ArrayList<Poker>();
                    for (GuandanPokers pokers1 : arrayList) {
                        pokers.addAll(pokers1.getPokers());
                    }
                    List<List<Poker>> list = GuandanUtil.typeCard(cardType, pokers, laiziValue);
                    result.addAll(list);
                    break;
                }
                if (arrayList.isEmpty()) break;
                Iterator<List<Poker>> guandanpokers = new ArrayList();
                for (GuandanPokers pokers4 : arrayList) {
                    CardType cardType1 = pokers4.getCardType();
                    Collection pokers1 = pokers4.getPokers();
                    if (cardType1.getType().equals(4)) {
                        if (cardType1.getWeight() <= weight || cardType1.getWeight() < 13) continue;
                        ArrayList<Poker> add = new ArrayList<Poker>();
                        add.add((Poker)pokers1.get(0));
                        add.add((Poker)pokers1.get(1));
                        result.add(add);
                        continue;
                    }
                    guandanpokers.addAll(GuandanUtil.mergeSame((List<Poker>)pokers1, null, null, null));
                }
                result.addAll(GuandanUtil.typeCard2(cardType, GuandanUtil.convert(guandanpokers, laiziValue, false), laiziValue));
                break;
            }
            case 5: {
                List orDefault;
                Object type_guandanPoker;
                HashMap<Integer, List> typeGuandans = new HashMap();
                for (GuandanPokers guandanPokers4 : guandanPokers) {
                    type_guandanPoker = guandanPokers4.getCardType().getType();
                    orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList());
                    orDefault.add(guandanPokers4);
                    typeGuandans.put((Integer)type_guandanPoker, orDefault);
                }
                List guandanPokers_sanbudai = (List)typeGuandans.get(4);
                List guandanPokers_duizi = (List)typeGuandans.get(2);
                if (null == guandanPokers_sanbudai || null == guandanPokers_duizi) {
                    return result;
                }
                guandanPokers_sanbudai.removeIf(guandanPokers1 -> guandanPokers1.getCardType().getWeight() <= weight);
                if (guandanPokers_sanbudai.isEmpty() || guandanPokers_duizi.isEmpty()) {
                    return result;
                }
                guandanPokers_sanbudai.sort(Comparator.comparingInt(o -> o.getCardType().getWeight()));
                guandanPokers_duizi.sort(Comparator.comparingInt(o -> o.getCardType().getWeight()));
                for (GuandanPokers guandanPokers5 : guandanPokers_duizi) {
                    for (GuandanPokers sanbudai_guandanpokers : guandanPokers_sanbudai) {
                        ArrayList add = new ArrayList();
                        add.addAll(guandanPokers5.getPokers());
                        add.addAll(sanbudai_guandanpokers.getPokers());
                        result.add(add);
                    }
                }
                break;
            }
            case 3: {
                List orDefault;
                Object type_guandanPoker;
                HashMap<Integer, List> typeGuandans = new HashMap();
                for (GuandanPokers guandanPokers6 : guandanPokers) {
                    type_guandanPoker = guandanPokers6.getCardType().getType();
                    orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList());
                    orDefault.add(guandanPokers6);
                    typeGuandans.put((Integer)type_guandanPoker, orDefault);
                }
                List guandanPokers_duizi = (List)typeGuandans.get(2);
                if (null == guandanPokers_duizi) {
                    return result;
                }
                if (guandanPokers_duizi.isEmpty()) {
                    return result;
                }
                if (guandanPokers_duizi.size() < 3) {
                    return result;
                }
                ArrayList<Poker> cards = new ArrayList<Poker>();
                for (GuandanPokers guandanPokers12 : guandanPokers_duizi) {
                    cards.addAll(guandanPokers12.getPokers());
                }
                result.addAll(GuandanUtil.typeCard(cardType, cards, laiziValue));
                break;
            }
            case 6: {
                HashMap<Integer, List> typeGuandans = new HashMap();
                for (GuandanPokers guandanPoker : guandanPokers) {
                    Integer type_guandanPoker = guandanPoker.getCardType().getType();
                    List orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList());
                    orDefault.add(guandanPoker);
                    typeGuandans.put(type_guandanPoker, orDefault);
                }
                List guandanPokers_sanbudai = (List)typeGuandans.get(4);
                if (null == guandanPokers_sanbudai) {
                    return result;
                }
                if (guandanPokers_sanbudai.isEmpty()) {
                    return result;
                }
                if (guandanPokers_sanbudai.size() < 2) {
                    return result;
                }
                ArrayList<Poker> cards = new ArrayList();
                for (GuandanPokers guandanPokers12 : guandanPokers_sanbudai) {
                    cards.addAll(guandanPokers12.getPokers());
                }
                result.addAll(GuandanUtil.typeCard(cardType, cards, laiziValue));
            }
        }
        if (!result.isEmpty() && result.size() > 1) {
            void var14_17;
            HashSet<Integer> hash = new HashSet<Integer>();
            int n = result.size() - 1;
            while (var14_17 >= 0) {
                List pokers3 = (List)result.get((int)var14_17);
                int n2 = GuandanUtil.hashCode(pokers3);
                if (hash.contains(n2)) {
                    result.remove((int)var14_17);
                } else {
                    hash.add(n2);
                }
                --var14_17;
            }
        }
        return result;
    }

    public static List<GuandanPokers> convert(Collection<List<Poker>> pokersArr, int laiziValue) {
        return GuandanUtil.convert(pokersArr, laiziValue, true);
    }

    public static List<GuandanPokers> convert(Collection<List<Poker>> pokersArr, int laiziValue, boolean sort) {
        ArrayList<GuandanPokers> resultArr = new ArrayList<GuandanPokers>();
        for (List<Poker> pokers : pokersArr) {
            CardType cardType1 = GuandanUtil.cardType(pokers, laiziValue);
            GuandanPokers guandanPokers1 = new GuandanPokers();
            guandanPokers1.setPokers(pokers);
            guandanPokers1.setCardType(cardType1);
            guandanPokers1.setWeight(GuandanUtil.getPokerWeight(cardType1, pokers));
            resultArr.add(guandanPokers1);
        }
        if (sort) {
            resultArr.sort(Comparator.comparingInt(a -> a.getCardType().getWeight()));
        }
        return resultArr;
    }

    public static List<GuandanPokers> guandanConvert(Collection<List<GuandanPokers>> pokersArr, int laiziValue) {
        return GuandanUtil.guandanConvert(pokersArr, laiziValue, true);
    }

    public static List<GuandanPokers> guandanConvert(Collection<List<GuandanPokers>> pokersArr, int laiziValue, boolean sort) {
        ArrayList<GuandanPokers> resultArr = new ArrayList<GuandanPokers>();
        for (List<GuandanPokers> pokers : pokersArr) {
            for (GuandanPokers poker : pokers) {
                Collection pokers1 = poker.getPokers();
                CardType cardType1 = GuandanUtil.cardType((List<Poker>)pokers1, laiziValue);
                GuandanPokers guandanPokers1 = new GuandanPokers();
                guandanPokers1.setPokers((List<Poker>)pokers1);
                guandanPokers1.setCardType(cardType1);
                guandanPokers1.setWeight(GuandanUtil.getPokerWeight(cardType1, (List<Poker>)pokers1));
                resultArr.add(guandanPokers1);
            }
        }
        if (sort) {
            resultArr.sort(Comparator.comparingInt(a -> a.getCardType().getWeight()));
        }
        return resultArr;
    }

    public static List<List<Poker>> typeCard(CardType cardType, List<Poker> handCards, int laiziValue) {
        ArrayList<List<Poker>> result = new ArrayList<List<Poker>>();
        if (null == handCards || handCards.isEmpty()) {
            return result;
        }
        List<Poker> handCards_copy = GuandanUtil.copy(handCards);
        Integer type = cardType.getType();
        Integer weight = cardType.getWeight();
        int ssss = 1;
        switch (type) {
            case 10: {
                return result;
            }
            case 1: {
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(handCards_copy);
                Set<Integer> values = pokerMapByValue.keySet();
                for (Integer value : values) {
                    int pokerDaXiao;
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao(value, laiziValue)) <= weight) continue;
                    ArrayList<Poker> add = new ArrayList<Poker>();
                    add.add(pokers.get(0));
                    result.add(add);
                }
                break;
            }
            case 2: {
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiZiNot);
                Set<Integer> values = pokerMapByValue.keySet();
                ssss = 2;
                for (Integer value : values) {
                    int pokerDaXiao;
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi.size() < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao(value, laiziValue)) <= weight) continue;
                    ArrayList add = new ArrayList();
                    if (size < ssss) {
                        ArrayList pokers2 = new ArrayList(laiZi.subList(0, ssss - size));
                        add.addAll(pokers2);
                    }
                    add.addAll(new ArrayList<Poker>(pokers.subList(0, ssss - add.size())));
                    result.add(add);
                }
                if (laiZi.size() < ssss) break;
                ArrayList add = new ArrayList(laiZi.subList(0, ssss));
                result.add(add);
                break;
            }
            case 4: {
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiZiNot);
                Set<Integer> values = pokerMapByValue.keySet();
                ssss = 3;
                for (Integer value : values) {
                    int pokerDaXiao;
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi.size() < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao(value, laiziValue)) <= weight) continue;
                    ArrayList add = new ArrayList();
                    if (size < ssss) {
                        ArrayList pokers2 = new ArrayList(laiZi.subList(0, ssss - size));
                        add.addAll(pokers2);
                    }
                    add.addAll(new ArrayList<Poker>(pokers.subList(0, ssss - add.size())));
                    result.add(add);
                }
                break;
            }
            case 9: {
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiZiNot);
                Set<Integer> values = pokerMapByValue.keySet();
                ssss = 4;
                for (Integer value : values) {
                    int maxsize;
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi.size() < ssss) continue;
                    int pokerDaXiao = GuandanUtil.getPokerDaXiao(value, laiziValue);
                    int myweight = pokerDaXiao + (maxsize - ((maxsize = Math.max(size + laiZi.size(), size)) > 5 ? 2 : 3)) * 100;
                    if (myweight <= weight) continue;
                    ArrayList add = new ArrayList();
                    if (size < maxsize) {
                        ArrayList pokers2 = new ArrayList(laiZi.subList(0, maxsize - size));
                        add.addAll(pokers2);
                    }
                    add.addAll(pokers);
                    result.add(add);
                }
                break;
            }
            case 5: {
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiZiNot);
                Set<Integer> values = pokerMapByValue.keySet();
                for (Integer value : values) {
                    int pokerDaXiao;
                    ssss = 3;
                    List<Poker> laiZi_copy = GuandanUtil.copy(laiZi);
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi_copy.size() < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao(value, laiziValue)) <= weight) continue;
                    ArrayList<Poker> add = new ArrayList<Poker>();
                    if (size < ssss) {
                        ArrayList<Poker> cards1 = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - size));
                        laiZi_copy.removeAll(cards1);
                        add.addAll(cards1);
                    }
                    add.addAll(new ArrayList<Poker>(pokers.subList(0, ssss - add.size())));
                    ssss = 2;
                    for (Integer value2 : values) {
                        List<Poker> pokers2;
                        int size2;
                        if (value2.equals(value) || (size2 = (pokers2 = pokerMapByValue.get(value2)).size()) + laiZi_copy.size() < ssss) continue;
                        ArrayList<Poker> add2 = new ArrayList<Poker>();
                        if (size2 < ssss) {
                            ArrayList<Poker> cards2 = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - size2));
                            add2.addAll(cards2);
                        }
                        add2.addAll(new ArrayList<Poker>(pokers2.subList(0, ssss - add2.size())));
                        add2.addAll(add);
                        result.add(add2);
                    }
                }
                break;
            }
            case 3: {
                int min;
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiZiNot);
                ssss = 2;
                if (pokerMapByValue.containsKey(1)) {
                    pokerMapByValue.put(14, pokerMapByValue.get(1));
                }
                for (int i = min = Math.max(weight - 1, 1); i < 13; ++i) {
                    ArrayList<Poker> pokers;
                    List<Poker> laiZi_copy = GuandanUtil.copy(laiZi);
                    List poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList());
                    List poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList());
                    List poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList());
                    poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                    poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                    poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));
                    if (poker1.size() + poker2.size() + poker3.size() + laiZi_copy.size() < 3 * ssss) continue;
                    ArrayList add = new ArrayList();
                    add.addAll(poker1);
                    add.addAll(poker2);
                    add.addAll(poker3);
                    if (poker1.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker1.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    if (poker2.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker2.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    if (poker3.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker3.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    result.add(add);
                }
                break;
            }
            case 6: {
                int min;
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiZiNot);
                ssss = 3;
                if (pokerMapByValue.containsKey(1)) {
                    pokerMapByValue.put(14, pokerMapByValue.get(1));
                }
                for (int i = min = Math.max(weight, 1); i < 14; ++i) {
                    ArrayList<Poker> pokers;
                    List<Poker> laiZi_copy = GuandanUtil.copy(laiZi);
                    List poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList());
                    List poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList());
                    poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                    poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                    if (poker1.size() + poker2.size() + laiZi_copy.size() < 2 * ssss) continue;
                    ArrayList add = new ArrayList();
                    add.addAll(poker1);
                    add.addAll(poker2);
                    if (poker1.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker1.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    if (poker2.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker2.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    result.add(add);
                }
                break;
            }
            case 7: {
                int min;
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiZiNot);
                ssss = 1;
                if (pokerMapByValue.containsKey(1)) {
                    pokerMapByValue.put(14, pokerMapByValue.get(1));
                }
                for (int i = min = Math.max(weight - 3, 1); i < 11; ++i) {
                    ArrayList<Poker> pokers;
                    List<Poker> laiZi_copy = GuandanUtil.copy(laiZi);
                    List poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList());
                    List poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList());
                    List poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList());
                    List poker4 = pokerMapByValue.getOrDefault(i + 3, new ArrayList());
                    List poker5 = pokerMapByValue.getOrDefault(i + 4, new ArrayList());
                    poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                    poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                    poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));
                    poker4 = poker4.subList(0, Math.min(poker4.size(), ssss));
                    poker5 = poker5.subList(0, Math.min(poker5.size(), ssss));
                    if (poker1.size() + poker2.size() + poker3.size() + poker4.size() + poker5.size() + laiZi_copy.size() < 5 * ssss) continue;
                    ArrayList add = new ArrayList();
                    add.addAll(poker1);
                    add.addAll(poker2);
                    add.addAll(poker3);
                    add.addAll(poker4);
                    add.addAll(poker5);
                    if (poker1.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker1.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    if (poker2.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker2.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    if (poker3.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker3.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    if (poker4.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker4.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    if (poker5.size() < ssss) {
                        pokers = new ArrayList<Poker>(laiZi_copy.subList(0, ssss - poker5.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    result.add(add);
                }
                break;
            }
            case 8: {
                Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(handCards_copy, laiziValue);
                List laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                List laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                Map<Integer, List<Poker>> pokerMapByColor = GuandanUtil.getPokerMapByColor(laiZiNot);
                for (List<Poker> value : pokerMapByColor.values()) {
                    List<Poker> arrayList = GuandanUtil.copy(value);
                    arrayList.addAll(laiZi);
                    CardType cardType1 = new CardType();
                    cardType1.setType(7);
                    cardType1.setWeight(weight - 300);
                    List<List<Poker>> lists = GuandanUtil.typeCard(cardType1, arrayList, laiziValue);
                    if (lists.isEmpty()) continue;
                    result.addAll(lists);
                }
                break;
            }
        }
        return result;
    }

    private static List<GuandanPokers> bestCards(List<Poker> handCards, int laiziValue) {
        GuandanPokersWeight guandanPokersWeight = GuandanUtil.arrangePoker(handCards, laiziValue);
        List<GuandanPokers> guandanPokers = guandanPokersWeight.getGuandanPokers();
        guandanPokers.sort((o1, o2) -> {
            CardType cardType1 = o1.getCardType();
            CardType cardType2 = o2.getCardType();
            if (cardType1.getWeight().equals(cardType2.getWeight())) {
                return Integer.compare(cardType1.getType(), cardType2.getType());
            }
            return Integer.compare(cardType1.getWeight(), cardType2.getWeight());
        });
        return guandanPokers;
    }

    /*
     * Could not resolve type clashes
     */
    public static List<List<GuandanPokers>> typeCard3(CardType cardType, List<GuandanPokers> handCards, int laiziValue) {
        ArrayList<List<GuandanPokers>> result = new ArrayList<List<GuandanPokers>>();
        if (null == handCards || handCards.isEmpty()) {
            return result;
        }
        ArrayList<Poker> pokerList = new ArrayList<Poker>();
        for (GuandanPokers handCard : handCards) {
            pokerList.addAll(handCard.getPokers());
        }
        List<GuandanPokers> bestCards = GuandanUtil.bestCards(pokerList, laiziValue);
        block13: for (GuandanPokers bestCard : bestCards) {
            ArrayList cards2;
            ArrayList add2;
            List<GuandanPokers> pokers2;
            int size2;
            ArrayList cards1;
            int size;
            List<GuandanPokers> pokers;
            ArrayList laiZi_copy;
            ArrayList add;
            Set<Integer> values;
            Map<Integer, List<GuandanPokers>> pokerMapByValue;
            List laiZi;
            List laiZiNot;
            Map<Integer, List<GuandanPokers>> laiZiOrNot;
            int ssss;
            CardType cardType1 = bestCard.getCardType();
            Integer type = cardType.getType();
            Integer weight = cardType.getWeight();
            if (type.equals(5)) {
                ssss = 0;
                laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                values = pokerMapByValue.keySet();
                for (Object value : values) {
                    add = new ArrayList();
                    ssss = 3;
                    laiZi_copy = new ArrayList(laiZi);
                    pokers = pokerMapByValue.get(value);
                    size = pokers.size();
                    if (size == 3) {
                        int pokerDaXiao;
                        if (size + laiZi_copy.size() < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao((Integer)value, laiziValue)) <= weight) continue;
                        if (size < ssss) {
                            cards1 = new ArrayList(laiZi_copy.subList(0, ssss - size));
                            laiZi_copy.removeAll(cards1);
                            add.addAll(cards1);
                        }
                        add.addAll(new ArrayList<GuandanPokers>(pokers.subList(0, ssss - add.size())));
                    }
                    ssss = 2;
                    for (Integer value2 : values) {
                        if (value2.equals(value) || (size2 = (pokers2 = pokerMapByValue.get(value2)).size()) != 2 || size2 + laiZi_copy.size() < ssss) continue;
                        add2 = new ArrayList();
                        if (size2 < ssss) {
                            cards2 = new ArrayList(laiZi_copy.subList(0, ssss - size2));
                            add2.addAll(cards2);
                        }
                        add2.addAll(new ArrayList<GuandanPokers>(pokers2.subList(0, ssss - add2.size())));
                        add2.addAll(add);
                        result.add(add2);
                    }
                }
            }
            if (!cardType1.getType().equals(type)) continue;
            switch (type) {
                case 10: {
                    return result;
                }
                case 1: {
                    Iterator<Integer> app;
                    Object value;
                    ssss = 0;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    Map<Integer, List<GuandanPokers>> guandanPokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(bestCards);
                    values = guandanPokerMapByValue.keySet();
                    ssss = 1;
                    value = values.iterator();
                    while (value.hasNext()) {
                        int pokerDaXiao;
                        Object value2 = value.next();
                        List<GuandanPokers> pokers3 = guandanPokerMapByValue.get(value2);
                        int size3 = pokers3.size();
                        if (pokers3.size() != 1 || size3 < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao((Integer)value2, laiziValue)) <= weight) continue;
                        ArrayList<GuandanPokers> add3 = new ArrayList<GuandanPokers>();
                        add3.add(pokers3.get(0));
                        result.add(add3);
                    }
                    continue block13;
                }
                case 2: {
                    List<GuandanPokers> pokers4;
                    Iterator<Integer> app;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList<GuandanPokers>();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    values = pokerMapByValue.keySet();
                    ssss = 2;
                    for (Object value : values) {
                        int pokerDaXiao;
                        pokers4 = pokerMapByValue.get(value);
                        int size4 = pokers4.size();
                        if (size4 != 2 || size4 + laiZi.size() < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao((Integer)value, laiziValue)) <= weight) continue;
                        ArrayList add4 = new ArrayList();
                        if (size4 < ssss) {
                            ArrayList pokers22 = new ArrayList(laiZi.subList(0, ssss - size4));
                            add4.addAll(pokers22);
                        }
                        add4.addAll(new ArrayList<GuandanPokers>(pokers4.subList(0, ssss - add4.size())));
                        result.add(add4);
                    }
                    if (laiZi.size() < ssss) break;
                    ArrayList add5 = new ArrayList(laiZi.subList(0, ssss));
                    result.add(add5);
                    break;
                }
                case 4: {
                    List<GuandanPokers> pokers4;
                    Iterator<Integer> app;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    values = pokerMapByValue.keySet();
                    ssss = 3;
                    for (Object value : values) {
                        int pokerDaXiao;
                        pokers4 = pokerMapByValue.get(value);
                        int size5 = pokers4.size();
                        if (size5 != 3 || size5 + laiZi.size() < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao((Integer)value, laiziValue)) <= weight) continue;
                        ArrayList add6 = new ArrayList();
                        if (size5 > ssss) {
                            ArrayList pokers23 = new ArrayList(laiZi.subList(0, ssss - size5));
                            add6.addAll(pokers23);
                        }
                        add6.addAll(new ArrayList<GuandanPokers>(pokers4.subList(0, ssss - add6.size())));
                        result.add(add6);
                    }
                    continue block13;
                }
                case 9: {
                    List<GuandanPokers> pokers4;
                    Iterator<Integer> app;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    values = pokerMapByValue.keySet();
                    ssss = 4;
                    for (Object value : values) {
                        int maxsize;
                        pokers4 = pokerMapByValue.get(value);
                        int size6 = pokers4.size();
                        if (size6 + laiZi.size() < ssss) continue;
                        int pokerDaXiao = GuandanUtil.getPokerDaXiao((Integer)value, laiziValue);
                        int myweight = pokerDaXiao + (maxsize - ((maxsize = Math.max(size6 + laiZi.size(), size6)) > 5 ? 2 : 3)) * 100;
                        if (myweight <= weight) continue;
                        ArrayList<GuandanPokers> add7 = new ArrayList<GuandanPokers>();
                        if (size6 < maxsize) {
                            pokers2 = new ArrayList<GuandanPokers>(laiZi.subList(0, maxsize - size6));
                            add7.addAll(pokers2);
                        }
                        add7.addAll(pokers4);
                        result.add(add7);
                    }
                    continue block13;
                }
                case 5: {
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    values = pokerMapByValue.keySet();
                    for (Object value : values) {
                        add = new ArrayList();
                        ssss = 3;
                        laiZi_copy = new ArrayList(laiZi);
                        pokers = pokerMapByValue.get(value);
                        size = pokers.size();
                        if (size == 3) {
                            int pokerDaXiao;
                            if (size + laiZi_copy.size() < ssss || (pokerDaXiao = GuandanUtil.getPokerDaXiao((Integer)value, laiziValue)) <= weight) continue;
                            if (size < ssss) {
                                cards1 = new ArrayList(laiZi_copy.subList(0, ssss - size));
                                laiZi_copy.removeAll(cards1);
                                add.addAll(cards1);
                            }
                            add.addAll(new ArrayList<GuandanPokers>(pokers.subList(0, ssss - add.size())));
                        }
                        ssss = 2;
                        for (Integer value2 : values) {
                            if (value2.equals(value) || (size2 = (pokers2 = pokerMapByValue.get(value2)).size()) != 2 || size2 + laiZi_copy.size() < ssss) continue;
                            add2 = new ArrayList();
                            if (size2 < ssss) {
                                cards2 = new ArrayList(laiZi_copy.subList(0, ssss - size2));
                                add2.addAll(cards2);
                            }
                            add2.addAll(new ArrayList<GuandanPokers>(pokers2.subList(0, ssss - add2.size())));
                            add2.addAll(add);
                            result.add(add2);
                        }
                    }
                    continue block13;
                }
                case 3: {
                    List poker2;
                    List poker1;
                    ArrayList laiZi_copy2;
                    int min;
                    Iterator<Integer> app;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    ssss = 2;
                    if (pokerMapByValue.containsKey(1)) {
                        pokerMapByValue.put(14, pokerMapByValue.get(1));
                    }
                    for (int i = min = Math.max(weight - 1, 1); i < 13; ++i) {
                        ArrayList pokers5;
                        laiZi_copy2 = new ArrayList(laiZi);
                        poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList());
                        poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList());
                        List poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList());
                        poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                        poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                        poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));
                        if (poker1.size() + poker2.size() + poker3.size() + laiZi_copy2.size() < 3 * ssss) continue;
                        ArrayList add8 = new ArrayList();
                        add8.addAll(poker1);
                        add8.addAll(poker2);
                        add8.addAll(poker3);
                        if (poker1.size() < ssss) {
                            pokers5 = new ArrayList(laiZi_copy2.subList(0, ssss - poker1.size()));
                            laiZi_copy2.removeAll(pokers5);
                            add8.addAll(pokers5);
                        }
                        if (poker2.size() < ssss) {
                            pokers5 = new ArrayList(laiZi_copy2.subList(0, ssss - poker2.size()));
                            laiZi_copy2.removeAll(pokers5);
                            add8.addAll(pokers5);
                        }
                        if (poker3.size() < ssss) {
                            pokers5 = new ArrayList(laiZi_copy2.subList(0, ssss - poker3.size()));
                            laiZi_copy2.removeAll(pokers5);
                            add8.addAll(pokers5);
                        }
                        result.add(add8);
                    }
                    continue block13;
                }
                case 6: {
                    int max;
                    List poker2;
                    List poker1;
                    ArrayList laiZi_copy2;
                    Iterator<Integer> app;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    ssss = 3;
                    if (pokerMapByValue.containsKey(1)) {
                        pokerMapByValue.put(14, pokerMapByValue.get(1));
                    }
                    for (int i = max = Math.max(weight, 1); i < 14; ++i) {
                        ArrayList pokers6;
                        laiZi_copy2 = new ArrayList(laiZi);
                        poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList());
                        poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList());
                        poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                        poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                        if (poker1.size() + poker2.size() + laiZi_copy2.size() < 2 * ssss) continue;
                        ArrayList add9 = new ArrayList();
                        add9.addAll(poker1);
                        add9.addAll(poker2);
                        if (poker1.size() < ssss) {
                            pokers6 = new ArrayList(laiZi_copy2.subList(0, ssss - poker1.size()));
                            laiZi_copy2.removeAll(pokers6);
                            add9.addAll(pokers6);
                        }
                        if (poker2.size() < ssss) {
                            pokers6 = new ArrayList(laiZi_copy2.subList(0, ssss - poker2.size()));
                            laiZi_copy2.removeAll(pokers6);
                            add9.addAll(pokers6);
                        }
                        result.add(add9);
                    }
                    continue block13;
                }
                case 7: {
                    int max;
                    List poker2;
                    List poker1;
                    ArrayList laiZi_copy2;
                    Iterator<Integer> app;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    pokerMapByValue = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    ssss = 1;
                    if (pokerMapByValue.containsKey(1)) {
                        pokerMapByValue.put(14, pokerMapByValue.get(1));
                    }
                    for (int i = max = Math.max(weight - 3, 1); i < 11; ++i) {
                        ArrayList pokers7;
                        laiZi_copy2 = new ArrayList(laiZi);
                        poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList());
                        poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList());
                        List poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList());
                        List poker4 = pokerMapByValue.getOrDefault(i + 3, new ArrayList());
                        List poker5 = pokerMapByValue.getOrDefault(i + 4, new ArrayList());
                        if (poker1.size() == 1) {
                            poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                        }
                        if (poker2.size() == 1) {
                            poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                        }
                        if (poker3.size() == 1) {
                            poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));
                        }
                        if (poker4.size() == 1) {
                            poker4 = poker4.subList(0, Math.min(poker4.size(), ssss));
                        }
                        if (poker5.size() == 1) {
                            poker5 = poker5.subList(0, Math.min(poker5.size(), ssss));
                        }
                        if (poker1.size() + poker2.size() + poker3.size() + poker4.size() + poker5.size() + laiZi_copy2.size() < 5 * ssss) continue;
                        ArrayList add10 = new ArrayList();
                        add10.addAll(poker1);
                        add10.addAll(poker2);
                        add10.addAll(poker3);
                        add10.addAll(poker4);
                        add10.addAll(poker5);
                        if (poker1.size() != 0 && poker1.size() < ssss) {
                            pokers7 = new ArrayList(laiZi_copy2.subList(0, ssss - poker1.size()));
                            laiZi_copy2.removeAll(pokers7);
                            add10.addAll(pokers7);
                        }
                        if (poker2.size() != 0 && poker2.size() < ssss) {
                            pokers7 = new ArrayList(laiZi_copy2.subList(0, ssss - poker2.size()));
                            laiZi_copy2.removeAll(pokers7);
                            add10.addAll(pokers7);
                        }
                        if (poker3.size() != 0 && poker3.size() < ssss) {
                            pokers7 = new ArrayList(laiZi_copy2.subList(0, ssss - poker3.size()));
                            laiZi_copy2.removeAll(pokers7);
                            add10.addAll(pokers7);
                        }
                        if (poker4.size() != 0 && poker4.size() < ssss) {
                            pokers7 = new ArrayList(laiZi_copy2.subList(0, ssss - poker4.size()));
                            laiZi_copy2.removeAll(pokers7);
                            add10.addAll(pokers7);
                        }
                        if (poker5.size() != 0 && poker5.size() < ssss) {
                            pokers7 = new ArrayList(laiZi_copy2.subList(0, ssss - poker5.size()));
                            laiZi_copy2.removeAll(pokers7);
                            add10.addAll(pokers7);
                        }
                        result.add(add10);
                    }
                    continue block13;
                }
                case 8: {
                    Iterator<Integer> app;
                    if (cardType1.getWeight() > weight) {
                        app = new ArrayList();
                        app.add((Integer)((Object)bestCard));
                        result.add((List<GuandanPokers>)((Object)app));
                        break;
                    }
                    laiZiOrNot = GuandanUtil.getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
                    Map<Integer, List<GuandanPokers>> pokerMapByColor = GuandanUtil.getGuandanPokerMapByValue(laiZiNot);
                    for (Object value2 : pokerMapByColor.values()) {
                        ArrayList<GuandanPokers> arrayList = new ArrayList<GuandanPokers>((Collection<GuandanPokers>)value2);
                        arrayList.addAll(laiZi);
                        CardType cardType2 = new CardType();
                        cardType2.setType(7);
                        cardType2.setWeight(weight - 300);
                        List<List<GuandanPokers>> lists = GuandanUtil.typeCard3(cardType2, arrayList, laiziValue);
                        if (lists.isEmpty()) continue;
                        result.addAll(lists);
                    }
                    break;
                }
            }
        }
        return result;
    }

    public static void quchong(List<List<Poker>> cards) {
        if (null == cards || cards.isEmpty() || cards.size() < 2) {
            return;
        }
        HashSet<Integer> hash = new HashSet<Integer>();
        for (int i = 0; i < cards.size(); ++i) {
            List<Poker> pokers = cards.get(i);
            int hashCode = GuandanUtil.hashCode(pokers);
            if (!hash.contains(hashCode)) {
                hash.add(hashCode);
                continue;
            }
            cards.remove(i--);
        }
    }

    public static List<List<Poker>> getBoom(CardType cardType, List<GuandanPokers> guandanPokers) {
        ArrayList<GuandanPokers> guandanPokers_new = new ArrayList<GuandanPokers>();
        for (GuandanPokers guandanPoker : guandanPokers) {
            boolean b;
            CardType cardType1 = guandanPoker.getCardType();
            if (!cardType1.getType().equals(9) && !cardType1.getType().equals(8) && !cardType1.getType().equals(10) || !(b = GuandanUtil.comparePoker(guandanPoker.getCardType(), cardType))) continue;
            guandanPokers_new.add(guandanPoker);
        }
        guandanPokers_new.sort(Comparator.comparingInt(a -> a.getCardType().getWeight()));
        return CollectUtil.getArr(guandanPokers_new, GuandanPokers::getPokers);
    }

    public static List<List<Poker>> getBoom(List<Poker> cards, int laiziValue) {
        return GuandanUtil.getBoom(cards, laiziValue, false, true);
    }

    public static List<List<Poker>> getBoom(List<Poker> cards, int laiziValue, boolean cross, boolean sort) {
        List<List<Poker>> result = new ArrayList<List<Poker>>();
        List<Poker> copy = GuandanUtil.copy(cards);
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(copy, laiziValue);
        List<Poker> laizi = laiZiOrNot.get(1);
        List<Poker> laiziNot = laiZiOrNot.get(2);
        Map<Integer, List<Poker>> pokerMapByValue = GuandanUtil.getPokerMapByValue(laiziNot);
        for (List<Poker> pokers : pokerMapByValue.values()) {
            if (!cross) {
                if (pokers.size() >= 4) {
                    result.add(pokers);
                    continue;
                }
                if (pokers.size() + laizi.size() < 4) continue;
                pokers.addAll(laizi);
                result.add(pokers);
                continue;
            }
            if (pokers.size() + laizi.size() < 4) continue;
            pokers.addAll(laizi);
            for (int i = 3; i < pokers.size(); ++i) {
                result.add(new ArrayList<Poker>(pokers.subList(0, i + 1)));
            }
        }
        List<List<Poker>> sameCards = GuandanUtil.optimalSingleLineSameColor(copy, laiziValue);
        result.addAll(sameCards);
        List<List<Poker>> bomKing = GuandanUtil.getBomKing(copy);
        result.addAll(bomKing);
        if (sort) {
            result = CollectUtil.getArr(GuandanUtil.convert(result, laiziValue, true), GuandanPokers::getPokers);
        }
        return result;
    }

    public static List<List<Poker>> freePlay(List<GuandanPokers> guandanPokers) {
        ArrayList<List<Poker>> result = new ArrayList<List<Poker>>();
        for (GuandanPokers guandanPoker : guandanPokers) {
            result.add((List<Poker>)guandanPoker.getPokers());
        }
        return result;
    }

    public static CardType cardType(List<Poker> cards, int laiziValue) {
        return GuandanUtil.cardType(cards, laiziValue, null);
    }

    public static CardType cardType(List<Poker> cards, int laiziValue, Boolean liandui) {
        cards.sort(Comparator.comparingInt(Poker::getValue));
        CardType cardType = new CardType();
        cardType.setType(-1);
        cardType.setWeight(0);
        int sizeCards = cards.size();
        Map<Integer, List<Poker>> laiZiOrNot = GuandanUtil.getLaiZiOrNot(cards, laiziValue);
        List cardsLaiZi = laiZiOrNot.getOrDefault(1, new ArrayList());
        int sizeLaiZi = cardsLaiZi.size();
        List cardsLaiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList());
        int sizeLaiZiNot = cardsLaiZiNot.size();
        List king = laiZiOrNot.getOrDefault(3, new ArrayList());
        boolean yitiaolong = false;
        if (king.isEmpty()) {
            yitiaolong = GuandanUtil.yitiaolong(cardsLaiZiNot);
        } else {
            boolean bl = yitiaolong = cardsLaiZiNot.isEmpty() && cardsLaiZi.isEmpty() && GuandanUtil.yitiaolong(king);
        }
        if (sizeCards == 0) {
            cardType.setType(0);
        } else if (sizeCards == 1) {
            cardType.setType(1);
            cardType.setWeight(GuandanUtil.getPokerDaXiao(cards.get(0), laiziValue));
        } else if (sizeCards == 2 && yitiaolong) {
            cardType.setType(2);
            if (sizeLaiZiNot == 0) {
                cardType.setWeight(GuandanUtil.getPokerDaXiao(cards.get(0), laiziValue));
            } else {
                cardType.setWeight(GuandanUtil.getPokerDaXiao((Poker)cardsLaiZiNot.get(0), laiziValue));
            }
        } else if (sizeCards == 3 && yitiaolong) {
            cardType.setType(4);
            if (sizeLaiZiNot == 0) {
                cardType.setWeight(GuandanUtil.getPokerDaXiao(cards.get(0), laiziValue));
            } else {
                cardType.setWeight(GuandanUtil.getPokerDaXiao((Poker)cardsLaiZiNot.get(0), laiziValue));
            }
        } else if (sizeCards >= 4 && yitiaolong) {
            cardType.setType(9);
            int daxiao = 0;
            daxiao = sizeLaiZiNot == 0 ? GuandanUtil.getPokerDaXiao(cards.get(0), laiziValue) : GuandanUtil.getPokerDaXiao((Poker)cardsLaiZiNot.get(0), laiziValue);
            int a = 3;
            if (sizeCards > 5) {
                a = 2;
            }
            cardType.setWeight(daxiao + (sizeCards - a) * 100);
        } else if (sizeCards == 4) {
            Map<Integer, List<Poker>> pokerMap = GuandanUtil.getPokerMapByValue(cards);
            List<Poker> dawang = pokerMap.get(100);
            List<Poker> xiaowang = pokerMap.get(99);
            if (null != dawang && null != xiaowang && dawang.size() == 2 && dawang.size() == xiaowang.size()) {
                cardType.setType(10);
                cardType.setWeight(1000);
            }
        } else if (sizeCards == 5) {
            List<Poker> shunzi = GuandanUtil.getShunzi(cardsLaiZiNot, sizeLaiZi);
            if (!shunzi.isEmpty()) {
                if (GuandanUtil.sameColor(cardsLaiZiNot)) {
                    cardType.setType(8);
                    cardType.setWeight(GuandanUtil.getPokerDaXiao(shunzi.get(shunzi.size() - 1), -1) + 300);
                } else {
                    cardType.setType(7);
                    cardType.setWeight(GuandanUtil.getPokerDaXiao(shunzi.get(shunzi.size() - 1), -1));
                }
            } else {
                Map<Integer, List<Poker>> pokerMap = GuandanUtil.getPokerMapByValue(cardsLaiZiNot);
                Set pokerSet = CollectUtil.getSet((Collection)cardsLaiZiNot, Poker::getValue);
                Set pokerSet_king = CollectUtil.getSet((Collection)king, Poker::getValue);
                if (pokerSet.size() + pokerSet_king.size() == 2) {
                    boolean isSandaier = false;
                    int maxvalue = -1;
                    for (List<Poker> pokers : pokerMap.values()) {
                        if (pokers.size() > 3) break;
                        if (pokers.size() != 3 && pokers.size() + sizeLaiZi != 3) continue;
                        Integer value = pokers.get(0).getValue();
                        if (maxvalue < value) {
                            maxvalue = value;
                        }
                        isSandaier = true;
                    }
                    if (isSandaier) {
                        cardType.setType(5);
                        cardType.setWeight(GuandanUtil.getPokerDaXiao(maxvalue, laiziValue));
                    }
                }
            }
        } else if (sizeCards == 6) {
            if (null != liandui && liandui.booleanValue()) {
                List<Poker> lianDui = GuandanUtil.getLianDui(cardsLaiZiNot, sizeLaiZi);
                if (!lianDui.isEmpty()) {
                    cardType.setType(3);
                    cardType.setWeight(GuandanUtil.getPokerDaXiao(lianDui.get(lianDui.size() - 1), -1));
                } else {
                    List<Poker> gangban = GuandanUtil.getGangban(cardsLaiZiNot, sizeLaiZi);
                    if (!gangban.isEmpty()) {
                        cardType.setType(6);
                        cardType.setWeight(GuandanUtil.getPokerDaXiao(gangban.get(gangban.size() - 1), -1));
                    }
                }
            } else {
                List<Poker> gangban = GuandanUtil.getGangban(cardsLaiZiNot, sizeLaiZi);
                if (!gangban.isEmpty()) {
                    cardType.setType(6);
                    cardType.setWeight(GuandanUtil.getPokerDaXiao(gangban.get(gangban.size() - 1), -1));
                } else {
                    List<Poker> lianDui = GuandanUtil.getLianDui(cardsLaiZiNot, sizeLaiZi);
                    if (!lianDui.isEmpty()) {
                        cardType.setType(3);
                        cardType.setWeight(GuandanUtil.getPokerDaXiao(lianDui.get(lianDui.size() - 1), -1));
                    }
                }
            }
        }
        return cardType;
    }

    public static int hashCode(Poker poker) {
        return Objects.hash(poker.getColor(), poker.getValue());
    }

    public static int hashCode2(List<List<Poker>> pokersList) {
        ArrayList<Integer> arr = new ArrayList<Integer>(pokersList.size());
        for (int i = 0; i < pokersList.size(); ++i) {
            arr.add(GuandanUtil.hashCode(pokersList.get(i)));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
    }

    public static int hashCode(Map<Integer, List<Poker>> pokerMap) {
        ArrayList<Integer> arr = new ArrayList<Integer>(pokerMap.size());
        for (Integer integer : pokerMap.keySet()) {
            arr.add(Objects.hash(integer, GuandanUtil.hashCode(pokerMap.get(integer))));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
    }

    public static int hashCode(List<Poker> pokers) {
        ArrayList<Integer> arr = new ArrayList<Integer>(pokers.size());
        for (int i = 0; i < pokers.size(); ++i) {
            arr.add(GuandanUtil.hashCode(pokers.get(i)));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
    }

    public static int hashCode2_value(List<List<Poker>> pokersList) {
        ArrayList<Integer> arr = new ArrayList<Integer>(pokersList.size());
        for (int i = 0; i < pokersList.size(); ++i) {
            arr.add(GuandanUtil.hashCode_value(pokersList.get(i)));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
    }

    public static int hashCode_value(Map<Integer, List<Poker>> pokerMap) {
        ArrayList<Integer> arr = new ArrayList<Integer>(pokerMap.size());
        for (Integer integer : pokerMap.keySet()) {
            arr.add(Objects.hash(integer, GuandanUtil.hashCode_value(pokerMap.get(integer))));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
    }

    public static int hashCode_value(List<Poker> pokers) {
        List arr = CollectUtil.getArr(pokers, Poker::getValue);
        arr.sort(Integer::compareTo);
        return arr.hashCode();
    }

    public static List<GuandanPokers> getBestSort(List<GuandanPokers> bestCards, int laiziValue) {
        ArrayList<GuandanPokers> allOutCardsArr = new ArrayList<GuandanPokers>();
        ArrayList<GuandanPokers> sangetouArr = new ArrayList<GuandanPokers>();
        ArrayList<GuandanPokers> duiziArr = new ArrayList<GuandanPokers>();
        for (GuandanPokers guandanPokers : bestCards) {
            CardType cardType = guandanPokers.getCardType();
            Integer type = cardType.getType();
            if (type.equals(2)) {
                duiziArr.add(guandanPokers);
                continue;
            }
            if (type.equals(4)) {
                sangetouArr.add(guandanPokers);
                continue;
            }
            allOutCardsArr.add(guandanPokers);
        }
        if (!sangetouArr.isEmpty() && !duiziArr.isEmpty()) {
            GuandanPokers sangetou = (GuandanPokers)sangetouArr.remove(0);
            GuandanPokers duizi = (GuandanPokers)duiziArr.remove(0);
            GuandanPokers sandaier = new GuandanPokers(new ArrayList<Poker>(), 0.0, new CardType(5, sangetou.getCardType().getWeight()));
            sandaier.getPokers().addAll(GuandanUtil.copy(sangetou.getPokers()));
            sandaier.getPokers().addAll(GuandanUtil.copy(duizi.getPokers()));
            allOutCardsArr.add(sandaier);
        }
        allOutCardsArr.addAll(sangetouArr);
        allOutCardsArr.addAll(duiziArr);
        allOutCardsArr.sort((o1, o2) -> {
            Integer weight2;
            Integer weight1 = o1.getCardType().getWeight();
            if (weight1.equals(weight2 = o2.getCardType().getWeight())) {
                CardType cardType1 = new CardType(o1.getCardType().getType(), 0);
                CardType cardType2 = new CardType(o2.getCardType().getType(), 0);
                List<List<Poker>> tyoeCards1 = GuandanUtil.typeCard2(cardType1, bestCards, laiziValue);
                List<List<Poker>> tyoeCards2 = GuandanUtil.typeCard2(cardType2, bestCards, laiziValue);
                if (tyoeCards1.size() == tyoeCards2.size()) {
                    Integer type2;
                    Integer type1 = o1.getCardType().getType();
                    if (type1.equals(type2 = o2.getCardType().getType())) {
                        List<Poker> laiziCount1 = GuandanUtil.getLaiZiOrNot((List<Poker>)o1.getPokers(), laiziValue).get(1);
                        List<Poker> laiziCount2 = GuandanUtil.getLaiZiOrNot((List<Poker>)o2.getPokers(), laiziValue).get(1);
                        return Integer.compare(laiziCount1.size(), laiziCount2.size());
                    }
                    return Integer.compare(type1, type2);
                }
                return Integer.compare(tyoeCards1.size(), tyoeCards2.size());
            }
            return Integer.compare(weight1, weight2);
        });
        return allOutCardsArr;
    }

    public static List<String[]> permutationNoRepeat(List list) {
        if (null == list || list.isEmpty()) {
            return new ArrayList<String[]>();
        }
        int length = list.size();
        List stringslist = list.stream().map(String::valueOf).collect(Collectors.toList());
        for (int a = 0; a < stringslist.size(); ++a) {
            stringslist.set(a, (String)stringslist.get(a) + ",");
        }
        Stream<Object> stream = stringslist.stream().distinct();
        for (int n = 1; n < length; ++n) {
            stream = stream.flatMap(i -> stringslist.stream().filter(j -> !i.contains((CharSequence)j)).map(i::concat));
        }
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        List collect = stream.collect(Collectors.toList());
        for (String c : collect) {
            String[] split = c.split(",");
            resultList.add(split);
        }
        return resultList;
    }

    public static Poker copy(Poker poker) {
        return new Poker(poker.getColor(), poker.getValue(), poker.getNumber());
    }

    public static List<Poker> copy(Collection<? extends Poker> pokers) {
        ArrayList<Poker> copy = new ArrayList<Poker>(pokers.size());
        for (Poker poker : pokers) {
            copy.add(GuandanUtil.copy(poker));
        }
        return copy;
    }

    public static List<List<Poker>> copy2(Collection<? extends Collection<? extends Poker>> pokersList) {
        ArrayList<List<Poker>> copy = new ArrayList<List<Poker>>(pokersList.size());
        for (Collection<? extends Poker> collection : pokersList) {
            copy.add(GuandanUtil.copy(collection));
        }
        return copy;
    }

    static {
        int a1;
        int i;
        arrlist = Arrays.asList(7, 8, 6, 4, 2, 3, 9);
        initShunziTonghua = new ArrayList<List<Poker>>();
        initShunzi = new LinkedHashMap();
        initGangban = new LinkedHashMap();
        initLiandui = new LinkedHashMap();
        initLaiZi_1 = new HashMap<Integer, List<List<Poker>>>();
        initLaiZi_2 = new HashMap<Integer, List<List<Poker>>>();
        for (i = 1; i < 5; ++i) {
            for (int j = 1; j < 11; ++j) {
                ArrayList<Poker> shunzi = new ArrayList<Poker>();
                for (int k = j; k < j + 5; ++k) {
                    Poker poker = new Poker();
                    poker.setColor(i);
                    poker.setValue(k);
                    shunzi.add(poker);
                }
                initShunziTonghua.add(shunzi);
            }
        }
        for (i = 9; i >= 0; --i) {
            a1 = i + 1;
            int a2 = i + 2;
            int a3 = i + 3;
            int a4 = i + 4;
            int a5 = i + 5;
            if (a5 == 14) {
                a5 = 1;
            }
            List<Poker> pokerShunzi = Arrays.asList(new Poker(null, a1, null), new Poker(null, a2, null), new Poker(null, a3, null), new Poker(null, a4, null), new Poker(null, a5, null));
            Set valueShunzi = CollectUtil.getSet(pokerShunzi, Poker::getValue);
            initShunzi.put(valueShunzi, pokerShunzi);
        }
        for (i = 12; i >= 0; --i) {
            a1 = i + 1;
            int a2 = i + 2;
            if (a2 == 14) {
                a2 = 1;
            }
            List<Poker> pokerGangban = Arrays.asList(new Poker(null, a1, null), new Poker(null, a1, null), new Poker(null, a1, null), new Poker(null, a2, null), new Poker(null, a2, null), new Poker(null, a2, null));
            Set valueGangban = CollectUtil.getSet(pokerGangban, Poker::getValue);
            initGangban.put(valueGangban, pokerGangban);
        }
        for (i = 11; i >= 0; --i) {
            a1 = i + 1;
            int a2 = i + 2;
            int a3 = i + 3;
            if (a3 == 14) {
                a3 = 1;
            }
            List<Poker> pokerLiandui = Arrays.asList(new Poker(null, a1, null), new Poker(null, a1, null), new Poker(null, a2, null), new Poker(null, a2, null), new Poker(null, a3, null), new Poker(null, a3, null));
            Set valueLiandui = CollectUtil.getSet(pokerLiandui, Poker::getValue);
            initLiandui.put(valueLiandui, pokerLiandui);
        }
        List<Poker> pokers1 = GuandanUtil.createPokers(1, false, null, false);
        for (int value = 1; value <= 13; ++value) {
            ArrayList temp = new ArrayList();
            for (Poker poker : pokers1) {
                if (poker.getColor().equals(Poker.Color.HONGTAO.getType()) && poker.getValue().equals(value)) continue;
                ArrayList<Poker> gs1 = new ArrayList<Poker>();
                gs1.add(poker);
                temp.add(gs1);
            }
            initLaiZi_1.put(value, temp);
        }
        for (Integer value : initLaiZi_1.keySet()) {
            List<List<Poker>> temp = initLaiZi_1.get(value);
            List<Poker> pokers = GuandanUtil.mergeTogher(temp);
            for (int i1 = 0; i1 < pokers.size(); ++i1) {
                for (int i2 = i1; i2 < pokers.size(); ++i2) {
                    ArrayList<Poker> add = new ArrayList<Poker>();
                    Poker poker1 = pokers.get(i1);
                    Poker poker2 = pokers.get(i2);
                    add.add(poker1);
                    add.add(poker2);
                    List orDefault = initLaiZi_2.getOrDefault(value, new ArrayList());
                    orDefault.add(add);
                    initLaiZi_2.put(value, orDefault);
                }
            }
        }
        System.err.println("guandan\u5de5\u5177\u5df2\u52a0\u8f7d\u6210\u529f!");
        defaultList = new ArrayList();
        defaultMap = new HashMap();
    }

    public static class GuandanPokersWeight {
        private List<Poker> pokers;
        private List<GuandanPokers> guandanPokers;
        private Double weightCount;

        public List<Poker> getPokers() {
            return this.pokers;
        }

        public void setPokers(List<Poker> pokers) {
            this.pokers = pokers;
        }

        public List<GuandanPokers> getGuandanPokers() {
            return this.guandanPokers;
        }

        public void setGuandanPokers(List<GuandanPokers> guandanPokers) {
            this.guandanPokers = guandanPokers;
        }

        public Double getWeightCount() {
            return this.weightCount;
        }

        public void setWeightCount(Double weightCount) {
            this.weightCount = weightCount;
        }

        public GuandanPokersWeight(List<Poker> pokers, List<GuandanPokers> guandanPokers, Double weightCount) {
            this.pokers = pokers;
            this.guandanPokers = guandanPokers;
            this.weightCount = weightCount;
        }

        public GuandanPokersWeight() {
        }
    }

    public static class GuandanPokers
    implements IPokers {
        private List<Poker> pokers;
        private Double weight;
        private CardType cardType;

        public GuandanPokers() {
        }

        public GuandanPokers(List<Poker> pokers, Double weight, CardType cardType) {
            this.pokers = pokers;
            this.weight = weight;
            this.cardType = cardType;
        }

        public List<Poker> getPokers() {
            return this.pokers;
        }

        public void setPokers(List<Poker> pokers) {
            this.pokers = pokers;
        }

        public Double getWeight() {
            return this.weight;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public CardType getCardType() {
            return this.cardType;
        }

        public void setCardType(CardType cardType) {
            this.cardType = cardType;
        }
    }

    public static class CardType
    implements IPokerType {
        private Integer type;
        private Integer weight;

        public CardType() {
        }

        @Override
        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getWeight() {
            return this.weight;
        }

        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        public CardType(Integer type, Integer weight) {
            this.type = type;
            this.weight = weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CardType cardType = (CardType)o;
            return Objects.equals(this.type, cardType.type);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public String toString() {
            return "\u724c\u578b: " + CardTypeEnum.get(this.type).getDesc() + " \u724c\u503c: " + this.weight;
        }
    }

    private static class OptimalCards {
        int size = 0;
        int oneCount = 0;
        int twoCount = 0;
        double weight = 0.0;
        List<List<Poker>> pokersList = new ArrayList<List<Poker>>();

        private OptimalCards() {
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getOneCount() {
            return this.oneCount;
        }

        public void setOneCount(int oneCount) {
            this.oneCount = oneCount;
        }

        public int getTwoCount() {
            return this.twoCount;
        }

        public void setTwoCount(int twoCount) {
            this.twoCount = twoCount;
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }

        public List<List<Poker>> getPokersList() {
            return this.pokersList;
        }

        public void setPokersList(List<List<Poker>> pokersList) {
            this.pokersList = pokersList;
        }
    }

    private static class MaxColorAndSize {
        private Integer color;
        private Integer sizeMax;
        private Map<Integer, List<Poker>> pokersMap;

        private MaxColorAndSize() {
        }

        public Map<Integer, List<Poker>> getPokersMap() {
            return this.pokersMap;
        }

        public void setPokersMap(Map<Integer, List<Poker>> pokersMap) {
            this.pokersMap = pokersMap;
        }

        public Integer getColor() {
            return this.color;
        }

        public void setColor(Integer color) {
            this.color = color;
        }

        public Integer getSizeMax() {
            return this.sizeMax;
        }

        public void setSizeMax(Integer sizeMax) {
            this.sizeMax = sizeMax;
        }
    }

    public static enum CardTypeEnum {
        CARDTYPE_ILLEGALCARD(-1, "\u975e\u6cd5\u724c\u578b"),
        CARDTYPE_NOCARD(0, "\u4e0d\u51fa"),
        CARDTYPE_SINGLECARD(1, "\u5355\u5f20"),
        CARDTYPE_DOUBLECARD(2, "\u5bf9\u5b50"),
        CARDTYPE_DOUBLECARDLINETHREE(3, "\u4e09\u8fde\u5bf9"),
        CARDTYPE_THREECARD(4, "\u4e09\u4e0d\u5e26"),
        CARDTYPE_THREECARDTWO(5, "\u4e09\u5e26\u4e8c"),
        CARDTYPE_THREECARDLINE(6, "\u94a2\u677f"),
        CARDTYPE_SINGLELINE(7, "\u987a\u5b50"),
        CARDTYPE_SINGLELINESAMECOLOR(8, "\u540c\u82b1\u987a"),
        CARDTYPE_BOMBCARD(9, "\u70b8\u5f39"),
        CARDTYPE_BOMBCARDKING(10, "\u738b\u70b8");

        private final int type;
        private final String desc;

        private CardTypeEnum(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }

        public static CardTypeEnum get(Integer type) {
            for (CardTypeEnum eventEnum : CardTypeEnum.values()) {
                if (!type.equals(eventEnum.getType())) continue;
                return eventEnum;
            }
            return null;
        }
    }
}

