/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.poker.guandan;

import cn.godmao.poker.Poker;
import cn.godmao.poker.guandan.GuandanUtil;
import cn.godmao.utils.CollectUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractGuandanAI
extends GuandanUtil {
    protected Map<Integer, PlayerInfo> seatIndexPlayerInfo = new HashMap<Integer, PlayerInfo>();
    protected Integer laiziValue;
    protected INode node;
    protected Integer seatIndex;
    protected Integer seatIndexLast;
    protected Integer seatIndexNext;
    protected Integer seatIndexFriend;

    public Map<Integer, PlayerInfo> getSeatIndexPlayerInfo() {
        return this.seatIndexPlayerInfo;
    }

    public Integer getLaiziValue() {
        return this.laiziValue;
    }

    public INode getNode() {
        return this.node;
    }

    public Integer getSeatIndex() {
        return this.seatIndex;
    }

    private void check() {
        if (this.seatIndexPlayerInfo.size() < 4) {
            throw new RuntimeException("\u63bc\u86cb\u73a9\u5bb6\u5fc5\u987b4\u4eba\u53c2\u4e0e");
        }
        if (this.laiziValue < 1 || this.laiziValue > 13) {
            throw new RuntimeException("\u63bc\u86cb\u7684\u8d56\u5b50\u503c\u5fc5\u987b\u662fA-K");
        }
        if (null == this.node) {
            throw new RuntimeException("\u5fc5\u987b\u8981\u6709\u8282\u70b9\u6570\u636e,\u5982\u679c\u6ca1\u6709\u6700\u5927\u51fa\u724c\u4eba,\u76f4\u63a5 new Node()");
        }
        if (this.seatIndex < 0 || this.seatIndex > 3) {
            throw new RuntimeException("\u5ea7\u4f4d\u53f7\u6709\u95ee\u9898 seatIndex:" + this.seatIndex);
        }
    }

    public AbstractGuandanAI(Collection<PlayerInfo> playerInfos, INode node, Integer seatIndex, Integer laiziValue, boolean updateNumber) {
        this.laiziValue = laiziValue;
        this.node = node;
        this.seatIndex = seatIndex;
        this.seatIndexPlayerInfo = CollectUtil.toMap(playerInfos, PlayerInfo::getSeatIndex);
        if (updateNumber) {
            int index = 0;
            for (PlayerInfo playerInfo : playerInfos) {
                for (Poker handCard : playerInfo.getHandCard()) {
                    handCard.setNumber(++index);
                }
            }
        }
        for (PlayerInfo playerInfo : playerInfos) {
            playerInfo.setArrangePoker(laiziValue);
        }
        switch (this.seatIndex) {
            case 0: {
                this.seatIndexFriend = 2;
                this.seatIndexLast = 3;
                this.seatIndexNext = 1;
                break;
            }
            case 1: {
                this.seatIndexFriend = 3;
                this.seatIndexLast = 0;
                this.seatIndexNext = 2;
                break;
            }
            case 2: {
                this.seatIndexFriend = 0;
                this.seatIndexLast = 1;
                this.seatIndexNext = 3;
                break;
            }
            case 3: {
                this.seatIndexFriend = 1;
                this.seatIndexLast = 2;
                this.seatIndexNext = 0;
            }
        }
        this.check();
    }

    public boolean isFreeOut() {
        return null == this.node.getSeatIndex() || -1 == this.node.getSeatIndex() || this.seatIndex.equals(this.node.getSeatIndex());
    }

    public boolean isPressOut() {
        return !this.isFreeOut();
    }

    public List<Poker> getMyHandCards() {
        return this.seatIndexPlayerInfo.get(this.seatIndex).getHandCard();
    }

    public List<Poker> getLastHandCards() {
        return this.seatIndexPlayerInfo.get(this.seatIndexLast).getHandCard();
    }

    public List<Poker> getNextHandCards() {
        return this.seatIndexPlayerInfo.get(this.seatIndexNext).getHandCard();
    }

    public List<Poker> getFriendHandCards() {
        return this.seatIndexPlayerInfo.get(this.seatIndexFriend).getHandCard();
    }

    public PlayerInfo getMyPlayInfo() {
        return this.seatIndexPlayerInfo.get(this.seatIndex);
    }

    public PlayerInfo getLastPlayInfo() {
        return this.seatIndexPlayerInfo.get(this.seatIndexLast);
    }

    public PlayerInfo getNextPlayerInfo() {
        return this.seatIndexPlayerInfo.get(this.seatIndexNext);
    }

    public PlayerInfo getFriendPlayerInfo() {
        return this.seatIndexPlayerInfo.get(this.seatIndexFriend);
    }

    public static interface INode {
        public Integer getSeatIndex();

        public GuandanUtil.CardType getCardType();

        public List<Poker> getCards();
    }

    public static class PlayerInfo {
        List<Poker> handCard;
        Integer seatIndex;
        GuandanUtil.GuandanPokersWeight arrangePoker;

        public PlayerInfo(List<Poker> handCard, Integer seatIndex) {
            this.handCard = handCard;
            this.seatIndex = seatIndex;
        }

        public List<Poker> getHandCard() {
            return this.handCard;
        }

        public Integer getSeatIndex() {
            return this.seatIndex;
        }

        protected void setArrangePoker(Integer laiziValue) {
            this.arrangePoker = GuandanUtil.arrangePoker(this.handCard, laiziValue);
            this.arrangePoker.setGuandanPokers(GuandanUtil.getBestSort(this.arrangePoker.getGuandanPokers(), laiziValue));
        }

        public GuandanUtil.GuandanPokersWeight getArrangePoker() {
            return this.arrangePoker;
        }
    }

    public static class Node
    implements INode {
        private Integer seatIndex = -1;
        private GuandanUtil.CardType cardType;
        private List<Poker> cards;
        private boolean exist;

        public Node(Integer seatIndex, List<Poker> cards, Integer laiziValue) {
            if (seatIndex > -1 && !cards.isEmpty()) {
                this.exist = true;
                this.seatIndex = seatIndex;
                this.cards = cards;
                this.cardType = GuandanUtil.cardType(cards, laiziValue);
            }
        }

        public Node() {
        }

        @Override
        public Integer getSeatIndex() {
            return this.seatIndex;
        }

        @Override
        public GuandanUtil.CardType getCardType() {
            return this.cardType;
        }

        @Override
        public List<Poker> getCards() {
            return this.cards;
        }

        public boolean isExist() {
            return this.exist;
        }
    }

    public static class NodeLast
    implements INode {
        private Integer seatIndex = -1;
        private GuandanUtil.CardType cardType;
        private List<Poker> cards;

        public NodeLast(Integer seatIndex, GuandanUtil.CardType cardType) {
            this.seatIndex = seatIndex;
            this.cardType = cardType;
        }

        public NodeLast(Integer seatIndex, GuandanUtil.CardType cardType, List<Poker> cards) {
            this.seatIndex = seatIndex;
            this.cardType = cardType;
            this.cards = cards;
        }

        public NodeLast() {
        }

        @Override
        public Integer getSeatIndex() {
            return this.seatIndex;
        }

        @Override
        public GuandanUtil.CardType getCardType() {
            return this.cardType;
        }

        @Override
        public List<Poker> getCards() {
            return this.cards;
        }
    }
}

