//package cn.godmao.poker.guandan;
//
//import cn.godmao.poker.Poker;
//import cn.godmao.utils.CollectUtil;
//
//import java.util.Collection;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
///**
// * 掼蛋出牌抽象类
// */
//public abstract class AbstractGuandanAI extends GuandanUtil {
//    protected Map<Integer, PlayerInfo> seatIndexPlayerInfo;// key是座位号 value是玩家信息
//    protected Integer laiziValue;// 赖子值
//    protected INode node;// 节点数据
//
//    //
//    protected Integer seatIndex;// 我的座位号
//    protected Integer seatIndexLast;// 上家的座位号
//    protected Integer seatIndexNext;// 下家的座位号
//    protected Integer seatIndexFriend;// 好友的座位号
//
//    public Map<Integer, PlayerInfo> getSeatIndexPlayerInfo() {
//        return seatIndexPlayerInfo;
//    }
//
//    public Integer getLaiziValue() {
//        return laiziValue;
//    }
//
//    public INode getNode() {
//        return node;
//    }
//
//    public Integer getSeatIndex() {
//        return seatIndex;
//    }
//
//
//    private void check() {
//        if (this.seatIndexPlayerInfo.size() < 4) {
//            throw new RuntimeException("掼蛋玩家必须4人参与");
//        }
//
//        if (this.laiziValue >= 1 && this.laiziValue <= 13) {
//
//        } else {
//            throw new RuntimeException("掼蛋的赖子值必须是A-K");
//        }
//
//        if (null == node) {
//            throw new RuntimeException("必须要有节点数据,如果没有最大出牌人,直接 new Node()");
//        }
//
//        if (this.seatIndex >= 0 && this.seatIndex <= 3) {
//
//        } else {
//            throw new RuntimeException("座位号有问题 seatIndex:" + seatIndex);
//        }
//    }
//
//    public AbstractGuandanAI(Collection<PlayerInfo> playerInfos, INode node, Integer seatIndex, Integer laiziValue, boolean updateNumber) {
//        this.seatIndexPlayerInfo = new HashMap<>();
//        this.laiziValue = laiziValue;
//        this.node = node;
//        this.seatIndex = seatIndex;
//        this.seatIndexPlayerInfo = CollectUtil.toMap(playerInfos, PlayerInfo::getSeatIndex);
//        //
//        if (updateNumber) {
//            int index = 0;
//            for (PlayerInfo playerInfo : playerInfos) {
//                for (Poker handCard : playerInfo.getHandCard()) {
//                    handCard.setNumber(++index);
//                }
//            }
//        }
//
//        // 设置玩家最优理牌
//        for (PlayerInfo playerInfo : playerInfos) {
//            playerInfo.setArrangePoker(laiziValue);
//        }
//
//
//        switch (this.seatIndex) {
//            case 0:
//                this.seatIndexFriend = 2;
//                this.seatIndexLast = 3;
//                this.seatIndexNext = 1;
//                break;
//            case 1:
//                this.seatIndexFriend = 3;
//                this.seatIndexLast = 0;
//                this.seatIndexNext = 2;
//                break;
//            case 2:
//                this.seatIndexFriend = 0;
//                this.seatIndexLast = 1;
//                this.seatIndexNext = 3;
//                break;
//            case 3:
//                this.seatIndexFriend = 1;
//                this.seatIndexLast = 2;
//                this.seatIndexNext = 0;
//                break;
//        }
//
//
//        this.check();
//    }
//
//
//    public interface INode {
//        Integer getSeatIndex();// 最大出牌人的座位号
//
//        GuandanUtil.CardType getCardType();// 最大出牌人出的牌型
//
//        List<Poker> getCards();// 最大出牌人出的牌
//    }
//
//    /**
//     * 上个节点数据
//     */
//    public static class NodeLast implements INode {
//        private Integer seatIndex = -1;// 最大出牌人的座位号
//        private GuandanUtil.CardType cardType;// 最大出牌人出的牌型
//        private List<Poker> cards;// 最大出牌人出的牌
//
//        public NodeLast(Integer seatIndex, GuandanUtil.CardType cardType) {
//            this.seatIndex = seatIndex;
//            this.cardType = cardType;
//        }
//
//        public NodeLast(Integer seatIndex, GuandanUtil.CardType cardType, List<Poker> cards) {
//            this.seatIndex = seatIndex;
//            this.cardType = cardType;
//            this.cards = cards;
//        }
//
//        public NodeLast() {
//        }
//
//        public Integer getSeatIndex() {
//            return seatIndex;
//        }
//
//        public GuandanUtil.CardType getCardType() {
//            return cardType;
//        }
//
//        @Override
//        public List<Poker> getCards() {
//            return cards;
//        }
//    }
//
//    /**
//     * 节点数据
//     */
//    public static class Node implements INode {
//        private Integer seatIndex = -1;// 最大出牌人的座位号
//        private GuandanUtil.CardType cardType;// 最大出牌人出的牌型
//        private List<Poker> cards;// 最大出牌人出的牌
//        private boolean exist;// 是否存在最大节点
//
//        public Node(Integer seatIndex, List<Poker> cards, Integer laiziValue) {
//            if (seatIndex > -1 && !cards.isEmpty()) {
//                this.exist = true;
//                this.seatIndex = seatIndex;
//                this.cards = cards;
//                this.cardType = GuandanUtil.cardType(cards, laiziValue);
//            }
//        }
//
//        public Node() {
//        }
//
//        public Integer getSeatIndex() {
//            return seatIndex;
//        }
//
//        public GuandanUtil.CardType getCardType() {
//            return cardType;
//        }
//
//        public List<Poker> getCards() {
//            return cards;
//        }
//
//        public boolean isExist() {
//            return exist;
//        }
//
//    }
//
//
//    /**
//     * 玩家数据
//     */
//    public static class PlayerInfo {
//        List<Poker> handCard;// 手牌
//        Integer seatIndex;// 座位号
//        GuandanPokersWeight arrangePoker;// 玩家的最优理牌 排过序的
//
//        public PlayerInfo(List<Poker> handCard, Integer seatIndex) {
//            this.handCard = handCard;
//            this.seatIndex = seatIndex;
//        }
//
//        public List<Poker> getHandCard() {
//            return handCard;
//        }
//
//        public Integer getSeatIndex() {
//            return seatIndex;
//        }
//
//
//        /**
//         * 设置玩家最优理牌
//         *
//         * @param laiziValue
//         */
//        protected void setArrangePoker(Integer laiziValue) {
//            this.arrangePoker = arrangePoker(handCard, laiziValue);
//            this.arrangePoker.setGuandanPokers(getBestSort(this.arrangePoker.getGuandanPokers(), laiziValue));
//        }
//
//        public GuandanPokersWeight getArrangePoker() {
//            return arrangePoker;
//        }
//    }
//
//
//    /**
//     * 是自由出牌
//     */
//    public boolean isFreeOut() {
//        return null == this.node.getSeatIndex() || -1 == this.node.getSeatIndex() || this.seatIndex.equals(this.node.getSeatIndex());
//    }
//
//    /**
//     * 是压牌
//     */
//    public boolean isPressOut() {
//        return !isFreeOut();
//    }
//
//
//    /**
//     * 获取我的手牌
//     */
//    public List<Poker> getMyHandCards() {
//        return this.seatIndexPlayerInfo.get(this.seatIndex).getHandCard();
//    }
//
//    /**
//     * 获取上家手牌
//     */
//    public List<Poker> getLastHandCards() {
//        return this.seatIndexPlayerInfo.get(this.seatIndexLast).getHandCard();
//    }
//
//    /**
//     * 获取下家手牌
//     */
//    public List<Poker> getNextHandCards() {
//        return this.seatIndexPlayerInfo.get(this.seatIndexNext).getHandCard();
//    }
//
//    /**
//     * 获取好友的手牌
//     */
//    public List<Poker> getFriendHandCards() {
//        return this.seatIndexPlayerInfo.get(this.seatIndexFriend).getHandCard();
//    }
//
//
//    /**
//     * 获取我的信息
//     */
//    public PlayerInfo getMyPlayInfo() {
//        return this.seatIndexPlayerInfo.get(this.seatIndex);
//    }
//
//    /**
//     * 获取上家的信息
//     */
//    public PlayerInfo getLastPlayInfo() {
//        return this.seatIndexPlayerInfo.get(this.seatIndexLast);
//    }
//
//
//    /**
//     * 获取下家的信息
//     */
//    public PlayerInfo getNextPlayerInfo() {
//        return this.seatIndexPlayerInfo.get(this.seatIndexNext);
//    }
//
//    /**
//     * 获取好友的信息
//     */
//    public PlayerInfo getFriendPlayerInfo() {
//        return this.seatIndexPlayerInfo.get(this.seatIndexFriend);
//    }
//
////    public List<com.godmao.poker.help.GuandanUtil.GuandanPokers> arrangePoker(List<Poker> cards, int laiziValue) {
////        List<Poker> cards_copy = PokerUtil.copy(cards);
////        List<List<Poker>> singleLineArrs = optimalSingleLine(cards_copy, laiziValue);// 所有顺子 或者同花顺
////        List<Poker> singleLineArr = mergeTogher(singleLineArrs);
////        deletePoker(cards_copy, singleLineArr, Poker::getNumber);
////        List<List<Poker>> boom = getBoom(cards_copy, laiziValue, false);
////    }
////
////    public List<List<Poker>> getBoom(List<Poker> cards, int laiziValue) {
////        Map<Integer, List<Poker>> sameVaules = new HashMap<>();
////        for (Poker card : cards) {
////            if (card.getValue().equals(laiziValue) && card.getColor().equals(COLOR_HONGTAO)) {
////                // 是癩子
////            } else if () {
////
////            }
////        }
////    }
//}
