package cn.godmao.poker.guandan;

public class GuandanUtil2 {

    public enum CardType {
        ILLEGALCARD(-1, "非法牌型"),
        NOCARD(0, "不出"),
        SINGLECARD(1, "单张"),
        DOUBLECARD(2, "对子"),
        DOUBLECARDLINETHREE(3, "三连对"),
        THREECARD(4, "三不带"),
        THREECARDTWO(5, "三带二"),
        THREECARDLINE(6, "钢板"),
        SINGLELINE(7, "顺子"),
        SINGLELINESAMECOLOR(8, "同花顺"),
        BOMBCARD(9, "炸弹"),
        BOMBCARDKING(10, "王炸"),
        ;

        private final int type;
        private final String desc;

        CardType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public boolean equals(Integer type) {
            return this.type == type;
        }

        public static CardType get(Integer type) {
            for (GuandanUtil2.CardType cardType : values()) {
                if (cardType.equals(type)) {
                    return cardType;
                }
            }
            return null;
        }
    }

}
