package cn.godmao.poker.guandan;


import cn.godmao.common.IFunction;
import cn.godmao.poker.IPokerType;
import cn.godmao.poker.IPokers;
import cn.godmao.poker.Poker;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.MathUtil;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GuandanUtil {

    public static void main(String[] args) {
        List<Poker> pokers = new ArrayList<>();
        pokers.add(Poker.大王);
        pokers.add(Poker.小王);
        pokers.add(Poker.梅花J);

        pokers.add(Poker.方块A);

        pokers.add(Poker.方块Q);

        pokers.add(Poker.梅花8);
        pokers.add(Poker.梅花8);
        pokers.add(Poker.方块8);
        pokers.add(Poker.黑桃8);

        pokers.add(Poker.红桃7);
        pokers.add(Poker.黑桃7);

        pokers.add(Poker.黑桃6);

        pokers.add(Poker.方块5);
        pokers.add(Poker.梅花5);

        pokers.add(Poker.方块4);
        pokers.add(Poker.方块3);
        pokers.add(Poker.方块2);

        pokers = newList(pokers);

        GuandanPokersWeight guandanPokersWeight = arrangePoker(pokers, 4);
        System.out.println(1);
    }

    public static List<Poker> newList(List<Poker> cards) {
        List<Poker> copy = copy(cards);
        for (int x = 0; x < copy.size(); x++) {
            copy.get(x).setNumber(x);
        }
        return copy;
    }

    public static List<Poker> deal(List<Poker> myHandCards, List<Poker> pokerList, LinkedHashMap<Integer, Integer> typeNums, int laiziValue) {
        List<Poker> result = new ArrayList<>();

        Set<Integer> values = CollectUtil.getSet(myHandCards, Poker::getValue);

        List<Poker> chongfu_not = new ArrayList<>();// 不重复的

        for (Poker poker : pokerList) {
            if (!values.contains(poker.getValue())) {
                chongfu_not.add(poker);
            }
        }


        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(chongfu_not, laiziValue);
        List<Poker> cards = laiZiOrNot.get(2);
        List<Poker> king = laiZiOrNot.get(3);

        Map<Integer, List<Poker>> pokerMapByValue;
        for (Integer type : typeNums.keySet()) {
            Integer num = typeNums.get(type);
            if (num < 1) {
                continue;
            }
            switch (type) {
                case CARDTYPE_SINGLECARD:// 单张
                    break;
                case CARDTYPE_DOUBLECARD:// 对子
                    pokerMapByValue = getPokerMapByValue(cards);
                    List<List<Poker>> duizis = new ArrayList<>(pokerMapByValue.values());
                    Collections.shuffle(duizis);
                    for (List<Poker> duizi : duizis) {
                        if (duizi.size() < 2) {
                            continue;
                        }
                        if (num < 1) {
                            break;
                        }
                        num--;
                        List<Poker> newduizi = new ArrayList<>(duizi.subList(0, 2));
                        deletePoker(cards, newduizi, Poker::getNumber);
                        result.addAll(newduizi);
                    }
                    break;
                case CARDTYPE_DOUBLECARDLINETHREE:// 三连对
                    break;
                case CARDTYPE_THREECARD:// 三不带
                    pokerMapByValue = getPokerMapByValue(cards);
                    List<List<Poker>> sangetous = new ArrayList<>(pokerMapByValue.values());
                    Collections.shuffle(sangetous);
                    for (List<Poker> sangetou : sangetous) {
                        if (sangetou.size() < 3) {
                            continue;
                        }
                        if (num < 1) {
                            break;
                        }
                        num--;
                        List<Poker> newSangetou = new ArrayList<>(sangetou.subList(0, 3));
                        deletePoker(cards, newSangetou, Poker::getNumber);
                        result.addAll(newSangetou);
                    }
                    break;
                case CARDTYPE_THREECARDTWO:// 三带二
                    break;
                case CARDTYPE_THREECARDLINE:// 钢板
                    break;
                case CARDTYPE_SINGLELINE:// 顺子
//                    Map<Integer, List<Poker>> pokerMapByValue = getPokerMapByValue(cards);
//                    List<List<Poker>> shunziArr = optimalSingleLine(cards, laiziValue);
//                    if (!shunziArr.isEmpty()) {
//                        Collections.shuffle(shunziArr);
//                        List<List<Poker>> shunziArr_ = shunziArr.subList(0, Math.min(shunziArr.size(), num));
//                        num -= shunziArr_.size();
//                        List<Poker> pokers = mergeTogher(shunziArr_);
//                        deletePoker(cards, pokers, Poker::getNumber);
//                        result.addAll(pokers);
//                    }
                    break;
                case CARDTYPE_SINGLELINESAMECOLOR: // 同花顺
                    Map<Integer, List<Poker>> pokerMapByColor = getPokerMapByColor(cards);
                    pokerMapByColor.remove(Poker.Color.KING.getType());
                    List<List<Poker>> sameColors = new ArrayList<>(pokerMapByColor.values());
                    Collections.shuffle(sameColors);
                    for (List<Poker> sameColor : sameColors) {
                        if (num < 1) {
                            break;
                        }
                        List<List<Poker>> sameColorShunzu = optimalSingleLine(sameColor, laiziValue);
                        if (sameColorShunzu.isEmpty()) {
                            continue;
                        }
                        Collections.shuffle(sameColorShunzu);
                        List<List<Poker>> sameColorShunzu_ = sameColorShunzu.subList(0, Math.min(sameColorShunzu.size(), num));
                        num -= sameColorShunzu_.size();
                        List<Poker> pokers = mergeTogher(sameColorShunzu_);
                        deletePoker(cards, pokers, Poker::getNumber);
                        result.addAll(pokers);
                    }
                    break;
                case CARDTYPE_BOMBCARD:// 炸弹
                    pokerMapByValue = getPokerMapByValue(cards);
                    List<List<Poker>> booms = new ArrayList<>(pokerMapByValue.values());
                    Collections.shuffle(booms);
                    for (List<Poker> boom : booms) {
                        if (boom.size() < 4) {
                            continue;
                        }
                        if (num < 1) {
                            break;
                        }
                        num--;
                        deletePoker(cards, boom, Poker::getNumber);
                        result.addAll(boom);
                    }
                    break;
                case CARDTYPE_BOMBCARDKING:// 王炸

                    if (null == king || king.isEmpty() || num < 1) {

                    } else {

                        result.addAll(king);
                        laiZiOrNot.remove(3);
                        deletePoker(cards, king, Poker::getNumber);
                        king = null;
                    }
                    break;
            }
        }
        return result;
    }

    /**
     * 查找所有同花顺
     */
    public static List<List<Poker>> optimalSingleSameColor(List<Poker> cards, int laiziValue) {
        return optimalSingleLine(cards, laiziValue, true);
    }

    /**
     * 查找所有同花顺
     */
    public static List<List<Poker>> optimalSingleLineSameColor(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = copy(cards);
        List<List<Poker>> result = new ArrayList<>();
        if (cards_copy.size() < 5) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards_copy, laiziValue);
        List<Poker> laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        List<Poker> laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());

        Set<Integer> hashcode = new HashSet<>();
        List<List<Poker>> tonghuashun = new ArrayList<>();

        Map<Integer, List<Poker>> pokerMapByValue = getPokerMapByColor(laiZiNot);


        for (Integer key_ : pokerMapByValue.keySet()) {
            List<Poker> values = pokerMapByValue.get(key_);
            values = CollectUtil.distinct(values, Poker::getValue);// 去重
            values.sort(Comparator.comparingInt(Poker::getValue));
            for (int i = 0; i < values.size(); i++) {
                if (values.size() - i < 5 - laiZi.size()) {
                    break;
                }
                Poker poker1 = values.get(i);
                Poker poker2 = values.get(i + 1);
                Poker poker3 = values.get(i + 2);


                Poker poker4 = null;
                if (values.size() > i + 3) {
                    poker4 = values.get(i + 3);
                }
                Poker poker5 = null;
                if (values.size() > i + 4) {
                    poker5 = values.get(i + 4);
                }

                List<Poker> shunzi1 = new ArrayList<>();
                shunzi1.add(copy(poker1));
                shunzi1.add(copy(poker2));
                shunzi1.add(copy(poker3));


                List<Poker> shunzi = getShunzi(shunzi1, Math.min(5 - shunzi1.size(), laiZi.size()));
                if (!shunzi.isEmpty()) {
                    int hash = Objects.hash(key_, hashCode_value(shunzi));
                    if (!hashcode.contains(hash)) {
                        List<Poker> new_shunzi1 = copy(shunzi1);
                        new_shunzi1.addAll(copy(laiZi.subList(0, 5 - shunzi1.size())));
                        tonghuashun.add(new_shunzi1);
                        hashcode.add(hash);
                    }
                }

                if (null != poker4) {
                    shunzi1.add(copy(poker4));
                }

                shunzi = getShunzi(shunzi1, Math.min(5 - shunzi1.size(), laiZi.size()));
                if (!shunzi.isEmpty()) {
                    int hash = Objects.hash(key_, hashCode_value(shunzi));
                    if (!hashcode.contains(hash)) {
                        List<Poker> new_shunzi1 = copy(shunzi1);
                        new_shunzi1.addAll(copy(laiZi.subList(0, 5 - shunzi1.size())));
                        tonghuashun.add(new_shunzi1);
                        hashcode.add(hash);
                    }
                }

                if (null != poker5) {
                    shunzi1.add(copy(poker5));
                }

                shunzi = getShunzi(shunzi1, Math.min(5 - shunzi1.size(), laiZi.size()));
                if (!shunzi.isEmpty()) {
                    int hash = Objects.hash(key_, hashCode_value(shunzi));
                    if (!hashcode.contains(hash)) {
                        List<Poker> new_shunzi1 = copy(shunzi1);
                        new_shunzi1.addAll(copy(laiZi.subList(0, 5 - shunzi1.size())));
                        tonghuashun.add(new_shunzi1);
                        hashcode.add(hash);
                    }
                }
            }
        }

        return tonghuashun;
    }

    public static final int CARDTYPE_ILLEGALCARD = -1; // 非法牌型
    public static final int CARDTYPE_NOCARD = 0;// 不出
    public static final int CARDTYPE_SINGLECARD = 1;// 单张
    public static final int CARDTYPE_DOUBLECARD = 2;// 对子
    public static final int CARDTYPE_DOUBLECARDLINETHREE = 3;// 三连对
    public static final int CARDTYPE_THREECARD = 4;// 三不带
    public static final int CARDTYPE_THREECARDTWO = 5;// 三带二
    public static final int CARDTYPE_THREECARDLINE = 6;// 钢板
    public static final int CARDTYPE_SINGLELINE = 7;// 顺子
    public static final int CARDTYPE_SINGLELINESAMECOLOR = 8;// 同花顺
    public static final int CARDTYPE_BOMBCARD = 9;// 炸弹
    public static final int CARDTYPE_BOMBCARDKING = 10;// 王炸

    public enum CardTypeEnum {
        CARDTYPE_ILLEGALCARD(GuandanUtil.CARDTYPE_ILLEGALCARD, "非法牌型"),
        CARDTYPE_NOCARD(GuandanUtil.CARDTYPE_NOCARD, "不出"),
        CARDTYPE_SINGLECARD(GuandanUtil.CARDTYPE_SINGLECARD, "单张"),
        CARDTYPE_DOUBLECARD(GuandanUtil.CARDTYPE_DOUBLECARD, "对子"),
        CARDTYPE_DOUBLECARDLINETHREE(GuandanUtil.CARDTYPE_DOUBLECARDLINETHREE, "三连对"),
        CARDTYPE_THREECARD(GuandanUtil.CARDTYPE_THREECARD, "三不带"),
        CARDTYPE_THREECARDTWO(GuandanUtil.CARDTYPE_THREECARDTWO, "三带二"),
        CARDTYPE_THREECARDLINE(GuandanUtil.CARDTYPE_THREECARDLINE, "钢板"),
        CARDTYPE_SINGLELINE(GuandanUtil.CARDTYPE_SINGLELINE, "顺子"),
        CARDTYPE_SINGLELINESAMECOLOR(GuandanUtil.CARDTYPE_SINGLELINESAMECOLOR, "同花顺"),
        CARDTYPE_BOMBCARD(GuandanUtil.CARDTYPE_BOMBCARD, "炸弹"),
        CARDTYPE_BOMBCARDKING(GuandanUtil.CARDTYPE_BOMBCARDKING, "王炸"),

        ;


        private final int type;
        private final String desc;

        CardTypeEnum(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public static CardTypeEnum get(Integer type) {
            for (CardTypeEnum eventEnum : CardTypeEnum.values()) {
                if (type.equals(eventEnum.getType())) {
                    return eventEnum;
                }
            }
            return null;
        }
    }

    /**
     * 所有同花顺
     */
    public static List<List<Poker>> initShunziTonghua;

    /**
     * 所有顺子
     */
    public static LinkedHashMap<Set<Integer>, List<Poker>> initShunzi;

    /**
     * 所有钢板
     */
    public static LinkedHashMap<Set<Integer>, List<Poker>> initGangban;

    /**
     * 所有连对
     */
    public static LinkedHashMap<Set<Integer>, List<Poker>> initLiandui;

    public static Map<Integer, List<List<Poker>>> initLaiZi_1;

    public static Map<Integer, List<List<Poker>>> initLaiZi_2;

    /**
     * 最优组合
     */
    public static final List<Integer> arrlist = Arrays.asList(
            CARDTYPE_SINGLELINE, // 顺子
            CARDTYPE_SINGLELINESAMECOLOR,// 同花顺
            CARDTYPE_THREECARDLINE,  // 钢板
            CARDTYPE_THREECARD, // 三不带
            CARDTYPE_DOUBLECARD, // 对子
            CARDTYPE_DOUBLECARDLINETHREE, // 三连对
            CARDTYPE_BOMBCARD// 炸弹
    );

    static {
        initShunziTonghua = new ArrayList<>();
        initShunzi = new LinkedHashMap<>();
        initGangban = new LinkedHashMap<>();
        initLiandui = new LinkedHashMap<>();
        initLaiZi_1 = new HashMap<>();
        initLaiZi_2 = new HashMap<>();

        for (int i = 1; i < 5; i++) {
            for (int j = 1; j < 11; j++) {
                List<Poker> shunzi = new ArrayList<>();
                for (int k = j; k < j + 5; k++) {
                    Poker poker = new Poker();
                    poker.setColor(i);
                    poker.setValue(k);
                    shunzi.add(poker);
                }
                initShunziTonghua.add(shunzi);
            }
        }

        for (int i = 9; i >= 0; i--) {
            int a1 = i + 1;
            int a2 = i + 2;
            int a3 = i + 3;
            int a4 = i + 4;
            int a5 = i + 5;

            if (a5 == 14) {
                a5 = 1;
            }

            List<Poker> pokerShunzi = Arrays.asList(
                    new Poker(null, a1, null),
                    new Poker(null, a2, null),
                    new Poker(null, a3, null),
                    new Poker(null, a4, null),
                    new Poker(null, a5, null)
            );

            Set<Integer> valueShunzi = CollectUtil.getSet(pokerShunzi, Poker::getValue);
            initShunzi.put(valueShunzi, pokerShunzi);
        }

        for (int i = 12; i >= 0; i--) {
            int a1 = i + 1;
            int a2 = i + 2;

            if (a2 == 14) {
                a2 = 1;
            }

            List<Poker> pokerGangban = Arrays.asList(
                    new Poker(null, a1, null),
                    new Poker(null, a1, null),
                    new Poker(null, a1, null),
                    new Poker(null, a2, null),
                    new Poker(null, a2, null),
                    new Poker(null, a2, null)
            );

            Set<Integer> valueGangban = CollectUtil.getSet(pokerGangban, Poker::getValue);
            initGangban.put(valueGangban, pokerGangban);
        }
        for (int i = 11; i >= 0; i--) {
            int a1 = i + 1;
            int a2 = i + 2;
            int a3 = i + 3;

            if (a3 == 14) {
                a3 = 1;
            }

            List<Poker> pokerLiandui = Arrays.asList(
                    new Poker(null, a1, null),
                    new Poker(null, a1, null),
                    new Poker(null, a2, null),
                    new Poker(null, a2, null),
                    new Poker(null, a3, null),
                    new Poker(null, a3, null)
            );

            Set<Integer> valueLiandui = CollectUtil.getSet(pokerLiandui, Poker::getValue);
            initLiandui.put(valueLiandui, pokerLiandui);
        }

        //
        List<Poker> pokers1 = createPokers(1, false, null, false);
        for (int value = 1; value <= 13; value++) {
            List<List<Poker>> temp = new ArrayList<>();
            for (Poker poker : pokers1) {
                if (poker.getColor().equals(Poker.Color.HONGTAO.getType()) && poker.getValue().equals(value)) {
                    continue;
                }
                List<Poker> gs1 = new ArrayList<>();
                gs1.add(poker);
                temp.add(gs1);
            }
            initLaiZi_1.put(value, temp);
        }

        //
        for (Integer value : initLaiZi_1.keySet()) {
            List<List<Poker>> temp = initLaiZi_1.get(value);
            List<Poker> pokers = mergeTogher(temp);
            for (int i1 = 0; i1 < pokers.size(); i1++) {
                for (int i2 = i1; i2 < pokers.size(); i2++) {
                    List<Poker> add = new ArrayList<>();
                    Poker poker1 = pokers.get(i1);
                    Poker poker2 = pokers.get(i2);
                    add.add(poker1);
                    add.add(poker2);
                    List<List<Poker>> orDefault = initLaiZi_2.getOrDefault(value, new ArrayList<>());
                    orDefault.add(add);
                    initLaiZi_2.put(value, orDefault);
                }
            }
        }

        System.err.println("guandan工具已加载成功!");
    }

    public static void init() {

    }


    /**
     * 获取王炸
     *
     * @return
     */
    private static List<List<Poker>> getBomKing(List<Poker> cards) {
        List<List<Poker>> result = new ArrayList<>();
        if (null == cards || cards.size() < 4) {
            return result;
        }
        List<Poker> da = null;
        List<Poker> xiao = null;
        for (Poker card : cards) {
            if (card.getColor().equals(Poker.Color.KING.getType())) {
                if (card.getValue().equals(Poker.VALUE_KING_DA)) {
                    if (null == da) {
                        da = new ArrayList<>();
                    }
                    da.add(card);
                } else if (card.getValue().equals(Poker.VALUE_KING_XIAO)) {
                    if (null == xiao) {
                        xiao = new ArrayList<>();
                    }
                    xiao.add(card);
                }
            }
        }
        if (null != da && null != xiao && da.size() > 1 && xiao.size() > 1) {
            int min = Math.min(da.size(), xiao.size());
            min = min - min % 2;

            for (int i = 0; i < min / 2; i++) {
                List<Poker> pokers = new ArrayList<>(4);
                pokers.addAll(new ArrayList<>(da.subList(i * 2, i * 2 + 2)));
                pokers.addAll(new ArrayList<>(xiao.subList(i * 2, i * 2 + 2)));
                result.add(pokers);
            }
        }
        return result;
    }

    /**
     * @param pokers:组合数组
     * @param m:生成组合长度
     * @return :所有可能的组合数组列表
     */
    public static List<List<Poker>> combination(List<Poker> pokers, int m) {
        List<List<Poker>> resultList = new ArrayList<>();
        if (pokers.size() <= m) {
            resultList.add(pokers);
            return resultList;
        }


        int n = pokers.size();
        boolean end = false; // 是否是最后一种组合的标记
        // 生成辅助数组。首先初始化，将数组前n个元素置1，表示第一个组合为前n个数。
        int[] tempNum = new int[n];
        for (int i = 0; i < n; i++) {
            if (i < m) {
                tempNum[i] = 1;

            } else {
                tempNum[i] = 0;
            }
        }

        List<Poker> result = new ArrayList<>(m);
        int j = 0;
        for (int i = 0; i < n; i++) {
            if (tempNum[i] == 1) {
                result.add(j, pokers.get(i));
                j++;
            }
        }

        resultList.add(result);// 打印第一种默认组合
        int k = 0;//标记位
        while (!end) {
            boolean findFirst = false;
            boolean swap = false;
            // 然后从左到右扫描数组元素值的"10"组合，找到第一个"10"组合后将其变为"01"
            for (int i = 0; i < n; i++) {
                int l = 0;
                if (!findFirst && tempNum[i] == 1) {
                    k = i;
                    findFirst = true;
                }
                if (tempNum[i] == 1 && tempNum[i + 1] == 0) {
                    tempNum[i] = 0;
                    tempNum[i + 1] = 1;
                    swap = true;
                    for (l = 0; l < i - k; l++) { // 同时将其左边的所有"1"全部移动到数组的最左端。
                        tempNum[l] = tempNum[k + l];
                    }
                    for (l = i - k; l < i; l++) {
                        tempNum[l] = 0;
                    }
                    if (k == i && i + 1 == n - m) {//假如第一个"1"刚刚移动到第n-m+1个位置,则终止整个寻找
                        end = true;
                    }
                }
                if (swap) {
                    break;
                }
            }

            result = new ArrayList<>(m);
            j = 0;
            for (int i = 0; i < n; i++) {
                if (tempNum[i] == 1) {
                    result.add(j, pokers.get(i));
                    j++;
                }
            }

            resultList.add(result);// 添加下一种默认组合
        }
        return resultList;
    }

    /**
     * 是否有赖子
     *
     * @param cardss
     * @param laiziValue
     * @return
     */
    public static boolean hasLaizi(List<Poker> cardss, int laiziValue) {
        if (null == cardss || cardss.isEmpty()) {
            return false;
        }
        for (Poker poker : cardss) {
            if (poker.getValue().equals(laiziValue) && poker.getColor().equals(Poker.Color.HONGTAO.getType())) {
                return true;
            }
        }
        return false;
    }

    /**
     * 最优理牌
     */
    public static GuandanPokersWeight arrangePoker(List<Poker> cardss, int laiziValue) {
        return arrangePoker(cardss, laiziValue, arrlist, true);
    }

    /**
     * 最优理牌
     */
    public static GuandanPokersWeight arrangePoker(List<Poker> cardss, int laiziValue, boolean sortByWeight) {
        return arrangePoker(cardss, laiziValue, arrlist, sortByWeight);
    }

    /**
     * 最优理牌
     */
    public static GuandanPokersWeight arrangePoker(List<Poker> cardss, int laiziValue, List<Integer> arrlist, boolean sortByWeight) {
        List<Poker> cards = copy(cardss);
        GuandanPokersWeight result = new GuandanPokersWeight();
        result.setPokers(cardss);

        //
        result.setWeightCount(0d);
        result.setGuandanPokers(new ArrayList<>());


        // 王炸
        List<List<Poker>> bomKing = getBomKing(cards);
        if (!bomKing.isEmpty()) {
            for (List<Poker> pokers : bomKing) {
                GuandanPokers guandanPokers = new GuandanPokers();
                guandanPokers.setPokers(pokers);
                CardType cardType = new CardType(CARDTYPE_BOMBCARDKING, 1000);
                guandanPokers.setWeight(getPokerWeight(cardType, pokers));
                guandanPokers.setCardType(cardType);
                //
                result.getGuandanPokers().add(guandanPokers);
                result.setWeightCount(result.getWeightCount() + guandanPokers.getWeight());

                deletePoker(cards, pokers, Poker::getNumber);
            }
        }

        List<Integer> myArrlist = new ArrayList<>();
        for (Integer type : arrlist) {
            switch (type) {
                case CARDTYPE_SINGLELINE:// 顺子
                    List<List<Poker>> shunziList = optimalSingleLine(cards, laiziValue);
                    if (!shunziList.isEmpty()) {
                        myArrlist.add(type);
                    }
                    break;
                case CARDTYPE_SINGLELINESAMECOLOR:// 同花顺
                    List<List<Poker>> shunziList_sameColor = optimalSingleSameColor(cards, laiziValue);
                    if (!shunziList_sameColor.isEmpty()) {
                        myArrlist.add(type);
                    }
                    break;
                case CARDTYPE_THREECARDLINE:// 钢板 +赖子
                    List<List<Poker>> sangetoulist1 = optimalGangban(cards, laiziValue);
                    if (!sangetoulist1.isEmpty()) {
                        myArrlist.add(type);
                    }
                    break;
                case CARDTYPE_THREECARD:// 三不带
                    List<List<Poker>> sangetoulist2 = mergeSame(cards, 3, true, true);
                    if (sangetoulist2.size() > 0) {
                        myArrlist.add(type);
                    }
                    break;
                case CARDTYPE_DOUBLECARD:// 对子
                    List<List<Poker>> duizilist = mergeSame(cards, 2, true, true);
                    if (duizilist.size() > 0) {
                        myArrlist.add(type);
                    }
                    break;
                case CARDTYPE_DOUBLECARDLINETHREE:// 三连对 +赖子
                    List<List<Poker>> duizilist2 = optimalBoubleLine(cards, laiziValue);
                    if (!duizilist2.isEmpty()) {
                        myArrlist.add(type);
                    }
                    break;
                case CARDTYPE_BOMBCARD:// 炸弹
                    List<List<Poker>> zhadanlist = optimalBomb(cards, laiziValue);
                    if (!zhadanlist.isEmpty()) {
                        myArrlist.add(type);
                    }
                    break;
                default:
                    System.err.println("未知类型" + type);
            }
        }

        // 有赖子
        if (hasLaizi(cards, laiziValue)) {

            // 癞子所有能出的类型
            myArrlist.remove((Object) CARDTYPE_THREECARD);
            myArrlist.remove((Object) CARDTYPE_DOUBLECARD);

        }


        if (myArrlist.isEmpty()) {
            List<List<Poker>> pokersList = mergeSame(cards, null, false, false);
            GuandanPokersWeight guandanPokersWeight = new GuandanPokersWeight();
            List<GuandanPokers> guandanPokers = new ArrayList<>();
            double weightCount = 0d;
            for (List<Poker> pokers : pokersList) {
                CardType cardType = cardType(pokers, laiziValue, null);
                double pokerWeight = getPokerWeight(cardType, pokers);
                weightCount = weightCount + pokerWeight;
                GuandanPokers guandanPokers1 = new GuandanPokers();
                guandanPokers1.setCardType(cardType);
                guandanPokers1.setPokers(pokers);
                guandanPokers1.setWeight(pokerWeight);
                guandanPokers.add(guandanPokers1);
            }
            guandanPokersWeight.setWeightCount(weightCount);
            guandanPokersWeight.setGuandanPokers(guandanPokers);
            //
            result.getGuandanPokers().addAll(guandanPokersWeight.getGuandanPokers());
            result.setWeightCount(result.getWeightCount() + guandanPokersWeight.getWeightCount());
            return result;
        }

        List<List<List<Poker>>> arrangeFinal = new ArrayList<>();
        Map<Integer, List<List<Poker>>> bbb = new HashMap<>();
        //
        List<String[]> permutation = permutationNoRepeat(myArrlist);
        for (String[] permuta : permutation) {
            List<List<Poker>> sb = new ArrayList<>();
            List<Poker> cards_copy = copy(cards);
            for (String types : permuta) {
                int type = Integer.parseInt(types);
                switch (type) {
                    case CARDTYPE_SINGLELINESAMECOLOR:// 同花顺
                        List<List<Poker>> shunziList_sameColor = optimalSingleSameColor(cards_copy, laiziValue);
                        if (shunziList_sameColor.size() > 0) {
                            sb.addAll(shunziList_sameColor);
                            deletePoker(cards_copy, mergeTogher(shunziList_sameColor), Poker::getNumber);
                        }
                        break;
                    case CARDTYPE_SINGLELINE:// 顺子
                        List<List<Poker>> shunziList = optimalSingleLine(cards_copy, laiziValue);
                        if (shunziList.size() > 0) {
                            sb.addAll(shunziList);
                            deletePoker(cards_copy, mergeTogher(shunziList), Poker::getNumber);
                        }
                        break;
                    case CARDTYPE_THREECARDLINE:// 钢板
                        List<List<Poker>> gangbans = optimalGangban(cards_copy, laiziValue);
                        if (gangbans.size() > 0) {
                            sb.addAll(gangbans);
                            try {
                                deletePoker(cards_copy, mergeTogher(gangbans), Poker::getNumber);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    case CARDTYPE_THREECARD:// 三不带
                        List<List<Poker>> sangetouList = mergeSame(cards_copy, 3, true, false);
                        if (sangetouList.size() > 0) {
                            sb.addAll(sangetouList);
                            deletePoker(cards_copy, mergeTogher(sangetouList), Poker::getNumber);
                        }
                        break;
                    case CARDTYPE_DOUBLECARD:// 对子
                        List<List<Poker>> duiziList1 = mergeSame(cards_copy, 2, false, false);
                        if (duiziList1.size() > 0) {
                            sb.addAll(duiziList1);
                            deletePoker(cards_copy, mergeTogher(duiziList1), Poker::getNumber);
                        }
                        break;
                    case CARDTYPE_DOUBLECARDLINETHREE:// 三连对
                        List<List<Poker>> lianduis = optimalBoubleLine(cards_copy, laiziValue);
                        if (lianduis.size() > 0) {
                            sb.addAll(lianduis);
                            deletePoker(cards_copy, mergeTogher(lianduis), Poker::getNumber);
                        }
                        break;
                    case CARDTYPE_BOMBCARD:// 炸弹
                        List<List<Poker>> zhadanList = optimalBomb(cards_copy, laiziValue);
                        if (zhadanList.size() > 0) {
                            sb.addAll(zhadanList);
                            deletePoker(cards_copy, mergeTogher(zhadanList), Poker::getNumber);
                        }
                        break;
                    default:
                        System.err.println("未知类型" + type);
                }
            }

            // 去重
            if (sb.size() > 0) {
                int hash = hashCode2(sb);
                if (!bbb.containsKey(hash)) {
                    bbb.put(hash, sb);
                    arrangeFinal.add(sb);
                }
            }
        }

        // ----------------------------------- 2 补齐剩余的牌
        for (List<List<Poker>> pokesList : arrangeFinal) {
            List<Poker> pokerList = mergeTogher(pokesList);
            List<Poker> cards_copy = copy(cards);
            deletePoker(cards_copy, pokerList, Poker::getNumber);
            List<List<Poker>> othersPokers = mergeSame(cards_copy, null, false, false);
            pokesList.addAll(othersPokers);
        }


//        // 找到整理长度最短的组合
//        if (arrangeFinal.size() > 1) {
//            Map<Integer, List<List<List<Poker>>>> sizeMap = new HashMap<>();
//            for (List<List<Poker>> lists : arrangeFinal) {
//                List<List<List<Poker>>> orDefault = sizeMap.getOrDefault(lists.size(), new ArrayList<>());
//                orDefault.add(lists);
//                sizeMap.put(lists.size(), orDefault);
//            }
//            arrangeFinal = sizeMap.get(Collections.min(new ArrayList<>(sizeMap.keySet())));
//
//            // 找到最小单的组合
//            if (arrangeFinal.size() > 1) {
//                Map<Integer, List<List<List<Poker>>>> sizeMap2 = new HashMap<>();
//                for (List<List<Poker>> lists : arrangeFinal) {
//                    int danzhang = 0;
//                    for (List<Poker> list : lists) {
//                        if (list.size() == 1) {
//                            danzhang++;
//                        }
//                    }
//                    List<List<List<Poker>>> orDefault = sizeMap2.getOrDefault(danzhang, new ArrayList<>());
//                    orDefault.add(lists);
//                    sizeMap2.put(danzhang, orDefault);
//                }
//                arrangeFinal = sizeMap2.get(Collections.min(new ArrayList<>(sizeMap2.keySet())));
//            }
//            //
//        }

        // 通过权重排序
        List<GuandanPokersWeight> guandanPokersWeights = new ArrayList<>();
        for (List<List<Poker>> pokersList : arrangeFinal) {
            GuandanPokersWeight guandanPokersWeight = new GuandanPokersWeight();
            List<GuandanPokers> guandanPokers = new ArrayList<>();
            double weightCount = 0d;
            for (List<Poker> pokers : pokersList) {
                CardType cardType = cardType(pokers, laiziValue, null);
                double pokerWeight = getPokerWeight(cardType, pokers);
                weightCount = weightCount + pokerWeight;
                GuandanPokers guandanPokers1 = new GuandanPokers();
                guandanPokers1.setCardType(cardType);
                guandanPokers1.setPokers(pokers);
                guandanPokers1.setWeight(pokerWeight);
                guandanPokers.add(guandanPokers1);
            }
            guandanPokersWeight.setWeightCount(weightCount);
            guandanPokersWeight.setGuandanPokers(guandanPokers);
            guandanPokersWeights.add(guandanPokersWeight);
        }

        //
        if (sortByWeight) {
            // 通过权重排序
            guandanPokersWeights.sort(Comparator.comparingDouble(GuandanPokersWeight::getWeightCount));
        } else {
            // 通过长度排序
            guandanPokersWeights.sort((a, b) -> Integer.compare(b.getGuandanPokers().size(), a.getGuandanPokers().size()));
//            guandanPokersWeights.sort(Comparator.comparingInt(a -> a.getGuandanPokers().size()));
        }

        // 找到权重最大的组合
        GuandanPokersWeight guandanPokersWeight = guandanPokersWeights.get(guandanPokersWeights.size() - 1);

        //
        result.getGuandanPokers().addAll(guandanPokersWeight.getGuandanPokers());
        result.setWeightCount(result.getWeightCount() + guandanPokersWeight.getWeightCount());

        return result;
    }

    /**
     * 找到最佳炸弹
     */
    public static List<List<Poker>> optimalBomb(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = copy(cards);
        for (int i = cards_copy.size() - 1; i >= 0; i--) {
            Poker poker = cards_copy.get(i);
            if (poker.getColor().equals(Poker.Color.KING.getType())) {
                cards_copy.remove(i);
            }
        }
        List<List<Poker>> result = new ArrayList<>();
        if (cards_copy.size() < 4) {
            return result;
        }

        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards_copy, laiziValue);
        List<Poker> laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        List<Poker> laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
        List<List<Poker>> cardsList = laizicomb(laiZiNot, laiziValue, laiZi.size(), true);
        Set<Integer> hashcodes = new HashSet<>();
        List<Map<Integer, List<Poker>>> a = new ArrayList<>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 4) {
                continue;
            }
            Map<Integer, List<Poker>> dd = getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; i--) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() < 4) {
                    dd.remove(value);
                }
            }
            dd.remove(Poker.VALUE_KING_DA);
            dd.remove(Poker.VALUE_KING_XIAO);
            //
//            a.add(dd);
            adddd_value(a, dd, hashcodes);
        }
        result = optimalBomb(a);
        laizibuquan2(result, laiZi);

        //
        if (!result.isEmpty() && laiZi.size() > 0) {
            deletePoker(cards_copy, mergeTogher(result), Poker::getNumber);
            List<List<Poker>> lists = optimalBomb(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    /**
     * 找到最佳炸弹
     */
    public static List<List<Poker>> optimalBomb(List<Map<Integer, List<Poker>>> a) {
//        quchong1(a);
        List<List<Poker>> result = new ArrayList<>();
        Map<Integer, List<List<List<Poker>>>> commmm = new HashMap<>();
        Set<Integer> hashcodes = new HashSet<>();
        for (Map<Integer, List<Poker>> duiziMap : a) {
            List<List<Poker>> b = new ArrayList<>();
            for (List<Poker> pokers : duiziMap.values()) {
                if (pokers.size() < 4) {
                    continue;
                }
//                b.add(copy(pokers.subList(0, 4 * (Math.abs(pokers.size() / 4)))));
                b.add(pokers);
            }
            //
            if (!b.isEmpty()) {

                // 去重
                int hashCode = hashCode2_value(b);
                if (hashcodes.contains(hashCode)) {
                    continue;
                } else {
                    hashcodes.add(hashCode);
                }

                //
                List<List<List<Poker>>> orDefault = commmm.getOrDefault(b.size(), new ArrayList<>());
                orDefault.add(b);
                commmm.put(b.size(), orDefault);
            }
        }
        //
        Optional<Integer> max = commmm.keySet().stream().max(Integer::compareTo);
        if (max.isPresent()) {
            List<List<List<Poker>>> lists = commmm.get(max.get());
            int maxweight = -1;
            for (List<List<Poker>> list : lists) {
                int weight = 0;
                for (List<Poker> pokers : list) {
                    weight = weight + pokers.get(pokers.size() - 1).getValue();
                }
                if (weight > maxweight) {
                    maxweight = weight;
                    result = list;
                }
            }
        }
        return result;
    }

    /**
     * 通过牌型获取权重
     *
     * @param cardType
     * @return
     */
    public static double getPokerWeight(CardType cardType, List<Poker> pokers) {
        double weightBase = 0.0d;// 基础权重
        double weightExtra = 0.0d;// 额外权重

        switch (cardType.getType()) {
            case CARDTYPE_SINGLECARD: // 单张
                weightBase = -1.5d;
                if (pokers.get(0).getValue().equals(Poker.VALUE_KING_XIAO)) {
                    // 小王
                    weightExtra = 22.0d / 20d;
                } else if (pokers.get(0).getValue().equals(Poker.VALUE_KING_DA)) {
                    weightExtra = 25.0d / 20d;
                    //todo
                } else if (pokers.get(0).getValue().equals(Poker.Color.HONGTAO.getType())) {

                } else {
                    weightExtra = cardType.getWeight() / 25d;
                }
                break;
            case CARDTYPE_DOUBLECARD:// 对子
                weightBase = -0.125d;
                if (pokers.get(0).getValue().equals(Poker.VALUE_KING_XIAO)) {
                    weightExtra = (22.0d / 20d);
                } else if (pokers.get(0).getValue().equals(Poker.VALUE_KING_DA)) {
                    weightExtra = (25.0d / 20d);
                } else {
                    weightExtra = cardType.getWeight() / 21.75d;
                }
                break;
            case CARDTYPE_DOUBLECARDLINETHREE:// 三连对
                weightBase = 0.15d * pokers.size() / 2d;
                for (int a = 0; a < pokers.size() / 2; a++) {
                    weightExtra = weightExtra + (cardType.getWeight() - a) / 20.0d;
                }
                break;
            case CARDTYPE_THREECARD:// 三不带
                weightBase = 0.575d;
                weightExtra = cardType.getWeight() / 20.0d;
                break;
            case CARDTYPE_THREECARDTWO:// 三带二
                weightBase = 0.675d;
                weightExtra = cardType.getWeight() / 20.0d;
                break;
            case CARDTYPE_THREECARDLINE:// 钢板
                weightBase = 0.625d * pokers.size() / 3d;
                for (int a = 0; a < pokers.size() / 3; a++) {
                    weightExtra = weightExtra + (cardType.getWeight() - a) / 20.0d;
                }
                break;
            case CARDTYPE_SINGLELINE:// 顺子
                weightBase = 1.475d;
                weightExtra = cardType.getWeight() / 20.0d;
                break;
            case CARDTYPE_SINGLELINESAMECOLOR:// 同花顺
                weightBase = 2.155d;
                double daxiao1 = cardType.getWeight() / 100.0d;
                weightExtra = 5.555d / 4.0d + daxiao1 / 20.0d;
                break;
            case CARDTYPE_BOMBCARD:// 炸弹
                weightBase = 2.155d;
                double daxiao2 = cardType.getWeight() / 100.0d;
                weightExtra = pokers.size() / 4.0d + daxiao2 / 20.0d;
                break;
            case CARDTYPE_BOMBCARDKING:// 王炸
                weightBase = 2.155d;
                weightExtra = cardType.getWeight() / 1000.0d * 2.5d;
                break;
            default:
                System.err.println("未知牌型" + cardType.getType());
        }
        return weightBase + weightExtra;
    }

    /**
     * 找到最佳钢板
     */
    private static List<List<Poker>> optimalGangban(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = copy(cards);
        List<List<Poker>> result = new ArrayList<>();
        if (cards_copy.size() < 6) {
            return result;
        }

        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards_copy, laiziValue);
        List<Poker> laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        List<Poker> laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
        List<List<Poker>> cardsList = laizicomb(laiZiNot, laiziValue, laiZi.size());
        Set<Integer> hashcodes = new HashSet<>();
        List<Map<Integer, List<Poker>>> a = new ArrayList<>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 6) {
                continue;
            }
            Map<Integer, List<Poker>> dd = getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; i--) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() < 3) {
                    dd.remove(value);
                }
            }
            dd.remove(Poker.VALUE_KING_DA);
            dd.remove(Poker.VALUE_KING_XIAO);
            if (dd.size() < 2) {
                continue;
            }
            //
//            a.add(dd);
            adddd_value(a, dd, hashcodes);

            if (dd.containsKey(1)) {
                HashMap<Integer, List<Poker>> b = new LinkedHashMap<>(dd);
                b.replaceAll((integer, pokers) -> copy(pokers));
                b.put(14, b.remove(1));
//                a.add(b);
                adddd_value(a, b, hashcodes);
            }
        }
        result = optimalGangban(a);
        laizibuquan2(result, laiZi);

        //
        if (!result.isEmpty() && laiZi.size() > 0) {
            deletePoker(cards_copy, mergeTogher(result), Poker::getNumber);
            List<List<Poker>> lists = optimalGangban(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    private static List<List<Poker>> optimalSanDaiEr(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = copy(cards);
        List<List<Poker>> result = new ArrayList<>();
        if (cards_copy.size() < 5) {
            return result;
        }

        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards_copy, laiziValue);
        List<Poker> laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        List<Poker> laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
        List<List<Poker>> cardsList = laizicomb(laiZiNot, laiziValue, laiZi.size());
        Set<Integer> hashcodes = new HashSet<>();
        List<Map<Integer, List<Poker>>> a = new ArrayList<>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 5) {
                continue;
            }
            Map<Integer, List<Poker>> dd = getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; i--) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() < 3) {
                    dd.remove(value);
                }
            }
            dd.remove(Poker.VALUE_KING_DA);
            dd.remove(Poker.VALUE_KING_XIAO);
            if (dd.size() < 2) {
                continue;
            }
            //
//            a.add(dd);
            adddd_value(a, dd, hashcodes);

            if (dd.containsKey(1)) {
                HashMap<Integer, List<Poker>> b = new LinkedHashMap<>(dd);
                b.replaceAll((integer, pokers) -> copy(pokers));
                b.put(14, b.remove(1));
//                a.add(b);
                adddd_value(a, b, hashcodes);
            }
        }
        result = optimalGangban(a);
        laizibuquan2(result, laiZi);

        //
        if (!result.isEmpty() && laiZi.size() > 0) {
            deletePoker(cards_copy, mergeTogher(result), Poker::getNumber);
            List<List<Poker>> lists = optimalGangban(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    /**
     * 找到最佳钢板
     */
    private static List<List<Poker>> optimalGangban(List<Map<Integer, List<Poker>>> a) {
        List<List<Poker>> result = new ArrayList<>();

        int sizeMax = 0;
        int oneMin = maxNum;
        int twoMin = maxNum;
        double weightMax = 0d;

        for (Map<Integer, List<Poker>> listMap : a) {
            OptimalCards optimalGangban = optimalGangban(listMap);

            boolean add = false;
            int size = optimalGangban.getSize();
            double weight = optimalGangban.getWeight();
            int twoCount = optimalGangban.getTwoCount();
            int oneCount = optimalGangban.getOneCount();
            List<List<Poker>> b = optimalGangban.getPokersList();

            if (oneMin >= oneCount) {
                if (oneMin > oneCount) {
                    add = true;
                } else {
                    if (twoMin >= twoCount) {
                        if (twoMin > twoCount) {
                            add = true;
                        } else {
                            if (sizeMax <= size) {
                                if (sizeMax < size) {
                                    add = true;
                                } else {
                                    add = weightMax <= weight;
                                }
                            }
                        }
                    }
                }
            }
            if (add) {
                oneMin = oneCount;
                twoMin = twoCount;
                sizeMax = size;
                weightMax = weight;
                result = b;
            }
        }
        //
        return result;
    }

    private static OptimalCards optimalGangban(Map<Integer, List<Poker>> listMap) {
        OptimalCards optimalCards = new OptimalCards();
        boolean firstAdd = false;
        //
        List<Integer> values = new ArrayList<>(listMap.keySet());
        for (int i = 0; i <= values.size() - 2; i++) {
            //
            int i1 = i;
            int i2 = i + 1;

            Integer value1 = values.get(i1);
            Integer value2 = values.get(i2);

            boolean a1 = value1 + 1 == value2;

            if (a1) {
                Map<Integer, List<Poker>> duiziMap = new LinkedHashMap<>(listMap);
                duiziMap.replaceAll((integer, poker) -> copy(poker));
                //
                List<Poker> list1 = duiziMap.get(value1);
                if (list1.size() < 3) {
                    continue;
                }
                List<Poker> list2 = duiziMap.get(value2);
                if (list2.size() < 3) {
                    continue;
                }

                //
                List<Poker> sangetou1 = new ArrayList<>(list1.subList(0, 3));
                List<Poker> sangetou2 = new ArrayList<>(list2.subList(0, 3));
                //
                List<Poker> add = new ArrayList<>(6);
                add.addAll(sangetou1);
                add.addAll(sangetou2);
                //
                list1.removeAll(sangetou1);
                list2.removeAll(sangetou2);

                // 1
                int oneCount = 0;
                int twoCount = 0;
                for (List<Poker> pokers : duiziMap.values()) {
                    if (pokers.size() == 1) {
                        oneCount++;
                    }
                    if (pokers.size() == 2) {
                        twoCount++;
                    }
                }

                //
                OptimalCards optimalGangban = optimalGangban(duiziMap);
                if (optimalGangban.getSize() < 1) {
                    optimalGangban.setOneCount(optimalGangban.getOneCount() + oneCount);
                    optimalGangban.setTwoCount(optimalGangban.getTwoCount() + twoCount);
                }
                optimalGangban.getPokersList().add(add);
                optimalGangban.setSize(optimalGangban.getPokersList().size());
                optimalGangban.setWeight(optimalGangban.getWeight() + value2);


                // 2
                boolean isAdd = false;
                if (optimalGangban.getSize() > 0) {
                    if (optimalCards.getOneCount() >= optimalGangban.getOneCount()) {
                        if (optimalCards.getOneCount() > optimalGangban.getOneCount()) {
                            isAdd = true;
                        } else {
                            if (optimalCards.getTwoCount() >= optimalGangban.getTwoCount()) {
                                if (optimalCards.getTwoCount() > optimalGangban.getTwoCount()) {
                                    isAdd = true;
                                } else {
                                    if (optimalCards.getSize() <= optimalGangban.getSize()) {
                                        if (optimalCards.getSize() < optimalGangban.getSize()) {
                                            isAdd = true;
                                        } else {
                                            isAdd = optimalCards.getWeight() <= optimalGangban.getWeight();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (isAdd || !firstAdd) {
                    firstAdd = true;
                    optimalCards = optimalGangban;
                }
            }
        }
        return optimalCards;
    }

    private static void adddd_value(List<Map<Integer, List<Poker>>> a, Map<Integer, List<Poker>> dd, Set<Integer> hashcodes) {
        int hashCode = hashCode_value(dd);
        if (!hashcodes.contains(hashCode)) {
            hashcodes.add(hashCode);
            a.add(dd);
        }
    }

    public static final int maxNum = 100;

    private static class OptimalCards {
        int size = 0;
        int oneCount = 0;
        int twoCount = 0;
        double weight = 0d;

        List<List<Poker>> pokersList = new ArrayList<>();

        public int getSize() {
            return size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getOneCount() {
            return oneCount;
        }

        public void setOneCount(int oneCount) {
            this.oneCount = oneCount;
        }

        public int getTwoCount() {
            return twoCount;
        }

        public void setTwoCount(int twoCount) {
            this.twoCount = twoCount;
        }

        public double getWeight() {
            return weight;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }

        public List<List<Poker>> getPokersList() {
            return pokersList;
        }

        public void setPokersList(List<List<Poker>> pokersList) {
            this.pokersList = pokersList;
        }
    }

    private static OptimalCards optimalSingleLine(Map<Integer, List<Poker>> listMap) {
        OptimalCards optimalCards = new OptimalCards();
        boolean firstAdd = false;
        //
        List<Integer> values = new ArrayList<>(listMap.keySet());
        for (int i = 0; i <= values.size() - 5; i++) {
            //
            int i1 = i;
            int i2 = i + 1;
            int i3 = i + 2;
            int i4 = i + 3;
            int i5 = i + 4;

            Integer value1 = values.get(i1);
            Integer value2 = values.get(i2);
            Integer value3 = values.get(i3);
            Integer value4 = values.get(i4);
            Integer value5 = values.get(i5);

            boolean a1 = value1 + 1 == value2;
            boolean a2 = value2 + 1 == value3;
            boolean a3 = value3 + 1 == value4;
            boolean a4 = value4 + 1 == value5;

            if (a1 && a2 && a3 && a4) {
                Map<Integer, List<Poker>> duiziMap = new LinkedHashMap<>(listMap);
                duiziMap.replaceAll((integer, poker) -> copy(poker));
                //
                List<Poker> list1 = duiziMap.get(value1);
                if (list1.isEmpty()) {
                    continue;
                }
                List<Poker> list2 = duiziMap.get(value2);
                if (list2.isEmpty()) {
                    continue;
                }
                List<Poker> list3 = duiziMap.get(value3);
                if (list3.isEmpty()) {
                    continue;
                }
                List<Poker> list4 = duiziMap.get(value4);
                if (list4.isEmpty()) {
                    continue;
                }
                List<Poker> list5 = duiziMap.get(value5);
                if (list5.isEmpty()) {
                    continue;
                }

                List<Poker> add = new ArrayList<>(5);

                add.add(list1.get(0));
                add.add(list2.get(0));
                add.add(list3.get(0));
                add.add(list4.get(0));
                add.add(list5.get(0));
                //
                list1.remove(0);
                list2.remove(0);
                list3.remove(0);
                list4.remove(0);
                list5.remove(0);

                // 1
                int oneCount = 0;
                int twoCount = 0;
                for (List<Poker> pokers : duiziMap.values()) {
                    if (pokers.size() == 1) {
                        oneCount++;
                    }
                    if (pokers.size() == 2) {
                        twoCount++;
                    }
                }

                //
                OptimalCards optimalSingleBest = optimalSingleLine(duiziMap);
                if (optimalSingleBest.getSize() < 1) {
                    optimalSingleBest.setOneCount(optimalSingleBest.getOneCount() + oneCount);
                    optimalSingleBest.setTwoCount(optimalSingleBest.getTwoCount() + twoCount);
                }
                optimalSingleBest.getPokersList().add(add);
                optimalSingleBest.setSize(optimalSingleBest.getPokersList().size());
                optimalSingleBest.setWeight(optimalSingleBest.getWeight() + value5);

                // 2
                boolean isAdd = false;
                if (optimalSingleBest.getSize() > 0) {
                    if (optimalCards.getOneCount() >= optimalSingleBest.getOneCount()) {
                        if (optimalCards.getOneCount() > optimalSingleBest.getOneCount()) {
                            isAdd = true;
                        } else {
                            if (optimalCards.getTwoCount() >= optimalSingleBest.getTwoCount()) {
                                if (optimalCards.getTwoCount() > optimalSingleBest.getTwoCount()) {
                                    isAdd = true;
                                } else {
                                    if (optimalCards.getSize() <= optimalSingleBest.getSize()) {
                                        if (optimalCards.getSize() < optimalSingleBest.getSize()) {
                                            isAdd = true;
                                        } else {
                                            isAdd = optimalCards.getWeight() <= optimalSingleBest.getWeight();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (isAdd || !firstAdd) {
                    firstAdd = true;
                    optimalCards = optimalSingleBest;
                }

            } else {
                //
                if (a4) {
                    i = i4;
                    if (a3) {
                        i = i3;
                        if (a2) {
                            i = i2;
                        }
                    }
                    i = i - 1;
                }
            }
        }
        return optimalCards;
    }

    /**
     * 找到最佳顺子
     */
    private static List<List<Poker>> optimalSingleLine(List<Map<Integer, List<Poker>>> a) {
        List<List<Poker>> result = new ArrayList<>();

        int sizeMax = 0;
        int oneMin = maxNum;
        int twoMin = maxNum;
        double weightMax = 0d;

        for (Map<Integer, List<Poker>> listMap : a) {

            OptimalCards optimalCards = optimalSingleLine(listMap);
            if (optimalCards.getSize() < 1) {
                continue;
            }

            boolean add = false;
            int size = optimalCards.getSize();
            double weight = optimalCards.getWeight();
            int twoCount = optimalCards.getTwoCount();
            int oneCount = optimalCards.getOneCount();
            List<List<Poker>> b = optimalCards.getPokersList();

            if (oneMin >= oneCount) {
                if (oneMin > oneCount) {
                    add = true;
                } else {
                    if (twoMin >= twoCount) {
                        if (twoMin > twoCount) {
                            add = true;
                        } else {
                            if (sizeMax <= size) {
                                if (sizeMax < size) {
                                    add = true;
                                } else {
                                    add = weightMax <= weight;
                                }
                            }
                        }
                    }
                }
            }
            if (add) {
                oneMin = oneCount;
                twoMin = twoCount;
                sizeMax = size;
                weightMax = weight;
                result = b;
            }
        }
        //
        return result;
    }

    /**
     * 找到最佳顺子
     */
    public static List<List<Poker>> optimalSingleLine(List<Poker> cards, int laiziValue) {
        return optimalSingleLine(cards, laiziValue, false);
    }

    /**
     * 找到最佳顺子 或者 同花顺
     */
    public static List<List<Poker>> optimalSingleLine(List<Poker> cards, int laiziValue, boolean sameColor) {
        List<Poker> cards_copy = copy(cards);
        List<List<Poker>> result = new ArrayList<>();
        if (cards_copy.size() < 5) {
            return result;
        }
        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards_copy, laiziValue);
        List<Poker> laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        List<Poker> laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
        List<List<Poker>> cardsList = laizicomb(laiZiNot, laiziValue, laiZi.size());
        Set<Integer> hashcodes = new HashSet<>();
        List<Map<Integer, List<Poker>>> a = new ArrayList<>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 5) {
                continue;
            }

            if (sameColor) {
                // 同花顺
                Map<Integer, Map<Integer, List<Poker>>> pokerColorAndValue = getPokerColorAndValue(pokers1);
                for (Map<Integer, List<Poker>> dd : pokerColorAndValue.values()) {
                    dd.remove(Poker.VALUE_KING_DA);
                    dd.remove(Poker.VALUE_KING_XIAO);
                    if (dd.size() < 5) {
                        continue;
                    }
                    adddd_value(a, dd, hashcodes);
                    if (dd.containsKey(1)) {
                        HashMap<Integer, List<Poker>> b = new LinkedHashMap<>(dd);
                        b.replaceAll((integer, poker) -> copy(poker));
                        b.put(14, b.remove(1));
                        adddd_value(a, b, hashcodes);
                    }
                }
            } else {
                // 顺子
                Map<Integer, List<Poker>> dd = getPokerMapByValue(pokers1);
                dd.remove(Poker.VALUE_KING_DA);
                dd.remove(Poker.VALUE_KING_XIAO);
                if (dd.size() < 5) {
                    continue;
                }
                adddd_value(a, dd, hashcodes);
                if (dd.containsKey(1)) {
                    HashMap<Integer, List<Poker>> b = new LinkedHashMap<>(dd);
                    b.replaceAll((integer, poker) -> copy(poker));
                    b.put(14, b.remove(1));
                    adddd_value(a, b, hashcodes);
                }
            }


        }

        result = optimalSingleLine(a);
        //
        optimalSameColor(result, cards, laiziValue);

        laizibuquan2(result, laiZi);

        //
        if (!result.isEmpty() && laiZi.size() > 0) {
            deletePoker(cards_copy, mergeTogher(result), Poker::getNumber);
            List<List<Poker>> lists = optimalSingleLine(cards_copy, laiziValue, sameColor);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }

        return result;
    }

    /**
     * 赖子组合
     */
    private static List<List<Poker>> laizicomb(List<Poker> cards, int laiziValue, int laiziCount, boolean all) {
        List<List<Poker>> cardsList = new ArrayList<>();

        if (all) {
            if (laiziCount == 1) {
                List<List<Poker>> zuhe = copy2(initLaiZi_1.get(laiziValue));
                for (List<Poker> pokers : zuhe) {
                    List<Poker> copy_cards = copy(cards);
                    copy_cards.addAll(pokers);
                    cardsList.add(copy_cards);
                }
            } else if (laiziCount == 2) {
                List<List<Poker>> zuhe = copy2(initLaiZi_2.get(laiziValue));
                for (List<Poker> pokers : zuhe) {
                    List<Poker> copy_cards = copy(cards);
                    copy_cards.addAll(pokers);
                    cardsList.add(copy_cards);
                }
            } else {
                cardsList.add(cards);
            }
        } else {
            if (laiziCount > 0) {
                List<List<Poker>> zuhe = copy2(initLaiZi_1.get(laiziValue));
                for (List<Poker> pokers : zuhe) {
                    List<Poker> copy_cards = copy(cards);
                    copy_cards.addAll(pokers);
                    cardsList.add(copy_cards);
                }
            } else {
                cardsList.add(cards);
            }
        }


        return cardsList;
    }

    /**
     * 赖子组合
     */
    private static List<List<Poker>> laizicomb(List<Poker> cards, int laiziValue, int laiziCount) {
        return laizicomb(cards, laiziValue, laiziCount, false);
    }

    private static final ArrayList defaultList = new ArrayList<>();

    private static final HashMap<?, ?> defaultMap = new HashMap<>();

    private static Map<Integer, List<Poker>> getPokerMapByColor(List<Poker> cards) {
        Map<Integer, List<Poker>> dd = new HashMap<>();
        for (Poker poker : cards) {
            Integer color = poker.getColor();
            List<Poker> orDefault = dd.getOrDefault(color, new ArrayList<>());
            orDefault.add(poker);
            dd.put(color, orDefault);
        }
        return dd;
    }

    //获取手牌集合   3   33
    //             4   44
    public static Map<Integer, List<Poker>> getPokerMapByValue(List<Poker> cards) {
        Map<Integer, List<Poker>> dd = new HashMap<>();
        for (Poker poker : cards) {
            Integer value = poker.getValue();
            List<Poker> orDefault = dd.getOrDefault(value, new ArrayList<>());
            orDefault.add(poker);
            dd.put(value, orDefault);
        }
        return dd;
    }

    public static Map<Integer, List<GuandanPokers>> getGuandanPokerMapByValue(List<GuandanPokers> guandanPokers) {
        Map<Integer, List<GuandanPokers>> aa = new HashMap<>();
        for (GuandanPokers guandanPoker : guandanPokers) {
            List<Poker> pokers = guandanPoker.getPokers();
            Integer value = null;
            for (Poker poker : pokers) {
                value = poker.getValue();
                List<GuandanPokers> orDefault = aa.getOrDefault(value, new ArrayList<>());
                orDefault.add(guandanPoker);
                aa.put(value, orDefault);
            }

        }
        return aa;
    }

    private static void optimalSameColor(List<List<Poker>> cardsList, List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = copy(cards);
        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards_copy, laiziValue);
        List<Poker> laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        List<Poker> laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());

        List<Integer> laiziValues = new ArrayList<>();
        for (List<Poker> pokers : cardsList) {
            for (Poker poker : pokers) {
                if (null == poker.getNumber()) {
                    laiziValues.add(poker.getValue());
                }
            }
        }
        for (int i = 0; i < laiZi.size() - laiziValues.size(); i++) {
            laiziValues.add(-1);
        }

        Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap = getColorAndValuesMap(laiZiNot);


        cardsList.sort((o1, o2) -> {
            MaxColorAndSize sizeByColorAndValuesMap1 = getMaxColorAndSizeByColorAndValuesMap(o1, colorAndValuesMap);
            MaxColorAndSize sizeByColorAndValuesMap2 = getMaxColorAndSizeByColorAndValuesMap(o2, colorAndValuesMap);
            return Integer.compare(sizeByColorAndValuesMap1.getSizeMax(), sizeByColorAndValuesMap2.getSizeMax());
        });

        List<Integer> setIndex = new ArrayList<>();

        for (int i = cardsList.size() - 1; i >= 0; i--) {
            List<Poker> pokers = cardsList.get(i);
            Set<Integer> values = CollectUtil.getSet(pokers, Poker::getValue);
            boolean has = false;
            List<Poker> shunzi = new ArrayList<>();

            for (Integer color_ : colorAndValuesMap.keySet()) {
                Map<Integer, List<Poker>> value = colorAndValuesMap.get(color_);
                HashSet<Integer> values_copy = new HashSet<>(values);
                values_copy.removeAll(value.keySet());

                if (!values_copy.isEmpty()) {

                    boolean ex = true;

                    if (values_copy.size() > laiziValues.size()) {
                        continue;
                    }

                    ArrayList<Integer> laiziValues_copy = new ArrayList<>(laiziValues);
                    for (Integer value_ : values_copy) {
                        if (laiziValues_copy.contains(value_)) {
                            laiziValues_copy.remove(value_);
                        } else if (laiziValues_copy.contains(-1)) {
                            laiziValues_copy.remove((Object) (-1));
                        } else {
                            ex = false;
                            break;
                        }
                    }

                    if (!ex) {
                        continue;
                    }
                    values_copy.clear();
                }

                //

                for (Integer value_ : values) {
                    List<Poker> pokers1 = value.get(value_);
                    if (null == pokers1 || pokers1.isEmpty()) {
                        //
                        shunzi.add(laiZi.remove(0));
                        boolean remove = laiziValues.remove((Object) value_);
                        if (!remove) {
                            laiziValues.remove((Object) (-1));
                        }
                        continue;
                    }
                    shunzi.add(copy(pokers1.remove(0)));
                    value.put(value_, pokers1);
                    if (pokers1.isEmpty()) {
                        value.remove(value_);
                    }
                }
                if (value.isEmpty()) {
                    colorAndValuesMap.remove(color_);
                }

                has = true;

                break;
            }


            if (has) {
                cardsList.set(i, shunzi);
            } else {
                setIndex.add(i);
            }
        }

        for (Integer index : setIndex) {
            List<Poker> pokers = cardsList.get(index);
            Set<Integer> values = CollectUtil.getSet(pokers, Poker::getValue);
            List<Poker> shunzi = new ArrayList<>();

            for (Map<Integer, List<Poker>> value : colorAndValuesMap.values()) {
                Set<Integer> values_ = new HashSet<>(value.keySet());
                for (Integer value_ : values) {
                    List<Poker> pokers1 = value.get(value_);
                    if (null == pokers1 || pokers1.isEmpty()) {
                        continue;
                    }
                    shunzi.add(copy(pokers1.remove(0)));
                    value.put(value_, pokers1);
                    if (pokers1.isEmpty()) {
                        value.remove(value_);
                    }
                }
                values.removeAll(values_);
                if (values.isEmpty()) {
                    break;
                }
            }

            if (shunzi.size() == pokers.size()) {

            } else {
                int needLaiziCount = pokers.size() - shunzi.size();
                if (needLaiziCount <= laiZi.size()) {
                    ArrayList<Poker> pokers3 = new ArrayList<>(laiZi.subList(0, needLaiziCount));
                    shunzi.addAll(pokers3);
                    laiZi.removeAll(pokers3);
                }
            }
            cardsList.set(index, shunzi);
        }

    }

    private static List<Poker> getRamdonValue(Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap, Integer value, Integer size) {
        List<Poker> result = new ArrayList<>();
        for (Map<Integer, List<Poker>> integerListMap : colorAndValuesMap.values()) {
            List<Poker> pokers = integerListMap.get(value);
            if (null == pokers || pokers.isEmpty()) {
                continue;
            }
            ArrayList<Poker> pokers1 = new ArrayList<>(pokers.subList(0, Math.min(pokers.size(), size)));
            result.addAll(pokers1);
            size = size - pokers1.size();
        }
        return result;
    }

    private static void removeColorAndValuesMap(Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap, Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap2) {
        for (Integer color : colorAndValuesMap2.keySet()) {
            Map<Integer, List<Poker>> integerListMap = colorAndValuesMap.get(color);
            if (null == integerListMap) {
                continue;
            }
            Map<Integer, List<Poker>> integerListMap1 = colorAndValuesMap2.get(color);
            for (Integer value : integerListMap1.keySet()) {

                List<Poker> pokers = integerListMap.get(value);
                if (null == pokers || pokers.isEmpty()) {
                    continue;
                }
                List<Poker> pokers1 = integerListMap1.get(value);
                pokers.removeAll(pokers1);

                if (pokers.isEmpty()) {
                    integerListMap.remove(value);
                }
            }
            if (integerListMap.isEmpty()) {
                colorAndValuesMap.remove(color);
            }
        }
    }

    private static Map<Integer, Map<Integer, List<Poker>>> getColorAndValuesMap(List<Poker> cards) {
        Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap = new HashMap<>();
        for (Poker poker : cards) {
            Integer pokerColor = poker.getColor();
            Integer pokerValue = poker.getValue();
            Map<Integer, List<Poker>> pokerValueMap = colorAndValuesMap.getOrDefault(pokerColor, new HashMap<>());
            List<Poker> pokersTemp1 = pokerValueMap.getOrDefault(pokerValue, new ArrayList<>());
            pokersTemp1.add(poker);
            pokerValueMap.put(pokerValue, pokersTemp1);
            colorAndValuesMap.put(pokerColor, pokerValueMap);
        }
        return colorAndValuesMap;
    }

    private static MaxColorAndSize getMaxColorAndSizeByColorAndValuesMap(List<Poker> cards, Map<Integer, Map<Integer, List<Poker>>> colorAndValuesMap) {
        MaxColorAndSize maxColorAndSize = new MaxColorAndSize();
        Map<Integer, List<Poker>> pokerMapByValue = getPokerMapByValue(cards);
        Set<Integer> valuesTemp = pokerMapByValue.keySet();
        int sizeMax = 0;
        int colorMax = -1;
        Map<Integer, List<Poker>> pokersMap = null;
        for (Integer color : colorAndValuesMap.keySet()) {
            int size = 0;
            Map<Integer, List<Poker>> pokersTemp = new HashMap<>();
            Map<Integer, List<Poker>> valueTempMap = colorAndValuesMap.get(color);
            for (Integer valueTemp : valuesTemp) {
                List<Poker> a1 = valueTempMap.getOrDefault(valueTemp, new ArrayList<>());
                List<Poker> a2 = pokerMapByValue.get(valueTemp);
                if (a1.size() < a2.size()) {
                    continue;
                }
                size = size + a2.size();
                pokersTemp.put(valueTemp, new ArrayList<>(a1.subList(0, a2.size())));
            }
            if (size > sizeMax) {
                sizeMax = size;
                colorMax = color;
                pokersMap = pokersTemp;
            }
        }
        maxColorAndSize.setColor(colorMax);
        maxColorAndSize.setSizeMax(sizeMax);
        maxColorAndSize.setPokersMap(pokersMap);
        return maxColorAndSize;
    }

    private static class MaxColorAndSize {
        private Integer color;
        private Integer sizeMax;
        private Map<Integer, List<Poker>> pokersMap;

        public Map<Integer, List<Poker>> getPokersMap() {
            return pokersMap;
        }

        public void setPokersMap(Map<Integer, List<Poker>> pokersMap) {
            this.pokersMap = pokersMap;
        }


        public Integer getColor() {
            return color;
        }

        public void setColor(Integer color) {
            this.color = color;
        }

        public Integer getSizeMax() {
            return sizeMax;
        }

        public void setSizeMax(Integer sizeMax) {
            this.sizeMax = sizeMax;
        }


    }

    private static Map<Integer, Map<Integer, List<Poker>>> getPokerColorAndValue(List<Poker> cards) {
        Map<Integer, Map<Integer, List<Poker>>> pokerColorAndValue = new HashMap<>();
        for (Poker card : cards) {
            Integer color = card.getColor();
            Integer value = card.getValue();
            Map<Integer, List<Poker>> valueMap = pokerColorAndValue.getOrDefault(color, new HashMap<>());
            List<Poker> pokers = valueMap.getOrDefault(value, new ArrayList<>());
            pokers.add(card);
            valueMap.put(value, pokers);
            pokerColorAndValue.put(color, valueMap);
        }
        return pokerColorAndValue;
    }

    /**
     * 赖子补全
     */
    private static void laizibuquan1(List<Poker> cards, List<Poker> laiZis) {
        if (laiZis.size() == 0) {
            return;
        }
        for (Poker card : cards) {
            if (null == card.getNumber()) {
                Poker laizi = laiZis.get(0);
                card.setNumber(laizi.getNumber());
                card.setValue(laizi.getValue());
                card.setColor(laizi.getColor());
                laiZis.remove(0);
            }
        }
    }

    /**
     * 赖子补全
     */
    private static void laizibuquan2(List<List<Poker>> cardsList, List<Poker> laiZis) {
        if (laiZis.size() == 0) {
            return;
        }
        for (List<Poker> pokers : cardsList) {
            laizibuquan1(pokers, laiZis);
        }
    }

    /**
     * 找到最佳三连对
     */
    private static OptimalCards optimalBoubleLine(Map<Integer, List<Poker>> listMap) {
        OptimalCards optimalCards = new OptimalCards();
        boolean firstAdd = false;
        //
        List<Integer> values = new ArrayList<>(listMap.keySet());
        for (int i = 0; i <= values.size() - 3; i++) {
            //
            int i1 = i;
            int i2 = i + 1;
            int i3 = i + 2;

            Integer value1 = values.get(i1);
            Integer value2 = values.get(i2);
            Integer value3 = values.get(i3);
            boolean a1 = value1 + 1 == value2;
            boolean a2 = value2 + 1 == value3;
            if (a1 && a2) {
                Map<Integer, List<Poker>> duiziMap = new LinkedHashMap<>(listMap);
                duiziMap.replaceAll((integer, poker) -> copy(poker));
                //
                List<Poker> list1 = duiziMap.get(value1);
                if (list1.size() < 2) {
                    continue;
                }
                List<Poker> list2 = duiziMap.get(value2);
                if (list2.size() < 2) {
                    continue;
                }
                List<Poker> list3 = duiziMap.get(value3);
                if (list3.size() < 2) {
                    continue;
                }
                //
                List<Poker> duizi1 = new ArrayList<>(list1.subList(0, 2));
                List<Poker> duizi2 = new ArrayList<>(list2.subList(0, 2));
                List<Poker> duizi3 = new ArrayList<>(list3.subList(0, 2));
                //
                List<Poker> add = new ArrayList<>(6);
                add.addAll(duizi1);
                add.addAll(duizi2);
                add.addAll(duizi3);
                //
                list1.removeAll(duizi1);
                list2.removeAll(duizi2);
                list3.removeAll(duizi3);

                // 1
                int oneCount = 0;
                int twoCount = 0;
                for (List<Poker> pokers : duiziMap.values()) {
                    if (pokers.size() == 1) {
                        oneCount++;
                    }
                    if (pokers.size() == 2) {
                        twoCount++;
                    }
                }

                //
                OptimalCards optimalBoubleLine = optimalBoubleLine(duiziMap);
                if (optimalBoubleLine.getSize() < 1) {
                    optimalBoubleLine.setOneCount(optimalBoubleLine.getOneCount() + oneCount);
                    optimalBoubleLine.setTwoCount(optimalBoubleLine.getTwoCount() + twoCount);
                }
                optimalBoubleLine.getPokersList().add(add);
                optimalBoubleLine.setSize(optimalBoubleLine.getPokersList().size());
                optimalBoubleLine.setWeight(optimalBoubleLine.getWeight() + value3);


                // 2
                boolean isAdd = false;
                if (optimalBoubleLine.getSize() > 0) {
                    if (optimalCards.getOneCount() >= optimalBoubleLine.getOneCount()) {
                        if (optimalCards.getOneCount() > optimalBoubleLine.getOneCount()) {
                            isAdd = true;
                        } else {
                            if (optimalCards.getTwoCount() >= optimalBoubleLine.getTwoCount()) {
                                if (optimalCards.getTwoCount() > optimalBoubleLine.getTwoCount()) {
                                    isAdd = true;
                                } else {
                                    if (optimalCards.getSize() <= optimalBoubleLine.getSize()) {
                                        if (optimalCards.getSize() < optimalBoubleLine.getSize()) {
                                            isAdd = true;
                                        } else {
                                            isAdd = optimalCards.getWeight() <= optimalBoubleLine.getWeight();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (isAdd || !firstAdd) {
                    firstAdd = true;
                    optimalCards = optimalBoubleLine;
                }

            } else {
                //
                if (a2) {
                    i = i2;
                    i = i - 1;
                }
            }
        }
        return optimalCards;
    }

    /**
     * 找到最佳三连对
     */
    private static List<List<Poker>> optimalBoubleLine(List<Map<Integer, List<Poker>>> a) {
        List<List<Poker>> result = new ArrayList<>();

        int sizeMax = 0;
        int oneMin = maxNum;
        int twoMin = maxNum;
        double weightMax = 0d;

        for (Map<Integer, List<Poker>> listMap : a) {
            OptimalCards optimalBoubleLine = optimalBoubleLine(listMap);

            boolean add = false;
            int size = optimalBoubleLine.getSize();
            double weight = optimalBoubleLine.getWeight();
            int twoCount = optimalBoubleLine.getTwoCount();
            int oneCount = optimalBoubleLine.getOneCount();
            List<List<Poker>> b = optimalBoubleLine.getPokersList();

            if (oneMin >= oneCount) {
                if (oneMin > oneCount) {
                    add = true;
                } else {
                    if (twoMin >= twoCount) {
                        if (twoMin > twoCount) {
                            add = true;
                        } else {
                            if (sizeMax <= size) {
                                if (sizeMax < size) {
                                    add = true;
                                } else {
                                    add = weightMax <= weight;
                                }
                            }
                        }
                    }
                }
            }
            if (add) {
                oneMin = oneCount;
                twoMin = twoCount;
                sizeMax = size;
                weightMax = weight;
                result = b;
            }
        }
        //
        return result;
    }

    /**
     * 找到最佳三连对
     */
    private static List<List<Poker>> optimalBoubleLine(List<Poker> cards, int laiziValue) {
        List<Poker> cards_copy = copy(cards);
        List<List<Poker>> result = new ArrayList<>();
        if (cards_copy.size() < 6) {
            return result;
        }

        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards_copy, laiziValue);
        List<Poker> laiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        List<Poker> laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
        List<List<Poker>> cardsList = laizicomb(laiZiNot, laiziValue, laiZi.size());
        Set<Integer> hashcodes = new HashSet<>();
        List<Map<Integer, List<Poker>>> a = new ArrayList<>();
        for (List<Poker> pokers1 : cardsList) {
            if (pokers1.size() < 6) {
                continue;
            }
            Map<Integer, List<Poker>> dd = getPokerMapByValue(pokers1);
            ArrayList<Integer> values = new ArrayList<>(dd.keySet());
            for (int i = values.size() - 1; i >= 0; i--) {
                Integer value = values.get(i);
                if (dd.getOrDefault(value, defaultList).size() < 2) {
                    dd.remove(value);
                }
            }
            dd.remove(Poker.VALUE_KING_DA);
            dd.remove(Poker.VALUE_KING_XIAO);
            if (dd.size() < 3) {
                continue;
            }
            //
//            a.add(dd);
            adddd_value(a, dd, hashcodes);
            if (dd.containsKey(1)) {
                HashMap<Integer, List<Poker>> b = new LinkedHashMap<>(dd);
                b.replaceAll((integer, pokers) -> copy(pokers));
                b.put(14, b.remove(1));
//                a.add(b);
                adddd_value(a, b, hashcodes);
            }
        }
        result = optimalBoubleLine(a);
        laizibuquan2(result, laiZi);

        //
        if (!result.isEmpty() && laiZi.size() > 0) {
            deletePoker(cards_copy, mergeTogher(result), Poker::getNumber);
            List<List<Poker>> lists = optimalBoubleLine(cards_copy, laiziValue);
            if (!lists.isEmpty()) {
                result.addAll(lists);
            }
        }
        return result;
    }

    public static List<Poker> createPokers(int cardPair, boolean shuffle) {
        return createPokers(cardPair, shuffle, 0, true);
    }

    /**
     * 创建几幅牌
     * cardPair 幅
     * shuffle 是否洗牌
     */
    public static List<Poker> createPokers(int cardPair, boolean shuffle, Integer number, boolean addKing) {
        List<Poker> allCard = new ArrayList<>();
        number = null == number ? null : number++;
        for (int i = 1; i <= cardPair; i++) {
            for (int type = 1; type <= 4; type++) {
                for (int value = 1; value <= 13; value++) {
                    Poker poker = new Poker();
                    poker.setColor(type);
                    poker.setValue(value);
                    poker.setNumber(null == number ? null : number++);
                    allCard.add(poker);
                }
            }

            if (addKing) {
                Poker da = new Poker();
                da.setColor(Poker.Color.KING.getType());
                da.setValue(Poker.VALUE_KING_DA);
                da.setNumber(null == number ? null : number++);

                Poker xiao = new Poker();
                xiao.setColor(Poker.Color.KING.getType());
                xiao.setValue(Poker.VALUE_KING_XIAO);
                xiao.setNumber(null == number ? null : number++);

                allCard.add(da);
                allCard.add(xiao);
            }
        }
        if (shuffle) {
            Collections.shuffle(allCard);
        }
        return allCard;
    }

    /**
     * 分配牌
     */
    public static Map<Integer, List<Poker>> distribPokers(List<Poker> pokers, int peoplenum) {
        Map<Integer, List<Poker>> resultMap = new HashMap<>();
        double dnum = (double) pokers.size() / (double) peoplenum;
        double remainder = dnum % (int) dnum;
        boolean zero = MathUtil.isZero(remainder);
        if (!zero) {
            System.err.println("牌不够分配 pokers : " + pokers.size() + " peoplenum : " + peoplenum);
            return null;
        }
        int num = (int) dnum;
        for (int i = 0; i < peoplenum; i++) {
            List<Poker> temppokers = new ArrayList<>(pokers.subList(i * num, (i + 1) * num));
            resultMap.put(i, temppokers);
        }
        return resultMap;
    }

    /**
     * 删除牌 cardsB cardsA 中存在 cardsB 的牌
     */
    public static void deletePoker(List<Poker> cardsA, List<Poker> cardsB, IFunction<? super Poker, Integer> keyExtractor) {
        if (null == cardsB || cardsB.isEmpty()) return;
        if (null == cardsA || cardsA.isEmpty()) return;
        for (Poker pokerB : cardsB) {
            for (Poker pokerA : cardsA) {
                if (keyExtractor.apply(pokerB).equals(keyExtractor.apply(pokerA))) {
                    cardsA.remove(pokerA);
                    break;
                }
            }
        }
    }

    /**
     * 取 pokers 中存在的 pokersNumber
     */
    public static List<Poker> parsePokerByNumbers(List<Poker> pokers, Collection<Integer> pokersNumber) {
        if (null == pokersNumber || pokersNumber.isEmpty()) return new ArrayList<>();
        List<Poker> resultCards = new ArrayList<>();
        for (Integer number : pokersNumber) {
            for (Poker poker : pokers) {
                if (poker.getNumber().equals(number)) {
                    resultCards.add(poker);
                    break;
                }
            }
        }
        return resultCards;
    }

    /**
     * 牌值包含
     *
     * @return cardsA 是否包含 cardsB 的字段的值
     */
    public static boolean containPoker(List<Poker> cardsA, List<Poker> cardsB, IFunction<? super Poker, Integer> keyExtractor) {
        if (null == cardsB || cardsB.size() == 0) return true;
        for (Poker cardB : cardsB) {
            boolean contain = false;
            for (Poker cardA : cardsA) {
                if (keyExtractor.apply(cardA).equals(keyExtractor.apply(cardB))) {
                    contain = true;
                    break;
                }
            }
            if (!contain) return contain;
        }
        return true;
    }

    /**
     * 是否同花
     */
    public static boolean sameColor(List<Poker> cards) {
        if (null == cards || cards.size() < 2) return false;

        int color = cards.get(0).getColor();
        for (Poker card : cards) {
            if (!card.getColor().equals(color)) {
                return false;
            }
        }
        return true;
    }

    /**
     * 是否同花
     */
    public static boolean sameColor(List<Poker> cards, int laiziValue) {
        if (null == cards || cards.size() < 2) return false;

        int color = cards.get(0).getColor();
        for (Poker card : cards) {
            if (!card.getColor().equals(color) && !(card.getColor().equals(Poker.Color.HONGTAO.getType()) && card.getValue().equals(laiziValue))) {
                return false;
            }
        }
        return true;
    }

    /**
     * 合并相同值的牌
     *
     * @param cards 手牌
     * @param sameSize       几张相同的牌
     * @param cardCross      是否越界获取  默认不越界（false）
     * @param sameSizeexceed true 截取大于等于几张相同长度的牌的长度  默认（false） 截取相同长度牌的长度
     * @return 合并的牌
     */
    public static List<List<Poker>> mergeSame(List<Poker> cards, Integer sameSize, Boolean cardCross, Boolean sameSizeexceed) {
        List<List<Poker>> result = new ArrayList<>();
        if (null == cards || cards.isEmpty()) {
            return result;
        }


        Map<Integer, List<Poker>> pokerMap = new HashMap<>();
        for (Poker poker : cards) {
            Integer key = poker.getValue();
            List<Poker> pokers = pokerMap.getOrDefault(key, new ArrayList<>());
            pokers.add(poker);
            pokerMap.put(key, pokers);
        }
        for (Integer pvkey : pokerMap.keySet()) {
            List<Poker> pokers = pokerMap.get(pvkey);
            if (null != sameSize) {
                if (null != sameSizeexceed && sameSizeexceed) {
                    // 长度是否超过
                    if (pokers.size() >= sameSize) {
                        result.add(pokers);
                    }
                    continue;
                }
                if (null != cardCross && cardCross) {
                    // 是否越界
                    for (int i = 0; i <= pokers.size() - sameSize; i += sameSize) {
                        List<Poker> temppokers = new ArrayList<>(pokers.subList(i, i + sameSize));
                        result.add(temppokers);
                    }
                    continue;
                } else {
                    if (pokers.size() != sameSize) continue;
                }
            }
            result.add(pokers);
        }
        return result;
    }


    /**
     * 合并所有牌
     */
    public static List<Poker> mergeTogher(Collection<List<Poker>> cards) {
        List<Poker> result = new ArrayList<>();
        if (null == cards || cards.isEmpty()) {
            return result;
        }
        for (List<Poker> pokers : cards) {
            result.addAll(pokers);
        }
        return result;
    }

    public static int getPokerDaXiao(Poker poker, int laiziValue) {
        return getPokerDaXiao(poker.getValue(), laiziValue);
    }

    public static List<Poker> getLianDui(List<Poker> cards, int laiziCount) {
        List<Poker> result = new ArrayList<>();
        if (null == cards || cards.size() + laiziCount != 6) {
            return result;
        }

        Map<Integer, List<Poker>> pokerMapByValue = CollectUtil.toGroup(cards, Poker::getValue);

        for (List<Poker> value : pokerMapByValue.values()) {
            if (value.size() > 2) {
                return result;
            }
        }

        Set<Integer> cardsValue = pokerMapByValue.keySet();
        //
        if (laiziCount == 0) {
            return initLiandui.getOrDefault(cardsValue, result);
        } else {
            for (Set<Integer> values : initLiandui.keySet()) {
                if (values.containsAll(cardsValue)) {
                    return initLiandui.getOrDefault(values, result);
                }
            }
        }
        return result;
    }

    /**
     * 获取钢板
     */
    public static List<Poker> getGangban(List<Poker> cards, int laiziCount) {
        List<Poker> result = new ArrayList<>();
        if (null == cards || cards.size() + laiziCount != 6) {
            return result;
        }

        Map<Integer, List<Poker>> pokerMapByValue = CollectUtil.toGroup(cards, Poker::getValue);

        for (List<Poker> value : pokerMapByValue.values()) {
            if (value.size() > 3) {
                return result;
            }
        }

        Set<Integer> cardsValue = pokerMapByValue.keySet();

        //
        if (laiziCount == 0) {
            return initGangban.getOrDefault(cardsValue, result);
        } else {
            for (Set<Integer> values : initGangban.keySet()) {
                if (values.containsAll(cardsValue)) {
                    return initGangban.getOrDefault(values, result);
                }
            }
        }
        return result;
    }

    /**
     * 连续牌的最大长度
     */
    public static int continueLength(List<Poker> cards) {
        if (null == cards || cards.size() < 2) {
            return 0;
        }
        List<Integer> values = new ArrayList<>(CollectUtil.getSet(cards, Poker::getValue));
        if (values.contains(1)) {
            values.add(14);
        }
        int maxLength = 1;
        int length = 1;
        for (int i = 0; i < values.size() - 1; i++) {
            Integer value1 = values.get(i);
            Integer value2 = values.get(i + 1);
            if (value1 + 1 == value2) {
                length++;
                continue;
            }
            if (maxLength < length) {
                maxLength = length;
            }
            length = 1;
        }
        return Math.max(maxLength, length);
    }

    /**
     * 有同花顺
     */
    public static boolean hasShunziTonghua(List<Poker> cards) {
        if (null == cards || cards.size() < 5) {
            return false;
        }
        Map<Integer, List<Poker>> pokerMap = new HashMap<>();
        for (Poker card : cards) {
            List<Poker> pokers = pokerMap.getOrDefault(card.getColor(), new ArrayList<>());
            pokers.add(card);
            pokerMap.put(card.getColor(), pokers);
        }
        for (List<Poker> pokers : pokerMap.values()) {
            int lengthMax = continueLength(pokers);
            if (lengthMax >= 5) {
                return true;
            }
        }
        return false;
    }

    /**
     * 是不是顺子
     */
    public static List<Poker> getShunzi(List<Poker> cards, int laiziCount) {
        List<Poker> result = new ArrayList<>();
        if (null == cards || cards.size() + laiziCount != 5) {
            return result;
        }
        Set<Integer> cardsValue = CollectUtil.getSet(cards, Poker::getValue);
        if (cardsValue.size() != cards.size()) {
            return result;
        }
        if (laiziCount == 0) {
            return copy(initShunzi.getOrDefault(cardsValue, result));
        } else {
            for (Set<Integer> shunziValues : initShunzi.keySet()) {
                if (shunziValues.containsAll(cardsValue)) {
                    return copy(initShunzi.getOrDefault(shunziValues, result));
                }
            }
        }
        return result;
    }

    public static int getPokerDaXiao(int pokervalue, int laiziValue) {
        if (pokervalue == laiziValue) {
            return 20;
        }
        if (pokervalue == 1) {
            return 14;
        }
        return pokervalue;
    }

    /**
     * 1 获取赖子牌
     * 2 获取非赖子牌
     */
    public static Map<Integer, List<Poker>> getLaiZiOrNot(List<Poker> cards, int laiziValue) {
        Map<Integer, List<Poker>> result = new HashMap<>(2);
        if (null == cards || cards.isEmpty()) {
            return result;
        }
        List<Poker> king = new ArrayList<>();
        List<Poker> laiziNot = new ArrayList<>();
        List<Poker> laizi = new ArrayList<>();
        for (Poker card : cards) {
            // ------ fixme
            if (card.getColor().equals(Poker.Color.KING.getType())) {
                king.add(card);
                continue;
            }
            // ------

            if (!card.getColor().equals(Poker.Color.HONGTAO.getType()) || !card.getValue().equals(laiziValue)) {
                laiziNot.add(card);
            } else {
                laizi.add(card);
            }
        }
        result.put(1, laizi);
        result.put(2, laiziNot);
        result.put(3, king);
        ArrayList<Poker> pokers = new ArrayList<>(laiziNot);
        pokers.addAll(king);
        result.put(4, pokers);
        return result;
    }

    /**
     * 1 获取赖子牌
     * 2 获取非赖子牌
     */
    public static Map<Integer, List<GuandanPokers>> getLaiZiOrNot1(List<GuandanPokers> cards, int laiziValue) {
        Map<Integer, List<GuandanPokers>> result = new HashMap<>(2);
        if (null == cards || cards.isEmpty()) {
            return result;
        }
        List<GuandanPokers> king = new ArrayList<>();
        List<GuandanPokers> laiziNot = new ArrayList<>();
        List<GuandanPokers> laizi = new ArrayList<>();
//        for (Poker card : cards) {
//            // ------ fixme
//            if (card.getColor().equals(Poker.COLOR_KING)) {
//                king.add(card);
//                continue;
//            }
//            // ------
//
//            if (!card.getColor().equals(Poker.COLOR_HONGTAO) || !card.getValue().equals(laiziValue)) {
//                laiziNot.add(card);
//            } else {
//                laizi.add(card);
//            }
//        }

        for (GuandanPokers card : cards) {

            List<Poker> pokers = card.getPokers();
            for (Poker poker : pokers) {

                if (poker.getColor().equals(Poker.Color.KING.getType())) {
                    king.add(card);
                    continue;
                }

                if (!poker.getColor().equals(Poker.Color.HONGTAO.getType()) || !poker.getValue().equals(laiziValue)) {
                    laiziNot.add(card);
                } else {
                    laizi.add(card);
                }
            }

        }


        result.put(1, laizi);
        result.put(2, laiziNot);
        result.put(3, king);
        ArrayList<GuandanPokers> pokers = new ArrayList<>(laiziNot);
        pokers.addAll(king);
        result.put(4, pokers);
        return result;
    }

    /**
     * 扑克比较 判断A是否压得起B
     */
    public static boolean comparePoker(CardType cardTypeA, CardType cardTypeB) {
        if (null == cardTypeA || null == cardTypeB) {
            return false;
        }
        Integer typeA = cardTypeA.getType();
        Integer weightA = cardTypeA.getWeight();
        Integer typeB = cardTypeB.getType();
        Integer weightB = cardTypeB.getWeight();

        if (typeA.equals(typeB)
                || typeA.equals(CARDTYPE_BOMBCARD)
                || typeA.equals(CARDTYPE_BOMBCARDKING)
                || typeA.equals(CARDTYPE_SINGLELINESAMECOLOR)) {
            return weightA > weightB;
        }
        return false;
    }

    private static boolean yitiaolong(List<Poker> cards) {
//        if (null == cards || cards.isEmpty())return false;
        Integer value = null;
        for (Poker card : cards) {
            if (null == value || card.getValue().equals(value)) {
                value = card.getValue();
            } else {
                return false;
            }
        }
        return true;
    }

    public static List<GuandanPokers> copy3(List<GuandanPokers> guandanPokers) {
        List<GuandanPokers> result = new ArrayList<>();
        for (GuandanPokers guandanPoker : guandanPokers) {
            GuandanPokers guandanPokers1 = new GuandanPokers();
            guandanPokers1.setPokers(copy(guandanPoker.getPokers()));
            guandanPokers1.setWeight(guandanPoker.getWeight());
            guandanPokers1.setCardType(new CardType(guandanPoker.getCardType().getType(), guandanPoker.getCardType().getWeight()));
            result.add(guandanPokers1);
        }
        return result;
    }

    /**
     * 合适的牌
     */
    public static List<List<Poker>> typeCard2(CardType cardType, List<GuandanPokers> guandanPokers, int laiziValue) {
        return typeCard2(cardType, guandanPokers, laiziValue, false);
    }

    /**
     * 合适的牌
     */
    public static List<List<Poker>> typeCard2(CardType cardType, List<GuandanPokers> guandanPokers, int laiziValue, boolean qiang) {

        List<List<Poker>> result = new ArrayList<>();
        if (null == guandanPokers || guandanPokers.isEmpty()) {
            return result;
        }

        //传进来的类型
        Integer type = cardType.getType();
        Integer weight = cardType.getWeight();

        List<GuandanPokers> guandanPokers_copy = copy3(guandanPokers);

        Map<Integer, List<GuandanPokers>> typeGuandans;
        List<GuandanPokers> guandanPokers_sanbudai;
        List<GuandanPokers> guandanPokers_duizi;
        List<GuandanPokers> guandanPokers_gangban;
        List<GuandanPokers> guandanPokers_sanliandui;

        // 合适的   牌值大的拿出来
        for (GuandanPokers pokers : guandanPokers_copy) {
            CardType cardType_ = pokers.getCardType();
            Integer weight_ = cardType_.getWeight();
            Integer type_ = cardType_.getType();
            if (type_.equals(type) && weight_ > weight) {
                result.add(pokers.getPokers());
            }
        }

        // 组合或者拆的
        switch (type) {
            case CARDTYPE_SINGLECARD:// 单张
                //  拆对子(K,A,2) 或者 三个头(A,2)

                typeGuandans = new HashMap<>();
                for (GuandanPokers guandanPoker : guandanPokers) {
                    Integer type_guandanPoker = guandanPoker.getCardType().getType();
                    List<GuandanPokers> orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList<>());
                    orDefault.add(guandanPoker);
                    typeGuandans.put(type_guandanPoker, orDefault);
                }

                guandanPokers_sanbudai = typeGuandans.get(CARDTYPE_THREECARD);
                guandanPokers_duizi = typeGuandans.get(CARDTYPE_DOUBLECARD);

                //合适的拆牌
                List<GuandanPokers> guandanPokers_dheshi = new ArrayList<>();

                if (null != guandanPokers_sanbudai && !guandanPokers_sanbudai.isEmpty()) {
                    guandanPokers_dheshi.addAll(guandanPokers_sanbudai);
                }

                if (null != guandanPokers_duizi && !guandanPokers_duizi.isEmpty()) {
                    guandanPokers_dheshi.addAll(guandanPokers_duizi);
                }


                if (null != guandanPokers_duizi && !guandanPokers_duizi.isEmpty()) {
                    guandanPokers_duizi.removeIf(guandanPokers1 -> guandanPokers1.getCardType().getWeight() <= weight);
                    guandanPokers_duizi.removeIf(guandanPokers1 -> guandanPokers1.getCardType().getWeight() < 12);

                    for (GuandanPokers pokers : guandanPokers_duizi) {
                        List<Poker> add = new ArrayList<>();
                        add.add(pokers.getPokers().get(0));
                        result.add(add);
                    }
                }


                break;
            case CARDTYPE_DOUBLECARD:// 对子
                //  拆三个头(A,配子)
                typeGuandans = new HashMap<>();
                for (GuandanPokers guandanPoker : guandanPokers) {
                    Integer type_guandanPoker = guandanPoker.getCardType().getType();
                    List<GuandanPokers> orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList<>());
                    orDefault.add(guandanPoker);
                    typeGuandans.put(type_guandanPoker, orDefault);
                }

                guandanPokers_sanbudai = typeGuandans.get(CARDTYPE_THREECARD);
                guandanPokers_gangban = typeGuandans.get(CARDTYPE_THREECARDLINE);
                guandanPokers_sanliandui = typeGuandans.get(CARDTYPE_DOUBLECARDLINETHREE);

                List<GuandanPokers> guandanPokers_heshi = new ArrayList<>();

                if (null != guandanPokers_sanbudai && !guandanPokers_sanbudai.isEmpty()) {
                    guandanPokers_heshi.addAll(guandanPokers_sanbudai);
                }
                if (null != guandanPokers_gangban && !guandanPokers_gangban.isEmpty()) {
                    guandanPokers_heshi.addAll(guandanPokers_gangban);
                }
                if (null != guandanPokers_sanliandui && !guandanPokers_sanliandui.isEmpty() && qiang) {
                    guandanPokers_heshi.addAll(guandanPokers_sanliandui);
                }

                if (qiang) {
                    // 强制拆牌 不分大小 乱拆
                    List<Poker> pokers = new ArrayList<>();
                    for (GuandanPokers pokers1 : guandanPokers_heshi) {
                        pokers.addAll(pokers1.getPokers());
                    }
                    List<List<Poker>> allcards = typeCard(cardType, pokers, laiziValue);
                    result.addAll(allcards);
                } else {
                    // 合适拆牌 不是乱拆

                    if (!guandanPokers_heshi.isEmpty()) {
                        List<List<Poker>> guandanpokers = new ArrayList<>();
                        for (GuandanPokers pokers : guandanPokers_heshi) {
                            CardType cardType1 = pokers.getCardType();
                            List<Poker> pokers1 = pokers.getPokers();

                            if (cardType1.getType().equals(CARDTYPE_THREECARD)) {
                                if (cardType1.getWeight() > weight && cardType1.getWeight() >= 13) {
                                    List<Poker> add = new ArrayList<>();
                                    add.add(pokers1.get(0));
                                    add.add(pokers1.get(1));
                                    result.add(add);
                                }
                            } else {
                                guandanpokers.addAll(mergeSame(pokers1, null, null, null));
                            }
                        }
                        result.addAll(typeCard2(cardType, convert(guandanpokers, laiziValue, false), laiziValue));
                    }
                }

                break;
            case CARDTYPE_THREECARDTWO:// 三带二
                typeGuandans = new HashMap<>();
                for (GuandanPokers guandanPoker : guandanPokers) {
                    Integer type_guandanPoker = guandanPoker.getCardType().getType();
                    List<GuandanPokers> orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList<>());
                    orDefault.add(guandanPoker);
                    typeGuandans.put(type_guandanPoker, orDefault);
                }

                guandanPokers_sanbudai = typeGuandans.get(CARDTYPE_THREECARD);
                guandanPokers_duizi = typeGuandans.get(CARDTYPE_DOUBLECARD);
                //
                if (null == guandanPokers_sanbudai || null == guandanPokers_duizi) {
                    return result;
                }
                guandanPokers_sanbudai.removeIf(guandanPokers1 -> guandanPokers1.getCardType().getWeight() <= weight);
                //
                if (guandanPokers_sanbudai.isEmpty() || guandanPokers_duizi.isEmpty()) {
                    return result;
                }

                guandanPokers_sanbudai.sort(Comparator.comparingInt(o -> o.getCardType().getWeight()));
                guandanPokers_duizi.sort(Comparator.comparingInt(o -> o.getCardType().getWeight()));

                for (GuandanPokers duizi_guandanpokers : guandanPokers_duizi) {
                    for (GuandanPokers sanbudai_guandanpokers : guandanPokers_sanbudai) {
                        List<Poker> add = new ArrayList<>();
                        add.addAll(duizi_guandanpokers.getPokers());
                        add.addAll(sanbudai_guandanpokers.getPokers());
                        result.add(add);
                    }
                }
                break;
            case CARDTYPE_DOUBLECARDLINETHREE:// 三连对
                typeGuandans = new HashMap<>();
                for (GuandanPokers guandanPoker : guandanPokers) {
                    Integer type_guandanPoker = guandanPoker.getCardType().getType();
                    List<GuandanPokers> orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList<>());
                    orDefault.add(guandanPoker);
                    typeGuandans.put(type_guandanPoker, orDefault);
                }
                guandanPokers_duizi = typeGuandans.get(CARDTYPE_DOUBLECARD);
                if (null == guandanPokers_duizi) {
                    return result;
                }
                if (guandanPokers_duizi.isEmpty()) {
                    return result;
                }

                if (guandanPokers_duizi.size() < 3) {
                    return result;
                }

                List<Poker> cards = new ArrayList<>();
                for (GuandanPokers guandanPokers1 : guandanPokers_duizi) {
                    cards.addAll(guandanPokers1.getPokers());
                }
                //
                result.addAll(typeCard(cardType, cards, laiziValue));
                //
                break;
            case CARDTYPE_THREECARDLINE:// 钢板
                typeGuandans = new HashMap<>();
                for (GuandanPokers guandanPoker : guandanPokers) {
                    Integer type_guandanPoker = guandanPoker.getCardType().getType();
                    List<GuandanPokers> orDefault = typeGuandans.getOrDefault(type_guandanPoker, new ArrayList<>());
                    orDefault.add(guandanPoker);
                    typeGuandans.put(type_guandanPoker, orDefault);
                }
                guandanPokers_sanbudai = typeGuandans.get(CARDTYPE_THREECARD);
                if (null == guandanPokers_sanbudai) {
                    return result;
                }
                if (guandanPokers_sanbudai.isEmpty()) {
                    return result;
                }

                if (guandanPokers_sanbudai.size() < 2) {
                    return result;
                }

                cards = new ArrayList<>();
                for (GuandanPokers guandanPokers1 : guandanPokers_sanbudai) {
                    cards.addAll(guandanPokers1.getPokers());
                }
                //
                result.addAll(typeCard(cardType, cards, laiziValue));
                //
                break;
        }

        // 去重
        if (!result.isEmpty() && result.size() > 1) {
            Set<Integer> hash = new HashSet<>();
            for (int i = result.size() - 1; i >= 0; i--) {
                List<Poker> pokers = result.get(i);
                int hashCode = hashCode(pokers);
                if (hash.contains(hashCode)) {
                    result.remove(i);
                    continue;
                }
                hash.add(hashCode);
            }
        }


        return result;
    }

    public static List<GuandanPokers> convert(Collection<List<Poker>> pokersArr, int laiziValue) {
        return convert(pokersArr, laiziValue, true);
    }

    public static List<GuandanPokers> convert(Collection<List<Poker>> pokersArr, int laiziValue, boolean sort) {
        List<GuandanPokers> resultArr = new ArrayList<>();
        for (List<Poker> pokers : pokersArr) {
            CardType cardType1 = cardType(pokers, laiziValue);
            GuandanPokers guandanPokers1 = new GuandanPokers();
            guandanPokers1.setPokers(pokers);
            guandanPokers1.setCardType(cardType1);
            guandanPokers1.setWeight(getPokerWeight(cardType1, pokers));
            resultArr.add(guandanPokers1);
        }
        if (sort) {
            resultArr.sort(Comparator.comparingInt(a -> a.getCardType().getWeight()));
        }
        return resultArr;
    }

    public static List<GuandanPokers> guandanConvert(Collection<List<GuandanPokers>> pokersArr, int laiziValue) {
        return guandanConvert(pokersArr, laiziValue, true);
    }

    public static List<GuandanPokers> guandanConvert(Collection<List<GuandanPokers>> pokersArr, int laiziValue, boolean sort) {
        List<GuandanPokers> resultArr = new ArrayList<>();
        for (List<GuandanPokers> pokers : pokersArr) {
            for (GuandanPokers poker : pokers) {
                List<Poker> pokers1 = poker.getPokers();
                CardType cardType1 = cardType(pokers1, laiziValue);
                GuandanPokers guandanPokers1 = new GuandanPokers();
                guandanPokers1.setPokers(pokers1);
                guandanPokers1.setCardType(cardType1);
                guandanPokers1.setWeight(getPokerWeight(cardType1, pokers1));
                resultArr.add(guandanPokers1);
            }
        }

        if (sort) {
            resultArr.sort(Comparator.comparingInt(a -> a.getCardType().getWeight()));
        }
        return resultArr;
    }

    public static List<List<Poker>> typeCard(CardType cardType, List<Poker> handCards, int laiziValue) {
        List<List<Poker>> result = new ArrayList<>();
        if (null == handCards || handCards.isEmpty()) {
            return result;
        }

        List<Poker> handCards_copy = copy(handCards);

        Integer type = cardType.getType();
        Integer weight = cardType.getWeight();

        int ssss = 1;
        Map<Integer, List<Poker>> laiZiOrNot;
        List<Poker> laiZiNot;
        List<Poker> laiZi;
        Map<Integer, List<Poker>> pokerMapByValue;
        Set<Integer> values;


        switch (type) {
            case CARDTYPE_BOMBCARDKING:// 天王炸
                return result;
            case CARDTYPE_SINGLECARD:// 单张
                pokerMapByValue = getPokerMapByValue(handCards_copy);
                values = pokerMapByValue.keySet();

                for (Integer value : values) {
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size < ssss) {
                        continue;
                    }
                    int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                    if (pokerDaXiao <= weight) {
                        continue;
                    }
                    List<Poker> add = new ArrayList<>();
                    add.add(pokers.get(0));
                    result.add(add);
                }
                break;
            case CARDTYPE_DOUBLECARD:// 对子
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getPokerMapByValue(laiZiNot);
                values = pokerMapByValue.keySet();

                ssss = 2;
                for (Integer value : values) {
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi.size() < ssss) {
                        continue;
                    }
                    int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                    if (pokerDaXiao <= weight) {
                        continue;
                    }
                    List<Poker> add = new ArrayList<>();
                    if (size < ssss) {
                        ArrayList<Poker> pokers2 = new ArrayList<>(laiZi.subList(0, ssss - size));
                        add.addAll(pokers2);
                    }
                    add.addAll(new ArrayList<>(pokers.subList(0, ssss - add.size())));
                    result.add(add);
                }
                if (laiZi.size() >= ssss) {
                    List<Poker> add = new ArrayList<>(laiZi.subList(0, ssss));
                    result.add(add);
                }
                break;
            case CARDTYPE_THREECARD:// 三不带
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getPokerMapByValue(laiZiNot);
                values = pokerMapByValue.keySet();

                ssss = 3;
                for (Integer value : values) {
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi.size() < ssss) {
                        continue;
                    }
                    int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                    if (pokerDaXiao <= weight) {
                        continue;
                    }
                    List<Poker> add = new ArrayList<>();
                    if (size < ssss) {
                        ArrayList<Poker> pokers2 = new ArrayList<>(laiZi.subList(0, ssss - size));
                        add.addAll(pokers2);
                    }
                    add.addAll(new ArrayList<>(pokers.subList(0, ssss - add.size())));
                    result.add(add);
                }
                break;
            case CARDTYPE_BOMBCARD:// 炸弹
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getPokerMapByValue(laiZiNot);
                values = pokerMapByValue.keySet();

                ssss = 4;
                for (Integer value : values) {
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi.size() < ssss) {
                        continue;
                    }
                    int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                    int maxsize = Math.max(size + laiZi.size(), size);
                    int myweight = pokerDaXiao + (maxsize - (maxsize > 5 ? 2 : 3)) * 100;
                    if (myweight <= weight) {
                        continue;
                    }
                    List<Poker> add = new ArrayList<>();
                    if (size < maxsize) {
                        ArrayList<Poker> pokers2 = new ArrayList<>(laiZi.subList(0, maxsize - size));
                        add.addAll(pokers2);
                    }
                    add.addAll(pokers);
                    result.add(add);
                }
                break;
            case CARDTYPE_THREECARDTWO:// 三带二
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getPokerMapByValue(laiZiNot);
                values = pokerMapByValue.keySet();

                for (Integer value : values) {
                    ssss = 3;
                    List<Poker> laiZi_copy = copy(laiZi);
                    List<Poker> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size + laiZi_copy.size() < ssss) {
                        continue;
                    }
                    int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                    if (pokerDaXiao <= weight) {
                        continue;
                    }
                    List<Poker> add = new ArrayList<>();
                    if (size < ssss) {
                        ArrayList<Poker> cards1 = new ArrayList<>(laiZi_copy.subList(0, ssss - size));
                        laiZi_copy.removeAll(cards1);
                        add.addAll(cards1);
                    }
                    add.addAll(new ArrayList<>(pokers.subList(0, ssss - add.size())));

                    ssss = 2;
                    for (Integer value2 : values) {
                        if (value2.equals(value)) {
                            continue;
                        }
                        List<Poker> pokers2 = pokerMapByValue.get(value2);
                        int size2 = pokers2.size();
                        if (size2 + laiZi_copy.size() < ssss) {
                            continue;
                        }
                        List<Poker> add2 = new ArrayList<>();
                        if (size2 < ssss) {
                            ArrayList<Poker> cards2 = new ArrayList<>(laiZi_copy.subList(0, ssss - size2));
                            add2.addAll(cards2);
                        }
                        add2.addAll(new ArrayList<>(pokers2.subList(0, ssss - add2.size())));
                        add2.addAll(add);
                        result.add(add2);
                    }
                }
                break;
            case CARDTYPE_DOUBLECARDLINETHREE:// 三连对
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getPokerMapByValue(laiZiNot);

                ssss = 2;
                if (pokerMapByValue.containsKey(1)) {
                    pokerMapByValue.put(14, pokerMapByValue.get(1));
                }
                int min = Math.max(weight - 1, 1);
                for (int i = min; i < 13; i++) {
                    List<Poker> laiZi_copy = copy(laiZi);

                    List<Poker> poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList<>());
                    List<Poker> poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList<>());
                    List<Poker> poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList<>());
                    poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                    poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                    poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));

                    if (poker1.size() + poker2.size() + poker3.size() + laiZi_copy.size() < 3 * ssss) {
                        continue;
                    }

                    List<Poker> add = new ArrayList<>();
                    add.addAll(poker1);
                    add.addAll(poker2);
                    add.addAll(poker3);

                    if (poker1.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker1.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }

                    if (poker2.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker2.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }

                    if (poker3.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker3.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    result.add(add);
                }

                break;
            case CARDTYPE_THREECARDLINE:// 钢板
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getPokerMapByValue(laiZiNot);

                ssss = 3;
                if (pokerMapByValue.containsKey(1)) {
                    pokerMapByValue.put(14, pokerMapByValue.get(1));
                }

                min = Math.max(weight, 1);
                for (int i = min; i < 14; i++) {
                    List<Poker> laiZi_copy = copy(laiZi);

                    List<Poker> poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList<>());
                    List<Poker> poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList<>());
                    poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                    poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));

                    if (poker1.size() + poker2.size() + laiZi_copy.size() < 2 * ssss) {
                        continue;
                    }

                    List<Poker> add = new ArrayList<>();
                    add.addAll(poker1);
                    add.addAll(poker2);

                    if (poker1.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker1.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }

                    if (poker2.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker2.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    result.add(add);
                }
                break;
            case CARDTYPE_SINGLELINE:// 顺子
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getPokerMapByValue(laiZiNot);

                ssss = 1;
                if (pokerMapByValue.containsKey(1)) {
                    pokerMapByValue.put(14, pokerMapByValue.get(1));
                }

                min = Math.max(weight - 3, 1);
                for (int i = min; i < 11; i++) {
                    List<Poker> laiZi_copy = copy(laiZi);

                    List<Poker> poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList<>());
                    List<Poker> poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList<>());
                    List<Poker> poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList<>());
                    List<Poker> poker4 = pokerMapByValue.getOrDefault(i + 3, new ArrayList<>());
                    List<Poker> poker5 = pokerMapByValue.getOrDefault(i + 4, new ArrayList<>());

                    poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                    poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                    poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));
                    poker4 = poker4.subList(0, Math.min(poker4.size(), ssss));
                    poker5 = poker5.subList(0, Math.min(poker5.size(), ssss));

                    if (poker1.size() + poker2.size() + poker3.size() + poker4.size() + poker5.size() + laiZi_copy.size() < 5 * ssss) {
                        continue;
                    }

                    List<Poker> add = new ArrayList<>();
                    add.addAll(poker1);
                    add.addAll(poker2);
                    add.addAll(poker3);
                    add.addAll(poker4);
                    add.addAll(poker5);

                    if (poker1.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker1.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }

                    if (poker2.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker2.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }

                    if (poker3.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker3.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }


                    if (poker4.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker4.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }


                    if (poker5.size() < ssss) {
                        ArrayList<Poker> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker5.size()));
                        laiZi_copy.removeAll(pokers);
                        add.addAll(pokers);
                    }
                    result.add(add);
                }
                break;

            case CARDTYPE_SINGLELINESAMECOLOR:// 同花顺
                laiZiOrNot = getLaiZiOrNot(handCards_copy, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());

                Map<Integer, List<Poker>> pokerMapByColor = getPokerMapByColor(laiZiNot);
                for (List<Poker> value : pokerMapByColor.values()) {
                    List<Poker> arrayList = copy(value);
                    arrayList.addAll(laiZi);
                    CardType cardType1 = new CardType();
                    cardType1.setType(CARDTYPE_SINGLELINE);
                    cardType1.setWeight(weight - 300);
                    List<List<Poker>> lists = typeCard(cardType1, arrayList, laiziValue);
                    if (!lists.isEmpty()) {
                        result.addAll(lists);
                    }
                }
                break;
        }
        return result;
    }

    /**
     * 最优理牌
     */
    private static List<GuandanPokers> bestCards(List<Poker> handCards, int laiziValue) {


        // 最优理牌
        GuandanPokersWeight guandanPokersWeight = arrangePoker(handCards, laiziValue);
        // 排序
        List<GuandanPokers> guandanPokers = guandanPokersWeight.getGuandanPokers();
        guandanPokers.sort((o1, o2) -> {
            CardType cardType1 = o1.getCardType();
            CardType cardType2 = o2.getCardType();
            if (cardType1.getWeight().equals(cardType2.getWeight())) {
                return Integer.compare(cardType1.getType(), cardType2.getType());
            }
            return Integer.compare(cardType1.getWeight(), cardType2.getWeight());
        });
        return guandanPokers;
    }

    //new 提示
    public static List<List<GuandanPokers>> typeCard3(CardType cardType, List<GuandanPokers> handCards, int laiziValue) {
        List<List<GuandanPokers>> result = new ArrayList<>();
        if (null == handCards || handCards.isEmpty()) {
            return result;
        }

        List<Poker> pokerList = new ArrayList<>();


        for (GuandanPokers handCard : handCards) {
            pokerList.addAll(handCard.getPokers());
        }


        List<GuandanPokers> bestCards = bestCards(pokerList, laiziValue);


        for (GuandanPokers bestCard : bestCards) {
            //我的类型
            CardType cardType1 = bestCard.getCardType();
            //List<GuandanPokers> handCards_copy = copy(pokerList);

            //上家的类型
            Integer type = cardType.getType();
            Integer weight = cardType.getWeight();


            Map<Integer, List<GuandanPokers>> laiZiOrNot;
            List<GuandanPokers> laiZiNot;
            List<GuandanPokers> laiZi;
            Map<Integer, List<GuandanPokers>> pokerMapByValue;
            Set<Integer> values;


            //三带二的类型
            if (type.equals(CARDTYPE_THREECARDTWO)) {

                int ssss = 0;

                laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);
                values = pokerMapByValue.keySet();

                for (Integer value : values) {
                    List<GuandanPokers> add = new ArrayList<>();
                    ssss = 3;
                    List<GuandanPokers> laiZi_copy = new ArrayList<>(laiZi);
                    List<GuandanPokers> pokers = pokerMapByValue.get(value);
                    int size = pokers.size();
                    if (size == 3) {
                        if (size + laiZi_copy.size() < ssss) {
                            continue;
                        }
                        int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                        if (pokerDaXiao <= weight) {
                            continue;
                        }

                        if (size < ssss) {
                            ArrayList<GuandanPokers> cards1 = new ArrayList<>(laiZi_copy.subList(0, ssss - size));
                            laiZi_copy.removeAll(cards1);
                            add.addAll(cards1);
                        }
                        add.addAll(new ArrayList<>(pokers.subList(0, ssss - add.size())));
                    }

                    ssss = 2;
                    for (Integer value2 : values) {
                        if (value2.equals(value)) {
                            continue;
                        }
                        List<GuandanPokers> pokers2 = pokerMapByValue.get(value2);
                        int size2 = pokers2.size();
                        if (size2 == 2) {
                            if (size2 + laiZi_copy.size() < ssss) {
                                continue;
                            }
                            List<GuandanPokers> add2 = new ArrayList<>();
                            if (size2 < ssss) {
                                ArrayList<GuandanPokers> cards2 = new ArrayList<>(laiZi_copy.subList(0, ssss - size2));
                                add2.addAll(cards2);
                            }
                            add2.addAll(new ArrayList<>(pokers2.subList(0, ssss - add2.size())));
                            add2.addAll(add);
                            result.add(add2);
                        }
                        //       }
                    }
                }


            }


            if (!cardType1.getType().equals(type)) {
                continue;
            }


            switch (type) {
                case CARDTYPE_BOMBCARDKING:// 天王炸
                    return result;
                case CARDTYPE_SINGLECARD:// 单张
//                pokerMapByValue = getPokerMapByValue(bestCards);
                    int ssss = 0;

                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);

                    } else {
                        Map<Integer, List<GuandanPokers>> guandanPokerMapByValue = getGuandanPokerMapByValue(bestCards);
                        values = guandanPokerMapByValue.keySet();
                        ssss = 1;
                        for (Integer value : values) {
                            List<GuandanPokers> pokers = guandanPokerMapByValue.get(value);
                            int size = pokers.size();
                            if (pokers.size() == 1) {
                                if (size < ssss) {
                                    continue;
                                }
                                int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                                if (pokerDaXiao <= weight) {
                                    continue;
                                }
                                List<GuandanPokers> add = new ArrayList<>();
                                add.add(pokers.get(0));
                                result.add(add);
                            }

                        }
                    }

                    break;
                case CARDTYPE_DOUBLECARD:// 对子

                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);
                    } else {
                        laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                        laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                        laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                        pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);
                        values = pokerMapByValue.keySet();

                        ssss = 2;
                        for (Integer value : values) {
                            List<GuandanPokers> pokers = pokerMapByValue.get(value);
                            int size = pokers.size();
                            if (size == 2) {
                                if (size + laiZi.size() < ssss) {
                                    continue;
                                }
                                int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                                if (pokerDaXiao <= weight) {
                                    continue;
                                }
                                List<GuandanPokers> add = new ArrayList<>();
                                if (size < ssss) {
                                    ArrayList<GuandanPokers> pokers2 = new ArrayList<>(laiZi.subList(0, ssss - size));
                                    add.addAll(pokers2);
                                }
                                add.addAll(new ArrayList<>(pokers.subList(0, ssss - add.size())));
                                result.add(add);
                            }
                        }
                        if (laiZi.size() >= ssss) {
                            List<GuandanPokers> add = new ArrayList<>(laiZi.subList(0, ssss));
                            result.add(add);
                        }
                    }


                    break;
                case CARDTYPE_THREECARD:// 三不带

                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);
                    } else {
                        laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                        laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                        laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                        pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);
                        values = pokerMapByValue.keySet();

                        ssss = 3;
                        for (Integer value : values) {
                            List<GuandanPokers> pokers = pokerMapByValue.get(value);
                            int size = pokers.size();
                            if (size == 3) {
                                if (size + laiZi.size() < ssss) {
                                    continue;
                                }
                                int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                                if (pokerDaXiao <= weight) {
                                    continue;
                                }
                                List<GuandanPokers> add = new ArrayList<>();
                                if (size > ssss) {
                                    ArrayList<GuandanPokers> pokers2 = new ArrayList<>(laiZi.subList(0, ssss - size));
                                    add.addAll(pokers2);
                                }
                                add.addAll(new ArrayList<>(pokers.subList(0, ssss - add.size())));
                                result.add(add);
                            }
                        }
                    }

                    break;
                case CARDTYPE_BOMBCARD:// 炸弹

                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);
                    } else {

                        laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                        laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                        laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                        pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);
                        values = pokerMapByValue.keySet();

                        ssss = 4;
                        for (Integer value : values) {
                            List<GuandanPokers> pokers = pokerMapByValue.get(value);
                            int size = pokers.size();
                            if (size + laiZi.size() < ssss) {
                                continue;
                            }
                            int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                            int maxsize = Math.max(size + laiZi.size(), size);
                            int myweight = pokerDaXiao + (maxsize - (maxsize > 5 ? 2 : 3)) * 100;
                            if (myweight <= weight) {
                                continue;
                            }
                            List<GuandanPokers> add = new ArrayList<>();
                            if (size < maxsize) {
                                ArrayList<GuandanPokers> pokers2 = new ArrayList<>(laiZi.subList(0, maxsize - size));
                                add.addAll(pokers2);
                            }
                            add.addAll(pokers);
                            result.add(add);
                        }

                    }

                    break;
                case CARDTYPE_THREECARDTWO:// 三带二

//                    if (cardType1.getWeight() > weight) {
//                        List<GuandanUtil.GuandanPokers> app = new ArrayList<>();
//                        app.add(bestCard);
//                        result.add(app);
//                    } else {

                    laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                    laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                    laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                    pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);
                    values = pokerMapByValue.keySet();

                    for (Integer value : values) {
                        List<GuandanPokers> add = new ArrayList<>();
                        ssss = 3;
                        List<GuandanPokers> laiZi_copy = new ArrayList<>(laiZi);
                        List<GuandanPokers> pokers = pokerMapByValue.get(value);
                        int size = pokers.size();
                        if (size == 3) {
                            if (size + laiZi_copy.size() < ssss) {
                                continue;
                            }
                            int pokerDaXiao = getPokerDaXiao(value, laiziValue);
                            if (pokerDaXiao <= weight) {
                                continue;
                            }

                            if (size < ssss) {
                                ArrayList<GuandanPokers> cards1 = new ArrayList<>(laiZi_copy.subList(0, ssss - size));
                                laiZi_copy.removeAll(cards1);
                                add.addAll(cards1);
                            }
                            add.addAll(new ArrayList<>(pokers.subList(0, ssss - add.size())));
                        }

                        ssss = 2;
                        for (Integer value2 : values) {
                            if (value2.equals(value)) {
                                continue;
                            }
                            List<GuandanPokers> pokers2 = pokerMapByValue.get(value2);
                            int size2 = pokers2.size();
                            if (size2 == 2) {
                                if (size2 + laiZi_copy.size() < ssss) {
                                    continue;
                                }
                                List<GuandanPokers> add2 = new ArrayList<>();
                                if (size2 < ssss) {
                                    ArrayList<GuandanPokers> cards2 = new ArrayList<>(laiZi_copy.subList(0, ssss - size2));
                                    add2.addAll(cards2);
                                }
                                add2.addAll(new ArrayList<>(pokers2.subList(0, ssss - add2.size())));
                                add2.addAll(add);
                                result.add(add2);
                            }
                            //       }
                        }
                    }

                    break;
                case CARDTYPE_DOUBLECARDLINETHREE:// 三连对

                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);
                    } else {
                        laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                        laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                        laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                        pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);

                        ssss = 2;
                        if (pokerMapByValue.containsKey(1)) {
                            pokerMapByValue.put(14, pokerMapByValue.get(1));
                        }
                        int min = Math.max(weight - 1, 1);
                        for (int i = min; i < 13; i++) {
                            List<GuandanPokers> laiZi_copy = new ArrayList<>(laiZi);

                            List<GuandanPokers> poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList<>());
                            List<GuandanPokers> poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList<>());
                            List<GuandanPokers> poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList<>());
                            poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                            poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                            poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));

                            if (poker1.size() + poker2.size() + poker3.size() + laiZi_copy.size() < 3 * ssss) {
                                continue;
                            }

                            List<GuandanPokers> add = new ArrayList<>();
                            add.addAll(poker1);
                            add.addAll(poker2);
                            add.addAll(poker3);

                            if (poker1.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker1.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }

                            if (poker2.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker2.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }

                            if (poker3.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker3.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }
                            result.add(add);
                        }
                    }


                    break;
                case CARDTYPE_THREECARDLINE:// 钢板

                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);
                    } else {
                        laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                        laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                        laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                        pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);

                        ssss = 3;
                        if (pokerMapByValue.containsKey(1)) {
                            pokerMapByValue.put(14, pokerMapByValue.get(1));
                        }

                        int max = Math.max(weight, 1);
                        for (int i = max; i < 14; i++) {
                            List<GuandanPokers> laiZi_copy = new ArrayList<>(laiZi);

                            List<GuandanPokers> poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList<>());
                            List<GuandanPokers> poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList<>());
                            poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                            poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));

                            //p2 是3  p1是2
                            if (poker1.size() + poker2.size() + laiZi_copy.size() < 2 * ssss) {
                                continue;
                            }

                            List<GuandanPokers> add = new ArrayList<>();
                            add.addAll(poker1);
                            add.addAll(poker2);

                            if (poker1.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker1.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }

                            if (poker2.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker2.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }
                            result.add(add);
                        }
                    }

                    break;
                case CARDTYPE_SINGLELINE:// 顺子
                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);
                    } else {
                        laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                        laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                        laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
                        pokerMapByValue = getGuandanPokerMapByValue(laiZiNot);

                        ssss = 1;
                        if (pokerMapByValue.containsKey(1)) {
                            pokerMapByValue.put(14, pokerMapByValue.get(1));
                        }

                        int max = Math.max(weight - 3, 1);
                        for (int i = max; i < 11; i++) {
                            List<GuandanPokers> laiZi_copy = new ArrayList<>(laiZi);

                            List<GuandanPokers> poker1 = pokerMapByValue.getOrDefault(i + 0, new ArrayList<>());
                            List<GuandanPokers> poker2 = pokerMapByValue.getOrDefault(i + 1, new ArrayList<>());
                            List<GuandanPokers> poker3 = pokerMapByValue.getOrDefault(i + 2, new ArrayList<>());
                            List<GuandanPokers> poker4 = pokerMapByValue.getOrDefault(i + 3, new ArrayList<>());
                            List<GuandanPokers> poker5 = pokerMapByValue.getOrDefault(i + 4, new ArrayList<>());


                            if (poker1.size() == 1) {
                                poker1 = poker1.subList(0, Math.min(poker1.size(), ssss));
                            }

                            if (poker2.size() == 1) {
                                poker2 = poker2.subList(0, Math.min(poker2.size(), ssss));
                            }

                            if (poker3.size() == 1) {
                                poker3 = poker3.subList(0, Math.min(poker3.size(), ssss));
                            }

                            if (poker4.size() == 1) {
                                poker4 = poker4.subList(0, Math.min(poker4.size(), ssss));
                            }

                            if (poker5.size() == 1) {
                                poker5 = poker5.subList(0, Math.min(poker5.size(), ssss));
                            }


                            if (poker1.size() + poker2.size() + poker3.size() + poker4.size() + poker5.size() + laiZi_copy.size() < 5 * ssss) {
                                continue;
                            }

                            List<GuandanPokers> add = new ArrayList<>();
                            add.addAll(poker1);
                            add.addAll(poker2);
                            add.addAll(poker3);
                            add.addAll(poker4);
                            add.addAll(poker5);

                            if (poker1.size() != 0 && poker1.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker1.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }

                            if (poker2.size() != 0 && poker2.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker2.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }

                            if (poker3.size() != 0 && poker3.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker3.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }


                            if (poker4.size() != 0 && poker4.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker4.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }


                            if (poker5.size() != 0 && poker5.size() < ssss) {
                                ArrayList<GuandanPokers> pokers = new ArrayList<>(laiZi_copy.subList(0, ssss - poker5.size()));
                                laiZi_copy.removeAll(pokers);
                                add.addAll(pokers);
                            }
                            result.add(add);
                        }
                    }

                    break;

                case CARDTYPE_SINGLELINESAMECOLOR:// 同花顺

                    if (cardType1.getWeight() > weight) {
                        List<GuandanPokers> app = new ArrayList<>();
                        app.add(bestCard);
                        result.add(app);
                    } else {
                        laiZiOrNot = getLaiZiOrNot1(bestCards, laiziValue);
                        laiZiNot = laiZiOrNot.getOrDefault(4, new ArrayList<>());
                        laiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());

                        Map<Integer, List<GuandanPokers>> pokerMapByColor = getGuandanPokerMapByValue(laiZiNot);
                        for (List<GuandanPokers> value : pokerMapByColor.values()) {
                            List<GuandanPokers> arrayList = new ArrayList<>(value);
                            arrayList.addAll(laiZi);
                            CardType cardType2 = new CardType();
                            cardType2.setType(CARDTYPE_SINGLELINE);
                            cardType2.setWeight(weight - 300);
                            List<List<GuandanPokers>> lists = typeCard3(cardType2, arrayList, laiziValue);
                            if (!lists.isEmpty()) {
                                result.addAll(lists);
                            }
                        }
                    }

                    break;
            }
        }


        return result;
    }

    public static void quchong(List<List<Poker>> cards) {
        if (null == cards || cards.isEmpty() || cards.size() < 2) {
            return;
        }
        Set<Integer> hash = new HashSet<>();
        for (int i = 0; i < cards.size(); i++) {
            List<Poker> pokers = cards.get(i);
            int hashCode = hashCode(pokers);
            if (!hash.contains(hashCode)) {
                hash.add(hashCode);
                continue;
            }
            cards.remove(i--);
        }
    }

    /**
     * 获取所有比cardType牌型大的炸弹
     */
    public static List<List<Poker>> getBoom(CardType cardType, List<GuandanPokers> guandanPokers) {
        List<GuandanPokers> guandanPokers_new = new ArrayList<>();
        for (GuandanPokers guandanPoker : guandanPokers) {
            CardType cardType1 = guandanPoker.getCardType();
            if (cardType1.getType().equals(CARDTYPE_BOMBCARD) || cardType1.getType().equals(CARDTYPE_SINGLELINESAMECOLOR) || cardType1.getType().equals(CARDTYPE_BOMBCARDKING)) {
                boolean b = comparePoker(guandanPoker.getCardType(), cardType);
                if (b) {
                    //排序
                    guandanPokers_new.add(guandanPoker);
                }
            }
        }

        // 排序
        guandanPokers_new.sort(Comparator.comparingInt(a -> a.getCardType().getWeight()));

        return CollectUtil.getArr(guandanPokers_new, GuandanPokers::getPokers);
    }

    /**
     * 获取炸弹
     */
    public static List<List<Poker>> getBoom(List<Poker> cards, int laiziValue) {
        return getBoom(cards, laiziValue, false, true);
    }

    /**
     * 获取炸弹
     */
    public static List<List<Poker>> getBoom(List<Poker> cards, int laiziValue, boolean cross, boolean sort) {
        //获取手牌
        List<List<Poker>> result = new ArrayList<>();

        List<Poker> copy = copy(cards);

        //获取手牌中癞子和非癞子的数量
        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(copy, laiziValue);
        List<Poker> laizi = laiZiOrNot.get(1);// 手牌中的所有的癞子
        List<Poker> laiziNot = laiZiOrNot.get(2);// 手牌中所有的不是癞子


        Map<Integer, List<Poker>> pokerMapByValue = getPokerMapByValue(laiziNot);
        /***
         *          判断非炸弹的手牌
         *          如果有手牌的数量加上癞子的数量是炸弹
         *
         * */
        for (List<Poker> pokers : pokerMapByValue.values()) {
            if (!cross) {
                if (pokers.size() >= 4) {
                    result.add(pokers);
                } else if (pokers.size() + laizi.size() >= 4) {
                    pokers.addAll(laizi);
                    result.add(pokers);
                }
            } else {
                if (pokers.size() + laizi.size() >= 4) {
                    pokers.addAll(laizi);
                    for (int i = 3; i < pokers.size(); i++) {
                        result.add(new ArrayList<>(pokers.subList(0, i + 1)));
                    }
                }
            }

        }

        //同花顺
        List<List<Poker>> sameCards = GuandanUtil.optimalSingleLineSameColor(copy, laiziValue);
        result.addAll(sameCards);

        //天王炸
        List<List<Poker>> bomKing = GuandanUtil.getBomKing(copy);
        result.addAll(bomKing);


        // 排序
        if (sort) {
            result = CollectUtil.getArr(convert(result, laiziValue, true), GuandanPokers::getPokers);
        }

        return result;
    }

    /**
     * 自由出牌
     */
    public static List<List<Poker>> freePlay(List<GuandanPokers> guandanPokers) {
        List<List<Poker>> result = new ArrayList<>();
        for (GuandanPokers guandanPoker : guandanPokers) {
//            CardType cardType = guandanPoker.getCardType();
//            Integer type = cardType.getType();
//            if (type.equals(CARDTYPE_DOUBLECARD)) {// 对子
//
//            } else if (type.equals(CARDTYPE_THREECARD)) {// 三不带
//
//            } else {
//
//            }
            result.add(guandanPoker.getPokers());
        }
        return result;
    }

    /**
     * 获取牌型
     */
    public static CardType cardType(List<Poker> cards, int laiziValue) {
        return cardType(cards, laiziValue, null);
    }

    /**
     * 获取牌型
     */
    public static CardType cardType(List<Poker> cards, int laiziValue, Boolean liandui) {
        // 排序
        cards.sort(Comparator.comparingInt(Poker::getValue));

        CardType cardType = new CardType();
        cardType.setType(CARDTYPE_ILLEGALCARD);
        cardType.setWeight(0);

        //
        int sizeCards = cards.size();
        Map<Integer, List<Poker>> laiZiOrNot = getLaiZiOrNot(cards, laiziValue);
        List<Poker> cardsLaiZi = laiZiOrNot.getOrDefault(1, new ArrayList<>());
        int sizeLaiZi = cardsLaiZi.size();
        List<Poker> cardsLaiZiNot = laiZiOrNot.getOrDefault(2, new ArrayList<>());
        int sizeLaiZiNot = cardsLaiZiNot.size();
        List<Poker> king = laiZiOrNot.getOrDefault(3, new ArrayList<>());

        boolean yitiaolong = false;// 一条龙

        if (king.isEmpty()) {
            yitiaolong = yitiaolong(cardsLaiZiNot);// 一条龙
        } else {
            yitiaolong = cardsLaiZiNot.isEmpty() && cardsLaiZi.isEmpty() && yitiaolong(king);// 一条龙
        }

        if (sizeCards == 0) {
            // 不出
            cardType.setType(CARDTYPE_NOCARD);
        } else if (sizeCards == 1) {
            // 单张
            cardType.setType(CARDTYPE_SINGLECARD);
            cardType.setWeight(getPokerDaXiao(cards.get(0), laiziValue));
        } else if (sizeCards == 2 && yitiaolong) {
            // 对子
            cardType.setType(CARDTYPE_DOUBLECARD);
            if (sizeLaiZiNot == 0) {
                cardType.setWeight(getPokerDaXiao(cards.get(0), laiziValue));// 只有赖子
            } else {
                cardType.setWeight(getPokerDaXiao(cardsLaiZiNot.get(0), laiziValue));// 没有赖子
            }
        } else if (sizeCards == 3 && yitiaolong) {
            // 三不带
            cardType.setType(CARDTYPE_THREECARD);
            if (sizeLaiZiNot == 0) {
                cardType.setWeight(getPokerDaXiao(cards.get(0), laiziValue));
            } else {
                cardType.setWeight(getPokerDaXiao(cardsLaiZiNot.get(0), laiziValue));
            }
        } else if (sizeCards >= 4 && yitiaolong) {
            // 炸弹
            cardType.setType(CARDTYPE_BOMBCARD);
            int daxiao = 0;
            if (sizeLaiZiNot == 0) {
                daxiao = getPokerDaXiao(cards.get(0), laiziValue);
            } else {
                daxiao = getPokerDaXiao(cardsLaiZiNot.get(0), laiziValue);
            }
            int a = 3;
            if (sizeCards > 5) {
                a = 2;
            }
            cardType.setWeight(daxiao + (sizeCards - a) * 100);
        } else if (sizeCards == 4) {
            // 天王炸
            Map<Integer, List<Poker>> pokerMap = getPokerMapByValue(cards);
            List<Poker> dawang = pokerMap.get(Poker.VALUE_KING_DA);
            List<Poker> xiaowang = pokerMap.get(Poker.VALUE_KING_XIAO);
            if (null != dawang && null != xiaowang && dawang.size() == 2 && dawang.size() == xiaowang.size()) {
                cardType.setType(CARDTYPE_BOMBCARDKING);
                cardType.setWeight(1000);
            }
        } else if (sizeCards == 5) {
            // 顺子 or 同花顺 or 三带二

            List<Poker> shunzi = getShunzi(cardsLaiZiNot, sizeLaiZi);
            if (!shunzi.isEmpty()) {
                if (sameColor(cardsLaiZiNot)) {
                    // 同花顺
                    cardType.setType(CARDTYPE_SINGLELINESAMECOLOR);
                    cardType.setWeight(getPokerDaXiao(shunzi.get(shunzi.size() - 1), -1) + 300);
                } else {
                    // 顺子
                    cardType.setType(CARDTYPE_SINGLELINE);
                    cardType.setWeight(getPokerDaXiao(shunzi.get(shunzi.size() - 1), -1));
                }
            } else {
                Map<Integer, List<Poker>> pokerMap = getPokerMapByValue(cardsLaiZiNot);
                Set<Integer> pokerSet = CollectUtil.getSet(cardsLaiZiNot, Poker::getValue);
                Set<Integer> pokerSet_king = CollectUtil.getSet(king, Poker::getValue);

                if (pokerSet.size() + pokerSet_king.size() == 2) {
                    boolean isSandaier = false;
                    int maxvalue = -1;
                    for (List<Poker> pokers : pokerMap.values()) {
                        if (pokers.size() > 3) {
                            break;
                        }
                        if (pokers.size() == 3 || pokers.size() + sizeLaiZi == 3) {
                            Integer value = pokers.get(0).getValue();
                            if (maxvalue < value) {
                                maxvalue = value;
                            }
                            isSandaier = true;
                        }
                    }
                    if (isSandaier) {
                        // 三带二
                        cardType.setType(CARDTYPE_THREECARDTWO);
                        cardType.setWeight(getPokerDaXiao(maxvalue, laiziValue));
                    }
                }
            }
        } else if (sizeCards == 6) {
            // 钢板 or 三连对

            if (null != liandui && liandui) {
                List<Poker> lianDui = getLianDui(cardsLaiZiNot, sizeLaiZi);
                if (!lianDui.isEmpty()) {
                    cardType.setType(CARDTYPE_DOUBLECARDLINETHREE);
                    cardType.setWeight(getPokerDaXiao(lianDui.get(lianDui.size() - 1), -1));
                } else {
                    List<Poker> gangban = getGangban(cardsLaiZiNot, sizeLaiZi);
                    if (!gangban.isEmpty()) {
                        cardType.setType(CARDTYPE_THREECARDLINE);
                        cardType.setWeight(getPokerDaXiao(gangban.get(gangban.size() - 1), -1));
                    }
                }
            } else {
                List<Poker> gangban = getGangban(cardsLaiZiNot, sizeLaiZi);
                if (!gangban.isEmpty()) {
                    cardType.setType(CARDTYPE_THREECARDLINE);
                    cardType.setWeight(getPokerDaXiao(gangban.get(gangban.size() - 1), -1));
                } else {
                    List<Poker> lianDui = getLianDui(cardsLaiZiNot, sizeLaiZi);
                    if (!lianDui.isEmpty()) {
                        cardType.setType(CARDTYPE_DOUBLECARDLINETHREE);
                        cardType.setWeight(getPokerDaXiao(lianDui.get(lianDui.size() - 1), -1));
                    }
                }
            }
        }


        return cardType;
    }

    public static class CardType implements IPokerType {
        private Integer type;
        private Integer weight;

        public CardType() {
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getWeight() {
            return weight;
        }

        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        public CardType(Integer type, Integer weight) {
            this.type = type;
            this.weight = weight;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CardType cardType = (CardType) o;
            return Objects.equals(type, cardType.type);
        }

        @Override
        public int hashCode() {
            return Objects.hash(type);
        }

        @Override
        public String toString() {
            return "牌型: " + CardTypeEnum.get(type).getDesc() +
                    " 牌值: " + weight;
        }
    }

    public static class GuandanPokersWeight {
        private List<Poker> pokers;
        private List<GuandanPokers> guandanPokers;
        private Double weightCount;

        public List<Poker> getPokers() {
            return pokers;
        }

        public void setPokers(List<Poker> pokers) {
            this.pokers = pokers;
        }

        public List<GuandanPokers> getGuandanPokers() {
            return guandanPokers;
        }

        public void setGuandanPokers(List<GuandanPokers> guandanPokers) {
            this.guandanPokers = guandanPokers;
        }

        public Double getWeightCount() {
            return weightCount;
        }

        public void setWeightCount(Double weightCount) {
            this.weightCount = weightCount;
        }

        public GuandanPokersWeight(List<Poker> pokers, List<GuandanPokers> guandanPokers, Double weightCount) {

            this.pokers = pokers;
            this.guandanPokers = guandanPokers;
            this.weightCount = weightCount;
        }

        public GuandanPokersWeight() {
        }
    }

    public static class GuandanPokers implements IPokers {
        private List<Poker> pokers;
        private Double weight;
        private CardType cardType;

        public GuandanPokers() {
        }

        public GuandanPokers(List<Poker> pokers, Double weight, CardType cardType) {
            this.pokers = pokers;
            this.weight = weight;
            this.cardType = cardType;
        }

        @Override
        public List<Poker> getPokers() {
            return pokers;
        }

        public void setPokers(List<Poker> pokers) {
            this.pokers = pokers;
        }

        public Double getWeight() {
            return weight;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public CardType getCardType() {
            return cardType;
        }

        public void setCardType(CardType cardType) {
            this.cardType = cardType;
        }

    }


    // ---------------------------------- hash
    public static int hashCode(Poker poker) {
        return Objects.hash(poker.getColor(), poker.getValue());
//        return (poker.getColor() + "" + poker.getValue()).hashCode();
    }


    public static int hashCode2(List<List<Poker>> pokersList) {
        List<Integer> arr = new ArrayList<>(pokersList.size());
        for (int i = 0; i < pokersList.size(); i++) {
            arr.add(hashCode(pokersList.get(i)));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
//        return arr.toString().hashCode();
    }

    public static int hashCode(Map<Integer, List<Poker>> pokerMap) {
        List<Integer> arr = new ArrayList<>(pokerMap.size());
        for (Integer integer : pokerMap.keySet()) {
            arr.add(Objects.hash(integer, hashCode(pokerMap.get(integer))));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
//        return arr.toString().hashCode();
    }

    public static int hashCode(List<Poker> pokers) {
        List<Integer> arr = new ArrayList<>(pokers.size());
        for (int i = 0; i < pokers.size(); i++) {
            arr.add(hashCode(pokers.get(i)));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
//        return arr.toString().hashCode();
    }


    // -----------------------------------------------------
    public static int hashCode2_value(List<List<Poker>> pokersList) {
        List<Integer> arr = new ArrayList<>(pokersList.size());
        for (int i = 0; i < pokersList.size(); i++) {
            arr.add(hashCode_value(pokersList.get(i)));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
        //        return arr.toString().hashCode();
    }

    public static int hashCode_value(Map<Integer, List<Poker>> pokerMap) {
        List<Integer> arr = new ArrayList<>(pokerMap.size());
        for (Integer integer : pokerMap.keySet()) {
            arr.add(Objects.hash(integer, hashCode_value(pokerMap.get(integer))));
        }
        arr.sort(Integer::compareTo);
        return arr.hashCode();
        //        return arr.toString().hashCode();
    }

    public static int hashCode_value(List<Poker> pokers) {
        List<Integer> arr = CollectUtil.getArr(pokers, Poker::getValue);
        arr.sort(Integer::compareTo);
        return arr.hashCode();
        //        return arr.toString().hashCode();
    }

    /**
     * 最优出牌 排序
     */
    public static List<GuandanPokers> getBestSort(List<GuandanPokers> bestCards, int laiziValue) {
        List<GuandanPokers> allOutCardsArr = new ArrayList<>();
        List<GuandanPokers> sangetouArr = new ArrayList<>();
        List<GuandanPokers> duiziArr = new ArrayList<>();
        for (GuandanPokers guandanPokers : bestCards) {
            CardType cardType = guandanPokers.getCardType();
            Integer type = cardType.getType();
            if (type.equals(CARDTYPE_DOUBLECARD)) {
                duiziArr.add(guandanPokers);
            } else if (type.equals(CARDTYPE_THREECARD)) {
                sangetouArr.add(guandanPokers);
            } else {
                allOutCardsArr.add(guandanPokers);
            }
        }


        if (!sangetouArr.isEmpty() && !duiziArr.isEmpty()) {
            GuandanPokers sangetou = sangetouArr.remove(0);
            GuandanPokers duizi = duiziArr.remove(0);
            GuandanPokers sandaier = new GuandanPokers(new ArrayList<>(), 0d, new CardType(CARDTYPE_THREECARDTWO, sangetou.getCardType().getWeight()));
            sandaier.getPokers().addAll(copy(sangetou.getPokers()));
            sandaier.getPokers().addAll(copy(duizi.getPokers()));
            allOutCardsArr.add(sandaier);
        }

        //
        allOutCardsArr.addAll(sangetouArr);
        allOutCardsArr.addAll(duiziArr);


        allOutCardsArr.sort((o1, o2) -> {

            Integer weight1 = o1.getCardType().getWeight();
            Integer weight2 = o2.getCardType().getWeight();
            if (weight1.equals(weight2)) {

                CardType cardType1 = new CardType(o1.getCardType().getType(), 0);
                CardType cardType2 = new CardType(o2.getCardType().getType(), 0);
                List<List<Poker>> tyoeCards1 = typeCard2(cardType1, bestCards, laiziValue);
                List<List<Poker>> tyoeCards2 = typeCard2(cardType2, bestCards, laiziValue);

                if (tyoeCards1.size() == tyoeCards2.size()) {
                    Integer type1 = o1.getCardType().getType();
                    Integer type2 = o2.getCardType().getType();
                    if (type1.equals(type2)) {
                        List<Poker> laiziCount1 = getLaiZiOrNot(o1.getPokers(), laiziValue).get(1);
                        List<Poker> laiziCount2 = getLaiZiOrNot(o2.getPokers(), laiziValue).get(1);
                        return Integer.compare(laiziCount1.size(), laiziCount2.size());
//                        if (laiziCount1.size() == laiziCount2.size()) {
//                            return 0;
//                        } else {
//                            Integer.compare(laiziCount1.size(), laiziCount2.size());
//                        }
                    } else {
                        return Integer.compare(type1, type2);
                    }
                } else {
                    return Integer.compare(tyoeCards1.size(), tyoeCards2.size());
                }
            } else {
                return Integer.compare(weight1, weight2);
            }
        });
        return allOutCardsArr;
    }

    public static List<String[]> permutationNoRepeat(List list) {
        if (null == list || list.isEmpty()) return new ArrayList<>();
        int length = list.size();
        List<String> stringslist = (List<String>) list.stream().map(String::valueOf).collect(Collectors.toList());
        for (int a = 0; a < stringslist.size(); a++) {
            stringslist.set(a, stringslist.get(a) + ",");
        }

        Stream<String> stream = stringslist.stream().distinct();
        for (int n = 1; n < length; n++) {
            stream = stream.flatMap(i -> stringslist.stream().filter(j -> !i.contains(j)).map(i::concat));
        }

        List<String[]> resultList = new ArrayList<>();
        List<String> collect = stream.collect(Collectors.toList());
        for (String c : collect) {
            String[] split = c.split(",");
            resultList.add(split);
        }

        return resultList;
    }

    public static Poker copy(Poker poker) {
        return new Poker(poker.getColor(), poker.getValue(), poker.getNumber());
    }

    public static List<Poker> copy(Collection<? extends Poker> pokers) {
        List<Poker> copy = new ArrayList<>(pokers.size());
        for (Poker poker : pokers) {
            copy.add(copy(poker));
        }
        return copy;
    }

    public static List<List<Poker>> copy2(Collection<? extends Collection<? extends Poker>> pokersList) {
        List<List<Poker>> copy = new ArrayList<>(pokersList.size());
        for (Collection<? extends Poker> pokers : pokersList) {
            copy.add(copy(pokers));
        }
        return copy;
    }
}
