package cn.godmao.poker;

public class Poker implements IPoker {
//    public static final int Color.HONGTAO = 1;// 红桃
//    public static final int Color.MEIHUA = 2;// 梅花
//    public static final int Color.HEITAO = 3;// 黑桃
//    public static final int Color.FANGKUAI = 4;// 方块
//    public static final int Color.KING = 5;// 王

    public static final int VALUE_KING_DA = 100;// 大王
    public static final int VALUE_KING_XIAO = 99;// 小王

    public enum Value {

        V_2(2, "2"),
        V_3(3, "3"),
        V_4(4, "4"),
        V_5(5, "5"),
        V_6(6, "6"),
        V_7(7, "7"),
        V_8(8, "8"),
        V_9(9, "9"),
        V_10(10, "10"),

        V_11(11, "J"),
        V_j(V_11.getType(), V_11.getDesc()),
        V_J(V_11.getType(), V_11.getDesc()),


        V_12(12, "Q"),
        V_q(V_12.getType(), V_12.getDesc()),
        V_Q(V_12.getType(), V_12.getDesc()),


        V_13(13, "K"),
        V_k(V_13.getType(), V_13.getDesc()),
        V_K(V_13.getType(), V_13.getDesc()),

        V_1(1, "A"),
        V_a(V_1.getType(), V_1.getDesc()),
        V_A(V_1.getType(), V_1.getDesc()),

        V_KING_XIAO(99, "小"),
        V_KING_DA(100, "大");

        private final int type;
        private final String desc;

        Value(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public boolean equals(Integer type) {
            return this.type == type;
        }

        public static Value get(Integer type) {
            for (Value value : values()) {
                if (value.equals(type)) {
                    return value;
                }
            }
            return null;
        }
    }

    public enum Color {
        HONGTAO(1, "红桃"),
        MEIHUA(2, "梅花"),
        HEITAO(3, "黑桃"),
        FANGKUAI(4, "方块"),
        KING(5, "王"),
        ;

        private final int type;
        private final String desc;

        Color(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return type;
        }

        public String getDesc() {
            return desc;
        }

        public boolean equals(Integer type) {
            return this.type == type;
        }

        public static Color get(Integer type) {
            for (Color color : values()) {
                if (color.equals(type)) {
                    return color;
                }
            }
            return null;
        }

    }

    public static final Poker 红桃A = new Poker(Poker.Color.HONGTAO.getType(), 1);
    public static final Poker 梅花A = new Poker(Poker.Color.MEIHUA.getType(), 1);
    public static final Poker 黑桃A = new Poker(Poker.Color.HEITAO.getType(), 1);
    public static final Poker 方块A = new Poker(Poker.Color.FANGKUAI.getType(), 1);

    public static final Poker 红桃1 = 红桃A;
    public static final Poker 梅花1 = 梅花A;
    public static final Poker 黑桃1 = 黑桃A;
    public static final Poker 方块1 = 方块A;

    public static final Poker 红桃a = 红桃A;
    public static final Poker 梅花a = 梅花A;
    public static final Poker 黑桃a = 黑桃A;
    public static final Poker 方块a = 方块A;

    public static final Poker 红桃2 = new Poker(Poker.Color.HONGTAO.getType(), 2);
    public static final Poker 梅花2 = new Poker(Poker.Color.MEIHUA.getType(), 2);
    public static final Poker 黑桃2 = new Poker(Poker.Color.HEITAO.getType(), 2);
    public static final Poker 方块2 = new Poker(Poker.Color.FANGKUAI.getType(), 2);


    public static final Poker 红桃3 = new Poker(Poker.Color.HONGTAO.getType(), 3);
    public static final Poker 梅花3 = new Poker(Poker.Color.MEIHUA.getType(), 3);
    public static final Poker 黑桃3 = new Poker(Poker.Color.HEITAO.getType(), 3);
    public static final Poker 方块3 = new Poker(Poker.Color.FANGKUAI.getType(), 3);

    public static final Poker 红桃4 = new Poker(Poker.Color.HONGTAO.getType(), 4);
    public static final Poker 梅花4 = new Poker(Poker.Color.MEIHUA.getType(), 4);
    public static final Poker 黑桃4 = new Poker(Poker.Color.HEITAO.getType(), 4);
    public static final Poker 方块4 = new Poker(Poker.Color.FANGKUAI.getType(), 4);

    public static final Poker 红桃5 = new Poker(Poker.Color.HONGTAO.getType(), 5);
    public static final Poker 梅花5 = new Poker(Poker.Color.MEIHUA.getType(), 5);
    public static final Poker 黑桃5 = new Poker(Poker.Color.HEITAO.getType(), 5);
    public static final Poker 方块5 = new Poker(Poker.Color.FANGKUAI.getType(), 5);

    public static final Poker 红桃6 = new Poker(Poker.Color.HONGTAO.getType(), 6);
    public static final Poker 梅花6 = new Poker(Poker.Color.MEIHUA.getType(), 6);
    public static final Poker 黑桃6 = new Poker(Poker.Color.HEITAO.getType(), 6);
    public static final Poker 方块6 = new Poker(Poker.Color.FANGKUAI.getType(), 6);

    public static final Poker 红桃7 = new Poker(Poker.Color.HONGTAO.getType(), 7);
    public static final Poker 梅花7 = new Poker(Poker.Color.MEIHUA.getType(), 7);
    public static final Poker 黑桃7 = new Poker(Poker.Color.HEITAO.getType(), 7);
    public static final Poker 方块7 = new Poker(Poker.Color.FANGKUAI.getType(), 7);

    public static final Poker 红桃8 = new Poker(Poker.Color.HONGTAO.getType(), 8);
    public static final Poker 梅花8 = new Poker(Poker.Color.MEIHUA.getType(), 8);
    public static final Poker 黑桃8 = new Poker(Poker.Color.HEITAO.getType(), 8);
    public static final Poker 方块8 = new Poker(Poker.Color.FANGKUAI.getType(), 8);

    public static final Poker 红桃9 = new Poker(Poker.Color.HONGTAO.getType(), 9);
    public static final Poker 梅花9 = new Poker(Poker.Color.MEIHUA.getType(), 9);
    public static final Poker 黑桃9 = new Poker(Poker.Color.HEITAO.getType(), 9);
    public static final Poker 方块9 = new Poker(Poker.Color.FANGKUAI.getType(), 9);

    public static final Poker 红桃10 = new Poker(Poker.Color.HONGTAO.getType(), 10);
    public static final Poker 梅花10 = new Poker(Poker.Color.MEIHUA.getType(), 10);
    public static final Poker 黑桃10 = new Poker(Poker.Color.HEITAO.getType(), 10);
    public static final Poker 方块10 = new Poker(Poker.Color.FANGKUAI.getType(), 10);

    public static final Poker 红桃j = new Poker(Poker.Color.HONGTAO.getType(), 11);
    public static final Poker 梅花j = new Poker(Poker.Color.MEIHUA.getType(), 11);
    public static final Poker 黑桃j = new Poker(Poker.Color.HEITAO.getType(), 11);
    public static final Poker 方块j = new Poker(Poker.Color.FANGKUAI.getType(), 11);

    public static final Poker 红桃J = 红桃j;
    public static final Poker 梅花J = 梅花j;
    public static final Poker 黑桃J = 黑桃j;
    public static final Poker 方块J = 方块j;

    public static final Poker 红桃11 = 红桃j;
    public static final Poker 梅花11 = 梅花j;
    public static final Poker 黑桃11 = 黑桃j;
    public static final Poker 方块11 = 方块j;

    public static final Poker 红桃q = new Poker(Poker.Color.HONGTAO.getType(), 12);
    public static final Poker 梅花q = new Poker(Poker.Color.MEIHUA.getType(), 12);
    public static final Poker 黑桃q = new Poker(Poker.Color.HEITAO.getType(), 12);
    public static final Poker 方块q = new Poker(Poker.Color.FANGKUAI.getType(), 12);

    public static final Poker 红桃Q = 红桃q;
    public static final Poker 梅花Q = 梅花q;
    public static final Poker 黑桃Q = 黑桃q;
    public static final Poker 方块Q = 方块q;

    public static final Poker 红桃12 = 红桃q;
    public static final Poker 梅花12 = 梅花q;
    public static final Poker 黑桃12 = 黑桃q;
    public static final Poker 方块12 = 方块q;

    public static final Poker 红桃k = new Poker(Poker.Color.HONGTAO.getType(), 13);
    public static final Poker 梅花k = new Poker(Poker.Color.MEIHUA.getType(), 13);
    public static final Poker 黑桃k = new Poker(Poker.Color.HEITAO.getType(), 13);
    public static final Poker 方块k = new Poker(Poker.Color.FANGKUAI.getType(), 13);

    public static final Poker 红桃K = 红桃k;
    public static final Poker 梅花K = 梅花k;
    public static final Poker 黑桃K = 黑桃k;
    public static final Poker 方块K = 方块k;

    public static final Poker 红桃13 = 红桃k;
    public static final Poker 梅花13 = 梅花k;
    public static final Poker 黑桃13 = 黑桃k;
    public static final Poker 方块13 = 方块k;

    public static final Poker 小王 = new Poker(Poker.Color.KING.getType(), Poker.VALUE_KING_XIAO);
    public static final Poker 大王 = new Poker(Poker.Color.KING.getType(), Poker.VALUE_KING_DA);
    public static final Poker 王小 = 小王;
    public static final Poker 王大 = 大王;

    private Integer color;
    private Integer value;
    private Integer number;

    public Poker() {
    }


    public Poker(Integer color, Integer value) {
        this.color = color;
        this.value = value;
    }

    public Poker(Integer color, Integer value, Integer number) {
        this.color = color;
        this.value = value;
        this.number = number;
    }

    @Override
    public Integer getColor() {
        return color;
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    @Override
    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Override
    public String toString() {
        String strcolor = "";
        if (null != color) {
            if (Color.HONGTAO.equals(color)) {
                strcolor = Color.HONGTAO.getDesc();
            } else if (Color.MEIHUA.equals(color)) {
                strcolor = Color.MEIHUA.getDesc();
            } else if (Color.HEITAO.equals(color)) {
                strcolor = Color.HEITAO.getDesc();
            } else if (Color.FANGKUAI.equals(color)) {
                strcolor = Color.FANGKUAI.getDesc();
            } else if (Color.KING.equals(color)) {
                strcolor = Color.KING.getDesc();
            } else {
                strcolor = String.valueOf(color);
            }
        }

        String strvalue = "";
        if (null != value) {
            switch (value) {
                case 1:
                    strvalue = "A";
                    break;
                case 11:
                    strvalue = "J";
                    break;
                case 12:
                    strvalue = "Q";
                    break;
                case 13:
                    strvalue = "K";
                    break;
                case VALUE_KING_XIAO:
                    strvalue = "小";
                    break;
                case VALUE_KING_DA:
                    strvalue = "大";
                    break;
                default:
                    strvalue = String.valueOf(value);
            }
        }

        if (null != number) {
            return strcolor + strvalue + "(" + number + ")";
        } else {
            return strcolor + strvalue;
        }
    }
}
