package cn.godmao.netty.server;

import cn.godmao.netty.handler.IConnectHandler;
import io.netty.channel.ChannelHandlerContext;

public abstract class AbstractServer extends DefaultServer implements IConnectHandler {
    public AbstractServer(int port) {
        super(port);
    }

    @Override
    public abstract void onOpen(ChannelHandlerContext ctx);

    @Override
    public abstract void onClose(ChannelHandlerContext ctx);

    @Override
    public abstract void onError(ChannelHandlerContext ctx, Throwable throwable);

    @Override
    public abstract void onMessage(ChannelHandlerContext ctx, Object message);
}
