package cn.godmao.netty.example;

import cn.godmao.netty.server.AbstractServer;
import io.netty.channel.ChannelHandlerContext;

/**
 * 简单服务端创建
 */
public class Server extends AbstractServer {

    final QpsTrack qpsTrack = new QpsTrack(this.getClass().getSimpleName());

    public Server(int port) {
        super(port);
    }

    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        // 连接成功
    }

    @Override
    public void onClose(ChannelHandlerContext ctx) {
        // 连接关闭
    }

    @Override
    public void onError(ChannelHandlerContext ctx, Throwable throwable) {
        // 连接异常
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Object message) {
        // 消息处理
        qpsTrack.track();
    }

    public static void main(String[] args) {
        Server server = new Server(10001);
        server.start();
    }
}
