package cn.godmao.netty.example;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.handler.IConnect;
import cn.godmao.netty.handler.IConnectHandler;

/**
 * 统一服务创建
 */
public class AirServer implements IConnect {
    private final IConnect connect;

    public AirServer(IConnect connect) {
        this.connect = connect;
    }

    @Override
    public synchronized void start() {
        this.connect.start();
    }

    @Override
    public ChannelService getChannelService() {
        return this.connect.getChannelService();
    }

    @Override
    public IConnectHandler getConnectHandler() {
        return this.connect.getConnectHandler();
    }

    public static void main(String[] args) {
        AirServer server = new AirServer(new Server(10001));
        server.start();
    }

}
