package cn.godmao.netty;

import cn.godmao.core.ISchedule;
import cn.godmao.executor.IExecutorService;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.*;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorService extends MultithreadEventExecutorGroup implements IExecutorService<EventExecutor>, ISchedule<ScheduledFuture<?>> {
    private EventExecutor[] executors;
    private int             size;

    public ExecutorService() {
        this(NettyRuntime.availableProcessors());
    }

    public ExecutorService(int threads) {
        this(threads, (ThreadFactory) null);
    }

    public ExecutorService(String threadName) {
        this(NettyRuntime.availableProcessors(), threadName);
    }

    public ExecutorService(int threads, String threadName) {
        this(threads, new DefaultThreadFactory(threadName, false));
    }

    public ExecutorService(int threads, ThreadFactory threadFactory) {
        super(threads, threadFactory);
    }

    public int getSize() {
        return size;
    }

    @Override
    protected EventExecutor newChild(Executor executor, Object... args) {
        if (null == executors) {
            executors = new EventExecutor[executorCount()];
        }
        DefaultEventExecutor eventExecutor = new DefaultEventExecutor(this, executor);
        executors[size++] = eventExecutor;
        return eventExecutor;
    }

    @Override
    public EventExecutor[] getExecutors() {
        return executors;
    }

    // ==========================================================================================

    public Future<?> submit(Object key, Runnable runnable) {
        return select(key).submit(runnable);
    }

    public <T> Future<T> submit(Object key, Runnable task, T result) {
        return select(key).submit(task, result);
    }

    public <T> Future<T> submit(Object key, Callable<T> task) {
        return select(key).submit(task);
    }

    public ScheduledFuture<?> schedule(Object key, Runnable command, long delay, TimeUnit unit) {
        return select(key).schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Object key, Callable<V> callable, long delay, TimeUnit unit) {
        return select(key).schedule(callable, delay, unit);
    }
    // ==========================================================================================
}

