/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.server;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.NettyUtil;
import cn.godmao.netty.handler.IConnect;
import cn.godmao.netty.server.base.ServerBaseInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements IConnect {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int port;
    private final ChannelService channelService;
    private final ServerBootstrap boot;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    private ChannelInitializer<Channel> channelInitializer;
    private ChannelFuture channelFuture;

    public AbstractServer(int port) {
        this.port = port;
        this.boot = new ServerBootstrap();
        this.channelService = new ChannelService("server" + port);
        this.bossGroup = NettyUtil.newEventLoopGroup(1, "server" + port + "-boss-loop-group");
        this.workGroup = NettyUtil.newEventLoopGroup("server" + port + "-work-loop-group");
    }

    @Override
    public void start() {
        if (null == this.channelInitializer) {
            this.channelInitializer = new ServerBaseInitializer(this);
        }
        this.init();
        this.bind();
    }

    private void init() {
        this.boot.group(this.bossGroup, this.workGroup);
        this.boot.option(ChannelOption.SO_BACKLOG, (Object)1024);
        this.boot.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.boot.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.boot.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.boot.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.boot.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.boot.channel(NettyUtil.getServerSocketChannelClass());
        this.boot.childHandler(this.channelInitializer);
    }

    private void bind() {
        try {
            this.channelFuture = this.boot.bind(this.port).sync();
            this.channelFuture.channel().closeFuture().sync();
        }
        catch (Exception e) {
            this.log.error("server-" + this.port + " start error!", (Throwable)e);
            System.exit(0);
        }
        finally {
            this.stop();
        }
    }

    public void stop() {
        this.bossGroup.shutdownGracefully();
        this.workGroup.shutdownGracefully();
        this.getChannelService().getExecutorGroup().shutdownGracefully();
        this.channelFuture.channel().close();
        this.channelFuture.channel().disconnect();
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public ChannelService getChannelService() {
        return this.channelService;
    }

    public void setChannelInitializer(ChannelInitializer<Channel> channelInitializer) {
        this.channelInitializer = channelInitializer;
    }
}

