/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.netty.codec;

import cn.godmao.netty.codec.IEncoder;
import cn.godmao.utils.KryoUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;

public class DefaultEncoder
implements IEncoder<Object, ByteBuf> {
    @Override
    public ByteBuf encode(Object message) throws EncoderException {
        ByteBuf byteBuf;
        if (null == message) {
            return null;
        }
        if (message instanceof ByteBuf) {
            byteBuf = ((ByteBuf)message).retainedDuplicate();
        } else if (message instanceof byte[]) {
            byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])message));
        } else {
            byte[] message_bytes = KryoUtil.serialize((Object)message);
            byteBuf = ByteBufAllocator.DEFAULT.buffer(message_bytes.length);
            byteBuf.writeBytes(message_bytes);
        }
        return byteBuf;
    }

    public static DefaultEncoder me() {
        return Holder.ME;
    }

    private static class Holder {
        static final DefaultEncoder ME = new DefaultEncoder();

        private Holder() {
        }
    }
}

